/*
 * Decompiled with CFR 0.152.
 */
package plot;

import java.util.Comparator;

class UserList {
    public static final Comparator byName = new Comparator<UserList>(){

        @Override
        public int compare(UserList o1, UserList o2) {
            return o1.name.compareTo(o2.name);
        }
    };
    public String name;
    public String[] enzymes;

    UserList() {
    }

    public static UserList fromString(String datafileline) {
        UserList item = new UserList();
        if (datafileline.startsWith(";")) {
            return null;
        }
        String[] entries = datafileline.split("\t");
        if (entries.length < 3 || !entries[0].equalsIgnoreCase("UserList")) {
            return null;
        }
        item.name = entries[1];
        item.enzymes = entries[2].split(",");
        return item;
    }

    public String toExportString() {
        String outVal = "UserList\t" + this.name + "\t";
        if (this.enzymes != null && this.enzymes.length > 0) {
            for (int x = 0; x < this.enzymes.length; ++x) {
                outVal = x == 0 ? outVal + this.enzymes[x] : outVal + "," + this.enzymes[x];
            }
        }
        return outVal;
    }

    public String toString() {
        return this.name;
    }
}

