/*
 * Decompiled with CFR 0.152.
 */
package plot;

import BinaryTrees.BinaryChain;
import FileReaders.ExternalLibrary;
import FileReaders.TextFileWriter;
import ObjectChains.ObjectChain;
import plot.EnzymeMixList;
import plot.PlotPrimer;
import plot.UserList;

class UserLibrary
extends ExternalLibrary {
    public ObjectChain<PlotPrimer> items;
    public BinaryChain<UserList> userLists;
    public BinaryChain<EnzymeMixList> userMixeLists;

    @Override
    public void init() {
        this.items = new ObjectChain();
        this.userLists = new BinaryChain();
        this.userMixeLists = new BinaryChain();
        this.setHistoryKey("userlibpath");
        this.setTitle("User Primers Library");
        this.setDefaultSaveName("user.dat");
        this.setOpenExtension(".dat");
        this.setSaveExtension(".dat");
    }

    public UserLibrary() {
    }

    public UserLibrary(String filepath) {
        super(filepath);
    }

    @Override
    public boolean loadFileContents(String file) {
        this.items.clear();
        String[] lines = this.getFileData(file);
        if (lines == null || lines.length == 0) {
            return false;
        }
        for (String line : lines) {
            EnzymeMixList list;
            if (line.startsWith("Primer\t")) {
                PlotPrimer primer = PlotPrimer.fromString(line);
                if (primer == null) continue;
                this.items.add(primer);
                continue;
            }
            if (line.startsWith("UserList\t")) {
                UserList userList = UserList.fromString(line);
                if (userList == null) continue;
                this.userLists.add(userList);
                continue;
            }
            if (!line.startsWith("UserMix\t") || (list = EnzymeMixList.fromString(line)) == null) continue;
            this.userMixeLists.add(list);
        }
        return true;
    }

    @Override
    public boolean saveContents(TextFileWriter writer) {
        writer.writeLine("User_Data_V2");
        if (this.userLists != null && this.userLists.size() > 0) {
            for (UserList list : this.userLists) {
                writer.writeLine(list.toExportString());
            }
        }
        if (this.userMixeLists != null && this.userMixeLists.size() > 0) {
            for (EnzymeMixList mixList : this.userMixeLists) {
                writer.writeLine(mixList.toExportString());
            }
        }
        if (this.items != null && this.items.size() > 0) {
            for (PlotPrimer primer : this.items) {
                writer.writeLine(primer.toExportString());
            }
        }
        return true;
    }

    @Override
    public void clear() {
        this.items.clear();
        this.userLists.clear();
    }
}

