/*
 * Decompiled with CFR 0.152.
 */
package plot;

import FileReaders.ExternalLibrary;
import FileReaders.TextFileWriter;
import ObjectChains.ObjectChain;
import plot.LibraryFeature;

class UserFeatures
extends ExternalLibrary {
    public ObjectChain<LibraryFeature> items;

    @Override
    public void init() {
        this.items = new ObjectChain();
        this.setHistoryKey("userfeatureslibpath");
        this.setTitle("User Features Library");
        this.setDefaultSaveName("userlibrary.da2");
        this.setOpenExtension(".da2");
        this.setSaveExtension(".da2");
    }

    public UserFeatures() {
    }

    public UserFeatures(String filepath) {
        super(filepath);
    }

    @Override
    public boolean loadFileContents(String file) {
        this.items.clear();
        String[] lines = this.getFileData(file);
        if (lines == null || lines.length == 0) {
            return false;
        }
        for (String line : lines) {
            LibraryFeature feature = LibraryFeature.fromString(line);
            if (feature == null) continue;
            this.items.add(feature);
        }
        return true;
    }

    @Override
    public boolean saveContents(TextFileWriter writer) {
        for (LibraryFeature f : this.items) {
            writer.writeLine(f.exportToString());
        }
        return true;
    }

    @Override
    public void clear() {
        this.items.clear();
    }
}

