/*
 * Decompiled with CFR 0.152.
 */
package plot;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class IconListRenderer
extends JLabel
implements ListCellRenderer<Object> {
    private Color selectionBackColor = null;
    private Color selectionForeColor = null;
    private Color foreColor = null;
    private Color backColor = null;
    private String[] titles;
    private Icon[] icons;

    public void setSelectionBackColor(Color color) {
        this.selectionBackColor = color;
    }

    public Color getSelectionBackColor() {
        return this.selectionBackColor;
    }

    public void setSelectionForeColor(Color color) {
        this.selectionForeColor = color;
    }

    public Color getSelectionForeColor() {
        return this.selectionForeColor;
    }

    public void setBackColor(Color color) {
        this.backColor = color;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setForeColor(Color color) {
        this.foreColor = color;
    }

    public Color getForeColor() {
        return this.foreColor;
    }

    public void setValues(String[] titles, Icon[] icons) {
        this.titles = titles;
        this.icons = icons;
    }

    public IconListRenderer() {
        this.setOpaque(true);
    }

    public IconListRenderer(String[] titles, Icon[] icons) {
        this.setOpaque(true);
        this.setValues(titles, icons);
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color bColor;
        Color fColor;
        if (isSelected) {
            fColor = this.selectionForeColor != null ? this.selectionForeColor : (Color)UIManager.get("ComboBox.selectionForeground");
            Color color = bColor = this.selectionBackColor != null ? this.selectionBackColor : (Color)UIManager.get("ComboBox.selectionBackground");
            if (bColor == null) {
                bColor = list.getSelectionBackground();
            }
            if (fColor == null) {
                fColor = list.getSelectionForeground();
            }
        } else {
            fColor = this.foreColor != null ? this.foreColor : (Color)UIManager.get("ComboBox.foreground");
            Color color = bColor = this.backColor != null ? this.backColor : (Color)UIManager.get("ComboBox.background");
            if (bColor == null) {
                bColor = list.getBackground();
            }
            if (fColor == null) {
                fColor = list.getForeground();
            }
        }
        this.setBackground(bColor != null ? bColor : Color.WHITE);
        this.setForeground(fColor != null ? fColor : Color.BLACK);
        this.setFont(list.getFont());
        if (value != null && value instanceof Integer) {
            int val = (Integer)value;
            if (this.titles != null && val >= 0 && val < this.titles.length) {
                this.setText(this.titles[val]);
            } else {
                this.setText("");
            }
            if (this.icons != null && val >= 0 && val < this.icons.length) {
                this.setIcon(this.icons[val]);
            } else {
                this.setIcon(null);
            }
        } else {
            this.setIcon(null);
            this.setText("");
        }
        return this;
    }
}

