/*
 * Decompiled with CFR 0.152.
 */
package plot;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class IconCellRenderer
extends JLabel
implements TableCellRenderer {
    private String[] titles;
    private Icon[] icons;
    private Color selectionBackColor = null;
    private Color selectionForeColor = null;
    private Color foreColor = null;
    private Color backColor = null;

    public void setValues(String[] titles, Icon[] icons) {
        this.titles = titles;
        this.icons = icons;
    }

    public void setSelectionBackColor(Color color) {
        this.selectionBackColor = color;
    }

    public Color getSelectionBackColor() {
        return this.selectionBackColor;
    }

    public void setSelectionForeColor(Color color) {
        this.selectionForeColor = color;
    }

    public Color getSelectionForeColor() {
        return this.selectionForeColor;
    }

    public void setBackColor(Color color) {
        this.backColor = color;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setForeColor(Color color) {
        this.foreColor = color;
    }

    public Color getForeColor() {
        return this.foreColor;
    }

    public IconCellRenderer() {
        this.setOpaque(true);
    }

    public IconCellRenderer(String[] titles, Icon[] icons) {
        this.setOpaque(true);
        this.setValues(titles, icons);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Color bColor;
        Color fColor;
        if (isSelected) {
            fColor = this.selectionForeColor != null ? this.selectionForeColor : table.getSelectionForeground();
            bColor = this.selectionBackColor != null ? this.selectionBackColor : table.getSelectionBackground();
        } else {
            fColor = this.foreColor != null ? this.foreColor : table.getForeground();
            bColor = this.backColor != null ? this.backColor : table.getBackground();
        }
        this.setBackground(bColor != null ? bColor : Color.WHITE);
        this.setForeground(fColor != null ? fColor : Color.BLACK);
        if (value != null && value instanceof Integer) {
            int val = (Integer)value;
            if (this.titles != null && val >= 0 && val < this.titles.length) {
                this.setText(this.titles[val]);
            } else {
                this.setText("");
            }
            if (this.icons != null && val >= 0 && val < this.icons.length) {
                this.setIcon(this.icons[val]);
            } else {
                this.setIcon(null);
            }
        } else {
            this.setIcon(null);
            this.setText("");
        }
        return this;
    }
}

