/*
 * Decompiled with CFR 0.152.
 */
package plot;

import Buttons.ButtonRenderer;
import Buttons.GlossyButton;
import CustomListBoxes.ComboDataItemModel;
import DocumentFilters.DocumentKeyFilter;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.text.AbstractDocument;
import plot.DefaultLibraries;
import plot.Globals;
import plot.JOptionPanes;
import plot.Ladder;
import plot.MainExclusiveDlg;
import plot.PLOTJ;

class FrmLadders
extends MainExclusiveDlg {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private ComboDataItemModel comboModel = new ComboDataItemModel();
    private JComboBox<String> cmbLadderName;
    private GlossyButton cmdAddNew;
    private JButton cmdCancel;
    private GlossyButton cmdDelLadder;
    private JButton cmdSave;
    private GlossyButton cmdUpdate;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea txtBands;
    private int returnStatus = 0;

    public FrmLadders(PLOTJ parent) {
        super((Window)parent);
        this.initComponents();
        ((AbstractDocument)this.txtBands.getDocument()).setDocumentFilter(new DocumentKeyFilter(){

            @Override
            public String filterText(String text) {
                return text.replaceAll("[^1234567890\n]", "");
            }
        });
        this.cmbLadderName.setModel(this.comboModel);
        if (!DefaultLibraries.userLadders.items.isEmpty()) {
            for (Ladder ladder : DefaultLibraries.userLadders.items) {
                this.comboModel.add(ladder.clone());
            }
            this.cmbLadderName.setSelectedIndex(0);
        }
        this.setIconImage(Globals.icon.getImage());
        this.setLocationRelativeTo(null);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.cmdSave = new JButton();
        this.cmdCancel = new JButton();
        this.jPanel1 = new JPanel();
        this.cmbLadderName = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.txtBands = new JTextArea();
        this.cmdUpdate = new GlossyButton();
        this.cmdAddNew = new GlossyButton();
        this.cmdDelLadder = new GlossyButton();
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FrmLadders.this.closeDialog(evt);
            }
        });
        this.cmdSave.setText("Save and Exit");
        this.cmdSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLadders.this.cmdSaveActionPerformed(evt);
            }
        });
        this.cmdCancel.setText("Cancel");
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLadders.this.cmdCancelActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Ladders"));
        this.cmbLadderName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLadders.this.cmbLadderNameActionPerformed(evt);
            }
        });
        this.txtBands.setColumns(20);
        this.txtBands.setRows(5);
        this.jScrollPane1.setViewportView(this.txtBands);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 203, Short.MAX_VALUE).addComponent(this.cmbLadderName, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.cmbLadderName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 369, Short.MAX_VALUE).addContainerGap()));
        this.cmdUpdate.setIcon(new ImageIcon(this.getClass().getResource("/images24/Save2.png")));
        this.cmdUpdate.setToolTipText("Save current ladder");
        this.cmdUpdate.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLadders.this.cmdUpdateActionPerformed(evt);
            }
        });
        this.cmdAddNew.setIcon(new ImageIcon(this.getClass().getResource("/images24/Plus.png")));
        this.cmdAddNew.setToolTipText("Add new ladder");
        this.cmdAddNew.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdAddNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLadders.this.cmdAddNewActionPerformed(evt);
            }
        });
        this.cmdDelLadder.setIcon(new ImageIcon(this.getClass().getResource("/images24/X.png")));
        this.cmdDelLadder.setToolTipText("Delete current ladder");
        this.cmdDelLadder.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdDelLadder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmLadders.this.cmdDelLadderActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cmdAddNew, -2, 38, -2).addComponent(this.cmdUpdate, -2, 38, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cmdDelLadder, -2, 34, -2)).addComponent(this.cmdSave, -1, -1, Short.MAX_VALUE).addComponent(this.cmdCancel, -1, -1, Short.MAX_VALUE)).addContainerGap(43, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.cmdAddNew, -2, -1, -2).addComponent(this.cmdDelLadder, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cmdUpdate, -2, -1, -2).addGap(28, 28, 28).addComponent(this.cmdSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdCancel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.getRootPane().setDefaultButton(this.cmdSave);
        this.pack();
    }

    private void cmdSaveActionPerformed(ActionEvent evt) {
        this.doOK();
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void cmdAddNewActionPerformed(ActionEvent evt) {
        String newName = JOptionPanes.showInputDialog(this.rootPane, "Enter New Ladder Name", "Create New Ladder", 1, null, null, "New Ladder");
        Ladder ladder = new Ladder(newName, 1000, 900, 800, 700, 600, 500, 400, 300, 200, 100);
        if (!DefaultLibraries.userLadders.items.containsKey(ladder.name)) {
            DefaultLibraries.userLadders.items.add(ladder, ladder.name);
            this.comboModel.add(ladder);
            this.cmbLadderName.setSelectedIndex(this.cmbLadderName.getItemCount() - 1);
        }
    }

    private void cmdUpdateActionPerformed(ActionEvent evt) {
        Ladder ladder = (Ladder)this.comboModel.getDataObject(this.cmbLadderName.getSelectedIndex());
        if (ladder != null) {
            ladder.textToBands(this.txtBands.getText());
        }
    }

    private void cmbLadderNameActionPerformed(ActionEvent evt) {
        Ladder ladder = (Ladder)this.comboModel.getSelectedDataObject();
        if (ladder != null) {
            this.txtBands.setText(ladder.bandsToText());
            this.txtBands.setCaretPosition(0);
            this.cmdDelLadder.setEnabled(!ladder.isDefault);
            this.cmdUpdate.setEnabled(!ladder.isDefault);
            this.txtBands.setEditable(!ladder.isDefault);
        } else {
            this.txtBands.setText("");
        }
    }

    private void cmdDelLadderActionPerformed(ActionEvent evt) {
        int index = this.cmbLadderName.getSelectedIndex();
        Ladder ladder = (Ladder)this.comboModel.getDataObject(index);
        this.comboModel.removeElementAt(index);
        if (ladder != null) {
            DefaultLibraries.userLadders.items.remove(ladder.name);
        }
    }

    private void doClose(int retStatus) {
        if (retStatus == 1) {
            DefaultLibraries.userLadders.items.clear();
            for (int x = 0; x < this.comboModel.getSize(); ++x) {
                Ladder ladder = (Ladder)this.comboModel.getDataObject(x);
                DefaultLibraries.userLadders.items.add(ladder, ladder.name);
                DefaultLibraries.userLadders.save();
            }
        }
        this.dispose();
    }

    @Override
    public void doOK() {
        this.doClose(1);
    }

    @Override
    public void doCancel() {
        this.doClose(0);
    }
}

