/*
 * Decompiled with CFR 0.152.
 */
package plot;

import GenbankFileReader.Locus;
import ListModels.UniqueComboModel;
import MiscTools.StringTools;
import ScrollPanels.ScrollPanel;
import ScrollPanels.StatusLabel;
import ToolTip.BasicTextToolTip;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ToolTipManager;
import plaf.BaseRootPaneUI;
import plot.DefaultLibraries;
import plot.EnzymeMix;
import plot.Globals;
import plot.Ladder;
import plot.PLOTJ;
import plot.ProjectDocument;
import plot.ProjectEnzyme;

final class FrmGel
extends JFrame {
    boolean useOverlay = false;
    private Well[] wells;
    BasicTextToolTip tip;
    private double minBp;
    private double maxBp;
    private boolean loading = true;
    private static final int BUFFERAREA = 5;
    private static final int BUFFERAREA2 = 10;
    private static final int WELL_WIDTH = 40;
    private static final int WELL_WIDTH2 = 20;
    private static final int WELL_SPACER = 10;
    private static final int WELL_Y1 = 15;
    private static final int WELL_HT = 5;
    private static final int WELL_Y2 = 20;
    private static final int TITLE_Y = 13;
    private FontMetrics fontMetrics;
    private int fontHt;
    private int gelWd;
    private int gelHt;
    private Image canvasBuffer;
    Graphics2D canvasGraphics;
    private Ladder leftLadder;
    private Ladder rightLadder;
    private UniqueComboModel<Ladder> comboModelLeft = new UniqueComboModel();
    private UniqueComboModel<Ladder> comboModelRight = new UniqueComboModel();
    double rise;
    double run;
    double m;
    double b;
    PLOTJ owner;
    private final MouseListener menuMouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
            JComponent c = (JComponent)arg0.getComponent();
            ToolTipManager.sharedInstance().setEnabled(false);
            if (!(c instanceof JSeparator)) {
                FrmGel.this.lblInfo.setText(c.getToolTipText(), 3000);
            }
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
            FrmGel.this.lblInfo.setText("");
            ToolTipManager.sharedInstance().setEnabled(true);
        }
    };
    int offsetX = 0;
    Band mouseOverBand = null;
    private JCheckBox chkShowBp;
    private JComboBox<Ladder> cmbLadderLeft;
    private JComboBox<Ladder> cmbLadderRight;
    private JComboBox<String> cmbMinBp;
    ScrollPanel gelPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private StatusLabel lblInfo;
    int panelWidth = 0;
    int panelHeight = 0;
    private static int BAND_HT = 3;

    private ProjectDocument getProject() {
        return this.owner.getProject();
    }

    public FrmGel(PLOTJ owner) {
        this.initComponents();
        BaseRootPaneUI.addAlwaysOnTop(this, this.menuMouseListener);
        this.cmbLadderLeft.addMouseListener(this.menuMouseListener);
        this.cmbLadderRight.addMouseListener(this.menuMouseListener);
        this.cmbMinBp.addMouseListener(this.menuMouseListener);
        this.chkShowBp.addMouseListener(this.menuMouseListener);
        this.owner = owner;
        this.tip = new BasicTextToolTip(this.gelPanel.displayPanel);
        this.tip.setHideOnPress(true);
        this.tip.setHideOnDrag(true);
        this.tip.setHideOnMove(false);
        this.tip.setFadeIn(true);
        this.tip.setFadeStep(1.0f);
        this.tip.setOpacity(1.0f);
        this.gelPanel.getHScrollBar().setValue(0);
        this.gelPanel.getHScrollBar().setMinimum(0L);
        this.gelPanel.getHScrollBar().setMaximum(0L);
        this.lblInfo.setText("");
        this.populateLadders();
        String cancelName = "cancel";
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelName);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put(cancelName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmGel.this.doCancel();
            }
        });
        this.setIconImage(Globals.icon.getImage());
        this.setLocationRelativeTo(owner);
        this.regenerateWells();
        this.loading = false;
    }

    private void populateLadders() {
        this.comboModelLeft.items.clear();
        this.comboModelRight.items.clear();
        int ladderCount = 0;
        if (DefaultLibraries.defaultLadders != null && DefaultLibraries.defaultLadders.items.length > 0) {
            ladderCount += DefaultLibraries.defaultLadders.items.length;
            for (Ladder ladder : DefaultLibraries.defaultLadders.items) {
                this.comboModelLeft.items.add(ladder);
                this.comboModelRight.items.add(ladder);
            }
        }
        if (!DefaultLibraries.userLadders.items.isEmpty()) {
            ladderCount += DefaultLibraries.userLadders.items.size();
            for (Ladder ladder : DefaultLibraries.userLadders.items) {
                this.comboModelLeft.items.add(ladder);
                this.comboModelRight.items.add(ladder);
            }
        }
        if (ladderCount > 0) {
            this.comboModelLeft.items.sort(Ladder.sortComparator);
            this.comboModelRight.items.sort(Ladder.sortComparator);
            this.cmbLadderLeft.setSelectedIndex(0);
            this.cmbLadderRight.setSelectedIndex(0);
        }
    }

    private void doCancel() {
        this.owner.gelForm = null;
        this.dispose();
    }

    private void intArrayToBands(Well dest, int[] intArray) {
        dest.bands = new Band[intArray.length];
        for (int x = 0; x < intArray.length; ++x) {
            dest.bands[x] = new Band(1, intArray[x], dest.rect.x);
        }
    }

    private void PosArrayToBands(Well dest, Locus[] sites) {
        dest.bands = new Band[sites.length];
        for (int x = 0; x < sites.length; ++x) {
            dest.bands[x] = new Band(sites[x].getStart(), sites[x].getStop(), dest.rect.x);
        }
    }

    public void resetEnzymes() {
        ProjectDocument project = this.getProject();
        for (ProjectEnzyme enzyme : project.selectedEnzymes) {
            enzyme.bands = null;
        }
        for (EnzymeMix mix : project.enzymeMixes) {
            mix.bands = null;
        }
    }

    public void regenerateWells() {
        int x;
        ProjectDocument project = this.getProject();
        if (this.leftLadder == null || this.rightLadder == null) {
            return;
        }
        int wellCount = 2 + project.selectedEnzymes.size() + project.enzymeMixes.size();
        this.wells = new Well[wellCount];
        this.wells[0] = new Well("Ladder");
        this.wells[0].setLeft(this.getWellX(1));
        this.intArrayToBands(this.wells[0], this.leftLadder.bands);
        this.wells[wellCount - 1] = new Well("Ladder");
        this.wells[wellCount - 1].rect.x = this.getWellX(wellCount);
        this.wells[wellCount - 1].setLeft(this.getWellX(wellCount));
        this.intArrayToBands(this.wells[wellCount - 1], this.rightLadder.bands);
        int manualMin = StringTools.filterStringToInt((String)this.cmbMinBp.getSelectedItem(), -1);
        boolean useManualMin = manualMin != -1;
        int wellIndex = 1;
        int seqLen = project.length();
        if (!project.selectedEnzymes.isEmpty()) {
            project.selectedEnzymes.sort(ProjectEnzyme.sortComparator);
            for (x = 0; x < project.selectedEnzymes.size(); ++x) {
                ProjectEnzyme enzyme = project.selectedEnzymes.get(x);
                if (enzyme.bands == null) {
                    project.generateDigestBands(enzyme);
                }
                if (!useManualMin && (double)enzyme.bands[enzyme.bands.length - 1].getLength(seqLen) < this.minBp) {
                    this.minBp = enzyme.bands[enzyme.bands.length - 1].getLength(seqLen);
                }
                this.wells[wellIndex] = new Well(enzyme.enzyme.name);
                this.wells[wellIndex].setLeft(this.getWellX(wellIndex + 1));
                this.PosArrayToBands(this.wells[wellIndex], enzyme.bands);
                ++wellIndex;
            }
        }
        if (!project.enzymeMixes.isEmpty()) {
            for (x = 0; x < project.enzymeMixes.size(); ++x) {
                EnzymeMix enzymeMix = project.enzymeMixes.get(x);
                if (enzymeMix.bands == null) {
                    project.genCuts(enzymeMix);
                    project.generateDigestBands(enzymeMix);
                }
                if (enzymeMix.bands == null) continue;
                if (!useManualMin && (double)enzymeMix.bands[enzymeMix.bands.length - 1].getLength(seqLen) < this.minBp) {
                    this.minBp = enzymeMix.bands[enzymeMix.bands.length - 1].getLength(seqLen);
                }
                this.wells[wellIndex] = new Well("Mix " + (x + 1));
                this.wells[wellIndex].setLeft(this.getWellX(wellIndex + 1));
                this.PosArrayToBands(this.wells[wellIndex], enzymeMix.bands);
                ++wellIndex;
            }
        }
        Well leftWell = this.wells[0];
        Well rightWell = this.wells[this.wells.length - 1];
        leftWell.isLadder = true;
        rightWell.isLadder = true;
        this.maxBp = Math.max(leftWell.bands[0].getStop(), rightWell.bands[0].getStop());
        this.minBp = !useManualMin ? (double)Math.min(leftWell.bands[leftWell.bands.length - 1].getStop(), rightWell.bands[rightWell.bands.length - 1].getStop()) : (double)manualMin;
        for (Well well : this.wells) {
            if (well.isLadder) continue;
            if ((double)well.bands[0].getLength(seqLen) > this.maxBp) {
                this.maxBp = well.bands[0].getLength(seqLen);
            }
            if (useManualMin || !((double)well.bands[well.bands.length - 1].getLength(seqLen) < this.minBp)) continue;
            this.minBp = well.bands[well.bands.length - 1].getLength(seqLen);
        }
    }

    void gelMouseMoved(int x, int y) {
        if (this.wells == null || this.wells.length == 0) {
            return;
        }
        int x2 = x + this.offsetX;
        if (this.mouseOverBand != null && this.mouseOverBand.rect.contains(x2, y)) {
            if (this.mouseOverBand.getStart() > 0) {
                this.tip.setLocation(x, y);
            }
            return;
        }
        int wellIndex = x2 / 50;
        if (wellIndex >= 0 && wellIndex < this.wells.length && x2 >= this.wells[wellIndex].rect.x && x2 <= this.wells[wellIndex].right) {
            for (Band band : this.wells[wellIndex].bands) {
                String info;
                if (!band.rect.contains(x, y)) continue;
                this.mouseOverBand = band;
                if (!this.wells[wellIndex].isLadder) {
                    info = "Bp(s) " + band.getStart() + " - " + band.getStop() + ", size = " + band.getLength(this.getProject().length()) + "bps";
                    this.owner.gelBand = this.mouseOverBand;
                    this.owner.resetMap();
                } else {
                    info = band.getStop() + "bps";
                }
                this.lblInfo.setText(info);
                this.tip.setText(info);
                this.tip.show(x, y);
                return;
            }
        }
        if (this.mouseOverBand != null) {
            this.mouseOverBand = null;
            this.tip.setText("");
            this.tip.hide();
            this.lblInfo.setText("");
            this.owner.gelBand = null;
            this.owner.resetMap();
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.chkShowBp = new JCheckBox();
        this.cmbLadderLeft = new JComboBox();
        this.cmbLadderRight = new JComboBox();
        this.cmbMinBp = new JComboBox();
        this.gelPanel = new ScrollPanel(){

            @Override
            public void customDisplayPaint(Graphics g, int width, int height) {
                FrmGel.this.drawGel(g, false);
            }

            @Override
            public void hScrollValueChanged(long newValue) {
                FrmGel.this.offsetX = (int)newValue;
                FrmGel.this.reDraw(true);
            }

            @Override
            public void vScrollValueChanged(long newValue) {
                FrmGel.this.reDraw(true);
            }

            @Override
            public void displayPanelMouseMoved(MouseEvent e) {
                FrmGel.this.gelMouseMoved(e.getX(), e.getY());
            }
        };
        this.lblInfo = new StatusLabel();
        this.setDefaultCloseOperation(2);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FrmGel.this.formFocusLost(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                FrmGel.this.formMouseExited(evt);
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
                FrmGel.this.formWindowLostFocus(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel1.setText("Left Ladder");
        this.jLabel2.setText("Right Ladder");
        this.jLabel3.setText("Min. Bp");
        this.chkShowBp.setSelected(true);
        this.chkShowBp.setText("Show Bp");
        this.chkShowBp.setToolTipText("Toggle band size labels on the gel.");
        this.chkShowBp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmGel.this.chkShowBpActionPerformed(evt);
            }
        });
        this.cmbLadderLeft.setModel(this.comboModelLeft);
        this.cmbLadderLeft.setToolTipText("Sets the leftmost molecular weight ladder.");
        this.cmbLadderLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmGel.this.cmbLadderLeftActionPerformed(evt);
            }
        });
        this.cmbLadderRight.setModel(this.comboModelRight);
        this.cmbLadderRight.setToolTipText("Sets the rightmost molecular weight ladder.");
        this.cmbLadderRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmGel.this.cmbLadderRightActionPerformed(evt);
            }
        });
        this.cmbMinBp.setModel(new DefaultComboBoxModel<String>(new String[]{"N/A", "10", "25", "50", "100", "150", "200", "250", "300", "500", "1000"}));
        this.cmbMinBp.setToolTipText("Sets the lowest weight on the gel.  N/A = autocalculated.");
        this.cmbMinBp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmGel.this.cmbMinBpActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cmbLadderLeft, -2, 154, -2).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cmbLadderRight, -2, 154, -2).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cmbMinBp, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkShowBp).addContainerGap(62, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.chkShowBp).addComponent(this.cmbLadderLeft, -2, -1, -2).addComponent(this.cmbLadderRight, -2, -1, -2).addComponent(this.cmbMinBp, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.gelPanel.setBackground(new Color(255, 255, 255));
        this.gelPanel.setHandleMouseMotion(true);
        this.gelPanel.setScrollBars(-1);
        this.gelPanel.setFont(new Font("Monospaced", 0, 14));
        this.lblInfo.setIcon(new ImageIcon(this.getClass().getResource("/images16/ToHeadlessArrow.png")));
        GroupLayout lblInfoLayout = new GroupLayout(this.lblInfo);
        this.lblInfo.setLayout(lblInfoLayout);
        lblInfoLayout.setHorizontalGroup(lblInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        lblInfoLayout.setVerticalGroup(lblInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.gelPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.lblInfo, -1, 784, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, 0).addComponent(this.gelPanel, -1, 406, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.lblInfo, -2, -1, -2)));
        this.pack();
    }

    private void cmbLadderLeftActionPerformed(ActionEvent evt) {
        this.leftLadder = (Ladder)this.comboModelLeft.getSelectedItem();
        if (!this.loading) {
            this.regenerateWells();
            this.reDraw(true);
        }
    }

    private void cmbLadderRightActionPerformed(ActionEvent evt) {
        this.rightLadder = (Ladder)this.comboModelRight.getSelectedItem();
        if (!this.loading) {
            this.regenerateWells();
            this.reDraw(true);
        }
    }

    private void cmbMinBpActionPerformed(ActionEvent evt) {
        if (!this.loading) {
            this.regenerateWells();
            this.reDraw(true);
        }
    }

    private void chkShowBpActionPerformed(ActionEvent evt) {
        if (!this.loading) {
            this.drawGel(null, true);
        }
    }

    private void formFocusLost(FocusEvent evt) {
        if (this.tip != null) {
            this.tip.hide();
        }
        this.removeActiveBand();
    }

    private void formWindowLostFocus(WindowEvent evt) {
        if (this.tip != null) {
            this.tip.hide();
        }
        this.removeActiveBand();
    }

    private void formMouseExited(MouseEvent evt) {
        if (this.tip != null) {
            this.tip.hide();
        }
    }

    void removeActiveBand() {
        if (this.mouseOverBand != null) {
            this.mouseOverBand = null;
            this.tip.setText("");
            this.tip.hide();
            this.lblInfo.setText("");
            this.owner.gelBand = null;
            this.owner.resetMap();
        }
    }

    void reDraw(boolean resetAll) {
        if (resetAll) {
            this.canvasBuffer = null;
        }
        this.gelPanel.displayPanel.repaint();
    }

    public void drawGel(Graphics g, boolean refresh) {
        int cWidth = this.gelPanel.getWidth();
        int cHeight = this.gelPanel.getHeight();
        if (this.canvasBuffer == null || refresh || cWidth != this.panelWidth || cHeight != this.panelHeight) {
            int maxX;
            int wellsRight = this.wells.length * 50 + 10;
            int legendWidth = 0;
            int legendX = 0;
            ProjectDocument project = this.getProject();
            if (!project.enzymeMixes.isEmpty()) {
                legendX = wellsRight + 10 - this.offsetX;
                wellsRight += 15;
                FontMetrics f2 = this.gelPanel.getFontMetrics(this.gelPanel.getFont());
                legendWidth = f2.stringWidth("Enzyme Mixes");
                for (int x = 0; x < project.enzymeMixes.size(); ++x) {
                    String caption = "Mix " + String.valueOf(x + 1) + ":  " + project.enzymeMixes.get(x).getName();
                    legendWidth = Math.max(f2.stringWidth(caption), legendWidth);
                }
            }
            if ((maxX = wellsRight + legendWidth + 10) > cWidth) {
                this.gelPanel.setScrollBars(0);
                this.gelPanel.getHScrollBar().setMaximum(maxX - cWidth);
            } else if (this.gelPanel.getScrollBars() != -1) {
                this.gelPanel.setScrollBars(-1);
            }
            this.panelWidth = cWidth;
            this.panelHeight = cHeight;
            this.canvasBuffer = this.createImage(this.panelWidth, this.panelHeight);
            this.canvasGraphics = (Graphics2D)this.canvasBuffer.getGraphics();
            this.canvasGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.canvasGraphics.setFont(this.gelPanel.getFont());
            this.fontMetrics = this.canvasGraphics.getFontMetrics();
            this.fontHt = this.fontMetrics.getAscent();
            this.canvasGraphics.setColor(Globals.mapBackcolor);
            this.canvasGraphics.fillRect(0, 0, this.panelWidth, this.panelHeight);
            if (this.wells != null && this.wells.length > 0) {
                this.gelHt = this.panelHeight - 20;
                double highestTravel = 25.0;
                double lowestTravel = this.gelHt - 10;
                this.minBp = Math.max(this.minBp, 1.0);
                this.rise = Math.log10(this.minBp) - Math.log10(this.maxBp);
                this.run = lowestTravel - 15.0 - highestTravel;
                this.m = this.rise / this.run;
                this.b = Math.log10(this.minBp) - this.m * lowestTravel;
                this.canvasGraphics.setColor(Color.WHITE);
                this.canvasGraphics.fillRect(0, 0, this.gelWd, this.panelHeight);
                this.canvasGraphics.setStroke(new BasicStroke(2.0f));
                for (Well well : this.wells) {
                    this.drawWell(this.canvasGraphics, well);
                }
                if (legendWidth > 0 && wellsRight - this.offsetX < this.panelWidth) {
                    int textY = 20;
                    this.canvasGraphics.drawString("Enzyme Mixes", legendX, textY);
                    for (int x = 0; x < project.enzymeMixes.size(); ++x) {
                        String caption = "Mix " + String.valueOf(x + 1) + ":  " + project.enzymeMixes.get(x).getName();
                        this.canvasGraphics.drawString(caption, legendX, textY += this.fontHt);
                    }
                    this.canvasGraphics.drawRect(legendX - 5, 20 - this.fontHt, legendWidth + 10, textY + 13);
                }
            }
            if (this.useOverlay) {
                this.canvasGraphics.setColor(Globals.overlay);
                this.canvasGraphics.fillRect(0, 0, this.panelWidth, this.panelHeight);
            }
        }
        if (g == null) {
            g = (Graphics2D)this.gelPanel.getGraphics();
        }
        g.drawImage(this.canvasBuffer, 0, 0, this);
    }

    private int getWellX(int wellNum) {
        return wellNum * 10 + (wellNum - 1) * 40;
    }

    private void drawWell(Graphics2D g2d, Well well) {
        int wellX = well.rect.x - this.offsetX;
        if (wellX < -40 || wellX > this.panelWidth) {
            return;
        }
        int midWell = wellX + 20;
        boolean drawNum = this.chkShowBp.isSelected();
        g2d.setColor(Color.BLACK);
        g2d.drawRect(wellX, 15, 40, 5);
        int cWd = this.fontMetrics.stringWidth(well.name);
        g2d.drawString(well.name, midWell - cWd / 2, 13);
        int seqLen = this.getProject().length();
        for (Band band : well.bands) {
            int bandLen = !well.isLadder ? band.getLength(seqLen) : band.getStop();
            band.rect.y = (int)((Math.log10(bandLen) - this.b) / this.m) - 1;
            band.rect.x = wellX;
            g2d.drawLine(wellX, band.rect.y + 1, well.right - this.offsetX, band.rect.y + 1);
            if (!drawNum) continue;
            String numString = String.valueOf(bandLen);
            cWd = this.fontMetrics.stringWidth(numString);
            g2d.drawString(numString, midWell - cWd / 2, band.rect.y - 1);
        }
    }

    static /* synthetic */ int access$900() {
        return BAND_HT;
    }

    public class Band
    extends Locus {
        final Rectangle rect = new Rectangle(0, 0, 40, FrmGel.access$900());

        public Band(int start, int stop, int x) {
            this(start, stop);
            this.rect.x = x;
        }

        public Band(int start, int stop) {
            this.start = start;
            this.stop = stop;
        }
    }

    class Well {
        final Rectangle rect = new Rectangle(0, 15, 40, 5);
        boolean isLadder = false;
        int right = 0;
        String name;
        Band[] bands;

        public void setLeft(int left) {
            this.rect.x = left;
            this.right = left + 40 - 1;
        }

        public Well(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name + "," + this.bands.length;
        }
    }
}

