/*
 * Decompiled with CFR 0.152.
 */
package plot;

import BinaryTrees.BinaryChain;
import BioDocumentFilters.BioAllowedKeyFilter;
import Buttons.ButtonRenderer;
import Buttons.GlossyButton;
import GhostTextControls.GhostTextBox;
import JXTableEditorsAndRenderers.ColorCellEditor;
import JXTableEditorsAndRenderers.ColorCellRenderer;
import JXTableEditorsAndRenderers.ComboBoxCellEditor;
import JXTableEditorsAndRenderers.DefaultTableHeaderCellRenderer;
import JXTableEditorsAndRenderers.GhostTextAreaCellEditor;
import JXTableEditorsAndRenderers.GhostTextAreaCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import org.jdesktop.swingx.JXTable;
import plot.DefaultLibraries;
import plot.FeatureRenderer;
import plot.Globals;
import plot.GraphicsListRenderer;
import plot.GraphicsTypeCellRenderer;
import plot.IconCellRenderer;
import plot.IconListRenderer;
import plot.LibraryFeature;
import plot.MainExclusiveDlg;
import plot.PLOTJ;
import plot.StaticArrayComboModel;

class FrmFLibEditor
extends MainExclusiveDlg {
    private FeatureTableModel tblFeaturesModel;
    private final ArrayList<LibraryFeature> workingFeatures = new ArrayList();
    private static final int COL_NAME = 0;
    private static final int COL_SEQTYPE = 1;
    private static final int COL_SEQ = 2;
    private static final int COL_GRAPHIC = 3;
    private static final int COL_GCOLOR = 4;
    private static final int COL_CATEGORY = 5;
    private static final int COL_GBTYPE = 6;
    private static final int COL_NOTES = 7;
    DefaultTableColumnModel columnModel;
    Comparator stringDescending = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    };
    Comparator byNameDescending = new Comparator<LibraryFeature>(){

        @Override
        public int compare(LibraryFeature o1, LibraryFeature o2) {
            return o1.name.toUpperCase().compareTo(o2.name.toUpperCase());
        }
    };
    Comparator byCatNameDescending = new Comparator<LibraryFeature>(){

        @Override
        public int compare(LibraryFeature o1, LibraryFeature o2) {
            return o1.category.toUpperCase().compareTo(o2.category.toUpperCase());
        }
    };
    Comparator bySeqTypeDescending = new Comparator<LibraryFeature>(){

        @Override
        public int compare(LibraryFeature o1, LibraryFeature o2) {
            return Integer.compare(o1.type, o2.type);
        }
    };
    Comparator byGBTypeNameDescending = new Comparator<LibraryFeature>(){

        @Override
        public int compare(LibraryFeature o1, LibraryFeature o2) {
            return o1.gbType.toUpperCase().compareTo(o2.gbType.toUpperCase());
        }
    };
    Comparator byNameAscending = new Comparator<LibraryFeature>(){

        @Override
        public int compare(LibraryFeature o1, LibraryFeature o2) {
            return o2.name.toUpperCase().compareTo(o1.name.toUpperCase());
        }
    };
    private GlossyButton cmdAddNew;
    private GlossyButton cmdBot;
    private GlossyButton cmdCancel;
    private GlossyButton cmdDelete;
    private GlossyButton cmdDown;
    private GlossyButton cmdDuplicate;
    private GlossyButton cmdOK;
    private GlossyButton cmdTop;
    private GlossyButton cmdUp;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JXTable tblFeatures;

    public FrmFLibEditor(PLOTJ parent) {
        super((Window)parent);
        this.initComponents();
        this.tblFeaturesModel = new FeatureTableModel();
        this.columnModel = (DefaultTableColumnModel)this.tblFeatures.getColumnModel();
        this.tblFeatures.setModel(this.tblFeaturesModel);
        this.tblFeatures.setAutoCreateRowSorter(false);
        this.tblFeatures.setRowSorter(null);
        this.setLocationRelativeTo(parent);
        this.setIconImage(Globals.icon.getImage());
        TextCellEditor textEditor = new TextCellEditor();
        ColorCellEditor gColEditor = new ColorCellEditor();
        gColEditor.setTitle("Select new graphic color.");
        ColorCellRenderer colorRenderer = new ColorCellRenderer();
        DefaultTableCellRenderer centeredRenderer = new DefaultTableCellRenderer();
        centeredRenderer.setHorizontalAlignment(0);
        DefaultTableCellRenderer leftRenderer = new DefaultTableCellRenderer();
        leftRenderer.setHorizontalAlignment(2);
        GhostTextAreaCellEditor noteEditor = new GhostTextAreaCellEditor();
        noteEditor.getTextArea().setBlankText("(Optional) Feature Notes");
        GhostTextAreaCellRenderer noteRenderer = new GhostTextAreaCellRenderer();
        noteRenderer.getTextArea().setBlankText("(Optional) Feature Notes");
        JComboBox<FeatureRenderer> cmbGraphic = new JComboBox<FeatureRenderer>(new StaticArrayComboModel<FeatureRenderer>(FeatureRenderer.drawFeatures));
        cmbGraphic.setRenderer(new GraphicsListRenderer());
        cmbGraphic.setSelectedIndex(0);
        GraphicsTypeCellRenderer graphicRenderer = new GraphicsTypeCellRenderer();
        ComboBoxCellEditor graphicEditor = new ComboBoxCellEditor(cmbGraphic);
        JComboBox<Integer> cmbSeqType = new JComboBox<Integer>(new StaticArrayComboModel<Integer>(Globals.typeItemValues));
        IconListRenderer seqTypeRenderer = new IconListRenderer();
        seqTypeRenderer.setValues(Globals.typeTitles, Globals.typeIcons);
        cmbSeqType.setRenderer(seqTypeRenderer);
        cmbSeqType.setSelectedIndex(0);
        ComboBoxCellEditor seqtypeEditor = new ComboBoxCellEditor(cmbSeqType);
        IconCellRenderer seqTypeCellRenderer = new IconCellRenderer();
        seqTypeCellRenderer.setValues(Globals.typeTitles, Globals.typeIcons);
        JComboBox cmbGBType = new JComboBox();
        Globals.populateGenbankTypes(cmbGBType);
        ComboBoxCellEditor gbEditor = new ComboBoxCellEditor(cmbGBType);
        DefaultTableHeaderCellRenderer lcRenderer = new DefaultTableHeaderCellRenderer();
        lcRenderer.setHorizontalAlignment(2);
        DefaultTableHeaderCellRenderer hcRenderer = new DefaultTableHeaderCellRenderer();
        hcRenderer.setHorizontalAlignment(0);
        this.columnModel.getColumn(0).setHeaderRenderer(lcRenderer);
        this.columnModel.getColumn(2).setHeaderRenderer(hcRenderer);
        this.columnModel.getColumn(1).setHeaderRenderer(hcRenderer);
        this.columnModel.getColumn(3).setHeaderRenderer(lcRenderer);
        this.columnModel.getColumn(5).setHeaderRenderer(hcRenderer);
        this.columnModel.getColumn(6).setHeaderRenderer(hcRenderer);
        this.columnModel.getColumn(4).setHeaderRenderer(hcRenderer);
        this.columnModel.getColumn(7).setHeaderRenderer(lcRenderer);
        this.columnModel.getColumn(0).setCellEditor(textEditor);
        this.columnModel.getColumn(3).setCellEditor(graphicEditor);
        this.columnModel.getColumn(3).setCellRenderer(graphicRenderer);
        this.columnModel.getColumn(6).setCellEditor(gbEditor);
        this.columnModel.getColumn(6).setCellRenderer(centeredRenderer);
        this.columnModel.getColumn(5).setCellRenderer(leftRenderer);
        this.columnModel.getColumn(4).setCellEditor(gColEditor);
        this.columnModel.getColumn(4).setCellRenderer(colorRenderer);
        this.columnModel.getColumn(7).setCellEditor(noteEditor);
        this.columnModel.getColumn(7).setCellRenderer(noteRenderer);
        this.columnModel.getColumn(2).setCellEditor(noteEditor);
        this.columnModel.getColumn(1).setCellEditor(seqtypeEditor);
        this.columnModel.getColumn(1).setCellRenderer(seqTypeCellRenderer);
        JComboBox<String> cmbBox = new JComboBox<String>();
        BinaryChain<String> foundCats = new BinaryChain<String>();
        for (LibraryFeature feature : DefaultLibraries.userFeatures.items) {
            this.addFeature(feature);
            if (feature.category == null || feature.category.length() <= 0) continue;
            foundCats.addIfAbsent(feature.category, feature.category);
        }
        this.workingFeatures.sort(this.byNameDescending);
        foundCats.sort(this.stringDescending);
        for (String catName : foundCats) {
            cmbBox.addItem(catName);
        }
        CatCellEditor catEditor = new CatCellEditor(cmbBox);
        this.columnModel.getColumn(5).setCellEditor(catEditor);
        this.tblFeatures.getTableHeader().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point point = e.getPoint();
                int column = FrmFLibEditor.this.tblFeatures.columnAtPoint(point);
                switch (column) {
                    case 0: {
                        FrmFLibEditor.this.workingFeatures.sort(FrmFLibEditor.this.byNameDescending);
                        FrmFLibEditor.this.tblFeatures.repaint();
                        break;
                    }
                    case 1: {
                        FrmFLibEditor.this.workingFeatures.sort(FrmFLibEditor.this.bySeqTypeDescending);
                        FrmFLibEditor.this.tblFeatures.repaint();
                        break;
                    }
                    case 5: {
                        FrmFLibEditor.this.workingFeatures.sort(FrmFLibEditor.this.byCatNameDescending);
                        FrmFLibEditor.this.tblFeatures.repaint();
                        break;
                    }
                    case 6: {
                        FrmFLibEditor.this.workingFeatures.sort(FrmFLibEditor.this.byGBTypeNameDescending);
                        FrmFLibEditor.this.tblFeatures.repaint();
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    @Override
    public void doCancel() {
        this.workingFeatures.clear();
        this.dispose();
    }

    @Override
    public void doOK() {
        DefaultLibraries.userFeatures.items.clear();
        for (LibraryFeature f : this.workingFeatures) {
            DefaultLibraries.userFeatures.items.add(f);
        }
        DefaultLibraries.userFeatures.save();
        this.dispose();
    }

    public final void addFeature(LibraryFeature f) {
        this.tblFeaturesModel.add(f.clone());
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tblFeatures = new JXTable();
        this.cmdOK = new GlossyButton();
        this.cmdCancel = new GlossyButton();
        this.cmdDuplicate = new GlossyButton();
        this.cmdDelete = new GlossyButton();
        this.cmdAddNew = new GlossyButton();
        this.cmdTop = new GlossyButton();
        this.cmdUp = new GlossyButton();
        this.cmdDown = new GlossyButton();
        this.cmdBot = new GlossyButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("User Features Library Editor");
        this.tblFeatures.setAutoCreateRowSorter(false);
        this.tblFeatures.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.tblFeatures.setColumnSelectionAllowed(true);
        this.tblFeatures.setDoubleBuffered(true);
        this.tblFeatures.setHorizontalScrollEnabled(true);
        this.tblFeatures.setRowHeight(24);
        this.tblFeatures.setShowGrid(true);
        this.tblFeatures.setSortable(false);
        this.tblFeatures.setSortsOnUpdates(false);
        this.tblFeatures.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.tblFeatures);
        this.tblFeatures.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.cmdOK.setIcon(new ImageIcon(this.getClass().getResource("/images24/Save2.png")));
        this.cmdOK.setText("Save");
        this.cmdOK.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdOK.setShiftOnPress(true);
        this.cmdOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmFLibEditor.this.cmdOKActionPerformed(evt);
            }
        });
        this.cmdCancel.setIcon(new ImageIcon(this.getClass().getResource("/images24/Cancel.png")));
        this.cmdCancel.setText("Cancel");
        this.cmdCancel.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdCancel.setShiftOnPress(true);
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmFLibEditor.this.cmdCancelActionPerformed(evt);
            }
        });
        this.cmdDuplicate.setIcon(new ImageIcon(this.getClass().getResource("/images24/Duplicate.png")));
        this.cmdDuplicate.setText("Duplicate");
        this.cmdDuplicate.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdDuplicate.setShiftOnPress(true);
        this.cmdDelete.setIcon(new ImageIcon(this.getClass().getResource("/images24/X.png")));
        this.cmdDelete.setText("Delete");
        this.cmdDelete.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdDelete.setShiftOnPress(true);
        this.cmdAddNew.setIcon(new ImageIcon(this.getClass().getResource("/images24/Plus.png")));
        this.cmdAddNew.setText("Add New");
        this.cmdAddNew.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdAddNew.setShiftOnPress(true);
        this.cmdAddNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmFLibEditor.this.cmdAddNewActionPerformed(evt);
            }
        });
        this.cmdTop.setIcon(new ImageIcon(this.getClass().getResource("/images24/MoveFirst_4.png")));
        this.cmdTop.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdTop.setColorHot(new Color(240, 240, 240));
        this.cmdTop.setColorNormal(new Color(240, 240, 240));
        this.cmdTop.setColorPressed(new Color(240, 240, 240));
        this.cmdTop.setShiftOnPress(true);
        this.cmdUp.setIcon(new ImageIcon(this.getClass().getResource("/images24/MoveUp.png")));
        this.cmdUp.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdUp.setColorHot(new Color(240, 240, 240));
        this.cmdUp.setColorNormal(new Color(240, 240, 240));
        this.cmdUp.setColorPressed(new Color(240, 240, 240));
        this.cmdUp.setShiftOnPress(true);
        this.cmdDown.setIcon(new ImageIcon(this.getClass().getResource("/images24/MoveDown3.png")));
        this.cmdDown.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdDown.setColorHot(new Color(240, 240, 240));
        this.cmdDown.setColorNormal(new Color(240, 240, 240));
        this.cmdDown.setColorPressed(new Color(240, 240, 240));
        this.cmdDown.setShiftOnPress(true);
        this.cmdBot.setIcon(new ImageIcon(this.getClass().getResource("/images24/MoveLast_4.png")));
        this.cmdBot.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdBot.setColorHot(new Color(240, 240, 240));
        this.cmdBot.setColorNormal(new Color(240, 240, 240));
        this.cmdBot.setColorPressed(new Color(240, 240, 240));
        this.cmdBot.setShiftOnPress(true);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 571, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdTop, -2, 25, -2).addComponent(this.cmdUp, -2, 25, -2).addComponent(this.cmdDown, -2, 25, -2).addComponent(this.cmdBot, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdCancel, -2, 93, -2).addComponent(this.cmdOK, -2, 93, -2).addComponent(this.cmdDelete, -2, 93, -2).addComponent(this.cmdDuplicate, -2, 93, -2).addComponent(this.cmdAddNew, -2, 93, -2)).addGap(6, 6, 6)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 403, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdAddNew, -2, 56, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.cmdTop, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdUp, -2, 21, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdDuplicate, -2, 56, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.cmdDown, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdBot, -2, 21, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdDelete, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdOK, -2, 56, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdCancel, -2, 59, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void cmdAddNewActionPerformed(ActionEvent evt) {
        this.tblFeaturesModel.add(new LibraryFeature());
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    private void cmdOKActionPerformed(ActionEvent evt) {
        this.doOK();
    }

    private class FeatureTableModel
    extends DefaultTableModel {
        Class[] types;

        public FeatureTableModel() {
            super(null, new String[]{"Feature Name", "Sequence Type", "Sequence", "Graphic Style", "Graphic Color", "Category", "Genbank Type", "Comment"});
            this.types = new Class[]{String.class, Integer.class, String.class, String.class, Integer.class, Integer.class, Integer.class, Integer.class, Boolean.class, Boolean.class, String.class, String.class};
        }

        public Class getColumnClass(int columnIndex) {
            return this.types[columnIndex];
        }

        public void addRow(LibraryFeature feature) {
            int row = FrmFLibEditor.this.workingFeatures.size();
            FrmFLibEditor.this.workingFeatures.add(feature);
            this.fireTableRowsInserted(row, row);
        }

        @Override
        public void removeRow(int row) {
            FrmFLibEditor.this.workingFeatures.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        @Override
        public Object getValueAt(int row, int col) {
            LibraryFeature f = (LibraryFeature)FrmFLibEditor.this.workingFeatures.get(row);
            switch (col) {
                case 0: {
                    return f.name;
                }
                case 3: {
                    return f.graphicType;
                }
                case 4: {
                    return f.color;
                }
                case 6: {
                    return f.gbType;
                }
                case 7: {
                    return f.comment;
                }
                case 1: {
                    return f.type;
                }
                case 2: {
                    return f.seq;
                }
                case 5: {
                    return f.category != null && f.category.length() > 0 ? f.category : " [None]";
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            LibraryFeature f = (LibraryFeature)FrmFLibEditor.this.workingFeatures.get(row);
            switch (column) {
                case 0: {
                    f.name = (String)value;
                    break;
                }
                case 3: {
                    f.graphicType = (Integer)value;
                    break;
                }
                case 4: {
                    f.color = (Color)value;
                    break;
                }
                case 6: {
                    f.gbType = (String)value;
                    break;
                }
                case 7: {
                    f.comment = (String)value;
                    break;
                }
                case 1: {
                    f.type = (Integer)value;
                    break;
                }
                case 2: {
                    f.seq = (String)value;
                    break;
                }
                case 5: {
                    f.category = (String)value;
                }
            }
            this.fireTableCellUpdated(row, column);
        }

        @Override
        public int getColumnCount() {
            return 8;
        }

        @Override
        public int getRowCount() {
            return FrmFLibEditor.this.workingFeatures.size();
        }

        public void clear() {
            FrmFLibEditor.this.workingFeatures.clear();
        }

        public void add(LibraryFeature f) {
            FrmFLibEditor.this.workingFeatures.add(f);
            int row = FrmFLibEditor.this.workingFeatures.size();
            this.fireTableRowsInserted(row, row);
        }
    }

    private static class TextCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        static GhostTextBox textBox = new GhostTextBox();
        BioAllowedKeyFilter nameFilter = new BioAllowedKeyFilter("\\w\\-'");
        DefaultCellEditor nameTextBox = new DefaultCellEditor(textBox);

        @Override
        public Object getCellEditorValue() {
            return this.nameTextBox.getCellEditorValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            switch (column) {
                case 0: {
                    textBox.setDocumentFilter(this.nameFilter);
                    break;
                }
                default: {
                    textBox.setDocumentFilter(null);
                }
            }
            return this.nameTextBox.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private static class CatCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComboBox cmbBox;
        DefaultCellEditor comboBox;

        public CatCellEditor(JComboBox cmbBox) {
            this.cmbBox = cmbBox;
            this.comboBox = new DefaultCellEditor(cmbBox);
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getCellEditorValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.cmbBox.getModel().setSelectedItem(value);
            return this.comboBox.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }
}

