/*
 * Decompiled with CFR 0.152.
 */
package plot;

import Buttons.ButtonRenderer;
import Buttons.GlossyButton;
import DNAAnalyzer.AnalyzerResult;
import DNAAnalyzer.DNAAnalyzer;
import DNAAnalyzer.KozakAnalyzer;
import DNAAnalyzer.ShineDalgarnoAnalyzer;
import DNAAnalyzer.Sigma70Analyzer;
import DNAAnalyzer.SimpleMatrixAnalyzer;
import DocumentFilters.DocumentKeyFilter;
import GhostTextControls.GhostTextArea;
import GhostTextControls.GhostTextBox;
import JXTableEditorsAndRenderers.DefaultTableHeaderCellRenderer;
import MiscTools.StringTools;
import SequenceEditorPanels.ROI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;
import plot.Feature;
import plot.Globals;
import plot.PLOTJ;
import plot.ProjectDocument;
import plot.TempFeatureDlg;

class FrmElementFinder
extends TempFeatureDlg {
    private final ArrayList<CheckedTableItem> results = new ArrayList();
    private final JMenuItem mnuCheckAll = new JMenuItem("Check all items");
    private final JMenuItem mnuCheckAllSel = new JMenuItem("Check all selected items");
    private final JMenuItem mnuCheckUnsel = new JMenuItem("Check all unselected items");
    private final JMenuItem mnuUncheckAll = new JMenuItem("Uncheck all items");
    private final JMenuItem mnuUncheckAllSel = new JMenuItem("Uncheck all selected items");
    private final JMenuItem mnuUncheckUnsel = new JMenuItem("Uncheck all unselected items");
    private final JMenuItem mnuInvert = new JMenuItem("Invert checks of all items");
    private final JMenuItem mnuInvertSel = new JMenuItem("Invert checks of selected items");
    private final JMenuItem mnuCopySel = new JMenuItem("Copy selected items to clipboard");
    private final JMenuItem mnuCopySelAll = new JMenuItem("Copy all items to clipboard");
    ResultsTableModel currentModel;
    private JCheckBox chkFilterORF;
    private JComboBox<Float> cmbCutoff;
    private JComboBox<String> cmbElement;
    private JComboBox<String> cmbStartCodon;
    private GlossyButton cmdAddItems;
    private GlossyButton cmdAddORFs;
    private GlossyButton cmdCancel;
    private GlossyButton cmdSave;
    private GlossyButton cmdSearch;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JPanel mainPanel;
    private JXTable tblResults;
    GhostTextBox txtEnd;
    private GhostTextBox txtMaxAA;
    private GhostTextBox txtMinAA;
    private GhostTextArea txtResults;
    GhostTextBox txtStart;
    private static final int COL_SELECTED = 0;
    private static final int COL_START = 1;
    private static final int COL_STOP = 2;
    private static final int COL_SEQ = 3;
    private static final int COL_SCORE = 4;
    private static final int COL_STRAND = 5;

    public FrmElementFinder(PLOTJ parent) {
        super(parent);
        this.initComponents();
        this.txtStart.setText("1");
        this.txtEnd.setText("" + parent.getProject().length());
        this.tblResults.setAutoCreateRowSorter(false);
        this.tblResults.setRowSorter(null);
        this.tblResults.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                CheckedTableItem element;
                int row = FrmElementFinder.this.tblResults.getSelectedRow();
                if (row > -1 && row < FrmElementFinder.this.results.size() && (element = (CheckedTableItem)FrmElementFinder.this.results.get(row)) != null) {
                    element.displayText();
                }
            }
        });
        this.tblResults.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    boolean haveSelected = FrmElementFinder.this.tblResults.getSelectedRows().length > 0;
                    JPopupMenu menu = new JPopupMenu();
                    menu.add(FrmElementFinder.genToolTipSep("Check Items"));
                    menu.add(FrmElementFinder.this.mnuCheckAll);
                    menu.add(FrmElementFinder.this.mnuCheckAllSel);
                    FrmElementFinder.this.mnuCheckAllSel.setEnabled(haveSelected);
                    menu.add(FrmElementFinder.this.mnuCheckUnsel);
                    FrmElementFinder.this.mnuCheckUnsel.setEnabled(haveSelected);
                    menu.add(FrmElementFinder.genToolTipSep("Uncheck Items"));
                    menu.add(FrmElementFinder.this.mnuUncheckAll);
                    menu.add(FrmElementFinder.this.mnuUncheckAllSel);
                    FrmElementFinder.this.mnuUncheckAllSel.setEnabled(haveSelected);
                    menu.add(FrmElementFinder.this.mnuUncheckUnsel);
                    FrmElementFinder.this.mnuUncheckUnsel.setEnabled(haveSelected);
                    menu.add(FrmElementFinder.genToolTipSep("Invert Check"));
                    menu.add(FrmElementFinder.this.mnuInvert);
                    menu.add(FrmElementFinder.this.mnuInvertSel);
                    FrmElementFinder.this.mnuInvertSel.setEnabled(haveSelected);
                    menu.add(FrmElementFinder.genToolTipSep("Copy Results"));
                    menu.add(FrmElementFinder.this.mnuCopySel);
                    FrmElementFinder.this.mnuCopySel.setEnabled(haveSelected);
                    menu.add(FrmElementFinder.this.mnuCopySelAll);
                    menu.show((JXTable)e.getSource(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }
        });
        this.mnuCheckAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int x = 0; x < FrmElementFinder.this.results.size(); ++x) {
                    FrmElementFinder.this.currentModel.setChecked(x, true);
                }
                FrmElementFinder.this.repaint();
            }
        });
        this.mnuCheckAllSel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] index = FrmElementFinder.this.tblResults.getSelectedRows();
                for (int x = 0; x < index.length; ++x) {
                    FrmElementFinder.this.currentModel.setChecked(index[x], true);
                }
                FrmElementFinder.this.repaint();
            }
        });
        this.mnuCheckUnsel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] index = FrmElementFinder.this.tblResults.getSelectedRows();
                for (int x = 0; x < index.length; ++x) {
                    FrmElementFinder.this.currentModel.setChecked(index[x], false);
                }
                FrmElementFinder.this.repaint();
            }
        });
        this.mnuUncheckAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int x = 0; x < FrmElementFinder.this.results.size(); ++x) {
                    FrmElementFinder.this.currentModel.setChecked(x, false);
                }
                FrmElementFinder.this.repaint();
            }
        });
        this.mnuUncheckAllSel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] index = FrmElementFinder.this.tblResults.getSelectedRows();
                for (int x = 0; x < index.length; ++x) {
                    FrmElementFinder.this.currentModel.setChecked(index[x], false);
                }
                FrmElementFinder.this.repaint();
            }
        });
        this.mnuUncheckUnsel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] index = FrmElementFinder.this.tblResults.getSelectedRows();
                for (int x = 0; x < index.length; ++x) {
                    FrmElementFinder.this.currentModel.setChecked(index[x], false);
                }
                FrmElementFinder.this.repaint();
            }
        });
        this.mnuInvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int x = 0; x < FrmElementFinder.this.results.size(); ++x) {
                    FrmElementFinder.this.currentModel.toggleChecked(x);
                }
                FrmElementFinder.this.repaint();
            }
        });
        this.mnuInvertSel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] index = FrmElementFinder.this.tblResults.getSelectedRows();
                for (int x = 0; x < index.length; ++x) {
                    FrmElementFinder.this.currentModel.toggleChecked(index[x]);
                }
                FrmElementFinder.this.repaint();
            }
        });
        this.txtStart.setDocumentFilter(DocumentKeyFilter.NumberFilter);
        this.txtEnd.setDocumentFilter(DocumentKeyFilter.NumberFilter);
        this.txtMinAA.setDocumentFilter(DocumentKeyFilter.NumberFilter);
        this.txtMaxAA.setDocumentFilter(DocumentKeyFilter.NumberFilter);
        this.setIconImage(Globals.icon.getImage());
        this.setLocationRelativeTo(parent);
        float cutoff = 1.0f;
        while (cutoff >= 0.0f) {
            this.cmbCutoff.addItem(Float.valueOf(cutoff));
            cutoff = (float)((double)cutoff - 0.01);
        }
        this.cmbCutoff.setSelectedIndex(20);
        this.cmbCutoff.setRenderer(new FloatRenderer());
    }

    private static JPopupMenu.Separator genToolTipSep(String toolTipText) {
        JPopupMenu.Separator sep = new JPopupMenu.Separator();
        sep.setToolTipText(toolTipText);
        return sep;
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.txtStart = new GhostTextBox();
        this.txtEnd = new GhostTextBox();
        this.cmbCutoff = new JComboBox();
        this.cmbElement = new JComboBox();
        this.cmdSearch = new GlossyButton();
        this.cmdSave = new GlossyButton();
        this.cmdCancel = new GlossyButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.txtMaxAA = new GhostTextBox();
        this.txtMinAA = new GhostTextBox();
        this.cmbStartCodon = new JComboBox();
        this.jLabel8 = new JLabel();
        this.chkFilterORF = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.cmdAddItems = new GlossyButton();
        this.cmdAddORFs = new GlossyButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane2 = new JScrollPane();
        this.tblResults = new JXTable();
        this.jScrollPane1 = new JScrollPane();
        this.txtResults = new GhostTextArea();
        this.setDefaultCloseOperation(2);
        this.setTitle("pLOT DNA Element Search Tool");
        this.txtStart.setHorizontalAlignment(0);
        this.txtStart.setText("1");
        this.txtStart.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FrmElementFinder.this.txtStartFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                FrmElementFinder.this.txtStartFocusLost(evt);
            }
        });
        this.txtEnd.setHorizontalAlignment(0);
        this.txtEnd.setText("1");
        this.txtEnd.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FrmElementFinder.this.txtEndFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                FrmElementFinder.this.txtEndFocusLost(evt);
            }
        });
        this.cmbElement.setModel(new DefaultComboBoxModel<String>(new String[]{"Bacterial Promoter", "Shine Dalgarno", "Kozak", "Intron Splice Donor (GT-AG Group)", "Intron Splice Acceptor (GT-AG Group)", "Intron Splice Donor  (GC-AG Group)", "Intron Splice Acceptor (GC-AG Group)", "CAP Binding Site", "Mef-2 Binding Site"}));
        this.cmdSearch.setText("Search");
        this.cmdSearch.setColorHot(new Color(153, 153, 255));
        this.cmdSearch.setColorNormal(new Color(153, 153, 255));
        this.cmdSearch.setColorPressed(new Color(153, 153, 255));
        this.cmdSearch.setFont(new Font("Tahoma", 1, 12));
        this.cmdSearch.setMaximumSize(new Dimension(0, 33));
        this.cmdSearch.setMinimumSize(new Dimension(0, 33));
        this.cmdSearch.setPreferredSize(new Dimension(0, 33));
        this.cmdSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmElementFinder.this.cmdSearchActionPerformed(evt);
            }
        });
        this.cmdSave.setText("Save and Exit");
        this.cmdSave.setColorHot(new Color(153, 153, 255));
        this.cmdSave.setColorNormal(new Color(153, 153, 255));
        this.cmdSave.setColorPressed(new Color(153, 153, 255));
        this.cmdSave.setFont(new Font("Tahoma", 1, 12));
        this.cmdSave.setMaximumSize(new Dimension(0, 33));
        this.cmdSave.setMinimumSize(new Dimension(0, 33));
        this.cmdSave.setPreferredSize(new Dimension(0, 33));
        this.cmdSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmElementFinder.this.cmdSaveActionPerformed(evt);
            }
        });
        this.cmdCancel.setText("Cancel");
        this.cmdCancel.setColorHot(new Color(153, 153, 255));
        this.cmdCancel.setColorNormal(new Color(153, 153, 255));
        this.cmdCancel.setColorPressed(new Color(153, 153, 255));
        this.cmdCancel.setFont(new Font("Tahoma", 1, 12));
        this.cmdCancel.setMaximumSize(new Dimension(0, 33));
        this.cmdCancel.setMinimumSize(new Dimension(0, 33));
        this.cmdCancel.setPreferredSize(new Dimension(0, 33));
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmElementFinder.this.cmdCancelActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("ORF Options"));
        this.jPanel1.setOpaque(false);
        this.jLabel1.setText("Min");
        this.jLabel2.setText("Max");
        this.txtMaxAA.setHorizontalAlignment(0);
        this.txtMaxAA.setText("1");
        this.txtMaxAA.setEnabled(false);
        this.txtMaxAA.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FrmElementFinder.this.txtMaxAAFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                FrmElementFinder.this.txtMaxAAFocusLost(evt);
            }
        });
        this.txtMinAA.setHorizontalAlignment(0);
        this.txtMinAA.setText("1");
        this.txtMinAA.setToolTipText("");
        this.txtMinAA.setEnabled(false);
        this.txtMinAA.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FrmElementFinder.this.txtMinAAFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                FrmElementFinder.this.txtMinAAFocusLost(evt);
            }
        });
        this.cmbStartCodon.setModel(new DefaultComboBoxModel<String>(new String[]{"ATG", "GTG", "CTG"}));
        this.jLabel8.setHorizontalAlignment(0);
        this.jLabel8.setText("Start Codon");
        this.chkFilterORF.setText("Limit ORF Lengths");
        this.chkFilterORF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmElementFinder.this.chkFilterORFActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkFilterORF).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtMaxAA, -2, 61, -2).addComponent(this.txtMinAA, -2, 61, -2)))).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel8, -1, -1, Short.MAX_VALUE).addComponent(this.cmbStartCodon, -2, 77, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.chkFilterORF)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtMinAA, -2, -1, -2).addComponent(this.cmbStartCodon, -2, -1, -2).addComponent(this.jLabel1)).addGap(4, 4, 4).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtMaxAA, -2, -1, -2).addComponent(this.jLabel2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setText("Cutoff");
        this.jLabel6.setHorizontalAlignment(0);
        this.jLabel6.setText("Start Bp");
        this.jLabel7.setHorizontalAlignment(0);
        this.jLabel7.setText("End Bp");
        this.cmdAddItems.setIcon(new ImageIcon(this.getClass().getResource("/images24/Plus.png")));
        this.cmdAddItems.setText("Add Items");
        this.cmdAddItems.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdAddItems.setIconHot(new ImageIcon(this.getClass().getResource("/images24/Plus.png")));
        this.cmdAddItems.setIconPressed(new ImageIcon(this.getClass().getResource("/images24/Plus.png")));
        this.cmdAddItems.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmElementFinder.this.cmdAddItemsActionPerformed(evt);
            }
        });
        this.cmdAddORFs.setIcon(new ImageIcon(this.getClass().getResource("/images24/Plus.png")));
        this.cmdAddORFs.setText("Add RBS & ORFs");
        this.cmdAddORFs.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdAddORFs.setIconHot(new ImageIcon(this.getClass().getResource("/images24/Plus.png")));
        this.cmdAddORFs.setIconPressed(new ImageIcon(this.getClass().getResource("/images24/Plus.png")));
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.tblResults.setAutoCreateRowSorter(false);
        this.tblResults.setBackground(new Color(255, 255, 255));
        this.tblResults.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.tblResults.setDoubleBuffered(true);
        this.tblResults.setFont(new Font("Monospaced", 0, 14));
        this.tblResults.setHorizontalScrollEnabled(true);
        this.tblResults.setRowHeight(24);
        this.tblResults.setShowGrid(true);
        this.tblResults.setSortable(false);
        this.tblResults.setSortsOnUpdates(false);
        this.tblResults.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane2.setViewportView(this.tblResults);
        this.jSplitPane1.setTopComponent(this.jScrollPane2);
        this.txtResults.setBorder(null);
        this.txtResults.setColumns(20);
        this.txtResults.setLineWrap(true);
        this.txtResults.setRows(5);
        this.txtResults.setBlankText("No additional information.");
        this.jScrollPane1.setViewportView(this.txtResults);
        this.jSplitPane1.setRightComponent(this.jScrollPane1);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 643, Short.MAX_VALUE).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.jLabel6, -2, 85, -2).addGap(18, 18, 18).addComponent(this.jLabel7, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel5, -2, 77, -2)).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addComponent(this.txtStart, -2, 85, -2).addGap(18, 18, 18).addComponent(this.txtEnd, -2, 85, -2).addGap(132, 132, 132))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 151, Short.MAX_VALUE)).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(10, 10, 10)).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addComponent(this.cmbElement, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 8, Short.MAX_VALUE).addComponent(this.cmbCutoff, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 196, Short.MAX_VALUE))).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cmdSave, -1, -1, Short.MAX_VALUE).addComponent(this.cmdSearch, -1, -1, Short.MAX_VALUE).addComponent(this.cmdCancel, -2, 115, -2))).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.jSplitPane1).addGap(12, 12, 12).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdAddORFs, -2, 113, -2).addComponent(this.cmdAddItems, -2, 113, -2)))).addContainerGap())));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 514, Short.MAX_VALUE).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbCutoff, -2, -1, -2).addComponent(this.txtStart, -2, -1, -2).addComponent(this.cmdSearch, -2, 31, -2).addComponent(this.txtEnd, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmbElement, -2, -1, -2).addComponent(this.cmdSave, -2, 33, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.cmdCancel, -2, 32, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 289, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.cmdAddItems, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdAddORFs, -2, 54, -2).addGap(175, 175, 175))).addContainerGap())));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.mainPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.mainPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void cmdSearchActionPerformed(ActionEvent evt) {
        ProjectDocument project = this.getProject();
        this.currentModel = new ResultsTableModel();
        this.tblResults.setModel(this.currentModel);
        DefaultTableHeaderCellRenderer hcRenderer = new DefaultTableHeaderCellRenderer();
        hcRenderer.setHorizontalAlignment(0);
        DefaultTableCellRenderer centeredRenderer = new DefaultTableCellRenderer();
        centeredRenderer.setHorizontalAlignment(0);
        FloatTableRenderer centeredFloatRenderer = new FloatTableRenderer();
        centeredFloatRenderer.setHorizontalAlignment(0);
        DefaultTableCellRenderer leftRenderer = new DefaultTableCellRenderer();
        DefaultTableHeaderCellRenderer lcRenderer = new DefaultTableHeaderCellRenderer();
        lcRenderer.setHorizontalAlignment(2);
        this.tblResults.getColumn(0).setResizable(false);
        this.tblResults.getColumn(0).setMinWidth(this.tblResults.getRowHeight());
        this.tblResults.getColumn(0).setMaxWidth(this.tblResults.getRowHeight());
        this.tblResults.getColumn(0).setHeaderRenderer(hcRenderer);
        this.tblResults.getColumn(1).setHeaderRenderer(hcRenderer);
        this.tblResults.getColumn(2).setHeaderRenderer(hcRenderer);
        this.tblResults.getColumn(4).setHeaderRenderer(hcRenderer);
        this.tblResults.getColumn(3).setHeaderRenderer(lcRenderer);
        this.tblResults.getColumn(1).setCellRenderer(centeredRenderer);
        this.tblResults.getColumn(2).setCellRenderer(centeredRenderer);
        this.tblResults.getColumn(4).setCellRenderer(centeredFloatRenderer);
        this.tblResults.getColumn(3).setCellRenderer(leftRenderer);
        this.results.clear();
        this.txtResults.setText("");
        float cutoff = ((Float)this.cmbCutoff.getSelectedItem()).floatValue();
        int start = 0;
        int stop = 0;
        int orfMin = 0;
        int orfMax = 0;
        if (this.chkFilterORF.isSelected()) {
            orfMin = Integer.parseInt(this.txtMinAA.getText());
            orfMax = Integer.parseInt(this.txtMaxAA.getText());
        }
        String startCodon = this.cmbStartCodon.getSelectedItem().toString();
        DNAAnalyzer analyzer = null;
        switch (this.cmbElement.getSelectedIndex()) {
            case 0: {
                analyzer = new Sigma70Analyzer();
                break;
            }
            case 1: {
                analyzer = new ShineDalgarnoAnalyzer();
                ((ShineDalgarnoAnalyzer)analyzer).setORFMinMax(orfMin, orfMax);
                ((ShineDalgarnoAnalyzer)analyzer).setStartCodon(startCodon);
                break;
            }
            case 2: {
                analyzer = new KozakAnalyzer();
                ((KozakAnalyzer)analyzer).setORFMinMax(orfMin, orfMax);
                ((KozakAnalyzer)analyzer).setStartCodon(startCodon);
                break;
            }
            case 3: {
                analyzer = SimpleMatrixAnalyzer.GT_INTRON_SD;
                break;
            }
            case 4: {
                analyzer = SimpleMatrixAnalyzer.GT_INTRON_SA;
                break;
            }
            case 5: {
                analyzer = SimpleMatrixAnalyzer.GC_INTRON_SD;
                break;
            }
            case 6: {
                analyzer = SimpleMatrixAnalyzer.GC_INTRON_SA;
                break;
            }
            case 7: {
                analyzer = SimpleMatrixAnalyzer.CAP;
                break;
            }
            case 8: {
                analyzer = SimpleMatrixAnalyzer.MEF;
                break;
            }
            default: {
                return;
            }
        }
        if (analyzer != null) {
            analyzer.setCutoff(cutoff);
            start = StringTools.filterStringToInt(this.txtStart.getText(), 1);
            stop = StringTools.filterStringToInt(this.txtEnd.getText(), project.length());
            analyzer.setStartStop(start, stop);
            analyzer.analyze(project.getSequence());
            if (analyzer.resultCount() == 0) {
                return;
            }
            for (int x = 0; x < analyzer.resultCount(); ++x) {
                this.currentModel.add(new CheckedTableItem(analyzer.getResult(x)));
            }
        }
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    private void cmdAddItemsActionPerformed(ActionEvent evt) {
        ProjectDocument project = this.getProject();
        boolean added = true;
        for (CheckedTableItem item : this.results) {
            if (!item.selected) continue;
            Feature f = new Feature();
            f.setName(item.result.getDescription() + " (score = " + String.format("%.2f", Float.valueOf(item.result.getScore())) + ")");
            f.setStart(item.result.getStart());
            f.setStop(item.result.getStop());
            f.setOffset(110);
            f.setNote(item.data);
            this.addedFeatures.add(f);
            project.addROI((ROI)f);
            added = true;
        }
        if (added) {
            ((PLOTJ)this.getParent()).resetMap();
        }
    }

    private void cmdSaveActionPerformed(ActionEvent evt) {
        this.doOK();
    }

    private void txtEndFocusLost(FocusEvent evt) {
        int stop;
        int start;
        ProjectDocument project = this.getProject();
        try {
            start = Integer.parseInt(this.txtStart.getText());
            if (start < 1) {
                start = 1;
            } else if (start > project.length()) {
                start = project.length();
            }
        }
        catch (NumberFormatException ex) {
            start = 1;
        }
        try {
            stop = Integer.parseInt(this.txtEnd.getText());
            if (stop < 1) {
                stop = 1;
            } else if (stop > project.length()) {
                stop = project.length();
            }
        }
        catch (NumberFormatException ex) {
            stop = project.length();
        }
        if (start > stop) {
            start = stop;
        }
        this.txtEnd.setText(String.valueOf(stop));
        this.txtStart.setText(String.valueOf(start));
    }

    private void txtStartFocusLost(FocusEvent evt) {
        int stop;
        int start;
        ProjectDocument project = this.getProject();
        try {
            start = Integer.parseInt(this.txtStart.getText());
            if (start < 1) {
                start = 1;
            } else if (start > project.length()) {
                start = project.length();
            }
        }
        catch (NumberFormatException ex) {
            start = 1;
        }
        try {
            stop = Integer.parseInt(this.txtEnd.getText());
            if (stop < 1) {
                stop = 1;
            } else if (stop > project.length()) {
                stop = project.length();
            }
        }
        catch (NumberFormatException ex) {
            stop = project.length();
        }
        if (start > stop) {
            stop = start;
        }
        this.txtEnd.setText(String.valueOf(stop));
        this.txtStart.setText(String.valueOf(start));
    }

    private void txtStartFocusGained(FocusEvent evt) {
        this.txtStart.selectAll();
    }

    private void txtEndFocusGained(FocusEvent evt) {
        this.txtEnd.selectAll();
    }

    private void txtMinAAFocusGained(FocusEvent evt) {
        this.txtMinAA.selectAll();
    }

    private void txtMaxAAFocusGained(FocusEvent evt) {
        this.txtMaxAA.selectAll();
    }

    private void txtMinAAFocusLost(FocusEvent evt) {
        int max;
        int min;
        try {
            min = Integer.parseInt(this.txtMinAA.getText());
        }
        catch (NumberFormatException ex) {
            min = 1;
        }
        try {
            max = Integer.parseInt(this.txtMaxAA.getText());
        }
        catch (NumberFormatException ex) {
            max = 1;
        }
        if (min > max) {
            max = min;
        }
        this.txtMinAA.setText(String.valueOf(min));
        this.txtMaxAA.setText(String.valueOf(max));
    }

    private void txtMaxAAFocusLost(FocusEvent evt) {
        int max;
        int min;
        try {
            min = Integer.parseInt(this.txtMinAA.getText());
        }
        catch (NumberFormatException ex) {
            min = 1;
        }
        try {
            max = Integer.parseInt(this.txtMaxAA.getText());
        }
        catch (NumberFormatException ex) {
            max = 1;
        }
        if (min < max) {
            min = max;
        }
        this.txtMinAA.setText(String.valueOf(min));
        this.txtMaxAA.setText(String.valueOf(max));
    }

    private void chkFilterORFActionPerformed(ActionEvent evt) {
        this.txtMinAA.setEnabled(this.chkFilterORF.isSelected());
        this.txtMaxAA.setEnabled(this.chkFilterORF.isSelected());
    }

    class FloatRenderer
    extends JLabel
    implements ListCellRenderer<Float> {
        public FloatRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Float value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!isSelected) {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            } else {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            }
            this.setText(String.format("%.2f", value));
            return this;
        }
    }

    private class ResultsTableModel
    extends DefaultTableModel {
        Class[] types;

        public ResultsTableModel() {
            super(null, new String[]{"", "Start", "Stop", "Sequence", "Score"});
            this.types = new Class[]{Boolean.class, Integer.class, Integer.class, String.class, Float.class};
        }

        public Class getColumnClass(int columnIndex) {
            return this.types[columnIndex];
        }

        public void addRow(CheckedTableItem f) {
            FrmElementFinder.this.results.add(f);
            int row = FrmElementFinder.this.results.size();
            this.fireTableRowsInserted(row, row);
        }

        @Override
        public Object getValueAt(int row, int col) {
            CheckedTableItem f = (CheckedTableItem)FrmElementFinder.this.results.get(row);
            switch (col) {
                case 0: {
                    return f.selected;
                }
                case 1: {
                    return f.result.getStart();
                }
                case 2: {
                    return f.result.getStop();
                }
                case 3: {
                    return f.result.getSequence();
                }
                case 4: {
                    return Float.valueOf(f.result.getScore());
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            CheckedTableItem f = (CheckedTableItem)FrmElementFinder.this.results.get(row);
            switch (column) {
                case 0: {
                    f.selected = (Boolean)value;
                }
            }
            this.fireTableCellUpdated(row, column);
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return FrmElementFinder.this.results.size();
        }

        public void clear() {
            FrmElementFinder.this.results.clear();
        }

        public void add(CheckedTableItem f) {
            FrmElementFinder.this.results.add(f);
            int row = FrmElementFinder.this.results.size();
            this.fireTableRowsInserted(row, row);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public void removeRow(int row) {
            FrmElementFinder.this.results.remove(row);
        }

        public void setChecked(int row, boolean checked) {
            if (row > -1 && row < FrmElementFinder.this.results.size()) {
                ((CheckedTableItem)((FrmElementFinder)FrmElementFinder.this).results.get((int)row)).selected = checked;
                this.fireTableCellUpdated(row, 0);
            }
        }

        public boolean isChecked(int row) {
            return row > -1 && row < FrmElementFinder.this.results.size() && ((CheckedTableItem)((FrmElementFinder)FrmElementFinder.this).results.get((int)row)).selected;
        }

        public void toggleChecked(int row) {
            CheckedTableItem f = (CheckedTableItem)FrmElementFinder.this.results.get(row);
            f.selected = !f.selected;
            this.fireTableCellUpdated(row, 0);
        }
    }

    class FloatTableRenderer
    extends JLabel
    implements TableCellRenderer {
        public FloatTableRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            float fVal = ((Float)value).floatValue();
            if (!isSelected) {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            } else {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            }
            this.setText(String.format("%.2f", Float.valueOf(fVal)));
            return this;
        }
    }

    private class CheckedTableItem {
        boolean selected = false;
        String data = "";
        AnalyzerResult result;

        public CheckedTableItem() {
        }

        public CheckedTableItem(AnalyzerResult result) {
            this.data = result.getResults();
            this.result = result;
        }

        public void displayText() {
            FrmElementFinder.this.txtResults.setText(this.data);
            FrmElementFinder.this.txtResults.select(0, 0);
        }
    }
}

