/*
 * Decompiled with CFR 0.152.
 */
package plot;

import BinaryTrees.BinaryChain;
import Buttons.ButtonRenderer;
import Buttons.GlossyButton;
import EditorTable.BasicDataTable;
import EditorTable.CellEditorCheckBox;
import EditorTable.CheckBoxCellRenderer;
import EditorTable.DataTableModel;
import EditorTable.DataTableModelEvent;
import GhostTextControls.GhostTextArea;
import GhostTextControls.GhostTextBox;
import MouseMenuListeners.Listeners;
import ScrollPanels.StatusLabel;
import SequenceEditorPanels.ExtensibleArray;
import Sequences.DNA;
import UIRenderers.RenderedMenuSeparatorUI;
import UndoRedo.UndoRedoManager;
import UndoRedo.Undoable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import plaf.Defaults;
import plot.DefaultLibraries;
import plot.EditedPrimer;
import plot.JOptionPanes;
import plot.MainExclusiveDlg;
import plot.PLOTJ;
import plot.PlotPrimer;
import plot.PrimerCategory;
import plot.myClipboard;

class FrmEditPrimers
extends MainExclusiveDlg {
    public static ImageIcon icon = new ImageIcon(PLOTJ.class.getResource("/images24/Primers.png"));
    private static final int COL_SELECTED = -1;
    private static final int COL_NAME = 0;
    private static final int COL_SEQUENCE = 1;
    private static final int COL_CATEGORY = 2;
    private static final int COL_COMMENT = 3;
    private static final int COL_LOCATION = 4;
    private static final int COL_ANNEAL = 5;
    private static final int COL_UNDEFINED = 6;
    private final ExtensibleArray<PlotPrimer> tmpPrimers = new ExtensibleArray<PlotPrimer>(PlotPrimer.class);
    private PrimerCategory allCat = new PrimerCategory(" [All] ");
    private DefaultListModel2 listModel;
    boolean changed = false;
    private final MouseListener menuMouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
            JComponent c = (JComponent)arg0.getComponent();
            ToolTipManager.sharedInstance().setEnabled(false);
            if (!(c instanceof JSeparator)) {
                FrmEditPrimers.this.statusLabel.setText(c.getToolTipText(), 3000);
            }
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
            FrmEditPrimers.this.statusLabel.setText("");
        }
    };
    protected UndoRedoManager undoManager = new UndoRedoManager(){

        @Override
        public void undoRedoOccurred() {
            FrmEditPrimers.this.updateUndoRedo();
        }
    };
    private BinaryChain<PrimerCategory> totalAddedPrimerCategories = new BinaryChain();
    private CSVImportTableModel importModel;
    private JComboBox<PrimerCategory> cmbCat;
    private JComboBox<PrimerCategory> cmbCat2;
    private GlossyButton cmdAddAsNew;
    private GlossyButton cmdAddImports;
    private GlossyButton cmdAddNew;
    private JButton cmdApply;
    private GlossyButton cmdCancel;
    private GlossyButton cmdClearImports;
    private GlossyButton cmdDelPrimer;
    private JButton cmdImportCB;
    private JButton cmdImportFile;
    private JButton cmdRedo;
    private GlossyButton cmdRemAll;
    private GlossyButton cmdSaveAndClose;
    private JButton cmdUndo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JPopupMenu.Separator jSeparator13;
    private JPopupMenu.Separator jSeparator14;
    private JList<PlotPrimer> lstPrimers;
    private JMenuBar mainMenuBar;
    private JToolBar mainToolBar;
    private JMenuItem mnuCancel;
    private JMenu mnuEdit;
    private JMenu mnuFile;
    private JMenuItem mnuRedo;
    private JMenuItem mnuSave;
    private JMenuItem mnuUndo;
    private JSpinner spnMinAnneal;
    private StatusLabel statusLabel;
    private JTabbedPane tabEdit;
    private BasicDataTable tableImport;
    private GhostTextArea txtComment;
    private GhostTextBox txtLocation;
    private GhostTextBox txtName;
    private GhostTextBox txtSeq;
    private static final String[] importHeaderTitles = new String[]{"Primer Name", "Primer Sequence", "Primer Category", "Primer Comment", "Primer Location", "Primer Min. Anneal Length", "Undefined"};

    private void updateUndoRedo() {
        this.mnuUndo.setToolTipText(this.undoManager.getUndoName());
        this.mnuRedo.setToolTipText(this.undoManager.getRedoName());
        this.mnuRedo.setEnabled(this.undoManager.canRedo());
        this.mnuUndo.setEnabled(this.undoManager.canUndo());
        this.cmdUndo.setToolTipText(this.undoManager.getUndoName());
        this.cmdRedo.setToolTipText(this.undoManager.getRedoName());
        this.cmdRedo.setEnabled(this.undoManager.canRedo());
        this.cmdUndo.setEnabled(this.undoManager.canUndo());
    }

    public FrmEditPrimers(PLOTJ parent, PlotPrimer selPrimer) {
        super((Window)parent);
        this.initComponents();
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (!FrmEditPrimers.this.okToClose()) {
                    FrmEditPrimers.this.setDefaultCloseOperation(0);
                } else {
                    FrmEditPrimers.this.setDefaultCloseOperation(2);
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        ToolTipManager.sharedInstance().setEnabled(false);
        Listeners.setMenuBarListeners(this.mainMenuBar, this.menuMouseListener);
        Listeners.setToolbarListeners(this.mainToolBar, this.menuMouseListener);
        this.cmdImportCB.addMouseListener(this.menuMouseListener);
        this.cmdImportFile.addMouseListener(this.menuMouseListener);
        this.cmdClearImports.addMouseListener(this.menuMouseListener);
        this.cmdAddImports.addMouseListener(this.menuMouseListener);
        this.cmdApply.addMouseListener(this.menuMouseListener);
        this.cmdAddNew.addMouseListener(this.menuMouseListener);
        this.cmdAddAsNew.addMouseListener(this.menuMouseListener);
        this.cmdDelPrimer.addMouseListener(this.menuMouseListener);
        this.cmdCancel.addMouseListener(this.menuMouseListener);
        this.cmdSaveAndClose.addMouseListener(this.menuMouseListener);
        this.cmdRemAll.addMouseListener(this.menuMouseListener);
        this.spnMinAnneal.addMouseListener(this.menuMouseListener);
        this.mainToolBar.setFloatable(false);
        Defaults.setMenuBarHeaderFooterUIs(this.mainMenuBar, new RenderedMenuSeparatorUI(1), new RenderedMenuSeparatorUI(3));
        this.setIconImage(icon.getImage());
        this.setLocationRelativeTo(parent);
        DefaultLibraries.primerCategories.sort(PrimerCategory.sortComparator);
        this.cmbCat2.addItem(this.allCat);
        for (PrimerCategory cat : DefaultLibraries.primerCategories) {
            this.cmbCat.addItem(cat);
            this.cmbCat2.addItem(cat);
        }
        this.listModel = (DefaultListModel2)this.lstPrimers.getModel();
        int index = -1;
        if (!DefaultLibraries.userLibrary.items.isEmpty()) {
            DefaultLibraries.userLibrary.items.sort(PlotPrimer.sortComparator);
            for (PlotPrimer primer : DefaultLibraries.userLibrary.items) {
                this.tmpPrimers.add(primer);
                if (primer != selPrimer) continue;
                index = this.tmpPrimers.size() - 1;
            }
        }
        this.populatePrimerList();
        if (index > -1) {
            this.lstPrimers.setSelectedIndex(index);
            this.lstPrimers.ensureIndexIsVisible(index);
        }
        this.txtName.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                FrmEditPrimers.this.txtName.setText(FrmEditPrimers.this.txtName.getText().trim());
            }
        });
        this.txtSeq.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                FrmEditPrimers.this.txtSeq.setText(DNA.filterSequence(FrmEditPrimers.this.txtSeq.getText()));
            }
        });
        this.txtLocation.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                FrmEditPrimers.this.txtLocation.setText(FrmEditPrimers.this.txtLocation.getText().trim());
            }
        });
        this.tableImport.displayPanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    FrmEditPrimers.this.popupImportHeaderMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    FrmEditPrimers.this.popupImportHeaderMenu(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.populateFields();
    }

    private void setChanged(boolean changed) {
        if (this.changed != changed) {
            this.changed = changed;
            this.setTitle(changed ? "User Primers Editor (Not saved)" : "User Primers Editor");
        }
    }

    public static boolean showEditor(PLOTJ parent) {
        return FrmEditPrimers.showEditor(parent, null);
    }

    public static boolean showEditor(PLOTJ parent, PlotPrimer primer) {
        FrmEditPrimers dialog = new FrmEditPrimers(parent, primer);
        dialog.setVisible(true);
        return dialog.changed;
    }

    private void initComponents() {
        this.tabEdit = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.cmdRemAll = new GlossyButton();
        this.cmdCancel = new GlossyButton();
        this.cmdSaveAndClose = new GlossyButton();
        this.cmdDelPrimer = new GlossyButton();
        this.cmdAddAsNew = new GlossyButton();
        this.cmdAddNew = new GlossyButton();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.cmdApply = new JButton();
        this.txtName = new GhostTextBox();
        this.txtSeq = new GhostTextBox();
        this.txtLocation = new GhostTextBox();
        this.cmbCat = new JComboBox();
        this.spnMinAnneal = new JSpinner();
        this.jScrollPane3 = new JScrollPane();
        this.txtComment = new GhostTextArea();
        this.jPanel6 = new JPanel();
        this.jLabel1 = new JLabel();
        this.cmbCat2 = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.lstPrimers = new JList();
        this.jPanel2 = new JPanel();
        this.tableImport = new BasicDataTable();
        this.jPanel5 = new JPanel();
        this.cmdClearImports = new GlossyButton();
        this.cmdAddImports = new GlossyButton();
        this.cmdImportCB = new JButton();
        this.cmdImportFile = new JButton();
        this.mainToolBar = new JToolBar();
        this.cmdUndo = new JButton(){

            @Override
            public String getToolTipText() {
                return FrmEditPrimers.this.getUndoTT();
            }
        };
        this.cmdRedo = new JButton(){

            @Override
            public String getToolTipText() {
                return FrmEditPrimers.this.getRedoTT();
            }
        };
        this.statusLabel = new StatusLabel();
        this.mainMenuBar = new JMenuBar();
        this.mnuFile = new JMenu();
        this.mnuSave = new JMenuItem();
        this.mnuCancel = new JMenuItem();
        this.mnuEdit = new JMenu();
        this.jSeparator13 = new JPopupMenu.Separator();
        this.mnuUndo = new JMenuItem();
        this.mnuRedo = new JMenuItem();
        this.jSeparator14 = new JPopupMenu.Separator();
        this.setDefaultCloseOperation(2);
        this.setTitle("User Primers Editor");
        this.tabEdit.setToolTipText("");
        this.jPanel4.setToolTipText("");
        this.cmdRemAll.setIcon(new ImageIcon(this.getClass().getResource("/images24/ToNoGraphic.png")));
        this.cmdRemAll.setText("Remove all");
        this.cmdRemAll.setToolTipText("Remove all primers.");
        this.cmdRemAll.setColorHot(new Color(255, 0, 51));
        this.cmdRemAll.setColorNormal(new Color(240, 240, 240));
        this.cmdRemAll.setColorPressed(new Color(204, 0, 51));
        this.cmdRemAll.setFont(new Font("Segoe UI", 0, 14));
        this.cmdRemAll.setIconAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdRemAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditPrimers.this.cmdRemAllActionPerformed(evt);
            }
        });
        this.cmdCancel.setIcon(new ImageIcon(this.getClass().getResource("/images24/Cancel_1.png")));
        this.cmdCancel.setText("Cancel");
        this.cmdCancel.setToolTipText("Cancel changes and close primer editor.");
        this.cmdCancel.setColorHot(new Color(153, 153, 255));
        this.cmdCancel.setColorNormal(new Color(240, 240, 240));
        this.cmdCancel.setColorPressed(new Color(153, 153, 255));
        this.cmdCancel.setFont(new Font("Segoe UI", 0, 14));
        this.cmdCancel.setIconAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditPrimers.this.cmdCancelActionPerformed(evt);
            }
        });
        this.cmdSaveAndClose.setIcon(new ImageIcon(this.getClass().getResource("/images24/Save.png")));
        this.cmdSaveAndClose.setText("Save & Close");
        this.cmdSaveAndClose.setToolTipText("Save changes and close primer editor.");
        this.cmdSaveAndClose.setColorHot(new Color(153, 153, 255));
        this.cmdSaveAndClose.setColorNormal(new Color(240, 240, 240));
        this.cmdSaveAndClose.setColorPressed(new Color(153, 153, 255));
        this.cmdSaveAndClose.setFont(new Font("Segoe UI", 0, 14));
        this.cmdSaveAndClose.setIconAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdSaveAndClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditPrimers.this.cmdSaveAndCloseActionPerformed(evt);
            }
        });
        this.cmdDelPrimer.setIcon(new ImageIcon(this.getClass().getResource("/images24/ToNoGraphic.png")));
        this.cmdDelPrimer.setText("Delete");
        this.cmdDelPrimer.setToolTipText("Delete current primer.");
        this.cmdDelPrimer.setColorHot(new Color(255, 0, 51));
        this.cmdDelPrimer.setColorNormal(new Color(240, 240, 240));
        this.cmdDelPrimer.setColorPressed(new Color(204, 0, 51));
        this.cmdDelPrimer.setFont(new Font("Segoe UI", 0, 14));
        this.cmdDelPrimer.setIconAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdDelPrimer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditPrimers.this.cmdDelPrimerActionPerformed(evt);
            }
        });
        this.cmdAddAsNew.setIcon(new ImageIcon(this.getClass().getResource("/images24/Copy2.png")));
        this.cmdAddAsNew.setText("Add as New");
        this.cmdAddAsNew.setToolTipText("Add the current primer settings as a new primer.");
        this.cmdAddAsNew.setColorHot(new Color(153, 153, 255));
        this.cmdAddAsNew.setColorNormal(new Color(240, 240, 240));
        this.cmdAddAsNew.setColorPressed(new Color(153, 153, 255));
        this.cmdAddAsNew.setFont(new Font("Segoe UI", 0, 14));
        this.cmdAddAsNew.setIconAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdAddAsNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditPrimers.this.cmdAddAsNewActionPerformed(evt);
            }
        });
        this.cmdAddNew.setIcon(new ImageIcon(this.getClass().getResource("/images24/PLUS_1.png")));
        this.cmdAddNew.setText("Add New");
        this.cmdAddNew.setToolTipText("Add a new primer");
        this.cmdAddNew.setColorHot(new Color(153, 153, 255));
        this.cmdAddNew.setColorNormal(new Color(240, 240, 240));
        this.cmdAddNew.setColorPressed(new Color(153, 153, 255));
        this.cmdAddNew.setFont(new Font("Segoe UI", 0, 14));
        this.cmdAddNew.setIconAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdAddNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditPrimers.this.cmdAddNewActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cmdDelPrimer, -1, -1, Short.MAX_VALUE).addComponent(this.cmdAddAsNew, -1, 156, Short.MAX_VALUE).addComponent(this.cmdAddNew, -1, -1, Short.MAX_VALUE)).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cmdRemAll, -1, -1, Short.MAX_VALUE).addComponent(this.cmdSaveAndClose, -2, 156, -2)).addComponent(this.cmdCancel, GroupLayout.Alignment.TRAILING, -2, 156, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.cmdAddNew, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdAddAsNew, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdDelPrimer, -2, 32, -2).addGap(45, 45, 45).addComponent(this.cmdRemAll, -2, 32, -2).addGap(18, 18, 18).addComponent(this.cmdCancel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cmdSaveAndClose, -2, 32, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel2.setText("Primer Name");
        this.jLabel3.setText("Sequence");
        this.jLabel4.setText("Location");
        this.jLabel5.setText("Min Anneal");
        this.jLabel6.setText("Category");
        this.jLabel7.setText("Notes");
        this.cmdApply.setIcon(new ImageIcon(this.getClass().getResource("/images24/Save.png")));
        this.cmdApply.setToolTipText("Apply changes made to this primer");
        this.cmdApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditPrimers.this.cmdApplyActionPerformed(evt);
            }
        });
        this.txtName.setBlankText("(Required) Primer name");
        this.txtName.setToolTipText("Primer name");
        this.txtName.setFont(new Font("Segoe UI", 0, 14));
        this.txtSeq.setBlankText("(Required) Primer sequence");
        this.txtSeq.setToolTipText("Primer sequence (5' - 3')");
        this.txtSeq.setFont(new Font("Segoe UI", 0, 14));
        this.txtLocation.setBlankText("(Optional) Storage location");
        this.txtLocation.setToolTipText("Storage location of the primer stock");
        this.txtLocation.setFont(new Font("Segoe UI", 0, 14));
        this.cmbCat.setFont(new Font("Segoe UI", 0, 14));
        this.cmbCat.setToolTipText("Project/Category of the primer.");
        this.spnMinAnneal.setFont(new Font("Segoe UI", 0, 14));
        this.spnMinAnneal.setModel(new SpinnerNumberModel(15, 15, 30, 1));
        this.spnMinAnneal.setToolTipText("Adjust minimum annealing length for primer to be considered a match.");
        this.jScrollPane3.setHorizontalScrollBarPolicy(32);
        this.jScrollPane3.setVerticalScrollBarPolicy(22);
        this.txtComment.setBlankText("(Optional) Comments");
        this.txtComment.setColumns(20);
        this.txtComment.setRows(5);
        this.txtComment.setFont(new Font("Segoe UI", 0, 14));
        this.jScrollPane3.setViewportView(this.txtComment);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, -2, 82, -2).addComponent(this.jLabel5, -2, 82, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtLocation, -1, 197, Short.MAX_VALUE).addComponent(this.spnMinAnneal, -2, -1, -2))).addComponent(this.jLabel7, -2, 82, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel6, -2, 82, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbCat, 0, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3, -2, 82, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtSeq, -1, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2, -2, 82, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtName, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cmdApply))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.cmdApply).addComponent(this.txtName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel3).addComponent(this.txtSeq, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel6).addComponent(this.cmbCat, -2, -1, -2)).addGap(9, 9, 9).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel4).addComponent(this.txtLocation, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel5).addComponent(this.spnMinAnneal, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 239, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.jLabel1.setText("Category");
        this.cmbCat2.setModel(new DefaultComboBoxModel());
        this.cmbCat2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditPrimers.this.cmbCat2ActionPerformed(evt);
            }
        });
        this.jScrollPane1.setHorizontalScrollBarPolicy(32);
        this.lstPrimers.setModel(new DefaultListModel2());
        this.lstPrimers.setAutoscrolls(false);
        this.lstPrimers.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FrmEditPrimers.this.lstPrimersValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstPrimers);
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 258, -2).addComponent(this.cmbCat2, -2, 258, -2).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbCat2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1).addGap(0, 0, 0)));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jPanel4, -2, -1, -2).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel6, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        this.tabEdit.addTab("Primer Editor", this.jPanel3);
        this.tableImport.setFont(new Font("Segoe UI", 0, 14));
        this.jPanel5.setToolTipText(".");
        this.cmdClearImports.setIcon(new ImageIcon(this.getClass().getResource("/images24/ToNoGraphic.png")));
        this.cmdClearImports.setText("Clear Table");
        this.cmdClearImports.setToolTipText("Clear the imported data table.");
        this.cmdClearImports.setColorHot(new Color(255, 0, 51));
        this.cmdClearImports.setColorNormal(new Color(240, 240, 240));
        this.cmdClearImports.setColorPressed(new Color(204, 0, 51));
        this.cmdClearImports.setFont(new Font("Segoe UI", 0, 14));
        this.cmdClearImports.setIconAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdClearImports.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditPrimers.this.cmdClearImportsActionPerformed(evt);
            }
        });
        this.cmdAddImports.setIcon(new ImageIcon(this.getClass().getResource("/images24/PLUS_1.png")));
        this.cmdAddImports.setText("Add Selected");
        this.cmdAddImports.setToolTipText("Add selected primers to the database.");
        this.cmdAddImports.setColorHot(new Color(153, 153, 255));
        this.cmdAddImports.setColorNormal(new Color(240, 240, 240));
        this.cmdAddImports.setColorPressed(new Color(153, 153, 255));
        this.cmdAddImports.setFont(new Font("Segoe UI", 0, 14));
        this.cmdAddImports.setIconAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdAddImports.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditPrimers.this.cmdAddImportsActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cmdClearImports, -1, -1, Short.MAX_VALUE).addComponent(this.cmdAddImports, -1, 156, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.cmdAddImports, -2, 32, -2).addGap(44, 44, 44).addComponent(this.cmdClearImports, -2, 32, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.cmdImportCB.setText("Import TSV from clipboard");
        this.cmdImportCB.setToolTipText("Imports tab separated data (Ex: copied from Excel) to the table.");
        this.cmdImportCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditPrimers.this.cmdImportCBActionPerformed(evt);
            }
        });
        this.cmdImportFile.setText("Import .TSV from file");
        this.cmdImportFile.setToolTipText("Imports tab separated data from a file to the table.");
        this.cmdImportFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditPrimers.this.cmdImportFileActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tableImport, -1, 627, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.cmdImportFile).addGap(18, 18, 18).addComponent(this.cmdImportCB).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, -1, -2).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmdImportCB).addComponent(this.cmdImportFile)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tableImport, -1, 411, Short.MAX_VALUE))).addContainerGap()));
        this.tabEdit.addTab("Import", this.jPanel2);
        this.mainToolBar.setRollover(true);
        this.cmdUndo.setIcon(new ImageIcon(this.getClass().getResource("/images24/Undo.png")));
        this.cmdUndo.setToolTipText("Undo last change.");
        this.cmdUndo.setEnabled(false);
        this.cmdUndo.setFocusable(false);
        this.cmdUndo.setHorizontalTextPosition(0);
        this.cmdUndo.setVerticalTextPosition(3);
        this.cmdUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditPrimers.this.cmdUndoActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.cmdUndo);
        this.cmdRedo.setIcon(new ImageIcon(this.getClass().getResource("/images24/Redo.png")));
        this.cmdRedo.setToolTipText("Redo last undone change.");
        this.cmdRedo.setEnabled(false);
        this.cmdRedo.setFocusable(false);
        this.cmdRedo.setHorizontalTextPosition(0);
        this.cmdRedo.setVerticalTextPosition(3);
        this.cmdRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditPrimers.this.cmdRedoActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.cmdRedo);
        this.statusLabel.setIcon(new ImageIcon(this.getClass().getResource("/images16/ToHeadlessArrow.png")));
        GroupLayout statusLabelLayout = new GroupLayout(this.statusLabel);
        this.statusLabel.setLayout(statusLabelLayout);
        statusLabelLayout.setHorizontalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        statusLabelLayout.setVerticalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 24, Short.MAX_VALUE));
        this.mnuFile.setText("File");
        this.mnuSave.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.mnuSave.setIcon(new ImageIcon(this.getClass().getResource("/images24/Save.png")));
        this.mnuSave.setText("Save and Close");
        this.mnuSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditPrimers.this.mnuSaveActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.mnuSave);
        this.mnuCancel.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        this.mnuCancel.setIcon(new ImageIcon(this.getClass().getResource("/images24/Cancel.png")));
        this.mnuCancel.setText("Cancel Changes and Close");
        this.mnuCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditPrimers.this.mnuCancelActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.mnuCancel);
        this.mainMenuBar.add(this.mnuFile);
        this.mnuEdit.setText("Edit");
        this.jSeparator13.setToolTipText("Undo/Redo");
        this.mnuEdit.add(this.jSeparator13);
        this.mnuUndo.setAccelerator(KeyStroke.getKeyStroke(90, 128));
        this.mnuUndo.setIcon(new ImageIcon(this.getClass().getResource("/images24/Undo.png")));
        this.mnuUndo.setText("Undo");
        this.mnuUndo.setToolTipText("Undo the last action performed.");
        this.mnuUndo.setEnabled(false);
        this.mnuUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditPrimers.this.mnuUndoActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuUndo);
        this.mnuRedo.setAccelerator(KeyStroke.getKeyStroke(89, 128));
        this.mnuRedo.setIcon(new ImageIcon(this.getClass().getResource("/images24/Redo.png")));
        this.mnuRedo.setText("Redo");
        this.mnuRedo.setToolTipText("Redo the last undone action.");
        this.mnuRedo.setEnabled(false);
        this.mnuRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmEditPrimers.this.mnuRedoActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuRedo);
        this.jSeparator14.setToolTipText("");
        this.mnuEdit.add(this.jSeparator14);
        this.mainMenuBar.add(this.mnuEdit);
        this.setJMenuBar(this.mainMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainToolBar, -1, -1, Short.MAX_VALUE).addComponent(this.tabEdit, GroupLayout.Alignment.TRAILING).addComponent(this.statusLabel, -1, 813, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.mainToolBar, -2, -1, -2).addGap(0, 0, 0).addComponent(this.tabEdit).addGap(0, 0, 0).addComponent(this.statusLabel, -2, 24, -2)));
        this.pack();
    }

    @Override
    public void doOK() {
        this.save();
    }

    public void save() {
        if (this.changed) {
            DefaultLibraries.userLibrary.items.clear();
            for (PlotPrimer p : this.tmpPrimers) {
                if (p instanceof EditedPrimer) {
                    ((EditedPrimer)p).original.cloneFrom(p);
                    DefaultLibraries.userLibrary.items.add(((EditedPrimer)p).original);
                    ((EditedPrimer)p).original = null;
                    continue;
                }
                DefaultLibraries.userLibrary.items.add(p);
            }
            this.tmpPrimers.clear();
            DefaultLibraries.userLibrary.save();
        }
        this.dispose();
    }

    @Override
    public void doCancel() {
        this.close();
    }

    private void close() {
        if (this.changed) {
            int val = JOptionPanes.showConfirmDialog(this, "The database has unsaved changes. Quit without saving?", "Confirm Quit", 3, 0);
            switch (val) {
                case 0: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        for (PlotPrimer p : this.tmpPrimers) {
            if (!(p instanceof EditedPrimer)) continue;
            ((EditedPrimer)p).original = null;
        }
        this.tmpPrimers.clear();
        this.dispose();
    }

    private boolean okToClose() {
        return !this.changed || JOptionPanes.showConfirmDialog(this, "The database has unsaved changes. Quit without saving?", "Confirm Quit", 0, 3) == 0;
    }

    private boolean isPrimerValid(PlotPrimer p) {
        return p.name.length() != 0 && p.sequence.length() >= p.minAnneal;
    }

    private void mnuUndoActionPerformed(ActionEvent evt) {
        this.undo();
    }

    private void mnuRedoActionPerformed(ActionEvent evt) {
        this.redo();
    }

    private void cmdUndoActionPerformed(ActionEvent evt) {
        this.undo();
    }

    private void cmdRedoActionPerformed(ActionEvent evt) {
        this.redo();
    }

    private void cmdRemAllActionPerformed(ActionEvent evt) {
        if (this.lstPrimers.getModel().getSize() == 0) {
            return;
        }
        final boolean wasChanged = this.changed;
        final PlotPrimer[] deletedPrimers = this.tmpPrimers.toArray();
        final DefaultListModel2 undoListModel = this.listModel;
        final DefaultListModel2 redoListModel = new DefaultListModel2();
        Undoable event = new Undoable(){

            @Override
            public boolean undo() {
                FrmEditPrimers.this.lstPrimers.setModel(undoListModel);
                FrmEditPrimers.this.listModel = undoListModel;
                FrmEditPrimers.this.tmpPrimers.add((T[])deletedPrimers);
                FrmEditPrimers.this.setChanged(wasChanged);
                return true;
            }

            @Override
            public boolean redo() {
                FrmEditPrimers.this.lstPrimers.setModel(redoListModel);
                FrmEditPrimers.this.listModel = redoListModel;
                FrmEditPrimers.this.tmpPrimers.clear();
                FrmEditPrimers.this.setChanged(true);
                return true;
            }
        };
        event.undoName = "Undo delete all primers";
        event.redoName = "Redo delete all primers";
        this.undoManager.runEdit(event);
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void cmdSaveAndCloseActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void cmdDelPrimerActionPerformed(ActionEvent evt) {
        final int pIndex = this.lstPrimers.getSelectedIndex();
        if (pIndex == -1) {
            return;
        }
        final PlotPrimer p = this.lstPrimers.getSelectedValue();
        final boolean wasChanged = this.changed;
        if (p != null) {
            Undoable event = new Undoable(){

                @Override
                public boolean undo() {
                    if (FrmEditPrimers.this.cmbCat2.getSelectedItem() == FrmEditPrimers.this.allCat || FrmEditPrimers.this.cmbCat2.getSelectedItem() == p.category) {
                        FrmEditPrimers.this.listModel.insertElementAt(p, pIndex);
                    }
                    FrmEditPrimers.this.tmpPrimers.add(p);
                    FrmEditPrimers.this.lstPrimers.setSelectedIndex(pIndex);
                    FrmEditPrimers.this.setChanged(wasChanged);
                    return true;
                }

                @Override
                public boolean redo() {
                    if (FrmEditPrimers.this.cmbCat2.getSelectedItem() == FrmEditPrimers.this.allCat || FrmEditPrimers.this.cmbCat2.getSelectedItem() == p.category) {
                        FrmEditPrimers.this.listModel.removeElement(p);
                    }
                    FrmEditPrimers.this.tmpPrimers.remove(p);
                    int newIndex = FrmEditPrimers.this.lstPrimers.getModel().getSize() - 1;
                    FrmEditPrimers.this.lstPrimers.setSelectedIndex(newIndex);
                    FrmEditPrimers.this.setChanged(true);
                    return true;
                }
            };
            event.undoName = "Undo delete primer";
            event.redoName = "Redo delete primer";
            this.undoManager.runEdit(event);
        }
    }

    private boolean showInList(PlotPrimer p) {
        return this.cmbCat2.getSelectedItem() == this.allCat || this.cmbCat2.getSelectedItem() == p.category;
    }

    private void cmdAddAsNewActionPerformed(ActionEvent evt) {
        if (this.lstPrimers.getSelectedValue() != null) {
            final PlotPrimer p = this.genPrimer();
            final boolean wasChanged = this.changed;
            if (p != null) {
                Undoable event = new Undoable(){

                    @Override
                    public boolean undo() {
                        if (FrmEditPrimers.this.showInList(p)) {
                            FrmEditPrimers.this.listModel.removeElement(p);
                        }
                        FrmEditPrimers.this.setChanged(wasChanged);
                        return true;
                    }

                    @Override
                    public boolean redo() {
                        FrmEditPrimers.this.listModel.addElement(p);
                        int newIndex = FrmEditPrimers.this.lstPrimers.getModel().getSize() - 1;
                        FrmEditPrimers.this.lstPrimers.setSelectedIndex(newIndex);
                        FrmEditPrimers.this.setChanged(true);
                        return true;
                    }
                };
                event.undoName = "Undo add primer as new";
                event.redoName = "Redo add primer as new";
                this.undoManager.runEdit(event);
            }
        }
    }

    private PlotPrimer genPrimer() {
        if (this.lstPrimers.getSelectedValue() != null) {
            PlotPrimer p = new PlotPrimer();
            p.name = this.txtName.getText();
            p.minAnneal = (Integer)this.spnMinAnneal.getValue();
            p.sequence = this.txtSeq.getText();
            p.searchSeq = "";
            p.comment = this.txtComment.getText();
            p.category = (PrimerCategory)this.cmbCat.getSelectedItem();
            return this.isPrimerValid(p) ? p : null;
        }
        return null;
    }

    private void cmdAddNewActionPerformed(ActionEvent evt) {
        final PlotPrimer p = new PlotPrimer();
        p.name = "New Primer";
        p.minAnneal = 15;
        p.sequence = "AAAAAAAAAAAAAAA";
        p.category = DefaultLibraries.catNoCategory;
        final boolean wasChanged = this.changed;
        if (this.isPrimerValid(p)) {
            Undoable event = new Undoable(){

                @Override
                public boolean undo() {
                    if (FrmEditPrimers.this.showInList(p)) {
                        FrmEditPrimers.this.listModel.removeElement(p);
                    }
                    FrmEditPrimers.this.tmpPrimers.remove(p);
                    int newIndex = FrmEditPrimers.this.lstPrimers.getModel().getSize() - 1;
                    FrmEditPrimers.this.lstPrimers.setSelectedIndex(newIndex);
                    FrmEditPrimers.this.setChanged(wasChanged);
                    return true;
                }

                @Override
                public boolean redo() {
                    FrmEditPrimers.this.listModel.addElement(p);
                    FrmEditPrimers.this.tmpPrimers.add(p);
                    int newIndex = FrmEditPrimers.this.lstPrimers.getModel().getSize() - 1;
                    FrmEditPrimers.this.lstPrimers.setSelectedIndex(newIndex);
                    FrmEditPrimers.this.setChanged(true);
                    return true;
                }
            };
            event.redoName = "Redo add new primer";
            event.undoName = "Undo add new primer";
            this.undoManager.runEdit(event);
        }
    }

    private void setImportTableModel(CSVImportTableModel model) {
        this.tableImport.setModel(model);
        this.tableImport.setColumnCellRenderer(0, new CheckBoxCellRenderer());
        this.tableImport.setColumnCellEditor(0, new CellEditorCheckBox());
        this.tableImport.setColumnCellAlignment(0, 0);
        this.tableImport.setColumnCellAlignment(6, 0);
        this.tableImport.setColumnCellAlignment(3, 0);
        this.tableImport.setColumnCellAlignment(1, 4);
        this.importModel = model;
    }

    private void importLines(String[] lines) {
        int maxColCount = 0;
        CSVImportTableModel iModel = new CSVImportTableModel();
        for (String line : lines) {
            ImportedRow row = new ImportedRow();
            ImportedRow.access$3602(row, line.split("\t"));
            if (maxColCount < row.rowColumns.length) {
                maxColCount = row.rowColumns.length;
            }
            iModel.dataRows.add(row);
        }
        iModel.ensureColumnHeaders(maxColCount + 1);
        this.setImportTableModel(iModel);
    }

    private void cmdClearImportsActionPerformed(ActionEvent evt) {
        this.setImportTableModel(new CSVImportTableModel());
    }

    private void cmdAddImportsActionPerformed(ActionEvent evt) {
        int indexName = -1;
        int indexSeq = -1;
        int indexMinLen = -1;
        int indexCat = -1;
        int indexLocation = -1;
        int indexComment = -1;
        block8: for (int x = 0; x < this.importModel.columns.size(); ++x) {
            switch (this.importModel.columns.get((int)x).style) {
                case 0: {
                    indexName = x;
                    continue block8;
                }
                case 1: {
                    indexSeq = x;
                    continue block8;
                }
                case 2: {
                    indexCat = x;
                    continue block8;
                }
                case 3: {
                    indexComment = x;
                    continue block8;
                }
                case 4: {
                    indexLocation = x;
                    continue block8;
                }
                case 5: {
                    indexMinLen = x;
                    continue block8;
                }
            }
        }
        if (indexName == -1) {
            JOptionPanes.showMessageDialog(this, "A column for primer names must be specified to add primers.", "Missing required column!", 0);
            return;
        }
        if (indexSeq == -1) {
            JOptionPanes.showMessageDialog(this, "A column for primer sequence must be specified to add primers.", "Missing required column!", 0);
            return;
        }
        final ArrayList<PlotPrimer> addedPrimers = new ArrayList<PlotPrimer>();
        final BinaryChain<PrimerCategory> addedPrimerCategories = new BinaryChain<PrimerCategory>();
        for (int x = 0; x < this.importModel.dataRows.size(); ++x) {
            ImportedRow row = this.importModel.dataRows.get(x);
            if (row == null || !row.isSelected) continue;
            PlotPrimer p = new PlotPrimer();
            p.setName(row.get(indexName - 1));
            p.setSequence(row.get(indexSeq - 1));
            if (indexComment > -1) {
                p.setComment(row.get(indexComment - 1));
            }
            if (indexLocation > -1) {
                p.setLocation(row.get(indexLocation - 1));
            }
            if (indexMinLen > -1) {
                p.setMinAnneal(row.get(indexMinLen - 1));
            }
            if (!this.isPrimerValid(p)) continue;
            if (indexCat > -1) {
                String catName = row.get(indexCat - 1);
                if (catName == null || catName.length() == 0) {
                    p.category = DefaultLibraries.catNoCategory;
                } else if (DefaultLibraries.primerCategories.containsKey(catName)) {
                    p.category = DefaultLibraries.primerCategories.get(catName);
                } else if (addedPrimerCategories.containsKey(catName)) {
                    p.category = (PrimerCategory)addedPrimerCategories.get(catName);
                } else {
                    PrimerCategory newCat = new PrimerCategory(catName);
                    addedPrimerCategories.add(newCat);
                    p.category = newCat;
                }
            } else {
                p.category = DefaultLibraries.catNoCategory;
            }
            addedPrimers.add(p);
        }
        if (!addedPrimers.isEmpty()) {
            final boolean wasChanged = this.changed;
            Undoable event = new Undoable(){

                @Override
                public boolean undo() {
                    for (PlotPrimer p : addedPrimers) {
                        FrmEditPrimers.this.listModel.removeElement(p);
                    }
                    if (!addedPrimerCategories.isEmpty()) {
                        for (PrimerCategory cat : addedPrimerCategories) {
                            FrmEditPrimers.this.totalAddedPrimerCategories.remove(cat.name);
                        }
                    }
                    FrmEditPrimers.this.setChanged(wasChanged);
                    return true;
                }

                @Override
                public boolean redo() {
                    for (PlotPrimer p : addedPrimers) {
                        FrmEditPrimers.this.listModel.addElement(p);
                    }
                    if (!addedPrimerCategories.isEmpty()) {
                        for (PrimerCategory cat : addedPrimerCategories) {
                            FrmEditPrimers.this.totalAddedPrimerCategories.add(cat);
                        }
                    }
                    int newIndex = FrmEditPrimers.this.listModel.getSize() - 1;
                    FrmEditPrimers.this.lstPrimers.setSelectedIndex(newIndex);
                    FrmEditPrimers.this.setChanged(true);
                    return true;
                }
            };
            this.undoManager.runEdit(event);
        }
    }

    private void mnuSaveActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void mnuCancelActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    private void cmdImportFileActionPerformed(ActionEvent evt) {
        this.importFromFile();
    }

    private void cmdImportCBActionPerformed(ActionEvent evt) {
        this.importFromCB();
    }

    private void lstPrimersValueChanged(ListSelectionEvent evt) {
        this.populateFields();
    }

    private void cmbCat2ActionPerformed(ActionEvent evt) {
        this.populatePrimerList();
    }

    private void cmdApplyActionPerformed(ActionEvent evt) {
        this.applyChanges();
    }

    private void populateFields() {
        boolean havePrimer;
        PlotPrimer primer = this.lstPrimers.getSelectedValue();
        boolean bl = havePrimer = primer != null;
        if (havePrimer) {
            this.txtName.setText(primer.name);
            this.txtName.select(0, 0);
            this.txtSeq.setText(primer.sequence);
            this.txtSeq.select(0, 0);
            this.txtLocation.setText(primer.location);
            this.txtLocation.select(0, 0);
            this.txtComment.setText(primer.comment);
            this.txtComment.select(0, 0);
            this.cmbCat.setSelectedItem(primer.category);
            this.spnMinAnneal.setValue(primer.minAnneal);
        } else {
            this.txtName.setText("");
            this.txtSeq.setText("");
            this.txtLocation.setText("");
            this.txtComment.setText("");
            this.cmbCat.setSelectedItem(null);
            this.spnMinAnneal.setValue(15);
        }
        this.txtName.setEnabled(havePrimer);
        this.txtSeq.setEnabled(havePrimer);
        this.txtLocation.setEnabled(havePrimer);
        this.txtComment.setEnabled(havePrimer);
        this.cmbCat.setEnabled(havePrimer);
        this.spnMinAnneal.setEnabled(havePrimer);
        this.cmdApply.setEnabled(havePrimer);
        this.cmdAddAsNew.setEnabled(havePrimer);
        this.cmdDelPrimer.setEnabled(havePrimer);
    }

    private void importFromCB() {
        String cbData = myClipboard.getString();
        String[] lines = this.splitTextToLines(cbData);
        if (lines != null) {
            this.importLines(lines);
        }
    }

    private void importFromFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().endsWith(".tsv");
            }

            @Override
            public String getDescription() {
                return "Tab Separated Variable (*.tsv)";
            }
        });
        if (chooser.showOpenDialog(this) == 0) {
            try {
                String fileContent = new String(Files.readAllBytes(Paths.get(chooser.getSelectedFile().getCanonicalPath(), new String[0])));
                String[] lines = this.splitTextToLines(fileContent);
                if (lines != null) {
                    this.importLines(lines);
                }
            }
            catch (IOException ex) {
                if (ex instanceof NoSuchFileException) {
                    JOptionPanes.showMessageDialog(this, "File could not be found.", "Import failed", 0);
                }
                JOptionPanes.showMessageDialog(this, ex.getLocalizedMessage(), "Import failed", 0);
            }
        }
    }

    private String[] splitTextToLines(String content) {
        if (content.contains("\t")) {
            String delimiter = content.contains("\r\n") ? "\r\n" : (content.contains("\r") ? "\r" : "\n");
            return content.split(delimiter);
        }
        return null;
    }

    private void undo() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
    }

    private void redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    private void populatePrimerList() {
        block4: {
            if (this.listModel == null) break block4;
            PrimerCategory cat = (PrimerCategory)this.cmbCat2.getSelectedItem();
            this.listModel.removeAllElements();
            if (cat == this.allCat) {
                for (PlotPrimer primer : this.tmpPrimers) {
                    this.listModel.addElement(primer);
                }
            } else {
                for (PlotPrimer primer : this.tmpPrimers) {
                    if (primer.category != cat) continue;
                    this.listModel.addElement(primer);
                }
            }
        }
    }

    private void applyChanges() {
        final boolean wasChanged = this.changed;
        final PlotPrimer redoPrimer = this.genPrimer();
        if (redoPrimer != null) {
            Undoable event;
            final PlotPrimer selectedPrimer = this.lstPrimers.getSelectedValue();
            final PlotPrimer undoPrimer = new PlotPrimer();
            undoPrimer.cloneFrom(selectedPrimer);
            if (selectedPrimer instanceof EditedPrimer) {
                event = new Undoable(){

                    @Override
                    public boolean undo() {
                        int index = FrmEditPrimers.this.listModel.indexOf(selectedPrimer);
                        selectedPrimer.cloneFrom(undoPrimer);
                        FrmEditPrimers.this.listModel.fireContentsChanged(FrmEditPrimers.this.lstPrimers, index, index);
                        FrmEditPrimers.this.lstPrimers.setSelectedIndex(index);
                        FrmEditPrimers.this.populateFields();
                        FrmEditPrimers.this.setChanged(wasChanged);
                        return true;
                    }

                    @Override
                    public boolean redo() {
                        int index = FrmEditPrimers.this.listModel.indexOf(selectedPrimer);
                        selectedPrimer.cloneFrom(redoPrimer);
                        FrmEditPrimers.this.listModel.fireContentsChanged(FrmEditPrimers.this.lstPrimers, index, index);
                        FrmEditPrimers.this.lstPrimers.setSelectedIndex(index);
                        FrmEditPrimers.this.populateFields();
                        FrmEditPrimers.this.setChanged(true);
                        return true;
                    }
                };
            } else {
                final EditedPrimer ePrimer = new EditedPrimer(selectedPrimer);
                ePrimer.cloneFrom(redoPrimer);
                event = new Undoable(){

                    @Override
                    public boolean undo() {
                        int index = FrmEditPrimers.this.listModel.indexOf(ePrimer);
                        FrmEditPrimers.this.listModel.removeElementAt(index);
                        FrmEditPrimers.this.listModel.insertElementAt(selectedPrimer, index);
                        FrmEditPrimers.this.listModel.fireContentsChanged(FrmEditPrimers.this.lstPrimers, index, index);
                        FrmEditPrimers.this.lstPrimers.setSelectedIndex(index);
                        FrmEditPrimers.this.tmpPrimers.remove(ePrimer);
                        FrmEditPrimers.this.tmpPrimers.add(selectedPrimer);
                        FrmEditPrimers.this.populateFields();
                        FrmEditPrimers.this.setChanged(wasChanged);
                        return true;
                    }

                    @Override
                    public boolean redo() {
                        int index = FrmEditPrimers.this.listModel.indexOf(selectedPrimer);
                        FrmEditPrimers.this.listModel.removeElementAt(index);
                        FrmEditPrimers.this.listModel.insertElementAt(ePrimer, index);
                        FrmEditPrimers.this.lstPrimers.setSelectedIndex(index);
                        FrmEditPrimers.this.listModel.fireContentsChanged(FrmEditPrimers.this.lstPrimers, index, index);
                        FrmEditPrimers.this.lstPrimers.setSelectedIndex(index);
                        FrmEditPrimers.this.tmpPrimers.remove(selectedPrimer);
                        FrmEditPrimers.this.tmpPrimers.add(ePrimer);
                        FrmEditPrimers.this.populateFields();
                        FrmEditPrimers.this.setChanged(true);
                        return true;
                    }
                };
            }
            event.redoName = "Redo change to primers";
            event.undoName = "Undo change to primers";
            this.undoManager.runEdit(event);
        }
    }

    private void popupImportHeaderMenu(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        final int hIndex = this.tableImport.getColumnIndexAt(e.getX());
        if (hIndex == 0) {
            JMenuItem newItem = new JMenuItem("Select all");
            newItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (int x = 0; x < ((FrmEditPrimers)FrmEditPrimers.this).importModel.dataRows.size(); ++x) {
                        ((FrmEditPrimers)FrmEditPrimers.this).importModel.dataRows.get((int)x).isSelected = true;
                    }
                    FrmEditPrimers.this.importModel.fireEvents(new DataTableModelEvent(FrmEditPrimers.this.importModel, -1, -1, 0, 0, 0));
                }
            });
            menu.add(newItem);
            newItem = new JMenuItem("Unselect all");
            newItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (int x = 0; x < ((FrmEditPrimers)FrmEditPrimers.this).importModel.dataRows.size(); ++x) {
                        ((FrmEditPrimers)FrmEditPrimers.this).importModel.dataRows.get((int)x).isSelected = false;
                    }
                    FrmEditPrimers.this.importModel.fireEvents(new DataTableModelEvent(FrmEditPrimers.this.importModel, -1, -1, 0, 0, 0));
                }
            });
            menu.add(newItem);
            newItem = new JMenuItem("Inverse selection");
            newItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (int x = 0; x < ((FrmEditPrimers)FrmEditPrimers.this).importModel.dataRows.size(); ++x) {
                        ((FrmEditPrimers)FrmEditPrimers.this).importModel.dataRows.get((int)x).isSelected = !((FrmEditPrimers)FrmEditPrimers.this).importModel.dataRows.get((int)x).isSelected;
                    }
                    FrmEditPrimers.this.importModel.fireEvents(new DataTableModelEvent(FrmEditPrimers.this.importModel, -1, -1, 0, 0, 0));
                }
            });
            menu.add(newItem);
        } else {
            int hType = this.importModel.columns.get((int)hIndex).style;
            for (int x = 0; x < importHeaderTitles.length; ++x) {
                if (hType == x) continue;
                final int type = x;
                JMenuItem newItem = new JMenuItem("Set column as " + importHeaderTitles[x]);
                newItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FrmEditPrimers.this.setImportColumn(hIndex, type);
                    }
                });
                menu.add(newItem);
            }
        }
        menu.show(this.tableImport, e.getX(), e.getY());
    }

    private void setImportColumn(int colIndex, int targetType) {
        this.importModel.columns.get((int)colIndex).style = targetType;
        if (targetType == 6) {
            this.importModel.columns.get((int)colIndex).title = "Undefined";
        } else {
            this.importModel.columns.get((int)colIndex).title = importHeaderTitles[targetType];
            for (int x = 0; x < this.importModel.columns.size(); ++x) {
                if (x == colIndex || this.importModel.columns.get((int)x).style != targetType) continue;
                this.importModel.columns.get((int)x).style = 6;
                this.importModel.columns.get((int)x).title = "Undefined";
                break;
            }
        }
        this.importModel.fireEvents(new DataTableModelEvent(this.importModel, -1, -1, -1, -1, 0));
    }

    private String getUndoTT() {
        return this.undoManager != null ? this.undoManager.getUndoName() : "";
    }

    private String getRedoTT() {
        return this.undoManager != null ? this.undoManager.getRedoName() : "";
    }

    private class CSVImportTableModel
    extends DataTableModel {
        protected final ExtensibleArray<ImportedRow> dataRows = new ExtensibleArray<ImportedRow>(ImportedRow.class);
        protected final ExtensibleArray<CSVImportHeader> columns = new ExtensibleArray<CSVImportHeader>(CSVImportHeader.class);

        public CSVImportTableModel() {
            this.columns.clear();
            this.columns.add(new CSVImportHeader("Add", -1));
            this.columns.add(new CSVImportHeader("Name", 0));
            this.columns.add(new CSVImportHeader("Sequence", 1));
            this.columns.add(new CSVImportHeader("Category", 2));
            this.columns.add(new CSVImportHeader("Comment", 3));
            this.columns.add(new CSVImportHeader("Location", 4));
            this.columns.add(new CSVImportHeader("Min. anneal len.", 5));
        }

        public CSVImportTableModel(String csvFilePath) {
            this();
            int colCount = 7;
            this.ensureColumnHeaders(colCount);
        }

        private void ensureColumnHeaders(int colCount) {
            if (this.columns.size() < colCount) {
                int first = this.columns.size();
                int last = colCount - 1;
                for (int x = this.columns.size(); x < colCount; ++x) {
                    this.columns.add(new CSVImportHeader());
                }
                this.fireEvents(new DataTableModelEvent(this, -1, -1, first, last, 1));
            }
        }

        @Override
        public void clear() {
            this.dataRows.clear();
            this.fireEvents(new DataTableModelEvent(this));
        }

        @Override
        public int getColumnCount() {
            return this.columns != null ? this.columns.size() : 0;
        }

        @Override
        public int getRowCount() {
            return this.dataRows.size();
        }

        @Override
        public boolean isCellEditable(int col, int row) {
            return col == 0 && row > -1 && row < this.dataRows.size();
        }

        ImportedRow get(int row) {
            this.ensureRow(row);
            ImportedRow dataRow = this.dataRows.get(row);
            return dataRow;
        }

        @Override
        public void setValue(int col, int row, Object value) {
            if (row < 0) {
                return;
            }
            if (col == 0) {
                ImportedRow importedRow = this.get(row);
                importedRow.isSelected = (Boolean)value;
            } else {
                ImportedRow importedRow = this.get(row);
                importedRow.set(col - 1, String.valueOf(value));
            }
            this.fireEvents(new DataTableModelEvent(this, row, row, col, col, 0));
        }

        @Override
        public Object getValue(int col, int row) {
            if (row < 0 || this.columns.size() < 0) {
                return null;
            }
            ImportedRow dataRow = this.get(row);
            if (col == 0) {
                return dataRow.isSelected;
            }
            return dataRow.get(col - 1);
        }

        private void ensureRow(int row) {
            if (row >= this.dataRows.size()) {
                int first = this.dataRows.size();
                for (int x = this.dataRows.size() - 1; x < row; ++x) {
                    this.dataRows.add(new ImportedRow());
                }
                this.fireEvents(new DataTableModelEvent(this, first, row - 1, -1, -1, 0));
            }
        }

        @Override
        public int addRow(Object ... values) {
            int index = this.dataRows.size();
            this.setRow(index, values);
            return index;
        }

        @Override
        public void setRow(int row, Object ... values) {
            ImportedRow newRow;
            if (row < 0) {
                throw new IllegalArgumentException("index out of range: " + row);
            }
            if (values.length == 1 && values[0] instanceof ImportedRow) {
                newRow = (ImportedRow)values[0];
                this.dataRows.replace(newRow, row);
            } else {
                newRow = new ImportedRow();
                ImportedRow.access$3602(newRow, new String[values.length]);
                for (int x = 0; x < values.length; ++x) {
                    ((ImportedRow)newRow).rowColumns[x] = values[x] instanceof String ? (String)values[x] : String.valueOf(values[x]);
                }
                this.dataRows.insert(newRow, row);
            }
            if (newRow.rowColumns != null && newRow.rowColumns.length + 1 > this.columns.size()) {
                this.ensureColumnHeaders(newRow.rowColumns.length + 1);
            } else {
                this.fireEvents(new DataTableModelEvent(this, row, row, -1, -1, 0));
            }
        }

        @Override
        public void removeRow(int row) {
            this.dataRows.remove(row);
            this.fireEvents(new DataTableModelEvent(this, row, row, -1, -1, -1));
        }

        @Override
        public boolean swap(int row1, int row2) {
            boolean retVal = this.dataRows.swap(row1, row2);
            this.fireEvents(new DataTableModelEvent(this, row1, row2, -1, -1, 0));
            return retVal;
        }

        public void setColumnType(int colIndex, int colType) {
            int newColIndex;
            if (colIndex < 0 || colIndex > this.columns.size()) {
                return;
            }
            CSVImportHeader cHeader = this.columns.get(colIndex);
            if (cHeader == null || cHeader.style == colType) {
                return;
            }
            for (newColIndex = 1; newColIndex < this.columns.size(); ++newColIndex) {
                if (this.columns.get((int)newColIndex).style != colType) continue;
                this.columns.swap(colIndex, newColIndex);
                break;
            }
            this.fireEvents(new DataTableModelEvent(this, -1, -1, Math.min(colIndex, newColIndex), Math.max(colIndex, newColIndex), 0));
        }

        @Override
        public void insertColumn(Object value, int index) {
        }

        @Override
        public Object getColumn(int index) {
            return this.columns.get(index);
        }

        private boolean isValidIndex(int index) {
            return this.columns != null && index > -1 && index < this.columns.size();
        }

        @Override
        public void setColumn(int index, Object value) {
            if (this.isValidIndex(index)) {
                if (value instanceof CSVImportHeader) {
                    this.columns.replace((CSVImportHeader)value, index);
                } else if (value instanceof String) {
                    this.columns.get((int)index).title = String.valueOf(value);
                } else if (value instanceof Integer) {
                    this.columns.get((int)index).style = (Integer)value;
                }
            }
        }

        @Override
        public void setColumns(Object ... values) {
            this.columns.clear();
            for (Object value : values) {
                if (value instanceof CSVImportHeader) {
                    this.columns.add((CSVImportHeader)value);
                    continue;
                }
                if (value instanceof String) {
                    this.columns.add(new CSVImportHeader((String)value));
                    continue;
                }
                if (!(value instanceof Integer)) continue;
                this.columns.add(new CSVImportHeader((Integer)value));
            }
        }

        @Override
        public void setColumnCount(int count) {
            block4: {
                block3: {
                    if (count == 0) {
                        this.columns.clear();
                        return;
                    }
                    if (count <= this.columns.size()) break block3;
                    for (int x = 0; x < count - this.columns.size(); ++x) {
                        this.columns.add(new CSVImportHeader());
                    }
                    break block4;
                }
                if (count >= this.columns.size()) break block4;
                for (int x = this.columns.size(); x > count; --x) {
                    this.columns.remove(x - 1);
                }
            }
        }

        @Override
        public void resizeColumn(int count) {
        }
    }

    class DefaultListModel2<Primer>
    extends DefaultListModel {
        DefaultListModel2() {
        }

        @Override
        public void fireContentsChanged(Object source, int index0, int index1) {
            super.fireContentsChanged(source, index0, index1);
        }
    }

    private class ImportedRow {
        public boolean isSelected = true;
        private String[] rowColumns = null;

        private ImportedRow() {
        }

        public String get(int columnIndex) {
            return this.rowColumns != null && columnIndex < this.rowColumns.length ? this.rowColumns[columnIndex] : "";
        }

        public void set(int col, String value) {
            if (col < 0) {
                return;
            }
            if (this.rowColumns == null || this.rowColumns.length == 0) {
                this.rowColumns = new String[col + 1];
            } else if (col >= this.rowColumns.length) {
                String[] newCols = new String[col + 1];
                System.arraycopy(this.rowColumns, 0, newCols, 0, this.rowColumns.length);
                this.rowColumns = newCols;
            }
            this.rowColumns[col] = value;
        }

        static /* synthetic */ String[] access$3602(ImportedRow x0, String[] x1) {
            x0.rowColumns = x1;
            return x1;
        }
    }

    private class CSVImportHeader {
        String title = "Undefined";
        int style = 6;

        public CSVImportHeader() {
        }

        public CSVImportHeader(String title) {
            this.title = title;
        }

        public CSVImportHeader(int style) {
            this.style = style;
        }

        public CSVImportHeader(String title, int style) {
            this.title = title;
            this.style = style;
        }

        public String toString() {
            return this.title;
        }
    }
}

