/*
 * Decompiled with CFR 0.152.
 */
package plot;

import GenbankFileReader.Locus;
import SequenceEditorPanels.ExtensibleArray;
import Sequences.DNA;
import java.util.ArrayList;
import plot.DefaultLibraries;
import plot.PlotPrimer;
import plot.PrimerFeature;
import plot.ProjectDocument;

class FoundPrimer {
    public PlotPrimer refPrimer;
    public int siteCount = 0;

    public static void findSites(PlotPrimer primer, String sequence, int maxLen, boolean searchSense, boolean searchAntisense, ProjectDocument project) {
        Locus pos;
        int index;
        ArrayList<Locus> bindingSites = new ArrayList<Locus>();
        if (primer.searchSeq == null || primer.searchSeq.length() == 0) {
            primer.searchSeq = primer.minAnneal < primer.sequence.length() ? primer.sequence.substring(primer.sequence.length() - primer.minAnneal) : primer.sequence;
        }
        String searchSeq = primer.searchSeq;
        int seqLen = searchSeq.length();
        int siteCount = 0;
        if (searchSense) {
            index = sequence.indexOf(searchSeq, 0);
            while (index > -1 && index < maxLen) {
                pos = new Locus(index + 1, index + seqLen, false, maxLen);
                bindingSites.add(pos);
                ++siteCount;
                index = sequence.indexOf(searchSeq, index + 1);
            }
        }
        if (searchAntisense) {
            searchSeq = DNA.getAntisense(searchSeq);
            index = sequence.indexOf(searchSeq, 0);
            while (index > -1 && index < maxLen) {
                pos = new Locus(index + 1, index + seqLen, true, maxLen);
                bindingSites.add(pos);
                ++siteCount;
                index = sequence.indexOf(searchSeq, index + 1);
            }
        }
        if (!bindingSites.isEmpty()) {
            FoundPrimer fPrimer = new FoundPrimer(primer);
            if (fPrimer.refPrimer.category == null) {
                fPrimer.refPrimer.category = DefaultLibraries.catNoCategory;
            }
            ExtensibleArray<PrimerFeature> list = new ExtensibleArray<PrimerFeature>(PrimerFeature.class);
            list.insert(0, (PrimerFeature[])project.linkedPrimers.get(primer.searchSeq));
            project.foundCategories.add(primer.category, primer.category.name);
            primer.category.count += bindingSites.size();
            for (int x = 0; x < bindingSites.size(); ++x) {
                PrimerFeature pf = new PrimerFeature(fPrimer, (Locus)bindingSites.get(x));
                project.foundPrimers.add(pf);
                list.add(pf);
            }
            if (list.size() == 0) {
                project.linkedPrimers.add(list.toArray(), primer.searchSeq);
            }
        }
    }

    public FoundPrimer(PlotPrimer p) {
        this.refPrimer = p;
    }

    public FoundPrimer clone() {
        FoundPrimer clone = new FoundPrimer(this.refPrimer);
        clone.siteCount = this.siteCount;
        return clone;
    }
}

