/*
 * Decompiled with CFR 0.152.
 */
package plot;

import Defaults.DefaultValues;
import Defaults.GenbankType;
import GenbankFileReader.Annotation;
import GenbankFileReader.Qualifier;
import MiscTools.ColorTools;
import MiscTools.StringTools;
import SequenceEditorPanels.ROI;
import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import plot.FeatureRenderer;
import plot.Label;
import plot.LibraryFeature;

public class Feature
extends ROI
implements Serializable {
    private static final long serialVersionUID = 1L;
    float fWidth = 0.0f;
    private Color textColor = Color.black;
    private int orgIndex = 0;
    private int alpha = 255;
    boolean showLabel = true;
    private boolean hidden = false;
    String note = "";
    private int offset = 100;
    int width = 5;
    String toolTipNote = null;
    private String caption = "";
    final transient Label label = new Label();
    transient double startDegree;
    transient float rOffset = 1.0f;
    transient FeatureRenderer renderer = FeatureRenderer.drawFeatures[5];
    transient GeneralPath[] shapes = new GeneralPath[4];
    private static final String FEATURESPACER = "     ";
    private static final int BASEQUALNUM = 10;
    private static final int ROI_NAME = 5;
    private static final int LABEL_NAME = 4;
    private static final int GENE_NAME = 3;
    private static final int ORGANISM_NAME = 2;
    private static final int PRODUCT_NAME = 1;

    public Feature() {
    }

    public Feature(String name) {
        this.setName(name);
    }

    public Feature(String name, int start, int stop) {
        this.setName(name);
        this.set(start, stop);
    }

    public Feature(String name, int start, int stop, boolean antisense) {
        this.setName(name);
        this.set(start, stop, antisense);
    }

    public Feature(String name, GraphicStyle style) {
        this.setName(name);
        this.setGraphicStyle(style);
    }

    public Feature(String name, int start, int stop, GraphicStyle style) {
        this.setName(name);
        this.set(start, stop);
        this.setGraphicStyle(style);
    }

    public Feature(String name, int start, int stop, boolean antisense, GraphicStyle style) {
        this.setName(name);
        this.set(start, stop, antisense);
        this.setGraphicStyle(style);
    }

    public Feature(String name, int start, int stop, boolean antisense, GraphicStyle style, Color graphicColor) {
        this.setName(name);
        this.set(start, stop, antisense);
        this.setGraphicStyle(style);
        this.setColor(graphicColor);
    }

    public Feature(String name, int start, int stop, boolean antisense, GraphicStyle style, Color graphicColor, Color textColor) {
        this.setName(name);
        this.set(start, stop, antisense);
        this.setGraphicStyle(style);
        this.setColor(graphicColor);
        this.setTextColor(textColor);
    }

    public void setOrg(int index) {
        this.orgIndex = index;
    }

    public int getOrg() {
        return this.orgIndex;
    }

    public void resetShape() {
        if (this.shapes != null) {
            this.shapes[0] = null;
            this.shapes[1] = null;
            this.shapes[2] = null;
            this.shapes[3] = null;
        }
        if (this.label != null) {
            this.label.hitTestShape = null;
        }
    }

    @Override
    public void antisense(int sequenceLength) {
        super.antisense(sequenceLength);
        this.resetShape();
    }

    @Override
    public void rotateOrigin(int newOrigin, int seqLen) {
        super.rotateOrigin(newOrigin, seqLen);
        this.resetShape();
    }

    public Color getBackColor() {
        return new Color(this.color.getRGB());
    }

    public void setBackColor(Color color) {
        if (color == null) {
            color = Color.black;
        }
        super.setColor(color);
        this.color = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.alpha);
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        this.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), alpha);
    }

    @Override
    public void setStart(int start) {
        if (this.start != start) {
            this.start = start;
            this.resetShape();
        }
    }

    @Override
    public void setStop(int stop) {
        if (this.stop != stop) {
            this.stop = stop;
            this.resetShape();
        }
    }

    public void setPosition(int start, int stop) {
        boolean changed = false;
        if (this.start != start) {
            this.start = start;
            changed = true;
        }
        if (this.stop != stop) {
            this.stop = stop;
            changed = true;
        }
        if (changed) {
            this.resetShape();
        }
    }

    public boolean showLabel() {
        return this.showLabel && this.renderer != null && !(this.renderer instanceof FeatureRenderer.NoGraphicFeature);
    }

    public void setShowLabel(boolean show) {
        this.showLabel = show;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean Hidden2) {
        this.hidden = Hidden2;
        this.resetShape();
    }

    @Override
    public void setAntisense(boolean antisense) {
        this.antisense = antisense;
        this.resetShape();
    }

    public void antisense() {
        this.antisense = !this.antisense;
        this.resetShape();
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String Note) {
        this.note = Note;
        this.toolTipNote = null;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int value) {
        if (value <= 150 && value >= 50) {
            this.offset = value;
            this.rOffset = (float)this.offset / 100.0f;
            this.resetShape();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        if ((float)width <= this.renderer.maxWidth && (float)width >= this.renderer.minWidth) {
            this.width = width;
            this.resetShape();
        }
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String text) {
        this.caption = text;
    }

    public String getLabelText() {
        String displayName;
        String string = displayName = this.caption != null && this.caption.length() > 0 ? this.caption : this.getName();
        if (this.antisense) {
            return displayName + " (" + this.stop + " - " + this.start + ")";
        }
        return displayName + " (" + this.start + " - " + this.stop + ")";
    }

    public FeatureRenderer getGraphicStyle() {
        return this.renderer;
    }

    void setGraphicStyle(FeatureRenderer graphicStyle) {
        Feature.pSetGraphicStyle(this, graphicStyle);
    }

    public final void setGraphicStyle(GraphicStyle style) {
        switch (style) {
            case Box: {
                this.setGraphicStyle(1);
                return;
            }
            case Line: {
                this.setGraphicStyle(0);
                return;
            }
            case BoxArrow: {
                this.setGraphicStyle(2);
                return;
            }
            case HeadlessArrow: {
                this.setGraphicStyle(6);
                return;
            }
            case LineArrow: {
                this.setGraphicStyle(7);
                return;
            }
            case TickMark: {
                this.setGraphicStyle(3);
                return;
            }
            case Bracket: {
                this.setGraphicStyle(4);
                return;
            }
            case None: {
                this.setGraphicStyle(5);
            }
        }
    }

    static int getGraphicStyleIndex(String value) {
        String lval = value.toLowerCase();
        for (int x = 0; x < FeatureRenderer.featureNames.length; ++x) {
            for (String sVal : FeatureRenderer.featureNames[x]) {
                if (!lval.equals(sVal)) continue;
                return x;
            }
        }
        return 3;
    }

    void setGraphicStyle(int graphicStyleValue) {
        if (graphicStyleValue < 0 || graphicStyleValue >= FeatureRenderer.loadedDrawFeatures.length) {
            graphicStyleValue = 3;
        }
        this.renderer = FeatureRenderer.loadedDrawFeatures[graphicStyleValue];
    }

    public void decWidth() {
        this.setWidth(this.width - 1);
    }

    public void incWidth() {
        this.setWidth(this.width + 1);
    }

    public void decOffset() {
        this.setOffset(this.offset - 1);
    }

    public void incOffset() {
        this.setOffset(this.offset + 1);
    }

    @Override
    public Feature clone() {
        Feature destFeature = new Feature();
        Feature.cloneFeature(this, destFeature);
        return destFeature;
    }

    public void cloneTo(Feature destFeature) {
        Feature.cloneFeature(this, destFeature);
    }

    public void cloneFrom(Feature srcFeature) {
        Feature.cloneFeature(srcFeature, this);
    }

    public boolean equals(Feature feature) {
        return super.equals(feature) && this.name.equals(feature.name);
    }

    @Override
    public String toGBString() {
        return Feature.pToGBString(this);
    }

    private static void pSetGraphicStyle(Feature feature, FeatureRenderer graphicStyle) {
        if (!graphicStyle.equals(feature.renderer)) {
            feature.width = (int)FeatureRenderer.scale(feature.width, feature.renderer.minWidth, feature.renderer.maxWidth, graphicStyle.minWidth, graphicStyle.maxWidth);
            feature.renderer = graphicStyle;
            if (feature.renderer.getSortIndex() == 5 && feature.offset == 100) {
                feature.setOffset(110);
            } else if (feature.renderer.getSortIndex() == 6 && feature.offset == 100) {
                feature.setOffset(120);
            }
            feature.resetShape();
        }
    }

    private static String pToGBString(Feature feature) {
        if (feature.gbType.length() == 0) {
            feature.gbType = "misc_feature";
        }
        StringBuilder outString = feature.antisense ? new StringBuilder(FEATURESPACER + feature.gbType + StringTools.repeat(' ', 17 - feature.gbType.length()) + "complement(" + feature.start + ".." + feature.stop + ")") : new StringBuilder(FEATURESPACER + feature.gbType + StringTools.repeat(' ', 17 - feature.gbType.length()) + feature.start + ".." + feature.stop);
        outString.append("\n                     /label=").append(feature.getName());
        outString.append("\n                     /pLOT_rOffset=").append(feature.rOffset);
        outString.append("\n                     /pLOT_Color=").append(ColorTools.colorToInt(feature.color));
        outString.append("\n                     /pLOT_Alpha=").append(feature.alpha);
        outString.append("\n                     /pLOT_fType=").append(FeatureRenderer.getFeatureLoadIndex(feature));
        outString.append("\n                     /pLOT_fWidth=").append((float)feature.width / 10.0f);
        outString.append("\n                     /pLOT_fOrient=").append(feature.antisense ? "-1" : "1");
        outString.append("\n                     /pLOT_FHide=").append(feature.hidden ? "1" : "0");
        outString.append("\n                     /pLOT_tcolor=").append(ColorTools.colorToInt(feature.textColor));
        outString.append("\n                     /pLOT_ShowLabel=").append(feature.showLabel ? "1" : "0");
        if (feature.note != null && feature.note.length() > 0) {
            String[] noteLines = feature.note.split("\n");
            for (int x = 0; x < noteLines.length; ++x) {
                outString.append("\n                     /note=").append(noteLines[x]);
            }
        }
        if (feature.qualifiers != null && feature.qualifiers.length > 0) {
            for (Qualifier qual : feature.qualifiers) {
                outString.append("\n").append(qual.toGBString());
            }
        }
        return outString.toString();
    }

    @Override
    public String toString() {
        return this.name + " " + super.toString();
    }

    private static void cloneFeature(Feature srcFeature, Feature destFeature) {
        destFeature.color = srcFeature.color;
        destFeature.caption = srcFeature.caption;
        destFeature.gbType = srcFeature.gbType;
        destFeature.renderer = srcFeature.renderer;
        destFeature.hidden = srcFeature.hidden;
        destFeature.name = srcFeature.name;
        destFeature.note = srcFeature.note;
        destFeature.showLabel = srcFeature.showLabel;
        destFeature.textColor = srcFeature.textColor;
        destFeature.setOffset(srcFeature.offset);
        destFeature.width = srcFeature.width;
        destFeature.toolTipNote = srcFeature.toolTipNote;
        destFeature.set(srcFeature.start, srcFeature.stop, srcFeature.antisense);
    }

    public static Feature fromLibraryFeature(LibraryFeature libraryFeature) {
        Feature f = new Feature();
        f.setBackColor(libraryFeature.color);
        f.setGBType(libraryFeature.gbType);
        f.setName(libraryFeature.name);
        f.setGraphicStyle(libraryFeature.graphicType);
        return f;
    }

    public static Annotation toAnnotation(Feature feature) {
        Annotation newAnnotation = new Annotation();
        int qnum = feature.qualifiers != null && feature.qualifiers.length > 0 ? 10 + feature.qualifiers.length + 1 : 11;
        newAnnotation.setName(feature.getName());
        newAnnotation.set(feature.start, feature.stop, feature.antisense);
        newAnnotation.setGBType(feature.getGBType());
        newAnnotation.qualifiers = new Qualifier[qnum];
        newAnnotation.qualifiers[0] = new Qualifier("plot_showlabel", "" + feature.showLabel());
        newAnnotation.qualifiers[1] = new Qualifier("textcolor", "" + ColorTools.colorToInt(feature.getTextColor()));
        newAnnotation.qualifiers[2] = new Qualifier("plot_alpha", "" + feature.getAlpha());
        newAnnotation.qualifiers[3] = new Qualifier("plot_labelcap", feature.getCaption());
        newAnnotation.qualifiers[4] = new Qualifier("plot_fwidth", "" + feature.getWidth());
        newAnnotation.qualifiers[5] = new Qualifier("plot_ftype", "" + FeatureRenderer.getFeatureLoadIndex(feature));
        newAnnotation.qualifiers[6] = new Qualifier("plot_fhide", "" + feature.isHidden());
        newAnnotation.qualifiers[7] = new Qualifier("note", feature.getNote());
        newAnnotation.qualifiers[8] = new Qualifier("plot_offset", "" + feature.getOffset());
        newAnnotation.qualifiers[9] = new Qualifier("orgindex", "" + feature.getOrg());
        newAnnotation.qualifiers[10] = new Qualifier("plot_color", "" + ColorTools.colorToInt(feature.getBackColor()));
        if (feature.qualifiers != null && feature.qualifiers.length > 0) {
            for (int y = 0; y < feature.qualifiers.length; ++y) {
                newAnnotation.qualifiers[10 + y] = feature.qualifiers[y].clone();
            }
        }
        return newAnnotation;
    }

    public static ROI toROI(ROI roi) {
        if (roi instanceof Feature) {
            Feature feature = (Feature)roi;
            ROI newAnnotation = new ROI();
            int qnum = feature.qualifiers != null && feature.qualifiers.length > 0 ? 10 + feature.qualifiers.length : 10;
            newAnnotation.setName(feature.getName());
            newAnnotation.set(feature.start, feature.stop, feature.antisense);
            newAnnotation.setGBType(feature.getGBType());
            newAnnotation.setColor(feature.getBackColor());
            newAnnotation.qualifiers = new Qualifier[qnum];
            newAnnotation.qualifiers[0] = new Qualifier("plot_showlabel", "" + feature.showLabel());
            newAnnotation.qualifiers[1] = new Qualifier("textcolor", "" + ColorTools.colorToInt(feature.getTextColor()));
            newAnnotation.qualifiers[2] = new Qualifier("plot_alpha", "" + feature.getAlpha());
            newAnnotation.qualifiers[3] = new Qualifier("plot_labelcap", feature.getCaption());
            newAnnotation.qualifiers[4] = new Qualifier("plot_fwidth", "" + feature.getWidth());
            newAnnotation.qualifiers[5] = new Qualifier("plot_ftype", "" + FeatureRenderer.getFeatureLoadIndex(feature));
            newAnnotation.qualifiers[6] = new Qualifier("plot_fhide", "" + feature.isHidden());
            newAnnotation.qualifiers[7] = new Qualifier("note", feature.getNote());
            newAnnotation.qualifiers[8] = new Qualifier("plot_offset", "" + feature.getOffset());
            newAnnotation.qualifiers[9] = new Qualifier("orgindex", "" + feature.getOrg());
            if (feature.qualifiers != null && feature.qualifiers.length > 0) {
                for (int y = 0; y < feature.qualifiers.length; ++y) {
                    newAnnotation.qualifiers[10 + y] = feature.qualifiers[y].clone();
                }
            }
            return newAnnotation;
        }
        if (roi instanceof ROI) {
            return roi.clone();
        }
        if (roi instanceof Annotation) {
            return ROI.fromAnnotation(roi);
        }
        return null;
    }

    public static Feature fromAnnotation(Annotation annotation) {
        if (annotation == null || annotation.getStart() < 1 || annotation.getStop() < 1) {
            return null;
        }
        Color gColor = null;
        Color tColor = Color.black;
        String name = annotation.getGBType();
        int nameSrc = 0;
        if (annotation instanceof Feature) {
            return ((Feature)annotation).clone();
        }
        if (annotation instanceof ROI) {
            gColor = ((ROI)annotation).getColor();
            nameSrc = 5;
            name = ((ROI)annotation).getName();
        }
        Feature outFeature = new Feature();
        outFeature.setName(annotation.getName());
        outFeature.set(annotation.getStart(), annotation.getStop(), annotation.isAntisense());
        outFeature.setGBType(annotation.getGBType());
        int rendererType = -1;
        GenbankType defaultType = DefaultValues.GBTYPES.get(outFeature.gbType.toLowerCase());
        if (defaultType != null) {
            rendererType = defaultType.loadedGraphicIndex;
            if (outFeature.getBackColor() == null && defaultType.color != null) {
                gColor = defaultType.color;
            }
            if (defaultType.textColor != null) {
                tColor = defaultType.textColor;
            }
        }
        if (annotation.qualifiers != null && annotation.qualifiers.length > 0) {
            ArrayList<Qualifier> quals = new ArrayList<Qualifier>();
            block50: for (int y = 0; y < annotation.qualifiers.length; ++y) {
                String lQual = annotation.qualifiers[y].key.toLowerCase();
                String val = annotation.qualifiers[y].value;
                switch (lQual) {
                    case "label": {
                        if (name.length() != 0 && nameSrc >= 4) continue block50;
                        name = val;
                        nameSrc = 4;
                        continue block50;
                    }
                    case "gene": {
                        if (name.length() != 0 && nameSrc >= 3) continue block50;
                        name = val;
                        nameSrc = 3;
                        continue block50;
                    }
                    case "organism": {
                        if (name.length() != 0 && nameSrc >= 2) continue block50;
                        name = val;
                        nameSrc = 2;
                        continue block50;
                    }
                    case "product": {
                        if (name.length() != 0 && nameSrc >= 1) continue block50;
                        name = val;
                        nameSrc = 1;
                        continue block50;
                    }
                    case "color": 
                    case "backcolor": 
                    case "plot_color": {
                        if (outFeature.getBackColor() != null) continue block50;
                        int bcolVal = StringTools.filterStringToInt(val, 0);
                        gColor = ColorTools.intToColor(bcolVal);
                        continue block50;
                    }
                    case "plot_tcolor": 
                    case "textcolor": 
                    case "forecolor": {
                        int fcolVal = StringTools.filterStringToInt(val, 0);
                        tColor = ColorTools.intToColor(fcolVal);
                        continue block50;
                    }
                    case "note": {
                        outFeature.setNote(outFeature.getNote().length() == 0 ? val : outFeature.getNote() + "\n" + val);
                        continue block50;
                    }
                    case "plot_showlabel": {
                        outFeature.setShowLabel(StringTools.stringToBoolean(val));
                        continue block50;
                    }
                    case "alpha": 
                    case "plot_alpha": {
                        int aVal = StringTools.filterStringToInt(val, 255);
                        if (aVal < 0) {
                            outFeature.setAlpha(0);
                            continue block50;
                        }
                        if (aVal > 255) {
                            outFeature.setAlpha(255);
                            continue block50;
                        }
                        outFeature.setAlpha(aVal);
                        continue block50;
                    }
                    case "plot_ftype": {
                        rendererType = Feature.getGraphicStyleIndex(val);
                        outFeature.setGraphicStyle(rendererType);
                        continue block50;
                    }
                    case "plot_roffset": {
                        outFeature.setOffset((int)(StringTools.filterStringToDouble(val, 1.0) * 100.0));
                        continue block50;
                    }
                    case "plot_offset": {
                        outFeature.setOffset(StringTools.filterStringToInt(val, 1));
                        continue block50;
                    }
                    case "plot_fwidth": {
                        int fwidth = (int)(StringTools.filterStringToDouble(val, 1.0) * (outFeature.renderer instanceof FeatureRenderer.TickMarkFeature ? 1.0 : 10.0));
                        outFeature.setWidth(fwidth);
                        continue block50;
                    }
                    case "gbtype": {
                        outFeature.setGBType(val);
                        continue block50;
                    }
                    case "plot_forient": {
                        outFeature.antisense = val.equals("-1");
                        continue block50;
                    }
                    case "plot_fhide": {
                        outFeature.setHidden(val.equals("-1") || val.toLowerCase().equals("true"));
                        continue block50;
                    }
                    case "plot_labelcap": {
                        outFeature.setCaption(val);
                        continue block50;
                    }
                    case "orgindex": {
                        outFeature.setOrg(StringTools.filterStringToInt(val, 0));
                        continue block50;
                    }
                    case "plot_codon_table": {
                        continue block50;
                    }
                    default: {
                        quals.add(annotation.qualifiers[y]);
                    }
                }
            }
            outFeature.setTextColor(tColor);
            if (!quals.isEmpty()) {
                outFeature.qualifiers = new Qualifier[quals.size()];
                for (int z = 0; z < quals.size(); ++z) {
                    outFeature.qualifiers[z] = (Qualifier)quals.get(z);
                }
                quals.clear();
            }
        }
        if (rendererType == -1) {
            rendererType = 3;
        }
        outFeature.setGraphicStyle(rendererType);
        if (gColor != null) {
            outFeature.setBackColor(gColor);
        } else {
            Random rand = new Random();
            outFeature.setBackColor(new Color(rand.nextFloat(), rand.nextFloat(), rand.nextFloat()));
        }
        return outFeature;
    }

    public static enum GraphicStyle {
        Box,
        BoxArrow,
        HeadlessArrow,
        Line,
        LineArrow,
        TickMark,
        Bracket,
        None;

    }
}

