/*
 * Decompiled with CFR 0.152.
 */
package plot;

import MiscTools.StringTools;
import java.io.Serializable;
import plot.ProjectDocument;

public class EnzymeFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int minCuts = 0;
    public int maxCuts = 0;
    public int minBp = 0;
    public int maxBp = 0;

    static EnzymeFilter fromValues(ProjectDocument dest, String ... values) {
        if (values.length != 4) {
            return null;
        }
        EnzymeFilter filter = new EnzymeFilter();
        filter.minCuts = StringTools.filterStringToInt(values[0], 1);
        filter.maxCuts = StringTools.filterStringToInt(values[1], 1);
        filter.minBp = StringTools.filterStringToInt(values[2], 1);
        filter.maxBp = StringTools.filterStringToInt(values[3], 1);
        return filter;
    }

    public String toGBString() {
        return "COMMENT RE_Filter:\t" + this.minCuts + "\t" + this.maxCuts + "\t" + this.minBp + "\t" + this.maxBp;
    }

    public String toString() {
        return "Filter: minCuts=" + this.minCuts + ", maxCuts=" + this.maxCuts + ", minBp=" + this.minBp + ", maxBp=" + this.maxBp;
    }

    public EnzymeFilter clone() {
        EnzymeFilter clone = new EnzymeFilter();
        clone.maxBp = this.maxBp;
        clone.maxCuts = this.maxCuts;
        clone.minBp = this.minBp;
        clone.minCuts = this.minCuts;
        return clone;
    }
}

