/*
 * Decompiled with CFR 0.152.
 */
package plot;

import GenbankFileReader.Locus;
import java.awt.Color;
import plot.Feature;
import plot.ProjectEnzyme;

class EnzymeFeature
extends Feature {
    public ProjectEnzyme enzyme;

    public EnzymeFeature(ProjectEnzyme e, int cutIndex) {
        this.enzyme = e;
        this.gbType = "restriction site";
        Locus pos = e.cuts[cutIndex];
        this.set(pos.getStart(), pos.getStop(), pos.isAntisense());
    }

    public EnzymeFeature() {
    }

    @Override
    public EnzymeFeature clone() {
        EnzymeFeature clone = new EnzymeFeature();
        clone.enzyme = this.enzyme;
        clone.start = this.start;
        clone.stop = this.stop;
        clone.antisense = this.antisense;
        return clone;
    }

    @Override
    public String getName() {
        return this.enzyme != null ? this.enzyme.enzyme.name + " (" + this.enzyme.enzyme.sequence + ")" : "";
    }

    @Override
    public Color getTextColor() {
        switch (this.enzyme.getCutCount()) {
            case 1: {
                return Color.BLUE;
            }
            case 2: {
                return Color.RED;
            }
            case 3: {
                return Color.GREEN;
            }
            case 4: {
                return Color.MAGENTA;
            }
        }
        return Color.BLACK;
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.start + "-" + this.stop;
    }
}

