/*
 * Decompiled with CFR 0.152.
 */
package plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;

class CustomSliderUI
extends BasicSliderUI {
    private BasicStroke stroke = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{1.0f, 2.0f}, 0.0f);
    private BasicStroke borderStroke = new BasicStroke(1.0f);
    private boolean autoTextColor = false;
    private Color autoColor;
    private Color thumbFillColor;
    private Color trackGradientColor = this.thumbFillColor = new Color(81, 83, 186);
    private Color trackGradientColor2 = new Color(this.trackGradientColor.getRed(), this.trackGradientColor.getGreen(), this.trackGradientColor.getBlue(), 0);
    private Color thumbBorderColor = new Color(131, 127, 211);
    private Color trackColor = Color.black;
    private boolean drawTrackGradient = true;
    private boolean drawTrackGradientBorder = true;
    private boolean paintFocus = false;
    private boolean drawInverted = false;
    private Color valueTextColor = Color.WHITE;

    public void setUseAutoTextColor(boolean b) {
        this.autoTextColor = b;
    }

    public void setDrawTrackGradient(boolean paint) {
        this.drawTrackGradient = paint;
        if (this.slider != null) {
            this.slider.repaint();
        }
    }

    public boolean isDrawTrackGradientBorder() {
        return this.drawTrackGradientBorder;
    }

    public void setDrawTrackGradientBorder(boolean paint) {
        this.drawTrackGradientBorder = paint;
        if (this.slider != null) {
            this.slider.repaint();
        }
    }

    public boolean isDrawTrackGradient() {
        return this.drawTrackGradient;
    }

    public void setTrackGradientColor(Color color) {
        this.trackGradientColor = color;
        this.trackGradientColor2 = new Color(this.trackGradientColor.getRed(), this.trackGradientColor.getGreen(), this.trackGradientColor.getBlue(), 0);
        this.autoColor = null;
        if (this.slider != null) {
            this.slider.repaint();
        }
    }

    public Color getTrackGradientColor() {
        return this.thumbFillColor;
    }

    public void setThumbFillColor(Color color) {
        this.thumbFillColor = color;
        if (this.slider != null) {
            this.slider.repaint();
        }
    }

    public Color getThumbFillColor() {
        return this.thumbFillColor;
    }

    public void setThumbBorderColor(Color color) {
        this.thumbBorderColor = color;
        if (this.slider != null) {
            this.slider.repaint();
        }
    }

    public Color getThumbBorderColor() {
        return this.thumbBorderColor;
    }

    public void setPaintFocus(boolean paint) {
        this.paintFocus = paint;
        if (this.slider != null) {
            this.slider.repaint();
        }
    }

    public boolean isPaintFocus() {
        return this.paintFocus;
    }

    public void setTrackColor(Color color) {
        this.trackColor = color;
        if (this.slider != null) {
            this.slider.repaint();
        }
    }

    public Color getTrackColor() {
        return this.trackColor;
    }

    public void setDrawInverted(boolean invert) {
        this.drawInverted = invert;
        if (this.slider != null) {
            this.slider.repaint();
        }
    }

    public boolean getDrawInverted() {
        return this.drawInverted;
    }

    public CustomSliderUI(JSlider b) {
        super(b);
        b.setOpaque(false);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paint(g, c);
        FontMetrics fm = g2d.getFontMetrics();
        String str = String.valueOf(this.slider.getValue());
        int ht = fm.getAscent() + fm.getDescent();
        int wd = fm.stringWidth(str);
        if (this.autoTextColor) {
            if (this.autoColor == null) {
                this.autoColor = CustomSliderUI.getForecolor(this.trackGradientColor);
            }
            g2d.setPaint(this.autoColor);
        } else {
            g2d.setColor(this.valueTextColor);
        }
        int y = this.trackRect.y + this.trackRect.height / 2 + ht / 3;
        g2d.drawString(str, (this.slider.getWidth() - wd) / 2, y);
    }

    @Override
    protected Dimension getThumbSize() {
        return new Dimension(12, 16);
    }

    @Override
    public void paintTrack(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.autoTextColor && this.autoColor == null) {
            this.autoColor = CustomSliderUI.getForecolor(this.trackGradientColor);
        }
        int right = this.trackRect.x + this.trackRect.width - this.thumbRect.width + 2;
        if (this.drawTrackGradient) {
            g2d.setPaint(new GradientPaint(this.trackRect.x, this.trackRect.y, this.trackGradientColor2, right, this.thumbRect.y, this.trackGradientColor, true));
            g2d.fillRect(this.trackRect.x, this.trackRect.y, right, this.trackRect.y + this.trackRect.height);
            if (this.drawTrackGradientBorder) {
                g2d.setColor(this.thumbBorderColor);
                g2d.drawRect(this.trackRect.x, this.trackRect.y, right, this.trackRect.y + this.trackRect.height - 1);
            }
        }
        Stroke old = g2d.getStroke();
        g2d.setStroke(this.stroke);
        g2d.setPaint(this.trackColor);
        if (this.slider.getOrientation() == 0) {
            int y = this.trackRect.y + this.trackRect.height / 2;
            g2d.drawLine(this.trackRect.x, y, this.trackRect.x + this.trackRect.width - 2, y);
        } else {
            int x = this.trackRect.x + this.trackRect.width / 2;
            g2d.drawLine(x, this.trackRect.y, x, this.trackRect.y + this.trackRect.height);
        }
        g2d.setStroke(old);
    }

    @Override
    public void paintFocus(Graphics g) {
        if (this.paintFocus) {
            super.paintFocus(g);
        }
    }

    @Override
    public void paintThumb(Graphics g) {
        this.paintThumbTriangle(g, !this.drawInverted);
    }

    public void paintThumbTriangle(Graphics g, boolean invert) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.autoTextColor && this.autoColor == null) {
            this.autoColor = CustomSliderUI.getForecolor(this.trackGradientColor);
        }
        GeneralPath shape = new GeneralPath(0);
        if (this.slider.getOrientation() == 1) {
            int x1 = this.thumbRect.x + 2;
            int x2 = this.thumbRect.x + this.thumbRect.width - 2;
            int height = this.thumbRect.height - 4;
            int y1 = this.thumbRect.y + 2;
            int y2 = y1 + height;
            if (invert) {
                shape.moveTo(x2, (y1 + y2) / 2);
                shape.lineTo(x1, y1);
                shape.lineTo(x1, y2);
            } else {
                shape.moveTo(x1, (y1 + y2) / 2);
                shape.lineTo(x2, y1);
                shape.lineTo(x2, y2);
            }
        } else {
            int x1 = this.thumbRect.x + 2;
            int x2 = this.thumbRect.x + this.thumbRect.width - 2;
            int width = this.thumbRect.width - 4;
            int y1 = this.thumbRect.y + this.thumbRect.height / 2 - this.thumbRect.width / 3;
            int y2 = y1 + width;
            if (invert) {
                shape.moveTo((x1 + x2) / 2, y1);
                shape.lineTo(x1, y2);
                shape.lineTo(x2, y2);
            } else {
                shape.moveTo((x1 + x2) / 2, y2);
                shape.lineTo(x1, y1);
                shape.lineTo(x2, y1);
            }
        }
        shape.closePath();
        g2d.setPaint(this.thumbFillColor);
        g2d.fill(shape);
        Stroke old = g2d.getStroke();
        g2d.setStroke(this.borderStroke);
        if (this.autoTextColor) {
            g2d.setPaint(this.autoColor);
        } else {
            g2d.setPaint(this.thumbBorderColor);
        }
        g2d.draw(shape);
        g2d.setStroke(old);
    }

    public void setTextColor(Color color) {
        this.valueTextColor = color;
        if (this.slider != null) {
            this.slider.repaint();
        }
    }

    public Color getTextColor() {
        return this.valueTextColor;
    }

    private static Color getForecolor(Color backcolor) {
        double r = (double)backcolor.getRed() / 255.0;
        double g = (double)backcolor.getGreen() / 255.0;
        double b = (double)backcolor.getBlue() / 255.0;
        r = r <= 0.03928 ? (r /= 12.92) : Math.pow((r + 0.055) / 1.055, 2.4);
        g = g <= 0.03928 ? (g /= 12.92) : Math.pow((g + 0.055) / 1.055, 2.4);
        b = b <= 0.03928 ? (b /= 12.92) : Math.pow((b + 0.055) / 1.055, 2.4);
        return 0.2126 * r + 0.7152 * g + 0.0722 * b > 0.179 ? Color.black : Color.white;
    }
}

