/*
 * Decompiled with CFR 0.152.
 */
package plaf;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import plaf.AbstractLookAndFeel;
import plaf.BaseBorders;
import plaf.UIUtilities;

public class RenderedBorders
extends BaseBorders {
    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return RenderedBorders.getButtonBorder();
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (AbstractLookAndFeel.getTheme().doDrawSquareButtons()) {
                return new Insets(3, 4, 3, 4);
            }
            return new Insets(2, 12, 2, 12);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            Insets insets = this.getBorderInsets(c);
            borderInsets.left = insets.left;
            borderInsets.top = insets.top;
            borderInsets.right = insets.right;
            borderInsets.bottom = insets.bottom;
            return borderInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            ColorUIResource loColor = AbstractLookAndFeel.getFrameColor();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed() || model.isSelected()) {
                    Graphics2D g2D = (Graphics2D)g;
                    Composite composite = g2D.getComposite();
                    g.setColor(loColor);
                    g.drawRect(x, y, w - 1, h - 1);
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.15f);
                    g2D.setComposite(alpha);
                    g.setColor(Color.black);
                    g.fillRect(x + 1, y + 1, w - 2, h - 2);
                    g2D.setComposite(composite);
                } else if (model.isRollover()) {
                    Graphics2D g2D = (Graphics2D)g;
                    Composite composite = g2D.getComposite();
                    g.setColor(loColor);
                    g.drawRect(x, y, w - 1, h - 1);
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.4f);
                    g2D.setComposite(alpha);
                    g.setColor(AbstractLookAndFeel.getTheme().getSelectionBackgroundColor());
                    g.fillRect(x + 1, y + 1, w - 2, h - 2);
                    g2D.setComposite(composite);
                }
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(RolloverToolButtonBorder.INSETS.top, RolloverToolButtonBorder.INSETS.left, RolloverToolButtonBorder.INSETS.bottom, RolloverToolButtonBorder.INSETS.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = RolloverToolButtonBorder.INSETS.left;
            borderInsets.top = RolloverToolButtonBorder.INSETS.top;
            borderInsets.right = RolloverToolButtonBorder.INSETS.right;
            borderInsets.bottom = RolloverToolButtonBorder.INSETS.bottom;
            return borderInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            ColorUIResource c1;
            Graphics2D g2D = (Graphics2D)g;
            ColorUIResource titleColor = AbstractLookAndFeel.getWindowInactiveTitleBackgroundColor();
            if (this.isActive(c)) {
                titleColor = AbstractLookAndFeel.getWindowTitleBackgroundColor();
            }
            int th = this.getTitleHeight(c);
            g.setColor(titleColor);
            g.fillRect(1, 1, w, 5);
            g.fillRect(1, h - 5, w, 4);
            if (this.isActive(c)) {
                UIUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 1, 5, 5, th + 1);
                UIUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowTitleColors(), w - 5, 5, 5, th + 1);
                c1 = AbstractLookAndFeel.getTheme().getWindowTitleColorDark();
                ColorUIResource c2 = AbstractLookAndFeel.getTheme().getWindowTitleColorLight();
                g2D.setPaint(new GradientPaint(0.0f, 5 + th + 1, c1, 0.0f, h - th - 10, c2));
                g.fillRect(1, 5 + th + 1, 4, h - th - 10);
                g.fillRect(w - 5, 5 + th + 1, 4, h - th - 10);
                g2D.setPaint(null);
            } else {
                UIUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, 5, 5, th + 1);
                UIUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), w - 5, 5, 5, th + 1);
                c1 = AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorDark();
                ColorUIResource c2 = AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorLight();
                g2D.setPaint(new GradientPaint(0.0f, 5 + th + 1, c1, 0.0f, h - th - 10, c2));
                g.fillRect(1, 5 + th + 1, 4, h - th - 10);
                g.fillRect(w - 5, 5 + th + 1, 4, h - th - 10);
                g2D.setPaint(null);
            }
            ColorUIResource borderColor = AbstractLookAndFeel.getWindowInactiveBorderColor();
            if (this.isActive(c)) {
                borderColor = AbstractLookAndFeel.getWindowBorderColor();
            }
            g.setColor(borderColor);
            g.drawRect(0, 0, w - 1, h - 1);
            g.drawLine(x + 5 - 1, y + this.INSETS.top + th, x + 5 - 1, y + h - 5);
            g.drawLine(x + w - 5, y + this.INSETS.top + th, x + w - 5, y + h - 5);
            g.drawLine(x + 5 - 1, y + h - 5, x + w - 5, y + h - 5);
            g.setColor(new Color(220, 220, 220));
            g.drawLine(1, 1, w - 3, 1);
            g.drawLine(1, 1, 1, h - 2);
        }
    }
}

