/*
 * Decompiled with CFR 0.152.
 */
package plaf;

import Renderers.BasicGradientRenderer;
import Renderers.BasicRenderer;
import Renderers.GelRenderer;
import Renderers.JavTRenderer;
import Renderers.MetalRenderer;
import UIRenderers.RenderedButtonUI;
import UIRenderers.RenderedCheckBoxUI;
import UIRenderers.RenderedFileChooserUI;
import UIRenderers.RenderedLabelUI;
import UIRenderers.RenderedMenuBarUI;
import UIRenderers.RenderedMenuCheckItemUI;
import UIRenderers.RenderedMenuItemUI;
import UIRenderers.RenderedMenuRadioItemUI;
import UIRenderers.RenderedMenuSeparatorUI;
import UIRenderers.RenderedMenuUI;
import UIRenderers.RenderedPopupMenuBorderUI;
import UIRenderers.RenderedProgressBarUI;
import UIRenderers.RenderedRadioButtonUI;
import UIRenderers.RenderedScrollBarUI;
import UIRenderers.RenderedSpinnerUI;
import UIRenderers.RenderedToggleButtonUI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import plaf.AbstractBorderFactory;
import plaf.AbstractIconFactory;
import plaf.AbstractLookAndFeel;
import plaf.AbstractTheme;
import plaf.Defaults;
import plaf.RenderedBorderFactory;
import plaf.RenderedDefaultTheme;
import plaf.RenderedIconFactory;

public class NWLookAndFeel
extends AbstractLookAndFeel {
    private static RenderedDefaultTheme myTheme = null;
    private static final ArrayList themesList = new ArrayList();
    private static final HashMap themesMap = new HashMap();
    private static final Properties defaultProps = new Properties();
    private static final Properties smallFontProps = new Properties();
    private static final Properties largeFontProps = new Properties();
    private static final Properties giantFontProps = new Properties();

    public static List getThemes() {
        return themesList;
    }

    public static Properties getThemeProperties(String name) {
        return (Properties)themesMap.get(name);
    }

    public static void setTheme(String name) {
        NWLookAndFeel.setTheme((Properties)themesMap.get(name));
        if (myTheme != null) {
            AbstractTheme.setInternalName(name);
        }
    }

    public static void setTheme(Properties themesProps) {
        currentThemeName = "renderedThemeDark";
        if (myTheme == null) {
            myTheme = new RenderedDefaultTheme();
        }
        if (myTheme != null && themesProps != null) {
            myTheme.setUpColor();
            myTheme.setProperties(themesProps);
            myTheme.setUpColorArrs();
            AbstractLookAndFeel.setTheme(myTheme);
        }
    }

    public static void setCurrentTheme(Properties themesProps) {
        NWLookAndFeel.setTheme(themesProps);
    }

    @Override
    public String getName() {
        return "Rendered";
    }

    @Override
    public String getID() {
        return "Rendered";
    }

    @Override
    public String getDescription() {
        return "The Rendered Look and Feel";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public AbstractBorderFactory getBorderFactory() {
        return RenderedBorderFactory.getInstance();
    }

    @Override
    public AbstractIconFactory getIconFactory() {
        return RenderedIconFactory.getInstance();
    }

    @Override
    protected void createDefaultTheme() {
        if (myTheme == null) {
            myTheme = new RenderedDefaultTheme();
        }
        NWLookAndFeel.setTheme(myTheme);
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        if (!"renderedThemeDark".equals(currentThemeName)) {
            NWLookAndFeel.setTheme("Default");
        }
        super.initClassDefaults(table);
        this.initTheme();
    }

    public void initTheme() {
        Color nwPurple;
        Color startColor = nwPurple = new Color(78, 32, 142);
        Color borderColor = nwPurple;
        Color mainColor = nwPurple;
        BasicGradientRenderer bgRenderer = new BasicGradientRenderer();
        bgRenderer.setPaintBorder(false);
        bgRenderer.setRounded(false);
        Color activeBackcolor = nwPurple;
        Color menuForecolor = Color.white;
        Color disabledColor = activeBackcolor.darker();
        UIManager.put("MenuBar.background", activeBackcolor);
        UIManager.put("MenuBar.foreground", menuForecolor);
        BasicRenderer menuBarRenderer = new BasicRenderer();
        menuBarRenderer.setColors(activeBackcolor);
        menuBarRenderer.setTextColors(menuForecolor, menuForecolor.brighter(), menuForecolor.darker());
        menuBarRenderer.setPaintBorder(false);
        RenderedMenuBarUI.setDefaultRenderer(menuBarRenderer);
        UIManager.put("MenuBarUI", RenderedMenuBarUI.class.getName());
        UIManager.put("ProgressBarUI", RenderedProgressBarUI.class.getName());
        bgRenderer.setEndColorDisabled(disabledColor);
        bgRenderer.setStartColorDisabled(disabledColor);
        bgRenderer.setTextColor(menuForecolor);
        bgRenderer.setColorNormal(activeBackcolor);
        bgRenderer.setStartColors(activeBackcolor);
        bgRenderer.setEndColors(activeBackcolor);
        bgRenderer.setEndColorSelected(menuForecolor);
        bgRenderer.setStartColorSelected(menuForecolor);
        bgRenderer.setTextColors(menuForecolor, activeBackcolor, activeBackcolor);
        bgRenderer.setEndColorPressed(mainColor);
        bgRenderer.setStartColorPressed(startColor);
        Color uiColor1 = activeBackcolor;
        Color uiColor2 = menuForecolor;
        Color disabledForecolor = menuForecolor.darker();
        UIManager.put("RenderedUI.MenuSeparator.background", uiColor1);
        UIManager.put("RenderedUI.MenuSeparator.bordercolor", uiColor2);
        UIManager.put("RenderedUI.MenuSeparator.fillcolor", uiColor2);
        UIManager.put("RenderedUI.MenuSeparator.foreground", uiColor1);
        UIManager.put("RenderedUI.MenuSeparator.header.background", uiColor1);
        UIManager.put("RenderedUI.MenuSeparator.header.bordercolor", uiColor2);
        UIManager.put("RenderedUI.MenuSeparator.header.fillcolor", uiColor2);
        UIManager.put("RenderedUI.MenuSeparator.header.foreground", uiColor1);
        UIManager.put("RenderedUI.MenuSeparator.footer.background", uiColor1);
        UIManager.put("RenderedUI.MenuSeparator.footer.bordercolor", uiColor2);
        UIManager.put("RenderedUI.MenuSeparator.footer.fillcolor", uiColor2);
        RenderedPopupMenuBorderUI.setDefaultRenderer(new GelRenderer());
        RenderedPopupMenuBorderUI.getDefaultRenderer().setRounded(false);
        RenderedPopupMenuBorderUI.getDefaultRenderer().setColors(activeBackcolor, activeBackcolor, activeBackcolor, activeBackcolor);
        RenderedPopupMenuBorderUI.getDefaultRenderer().setTextColors(menuForecolor, menuForecolor, menuForecolor);
        RenderedScrollBarUI.getDefaultThumbRenderer().setColors(menuForecolor);
        RenderedScrollBarUI.getDefaultButtonRenderer().setColors(menuForecolor);
        RenderedScrollBarUI.getDefaultArrowRenderer().getColors().setColors(1, activeBackcolor);
        RenderedScrollBarUI.setDefaultTrackRenderer(new JavTRenderer());
        RenderedScrollBarUI.getDefaultTrackRenderer().setColors(activeBackcolor);
        RenderedScrollBarUI.getDefaultTrackRenderer().setBorderColor(Color.black);
        RenderedScrollBarUI.getDefaultThumbRenderer().setBorderColor(activeBackcolor);
        RenderedProgressBarUI.setDefaultThumbRenderer(RenderedScrollBarUI.getDefaultThumbRenderer());
        RenderedProgressBarUI.setDefaultTrackRenderer(RenderedScrollBarUI.getDefaultTrackRenderer());
        RenderedProgressBarUI.getDefaultValueRenderer().setTextColor(menuForecolor);
        UIManager.put("MenuScroller.background", activeBackcolor);
        UIManager.put("MenuScroller.foreground", menuForecolor);
        UIManager.put("MenuScroller.bordercolor", menuForecolor);
        UIManager.put("TaskPaneContainer.backcolor", activeBackcolor);
        UIManager.put("TaskPaneContainer.forecolor", menuForecolor);
        UIManager.put("TaskPane.borderColor", menuForecolor);
        UIManager.put("TaskPane.specialTitleBackground", menuForecolor);
        UIManager.put("TaskPane.titleOver", activeBackcolor);
        UIManager.put("TaskPane.specialTitleOver", Color.black);
        UIManager.put("TaskPane.specialTitleForeground", activeBackcolor);
        UIManager.put("ToolBar.background", activeBackcolor);
        UIManager.put("Menu.background", activeBackcolor);
        UIManager.put("PopupMenu.background", activeBackcolor);
        UIManager.put("Menu.selectionBackground", menuForecolor);
        UIManager.put("Menu.selectionForeground", activeBackcolor);
        UIManager.put("Menu.borderColor", borderColor);
        UIManager.put("Menu.selectionBorderColor", borderColor);
        UIManager.put("MenuItem.borderColor", borderColor);
        UIManager.put("MenuItem.acceleratorForeground", borderColor);
        UIManager.put("MenuItem.acceleratorSelectionForeground", menuForecolor);
        UIManager.put("MenuItem.background", activeBackcolor);
        UIManager.put("MenuItem.foreground", menuForecolor);
        UIManager.put("MenuItem.selectionForeground", activeBackcolor);
        UIManager.put("MenuItem.selectionBackground", menuForecolor);
        UIManager.put("CheckBoxMenuItem.selectionBackground", menuForecolor);
        UIManager.put("CheckBoxMenuItem.selectionForeground", activeBackcolor);
        UIManager.put("CheckBoxMenuItem.foreground", menuForecolor);
        UIManager.put("CheckBoxMenuItem.background", activeBackcolor);
        UIManager.put("CheckBoxMenuItem.acceleratorForeground", Color.white);
        UIManager.put("CheckBoxMenuItem.disabledBackground", activeBackcolor.darker());
        UIManager.put("CheckBoxMenuItem.disabledForeground", disabledForecolor);
        UIManager.put("RadioButtonMenuItem.selectionBackground", menuForecolor);
        UIManager.put("RadioButtonMenuItem.selectionForeground", activeBackcolor);
        UIManager.put("RadioButtonMenuItem.foreground", menuForecolor);
        UIManager.put("RadioButtonMenuItem.background", activeBackcolor);
        UIManager.put("RadioButtonMenuItem.acceleratorForeground", Color.white);
        UIManager.put("RadioButtonMenuItem.disabledBackground", activeBackcolor.darker());
        UIManager.put("RadioButtonMenuItem.disabledForeground", disabledForecolor);
        UIManager.put("FileChooser.openButtonText", "Open Project");
        UIManager.put("FileChooser.saveButtonText", "Save Project");
        UIManager.put("FileChooserUI", RenderedFileChooserUI.class.getName());
        MetalRenderer shortcutButtonRenderer = new MetalRenderer();
        shortcutButtonRenderer.getColors().setColors(1, null, activeBackcolor, null, activeBackcolor, null, activeBackcolor, activeBackcolor);
        shortcutButtonRenderer.getColors().setColors(0, menuForecolor);
        shortcutButtonRenderer.getColors().setColors(2, null, menuForecolor, null, menuForecolor, null, menuForecolor, menuForecolor);
        shortcutButtonRenderer.setPaintBorder(true);
        RenderedToggleButtonUI shortcutUI = new RenderedToggleButtonUI();
        shortcutUI.setDefaultIconTextPaint(true);
        shortcutUI.setRenderer(shortcutButtonRenderer);
        UIManager.put("ToolTip.background", menuForecolor);
        UIManager.put("ToolTip.foreground", activeBackcolor);
        UIManager.put("ToolTip.border", new LineBorder(Color.BLACK));
        UIManager.put("Separator.foreground", menuForecolor);
        UIManager.put("Separator.background", Color.BLACK);
        UIManager.put("List.border", new LineBorder(Color.BLACK));
        UIManager.put("List.selectionForeground", activeBackcolor);
        UIManager.put("List.selectionBackground", menuForecolor);
        UIManager.put("List.background", activeBackcolor);
        UIManager.put("List.foreground", menuForecolor);
        UIManager.put("Spinner.border", new LineBorder(Color.BLACK));
        UIManager.put("Spinner.background", activeBackcolor);
        UIManager.put("Spinner.foreground", menuForecolor);
        UIManager.put("SpinnerUI", RenderedSpinnerUI.class.getName());
        UIManager.put("TabbedPane.background", activeBackcolor);
        UIManager.put("TabbedPane.foreground", menuForecolor);
        UIManager.put("Panel.background", activeBackcolor);
        UIManager.put("Panel.foreground", menuForecolor);
        UIManager.put("CheckBox.background", activeBackcolor);
        UIManager.put("CheckBox.foreground", menuForecolor);
        UIManager.put("ComboBox.border", new LineBorder(Color.BLACK));
        UIManager.put("ComboBox.selectionForeground", activeBackcolor);
        UIManager.put("ComboBox.selectionBackground", menuForecolor);
        UIManager.put("ComboBox.background", activeBackcolor);
        UIManager.put("ComboBox.foreground", menuForecolor);
        UIManager.put("ComboBox.disabledBackground", disabledColor);
        UIManager.put("ComboBox.disabledForeground", disabledForecolor);
        UIManager.put("TextField.border", new LineBorder(Color.BLACK));
        UIManager.put("TextField.background", activeBackcolor);
        UIManager.put("TextField.foreground", menuForecolor);
        UIManager.put("OptionPane.messageForeground", menuForecolor);
        UIManager.put("TextArea.background", activeBackcolor);
        UIManager.put("TextArea.foreground", menuForecolor);
        UIManager.put("TextArea.border", new LineBorder(Color.BLACK));
        UIManager.put("TextPane.background", activeBackcolor);
        UIManager.put("TextPane.foreground", menuForecolor);
        UIManager.put("TextPane.border", new LineBorder(Color.BLACK));
        UIManager.put("EditorPane.background", nwPurple.brighter());
        UIManager.put("EditorPane.foreground", menuForecolor);
        UIManager.put("EditorPane.border", new LineBorder(Color.BLACK));
        UIManager.put("Table.background", activeBackcolor);
        UIManager.put("Table.foreground", menuForecolor);
        UIManager.put("Table.selectionBackground", menuForecolor);
        UIManager.put("Table.gridColor", menuForecolor);
        UIManager.put("Table.selectionForeground", activeBackcolor);
        UIManager.put("Table.border", new LineBorder(Color.BLACK));
        UIManager.put("TableHeader.foreground", new LineBorder(activeBackcolor));
        UIManager.put("TableHeader.background", new LineBorder(menuForecolor));
        UIManager.put("Button.background", activeBackcolor);
        UIManager.put("Button.foreground", menuForecolor);
        RenderedLabelUI.setDefaultRenderer(new BasicRenderer());
        RenderedLabelUI.getDefaultRenderer().setColors(activeBackcolor);
        RenderedLabelUI.getDefaultRenderer().setTextColors(menuForecolor, menuForecolor, menuForecolor, menuForecolor.darker());
        RenderedLabelUI.getDefaultRenderer().setPaintBorder(false);
        UIManager.put("Label.background", activeBackcolor);
        UIManager.put("Label.foreground", menuForecolor);
        UIManager.put("Label.disabledForeground", disabledForecolor);
        UIManager.put("Label.opaque", false);
        UIManager.put("ToggleButton.background", activeBackcolor);
        UIManager.put("ToggleButton.foreground", menuForecolor);
        UIManager.put("SplitPane.background", activeBackcolor);
        UIManager.put("ScrollPane.background", activeBackcolor);
        UIManager.put("Plot.map.useoverlay", true);
        UIManager.put("Plot.link.inactive", menuForecolor);
        UIManager.put("Plot.link.active", menuForecolor.brighter());
        UIManager.put("Plot.tooltip.green", new Color(0, 204, 0));
        UIManager.put("Plot.tooltip.blue", new Color(0, 0, 204));
        UIManager.put("Plot.tooltip.yellow", new Color(204, 235, 204));
        UIManager.put("Plot.tooltip.red", new Color(204, 0, 0));
        UIManager.put("RenderedUI.Slider.thumbBorderColor", menuForecolor.brighter());
        UIManager.put("RenderedUI.Slider.thumbFillcolor", activeBackcolor);
        UIManager.put("RenderedUI.Slider.forecolor", menuForecolor);
        UIManager.put("SequenceEditor.background", new Color(100, 100, 100));
        UIManager.put("SequenceEditor.foreground", Color.black);
        UIManager.put("StatusLabel.background", activeBackcolor);
        UIManager.put("StatusLabel.foreground", menuForecolor);
        UIManager.put("TitledBorder.titleColor", menuForecolor);
        UIManager.put("TitledBorder.border", new LineBorder(menuForecolor));
        LineBorder borderOut = new LineBorder(menuForecolor, 1, false);
        EmptyBorder borderIn = new EmptyBorder(15, 15, 15, 15);
        CompoundBorder border = new CompoundBorder(borderOut, borderIn);
        UIManager.put("OptionPane.border", border);
        UIManager.put("OptionPane.background", activeBackcolor);
        UIManager.put("OptionPane.foreground", menuForecolor);
        UIManager.put("DockingFrame.activeTitleBackgroundStart", menuForecolor);
        UIManager.put("DockingFrame.activeTitleBackgroundEnd", activeBackcolor);
        UIManager.put("DockingFrame.activeTitleForeground", menuForecolor);
        UIManager.put("DockingFrame.background", menuForecolor);
        UIManager.put("ComboBoxUI", "UIRenderers.RenderedComboBoxUI");
        MetalRenderer buttonRenderer = new MetalRenderer();
        buttonRenderer.setColors(menuForecolor, menuForecolor, menuForecolor.darker(), Color.black);
        buttonRenderer.setTextColors(menuForecolor);
        buttonRenderer.setBorderColor(menuForecolor);
        RenderedButtonUI.setDefaultRenderer(buttonRenderer);
        RenderedToggleButtonUI.setDefaultRenderer(buttonRenderer);
        UIManager.put("ButtonUI", "UIRenderers.RenderedButtonUI");
        UIManager.put("ToggleButtonUI", "UIRenderers.RenderedToggleButtonUI");
        RenderedCheckBoxUI.getDefaultIconRenderer().setColors(0, activeBackcolor);
        RenderedCheckBoxUI.getDefaultIconRenderer().setColor(0, 2, Color.lightGray);
        RenderedCheckBoxUI.getDefaultIconRenderer().setColor(0, 4, Color.lightGray);
        RenderedCheckBoxUI.getDefaultIconRenderer().setColors(2, activeBackcolor);
        RenderedCheckBoxUI.getDefaultIconRenderer().setColors(1, menuForecolor);
        RenderedRadioButtonUI.setDefaultRenderer(RenderedLabelUI.getDefaultRenderer());
        RenderedCheckBoxUI.setDefaultRenderer(RenderedLabelUI.getDefaultRenderer());
        UIManager.put("RadioButtonUI", RenderedRadioButtonUI.class.getName());
        UIManager.put("CheckBoxUI", RenderedCheckBoxUI.class.getName());
        BasicGradientRenderer defaultRenderer = new BasicGradientRenderer();
        defaultRenderer.setStartColors(menuForecolor);
        defaultRenderer.setEndColors(activeBackcolor);
        UIManager.put("RenderedUI.TitlePaneRenderer", defaultRenderer);
        UIManager.put("RootPaneUI", "UIRenderers.RenderedRootPaneUI");
        UIManager.put("PopupMenu.border", Defaults.getPopupMenuBorder());
        UIManager.put("RenderedPopupMenuBorder.bordercolor", activeBackcolor);
        RenderedPopupMenuBorderUI.getDefaultRenderer().setBorderColors(menuForecolor);
        RenderedMenuUI.setDefaultRenderer(bgRenderer);
        RenderedMenuItemUI.setDefaultRenderer(bgRenderer);
        RenderedMenuCheckItemUI.setDefaultRenderer(bgRenderer);
        RenderedMenuRadioItemUI.setDefaultRenderer(bgRenderer);
        UIManager.put("MenuUI", RenderedMenuUI.class.getName());
        UIManager.put("MenuItemUI", RenderedMenuItemUI.class.getName());
        UIManager.put("RadioButtonMenuItemUI", RenderedMenuRadioItemUI.class.getName());
        UIManager.put("CheckBoxMenuItemUI", RenderedMenuCheckItemUI.class.getName());
        UIManager.put("PopupMenuSeparatorUI", RenderedMenuSeparatorUI.class.getName());
        UIManager.put("ScrollBarUI", RenderedScrollBarUI.class.getName());
    }

    static {
        smallFontProps.setProperty("controlTextFont", "Dialog 10");
        smallFontProps.setProperty("systemTextFont", "Dialog 10");
        smallFontProps.setProperty("userTextFont", "Dialog 10");
        smallFontProps.setProperty("menuTextFont", "Dialog 10");
        smallFontProps.setProperty("windowTitleFont", "Dialog bold 10");
        smallFontProps.setProperty("subTextFont", "Dialog 8");
        largeFontProps.setProperty("controlTextFont", "Dialog 14");
        largeFontProps.setProperty("systemTextFont", "Dialog 14");
        largeFontProps.setProperty("userTextFont", "Dialog 14");
        largeFontProps.setProperty("menuTextFont", "Dialog 14");
        largeFontProps.setProperty("windowTitleFont", "Dialog bold 14");
        largeFontProps.setProperty("subTextFont", "Dialog 12");
        giantFontProps.setProperty("controlTextFont", "Dialog 18");
        giantFontProps.setProperty("systemTextFont", "Dialog 18");
        giantFontProps.setProperty("userTextFont", "Dialog 18");
        giantFontProps.setProperty("menuTextFont", "Dialog 18");
        giantFontProps.setProperty("windowTitleFont", "Dialog 18");
        giantFontProps.setProperty("subTextFont", "Dialog 16");
        themesList.add("Default");
        themesList.add("Small-Font");
        themesList.add("Large-Font");
        themesList.add("Giant-Font");
        themesMap.put("Default", defaultProps);
        themesMap.put("Small-Font", smallFontProps);
        themesMap.put("Large-Font", largeFontProps);
        themesMap.put("Giant-Font", giantFontProps);
    }
}

