/*
 * Decompiled with CFR 0.152.
 */
package plaf;

import BaseClasses.FrameBorder;
import IconRenderers.BasicCheckIcon;
import IconRenderers.BasicRadioIcon;
import IconRenderers.ControlButtonColors;
import IconRenderers.TreeOpenClosedIcon;
import Renderers.BasicGradientRenderer;
import Renderers.BasicRenderer;
import Renderers.GelRenderer;
import Renderers.JavTRenderer;
import Renderers.MetalRenderer;
import UIRenderers.RenderedCheckBoxUI;
import UIRenderers.RenderedMenuCheckItemUI;
import UIRenderers.RenderedMenuItemScrollUI;
import UIRenderers.RenderedMenuItemUI;
import UIRenderers.RenderedMenuRadioItemUI;
import UIRenderers.RenderedMenuSeparatorUI;
import UIRenderers.RenderedMenuUI;
import UIRenderers.RenderedPopupMenuBorderUI;
import UIRenderers.RenderedScrollBarUI;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.LineBorder;

public class Defaults {
    public static final int UI_CLASSIC = 0;
    public static final int UI_DARK = 1;
    public static final int UI_LIGHT = 2;
    public static final int UI_NW = 3;
    public static final int UI_DARK2 = 4;
    private static final RenderedPopupMenuBorderUI popUpMenuBorder = new RenderedPopupMenuBorderUI();

    public static void setUI() {
        Defaults.setUI(0);
    }

    public static void setUI(int style) {
        switch (style) {
            case 1: {
                Defaults.setDarkTheme();
                ControlButtonColors basicCtrlButtonColors = new ControlButtonColors();
                basicCtrlButtonColors.setColors(2, Color.lightGray, Color.white, null, null, null, Color.white, null);
                basicCtrlButtonColors.setColors(5, Color.gray, Color.darkGray, null, null, null, Color.darkGray, null);
                UIManager.put("RenderedUI.TitlePaneButton.min.colors", basicCtrlButtonColors);
                UIManager.put("RenderedUI.TitlePaneButton.max.colors", basicCtrlButtonColors);
                UIManager.put("RenderedUI.TitlePaneButton.dock.colors", basicCtrlButtonColors);
                UIManager.put("RenderedUI.TitlePaneButton.alwaysontop.colors", basicCtrlButtonColors);
                break;
            }
            case 4: {
                Defaults.setDarkTheme();
                Color activeBackcolor = new Color(60, 63, 65);
                BasicRenderer defaultRenderer = new BasicRenderer();
                defaultRenderer.getColors().setColors(1, activeBackcolor, Color.lightGray, Color.lightGray, Color.lightGray, Color.lightGray, Color.lightGray, Color.lightGray);
                defaultRenderer.getColors().setColors(0, Color.lightGray, Color.gray, Color.gray, Color.gray, Color.gray, Color.gray, Color.gray);
                UIManager.put("RenderedUI.TitlePaneRenderer", defaultRenderer);
                ControlButtonColors basicCtrlButtonColors = new ControlButtonColors();
                basicCtrlButtonColors.setColors(2, Color.lightGray, Color.gray, null, Color.lightGray, null, Color.white, Color.lightGray);
                basicCtrlButtonColors.setColors(5, Color.gray, Color.gray, null, Color.lightGray, null, Color.darkGray, Color.lightGray);
                UIManager.put("RenderedUI.TitlePaneButton.min.colors", basicCtrlButtonColors);
                UIManager.put("RenderedUI.TitlePaneButton.max.colors", basicCtrlButtonColors);
                UIManager.put("RenderedUI.TitlePaneButton.dock.colors", basicCtrlButtonColors);
                UIManager.put("RenderedUI.TitlePaneButton.alwaysontop.colors", basicCtrlButtonColors);
                BasicRenderer popupMenuBarRenderer = new BasicRenderer();
                popupMenuBarRenderer.setColors(activeBackcolor);
                popupMenuBarRenderer.setTextColors(Color.lightGray);
                popUpMenuBorder.setRenderer(popupMenuBarRenderer);
                Color activeFrameColor = Color.gray;
                Color inactiveFrameColor = Color.lightGray;
                UIManager.put("RootPane.frameBorder", new FrameBorder(activeFrameColor, inactiveFrameColor, 1, false));
                UIManager.put("TitlePane.border", new FrameBorder(activeFrameColor, inactiveFrameColor, 1, false));
                UIManager.put("RootPane.plainDialogBorder", new FrameBorder(Color.DARK_GRAY, inactiveFrameColor, 1, false));
                UIManager.put("RootPane.informationDialogBorder", new FrameBorder(activeFrameColor, inactiveFrameColor, 1, false));
                UIManager.put("RootPane.errorDialogBorder", new FrameBorder(activeFrameColor, inactiveFrameColor, 1, false));
                UIManager.put("RootPane.colorChooserDialogBorder", new FrameBorder(activeFrameColor, inactiveFrameColor, 1, false));
                UIManager.put("RootPane.fileChooserDialogBorder", new FrameBorder(activeFrameColor, inactiveFrameColor, 1, false));
                UIManager.put("questionDialogBorder", new FrameBorder(activeFrameColor, inactiveFrameColor, 1, false));
                UIManager.put("RootPane.warningDialogBorder", new FrameBorder(activeFrameColor, inactiveFrameColor, 1, false));
                UIManager.put("WindowBorderColor", Color.DARK_GRAY);
                UIManager.put("WindowInactiveBorderColor", Color.gray);
                break;
            }
            case 3: {
                Defaults.setPurpleTheme();
                break;
            }
            case 2: {
                Defaults.setLightTheme();
                break;
            }
            default: {
                Defaults.setClassicTheme();
                ControlButtonColors basicCtrlButtonColors = new ControlButtonColors();
                basicCtrlButtonColors.setColors(0, Color.white, Color.white, null, null, null, Color.white, null);
                basicCtrlButtonColors.setColors(3, Color.white, Color.white, null, null, null, Color.white, null);
                basicCtrlButtonColors.setColors(0, Color.white, Color.white, null, null, null, Color.white, null);
                basicCtrlButtonColors.setColors(3, Color.white, Color.white, null, null, null, Color.white, null);
                UIManager.put("RenderedUI.TitlePaneButton.min.colors", basicCtrlButtonColors);
                UIManager.put("RenderedUI.TitlePaneButton.max.colors", basicCtrlButtonColors);
                UIManager.put("RenderedUI.TitlePaneButton.dock.colors", basicCtrlButtonColors);
                UIManager.put("RenderedUI.TitlePaneButton.alwaysontop.colors", basicCtrlButtonColors);
            }
        }
    }

    public static void setUI(String name) {
        switch (name.toLowerCase()) {
            case "dark": {
                Defaults.setUI(1);
                break;
            }
            case "dark2": {
                Defaults.setUI(4);
                break;
            }
            case "purple": {
                Defaults.setUI(3);
                break;
            }
            case "light": {
                Defaults.setUI(2);
                break;
            }
            default: {
                Defaults.setUI(0);
            }
        }
    }

    public static RenderedPopupMenuBorderUI getPopupMenuBorder() {
        return popUpMenuBorder;
    }

    public static boolean setMenuHeaderFooterUIs(JMenu parentMenu, RenderedMenuSeparatorUI headerUI, RenderedMenuSeparatorUI footerUI) {
        if (parentMenu == null) {
            return false;
        }
        Component[] items = parentMenu.getMenuComponents();
        if (items == null || items.length == 0) {
            return false;
        }
        boolean haveHeader = false;
        JSeparator header = null;
        if (items[0] instanceof JSeparator) {
            haveHeader = true;
            header = (JSeparator)items[0];
            header.setUI(headerUI);
        }
        if (items.length > 1 && items[items.length - 1] instanceof JSeparator) {
            JSeparator footer = (JSeparator)items[items.length - 1];
            if (haveHeader && (footer.getToolTipText() == null || footer.getToolTipText().length() == 0)) {
                footer.setToolTipText(header.getToolTipText());
            }
            footer.setUI(footerUI);
        }
        for (Component item : items) {
            if (!(item instanceof JMenu)) continue;
            Defaults.setMenuHeaderFooterUIs((JMenu)item, headerUI, footerUI);
        }
        return true;
    }

    public static boolean setMenuHeaderFooterUIs(JPopupMenu parentMenu, RenderedMenuSeparatorUI headerUI, RenderedMenuSeparatorUI footerUI) {
        if (parentMenu == null) {
            return false;
        }
        Component[] items = parentMenu.getComponents();
        if (items == null || items.length == 0) {
            return false;
        }
        boolean haveHeader = false;
        JSeparator header = null;
        if (items[0] instanceof JSeparator) {
            haveHeader = true;
            header = (JSeparator)items[0];
            header.setUI(headerUI);
        }
        if (items.length > 1 && items[items.length - 1] instanceof JSeparator) {
            JSeparator footer = (JSeparator)items[items.length - 1];
            if (haveHeader && (footer.getToolTipText() == null || footer.getToolTipText().length() == 0)) {
                footer.setToolTipText(header.getToolTipText());
            }
            footer.setUI(footerUI);
        }
        for (Component item : items) {
            if (!(item instanceof JMenu)) continue;
            Defaults.setMenuHeaderFooterUIs((JMenu)item, headerUI, footerUI);
        }
        return true;
    }

    public static boolean setMenuBarHeaderFooterUIs(JMenuBar menuBar, RenderedMenuSeparatorUI headerUI, RenderedMenuSeparatorUI footerUI) {
        for (int x = menuBar.getMenuCount() - 1; x >= 0; --x) {
            JMenu item = menuBar.getMenu(x);
            Defaults.setMenuHeaderFooterUIs(item, headerUI, footerUI);
        }
        return true;
    }

    private static void setClassicTheme() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        Color menuBlue = new Color(153, 153, 255);
        Color startColor = new Color(204, 204, 255);
        Color borderColor = Color.BLUE;
        Color mainColor = menuBlue;
        BasicGradientRenderer bgRenderer = new BasicGradientRenderer();
        bgRenderer.setPaintBorder(false);
        bgRenderer.setRounded(false);
        Color disabledColor = Color.lightGray.brighter();
        bgRenderer.setTextColor(Color.black);
        bgRenderer.setColorNormal(Color.white);
        bgRenderer.setStartColors(Color.white);
        bgRenderer.setEndColors(Color.white);
        bgRenderer.setEndColorSelected(mainColor);
        bgRenderer.setStartColorSelected(startColor);
        bgRenderer.setEndColorPressed(mainColor);
        bgRenderer.setStartColorPressed(startColor);
        bgRenderer.setEndColorDisabled(disabledColor);
        bgRenderer.setStartColorDisabled(disabledColor);
        BasicRenderer labelRenderer = new BasicRenderer();
        labelRenderer.setTextColors(Color.black, Color.black, Color.black, Color.gray);
        labelRenderer.setPaintBorder(false);
        BasicCheckIcon menuCheckIcon = new BasicCheckIcon();
        menuCheckIcon.setColors(0, Color.green.darker());
        menuCheckIcon.setColors(2, Color.black);
        menuCheckIcon.setColors(1, Color.white);
        menuCheckIcon.setColor(0, 0, null);
        menuCheckIcon.setColor(0, 2, Color.lightGray);
        menuCheckIcon.setColor(0, 4, Color.lightGray);
        menuCheckIcon.setColor(0, 1, Color.gray);
        menuCheckIcon.setColor(0, 6, Color.darkGray);
        menuCheckIcon.setColor(1, 6, Color.white);
        menuCheckIcon.setColor(2, 6, Color.black);
        menuCheckIcon.setColor(1, 5, Color.white);
        menuCheckIcon.setColor(0, 5, Color.green);
        menuCheckIcon.setColor(2, 5, Color.black);
        BasicRadioIcon menuRadioIcon = new BasicRadioIcon();
        menuRadioIcon.setColors(menuCheckIcon.getColors());
        BasicGradientRenderer menuCheckRadioRenderer = new BasicGradientRenderer();
        menuCheckRadioRenderer.setPaintBorder(false);
        menuCheckRadioRenderer.setRounded(false);
        menuCheckRadioRenderer.setTextColors(Color.black);
        menuCheckRadioRenderer.getColors().setColors(1, Color.white, startColor, disabledColor, Color.white, disabledColor, startColor, startColor);
        menuCheckRadioRenderer.getColors().setColors(4, Color.white, mainColor, disabledColor, Color.white, disabledColor, mainColor, mainColor);
        RenderedMenuCheckItemUI.setDefaultRenderer(menuCheckRadioRenderer);
        RenderedMenuRadioItemUI.setDefaultRenderer(menuCheckRadioRenderer);
        UIManager.put("CheckBoxMenuItem.checkIcon", menuCheckIcon);
        UIManager.put("CheckBox.icon", menuCheckIcon);
        UIManager.put("RadioButton.icon", menuRadioIcon);
        UIManager.put("RadioButtonMenuItem.checkIcon", menuRadioIcon);
        RenderedCheckBoxUI.setDefaultRenderer(labelRenderer);
        UIManager.put("CheckBoxUI", RenderedCheckBoxUI.class.getName());
        UIManager.put("CheckBoxMenuItemUI", RenderedMenuCheckItemUI.class.getName());
        UIManager.put("ComboBox.border", new LineBorder(Color.BLACK));
        UIManager.put("ComboBox.selectionForeground", Color.BLACK);
        UIManager.put("ComboBox.selectionBackground", mainColor);
        UIManager.put("ComboBox.background", Color.WHITE);
        UIManager.put("FileChooser.openButtonText", "Open Project");
        UIManager.put("FileChooser.saveButtonText", "Save Project");
        UIManager.put("List.border", new LineBorder(Color.BLACK));
        UIManager.put("List.selectionForeground", Color.BLACK);
        UIManager.put("List.selectionBackground", mainColor);
        UIManager.put("List.background", Color.WHITE);
        UIManager.put("Menu.background", Color.WHITE);
        UIManager.put("Menu.selectionBackground", mainColor);
        UIManager.put("Menu.selectionForeground", Color.WHITE);
        UIManager.put("Menu.borderColor", borderColor);
        UIManager.put("Menu.selectionBorderColor", borderColor);
        UIManager.put("Menu.opaque", true);
        RenderedMenuUI.setDefaultRenderer(bgRenderer);
        UIManager.put("MenuUI", RenderedMenuUI.class.getName());
        UIManager.put("MenuBar.background", Color.WHITE);
        UIManager.put("MenuItem.borderColor", borderColor);
        UIManager.put("MenuItem.acceleratorForeground", borderColor);
        UIManager.put("MenuItem.acceleratorSelectionForeground", Color.WHITE);
        UIManager.put("MenuItem.background", Color.WHITE);
        UIManager.put("MenuItem.foreground", Color.BLACK);
        UIManager.put("MenuItem.selectionForeground", Color.WHITE);
        RenderedMenuItemUI.setDefaultRenderer(bgRenderer);
        UIManager.put("MenuItemUI", RenderedMenuItemUI.class.getName());
        UIManager.put("RenderedUI.MenuFooter.opaque", false);
        UIManager.put("RenderedUI.MenuHeader.opaque", false);
        UIManager.put("RenderedUI.MenuRadioItem.opaque", false);
        UIManager.put("RenderedUI.MenuCheckBoxItem.opaque", false);
        UIManager.put("RenderedUI.MenuItem.opaque", false);
        RenderedMenuItemScrollUI.getDefaultColor().setColors(1, Color.white);
        RenderedMenuItemScrollUI.getDefaultColor().setColors(2, Color.BLUE);
        RenderedMenuItemScrollUI.getDefaultColor().setColors(0, null);
        RenderedMenuItemScrollUI.getDefaultColor().setColors(3, menuBlue);
        RenderedMenuSeparatorUI.getDefaultColor().setColors(1, Color.white);
        RenderedMenuSeparatorUI.getDefaultColor().setColors(2, borderColor);
        RenderedMenuSeparatorUI.getDefaultColor().setColors(3, mainColor);
        RenderedMenuSeparatorUI.getDefaultColor().setColors(0, Color.white);
        UIManager.put("PopupMenu.background", Color.WHITE);
        UIManager.put("PopupMenu.border", Defaults.getPopupMenuBorder());
        UIManager.put("RenderedPopupMenuBorder.bordercolor", borderColor);
        RenderedPopupMenuBorderUI.setDefaultRenderer(new GelRenderer());
        RenderedPopupMenuBorderUI.getDefaultRenderer().setRounded(false);
        RenderedPopupMenuBorderUI.getDefaultRenderer().setColors(mainColor, startColor, mainColor, mainColor);
        RenderedPopupMenuBorderUI.getDefaultRenderer().setTextColors(Color.white, Color.DARK_GRAY, Color.DARK_GRAY);
        RenderedPopupMenuBorderUI.getDefaultRenderer().setBorderColors(borderColor);
        UIManager.put("PopupMenuSeparatorUI", RenderedMenuSeparatorUI.class.getName());
        RenderedScrollBarUI.getDefaultThumbRenderer().setColors(mainColor);
        RenderedScrollBarUI.setDefaultButtonRenderer(new MetalRenderer());
        RenderedScrollBarUI.getDefaultButtonRenderer().setColors(mainColor);
        RenderedScrollBarUI.getDefaultArrowRenderer().getColors().setColors(1, Color.white);
        RenderedScrollBarUI.getDefaultArrowRenderer().getColors().setColors(2, Color.black);
        RenderedScrollBarUI.setDefaultTrackRenderer(new JavTRenderer());
        RenderedScrollBarUI.getDefaultTrackRenderer().setColors(new Color(204, 204, 255));
        RenderedScrollBarUI.getDefaultTrackRenderer().setBorderColors(Color.black);
        RenderedScrollBarUI.getDefaultThumbRenderer().setBorderColors(Color.white);
        UIManager.put("ScrollBarUI", RenderedScrollBarUI.class.getName());
        UIManager.put("Separator.foreground", Color.BLACK);
        UIManager.put("Separator.background", Color.BLACK);
        UIManager.put("Spinner.border", new LineBorder(Color.BLACK));
        UIManager.put("TextArea.border", new LineBorder(Color.BLACK));
        UIManager.put("TextField.border", new LineBorder(Color.BLACK));
        UIManager.put("ToolTip.border", new LineBorder(Color.BLACK));
        UIManager.put("ToolTip.background", Color.WHITE);
        UIManager.put("Tree.background", Color.white);
        UIManager.put("Tree.foreground", Color.black);
        UIManager.put("Tree.background", Color.white);
        UIManager.put("Tree.dropLineColor", Color.black);
        UIManager.put("Tree.foreground", Color.black);
        UIManager.put("Tree.selectionBackground", Color.yellow);
        UIManager.put("Tree.selectionForeground", Color.black);
        UIManager.put("Tree.textBackground", Color.white);
        UIManager.put("Tree.textForeground", Color.black);
        TreeOpenClosedIcon closedIcon = new TreeOpenClosedIcon(true);
        TreeOpenClosedIcon openedIcon = new TreeOpenClosedIcon(false);
        closedIcon.getColors().setColor(1, 0, Color.white);
        closedIcon.getColors().setColor(0, 0, Color.black);
        closedIcon.getColors().setColor(2, 0, Color.black);
        openedIcon.setColors(closedIcon.getColors());
        UIManager.put("Tree.collapsedIcon", closedIcon);
        UIManager.put("Tree.expandedIcon", openedIcon);
        UIManager.put("RadioButtonMenuItemUI", RenderedMenuRadioItemUI.class.getName());
        UIManager.put("DockingFrame.activeTitleBackgroundStart", new Color(204, 204, 255));
        UIManager.put("DockingFrame.activeTitleBackgroundEnd", new Color(102, 102, 255));
        UIManager.put("DockingFrame.activeTitleForeground", Color.black);
        UIManager.put("DockingFrame.background", Color.white);
        UIManager.put("DockingFrame.titlebar.hidedocked", false);
        UIManager.put("DockingFrame.titlebar.hideundocked", false);
        UIManager.put("DockingFrame.titlebar.docked.height", 24);
        UIManager.put("DockingFrame.titlebar.undocked.height", 28);
        UIManager.put("GhostTextPane.background", Color.white);
        UIManager.put("GhostTextPane.foreground", Color.black);
        UIManager.put("GhostTextPane.selectionBackground", startColor);
        UIManager.put("GhostTextPane.selectionForeground", Color.black);
        UIManager.put("Plot.link.active", Color.red);
        UIManager.put("Plot.link.inactive", Color.blue);
        UIManager.put("StatusLabel.background", Color.white);
        UIManager.put("StatusLabel.foreground", Color.black);
        UIManager.put("SequenceEditor.background", new Color(204, 204, 255));
        UIManager.put("SequenceEditor.foreground", Color.black);
    }

    private static void setNWTheme() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        Color nwPurple = new Color(78, 32, 142);
        Color startColor = new Color(204, 204, 255);
        Color borderColor = nwPurple;
        Color mainColor = nwPurple;
        BasicGradientRenderer bgRenderer = new BasicGradientRenderer();
        bgRenderer.setPaintBorder(false);
        bgRenderer.setRounded(false);
        Color disabledColor = Color.lightGray.brighter();
        bgRenderer.setTextColor(Color.black);
        bgRenderer.setColorNormal(Color.white);
        bgRenderer.setStartColors(Color.white);
        bgRenderer.setEndColors(Color.white);
        bgRenderer.setEndColorSelected(mainColor);
        bgRenderer.setStartColorSelected(startColor);
        bgRenderer.setEndColorPressed(mainColor);
        bgRenderer.setStartColorPressed(startColor);
        bgRenderer.setEndColorDisabled(disabledColor);
        bgRenderer.setStartColorDisabled(disabledColor);
        RenderedMenuUI.setDefaultRenderer(bgRenderer);
        RenderedMenuItemUI.setDefaultRenderer(bgRenderer);
        BasicGradientRenderer menuCheckRadioRenderer = new BasicGradientRenderer();
        menuCheckRadioRenderer.setPaintBorder(false);
        menuCheckRadioRenderer.setRounded(false);
        menuCheckRadioRenderer.setTextColors(Color.black);
        menuCheckRadioRenderer.getColors().setColors(1, Color.white, startColor, disabledColor, Color.white, disabledColor, startColor, startColor);
        menuCheckRadioRenderer.getColors().setColors(4, Color.white, mainColor, disabledColor, Color.white, disabledColor, mainColor, mainColor);
        RenderedMenuCheckItemUI.setDefaultRenderer(menuCheckRadioRenderer);
        RenderedMenuRadioItemUI.setDefaultRenderer(menuCheckRadioRenderer);
        UIManager.put("RenderedUI.MenuSeparator.background", Color.white);
        UIManager.put("RenderedUI.MenuSeparator.bordercolor", borderColor);
        UIManager.put("RenderedUI.MenuSeparator.fillcolor", mainColor);
        UIManager.put("RenderedUI.MenuSeparator.foreground", Color.white);
        UIManager.put("RenderedUI.MenuSeparator.header.background", Color.white);
        UIManager.put("RenderedUI.MenuSeparator.header.bordercolor", borderColor);
        UIManager.put("RenderedUI.MenuSeparator.header.fillcolor", mainColor);
        UIManager.put("RenderedUI.MenuSeparator.header.foreground", Color.white);
        UIManager.put("RenderedUI.MenuSeparator.footer.background", Color.white);
        UIManager.put("RenderedUI.MenuSeparator.footer.bordercolor", borderColor);
        UIManager.put("RenderedUI.MenuSeparator.footer.fillcolor", mainColor);
        UIManager.put("DockingFrame.activeTitleBackgroundStart", Color.white);
        UIManager.put("DockingFrame.activeTitleBackgroundEnd", mainColor);
        UIManager.put("DockingFrame.activeTitleForeground", Color.white);
        UIManager.put("DockingFrame.background", Color.white);
        RenderedPopupMenuBorderUI.setDefaultRenderer(new GelRenderer());
        RenderedPopupMenuBorderUI.getDefaultRenderer().setRounded(false);
        RenderedPopupMenuBorderUI.getDefaultRenderer().setColors(mainColor, startColor, mainColor, mainColor);
        RenderedPopupMenuBorderUI.getDefaultRenderer().setTextColors(Color.white, Color.DARK_GRAY, Color.DARK_GRAY);
        RenderedScrollBarUI.getDefaultThumbRenderer().setColors(mainColor);
        RenderedScrollBarUI.setDefaultButtonRenderer(new MetalRenderer());
        RenderedScrollBarUI.getDefaultButtonRenderer().setColors(mainColor);
        RenderedScrollBarUI.getDefaultArrowRenderer().getColors().setColors(1, Color.black);
        RenderedScrollBarUI.getDefaultArrowRenderer().getColors().setColors(2, Color.white);
        RenderedScrollBarUI.setDefaultTrackRenderer(new JavTRenderer());
        RenderedScrollBarUI.getDefaultTrackRenderer().setColors(new Color(204, 204, 255));
        RenderedScrollBarUI.getDefaultTrackRenderer().setBorderColor(Color.black);
        RenderedScrollBarUI.getDefaultThumbRenderer().setBorderColor(Color.white);
        UIManager.put("MenuScroller.background", mainColor);
        UIManager.put("MenuScroller.foreground", Color.WHITE);
        UIManager.put("MenuScroller.bordercolor", Color.WHITE);
        UIManager.put("MenuBar.background", Color.WHITE);
        UIManager.put("Menu.background", Color.WHITE);
        UIManager.put("PopupMenu.background", Color.WHITE);
        UIManager.put("Menu.selectionBackground", mainColor);
        UIManager.put("Menu.selectionForeground", Color.WHITE);
        UIManager.put("Menu.borderColor", borderColor);
        UIManager.put("Menu.selectionBorderColor", borderColor);
        UIManager.put("MenuItem.borderColor", borderColor);
        UIManager.put("MenuItem.acceleratorForeground", borderColor);
        UIManager.put("MenuItem.acceleratorSelectionForeground", Color.WHITE);
        UIManager.put("MenuItem.background", Color.WHITE);
        UIManager.put("MenuItem.foreground", Color.BLACK);
        UIManager.put("MenuItem.selectionForeground", Color.WHITE);
        UIManager.put("FileChooser.openButtonText", "Open Project");
        UIManager.put("FileChooser.saveButtonText", "Save Project");
        UIManager.put("Separator.foreground", Color.BLACK);
        UIManager.put("Separator.background", Color.BLACK);
        UIManager.put("List.border", new LineBorder(Color.BLACK));
        UIManager.put("List.selectionForeground", Color.BLACK);
        UIManager.put("List.selectionBackground", mainColor);
        UIManager.put("List.background", Color.WHITE);
        UIManager.put("Spinner.border", new LineBorder(Color.BLACK));
        UIManager.put("ComboBox.border", new LineBorder(Color.BLACK));
        UIManager.put("ComboBox.selectionForeground", Color.BLACK);
        UIManager.put("ComboBox.selectionBackground", mainColor);
        UIManager.put("ComboBox.background", Color.WHITE);
        UIManager.put("ToolTip.border", new LineBorder(Color.BLACK));
        UIManager.put("ToolTip.background", Color.WHITE);
        UIManager.put("TextField.border", new LineBorder(Color.BLACK));
        UIManager.put("TextArea.border", new LineBorder(Color.BLACK));
        UIManager.put("Plot.link.active", Color.red);
        UIManager.put("Plot.link.inactive", Color.blue);
        UIManager.put("StatusLabel.background", Color.white);
        UIManager.put("StatusLabel.foreground", Color.black);
        UIManager.put("SequenceEditor.background", new Color(204, 204, 255));
        UIManager.put("SequenceEditor.foreground", Color.black);
        UIManager.put("PopupMenu.border", Defaults.getPopupMenuBorder());
        UIManager.put("RenderedPopupMenuBorder.bordercolor", borderColor);
        RenderedPopupMenuBorderUI.getDefaultRenderer().setBorderColors(borderColor);
        UIManager.put("Tree.background", Color.white);
        UIManager.put("Tree.foreground", Color.black);
        UIManager.put("Tree.background", Color.white);
        UIManager.put("Tree.dropLineColor", Color.black);
        UIManager.put("Tree.foreground", Color.black);
        UIManager.put("Tree.selectionBackground", Color.yellow);
        UIManager.put("Tree.selectionForeground", Color.black);
        UIManager.put("GhostTextPane.background", Color.white);
        UIManager.put("GhostTextPane.foreground", Color.black);
        UIManager.put("GhostTextPane.selectionBackground", startColor);
        UIManager.put("MenuUI", RenderedMenuUI.class.getName());
        UIManager.put("MenuItemUI", RenderedMenuItemUI.class.getName());
        UIManager.put("RadioButtonMenuItemUI", RenderedMenuRadioItemUI.class.getName());
        UIManager.put("CheckBoxMenuItemUI", RenderedMenuCheckItemUI.class.getName());
        UIManager.put("PopupMenuSeparatorUI", RenderedMenuSeparatorUI.class.getName());
        UIManager.put("ScrollBarUI", RenderedScrollBarUI.class.getName());
    }

    private static void setDarkTheme() {
        try {
            UIManager.setLookAndFeel("plaf.DarkLookAndFeel");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
    }

    private static void setLightTheme() {
        try {
            UIManager.setLookAndFeel("plaf.LightLookAndFeel");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
    }

    private static void setPurpleTheme() {
        try {
            UIManager.setLookAndFeel("plaf.NWLookAndFeel");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
    }
}

