/*
 * Decompiled with CFR 0.152.
 */
package plaf;

import IconRenderers.ControlButtonColors;
import IconRenderers.TreeOpenClosedIcon;
import Renderers.BasicGradientRenderer;
import Renderers.BasicRenderer;
import Renderers.GelRenderer;
import Renderers.JavTRenderer;
import Renderers.MetalRenderer;
import UIRenderers.RenderedButtonUI;
import UIRenderers.RenderedCheckBoxUI;
import UIRenderers.RenderedLabelUI;
import UIRenderers.RenderedMenuBarUI;
import UIRenderers.RenderedMenuCheckItemUI;
import UIRenderers.RenderedMenuItemScrollUI;
import UIRenderers.RenderedMenuItemUI;
import UIRenderers.RenderedMenuRadioItemUI;
import UIRenderers.RenderedMenuSeparatorUI;
import UIRenderers.RenderedMenuUI;
import UIRenderers.RenderedPopupMenuBorderUI;
import UIRenderers.RenderedProgressBarUI;
import UIRenderers.RenderedRadioButtonUI;
import UIRenderers.RenderedScrollBarUI;
import UIRenderers.RenderedSeparatorUI;
import UIRenderers.RenderedSpinnerUI;
import UIRenderers.RenderedSplitPaneUI;
import UIRenderers.RenderedTabbedPaneUI;
import UIRenderers.RenderedToggleButtonUI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ColorUIResource;
import plaf.AbstractBorderFactory;
import plaf.AbstractIconFactory;
import plaf.AbstractLookAndFeel;
import plaf.AbstractTheme;
import plaf.Defaults;
import plaf.RenderedBorderFactory;
import plaf.RenderedDefaultTheme;
import plaf.RenderedIconFactory;

public class ClassicLookAndFeel
extends AbstractLookAndFeel {
    private static RenderedDefaultTheme myTheme = null;
    private static final ArrayList themesList = new ArrayList();
    private static final HashMap themesMap = new HashMap();
    private static final Properties defaultProps = new Properties();
    private static final Properties smallFontProps = new Properties();
    private static final Properties largeFontProps = new Properties();
    private static final Properties giantFontProps = new Properties();

    public static List getThemes() {
        return themesList;
    }

    public static Properties getThemeProperties(String name) {
        return (Properties)themesMap.get(name);
    }

    public static void setTheme(String name) {
        ClassicLookAndFeel.setTheme((Properties)themesMap.get(name));
        if (myTheme != null) {
            AbstractTheme.setInternalName(name);
        }
    }

    public static void setTheme(Properties themesProps) {
        currentThemeName = "renderedThemeDefault";
        if (myTheme == null) {
            myTheme = new RenderedDefaultTheme();
        }
        if (myTheme != null && themesProps != null) {
            myTheme.setUpColor();
            myTheme.setProperties(themesProps);
            myTheme.setUpColorArrs();
            AbstractLookAndFeel.setTheme(myTheme);
        }
    }

    public static void setCurrentTheme(Properties themesProps) {
        ClassicLookAndFeel.setTheme(themesProps);
    }

    @Override
    public String getName() {
        return "Rendered";
    }

    @Override
    public String getID() {
        return "Rendered";
    }

    @Override
    public String getDescription() {
        return "The Rendered Look and Feel";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public AbstractBorderFactory getBorderFactory() {
        return RenderedBorderFactory.getInstance();
    }

    @Override
    public AbstractIconFactory getIconFactory() {
        return RenderedIconFactory.getInstance();
    }

    @Override
    protected void createDefaultTheme() {
        if (myTheme == null) {
            myTheme = new RenderedDefaultTheme();
        }
        ClassicLookAndFeel.setTheme(myTheme);
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        if (!"renderedThemeDefault".equals(currentThemeName)) {
            ClassicLookAndFeel.setTheme("Default");
        }
        super.initClassDefaults(table);
        this.initTheme();
    }

    public void initTheme() {
        Color startColorBlue = new Color(204, 204, 255);
        Color menuBlue = new Color(153, 153, 255);
        Color startColor = startColorBlue;
        Color borderColor = Color.BLUE;
        Color mainColor = menuBlue;
        Color activeBackcolor = new Color(60, 63, 65);
        Color menuForecolor = new Color(187, 187, 187);
        Color disabledColor = activeBackcolor.darker();
        ColorUIResource uiActiveBackcolor = new ColorUIResource(activeBackcolor);
        ColorUIResource uiMenuForecolor = new ColorUIResource(menuForecolor);
        ColorUIResource disabledForecolor = new ColorUIResource(activeBackcolor.darker());
        BasicGradientRenderer bgRenderer = new BasicGradientRenderer();
        bgRenderer.setPaintBorder(false);
        bgRenderer.setRounded(false);
        bgRenderer.setEndColorDisabled(disabledColor);
        bgRenderer.setStartColorDisabled(disabledColor);
        bgRenderer.setTextColor(menuForecolor);
        bgRenderer.setColorNormal(activeBackcolor);
        bgRenderer.setStartColors(activeBackcolor);
        bgRenderer.setEndColors(activeBackcolor);
        bgRenderer.setEndColorSelected(menuForecolor);
        bgRenderer.setStartColorSelected(menuForecolor);
        bgRenderer.setTextColors(menuForecolor, activeBackcolor, activeBackcolor);
        bgRenderer.setEndColorPressed(mainColor);
        bgRenderer.setStartColorPressed(startColor);
        MetalRenderer buttonRenderer = new MetalRenderer();
        buttonRenderer.getColors().setColors(1, menuForecolor, menuForecolor.darker(), menuForecolor.darker(), menuForecolor.darker(), menuForecolor.darker(), menuForecolor, menuForecolor.darker());
        buttonRenderer.getColors().setColors(0, menuForecolor);
        buttonRenderer.getColors().setColors(2, menuForecolor);
        buttonRenderer.setPaintBorder(true);
        BasicGradientRenderer defaultRenderer = new BasicGradientRenderer();
        defaultRenderer.setStartColors(menuForecolor);
        defaultRenderer.setEndColors(activeBackcolor);
        defaultRenderer.setEndColors(activeBackcolor);
        defaultRenderer.getColors().setColors(0, Color.white, Color.white, disabledColor, Color.white, Color.DARK_GRAY, Color.white, Color.white);
        RenderedPopupMenuBorderUI.getDefaultRenderer().setBorderColors(menuForecolor);
        RenderedMenuUI.setDefaultRenderer(bgRenderer);
        RenderedMenuItemUI.setDefaultRenderer(bgRenderer);
        BasicGradientRenderer menuCheckRadioRenderer = new BasicGradientRenderer();
        menuCheckRadioRenderer.setPaintBorder(false);
        menuCheckRadioRenderer.setRounded(false);
        menuCheckRadioRenderer.setEndColorDisabled(disabledColor);
        menuCheckRadioRenderer.setStartColorDisabled(disabledColor);
        menuCheckRadioRenderer.setTextColor(menuForecolor);
        menuCheckRadioRenderer.setColorNormal(activeBackcolor);
        menuCheckRadioRenderer.setStartColors(activeBackcolor);
        menuCheckRadioRenderer.setEndColors(activeBackcolor);
        menuCheckRadioRenderer.setEndColorSelected(activeBackcolor);
        menuCheckRadioRenderer.setStartColorSelected(activeBackcolor);
        menuCheckRadioRenderer.setEndColorRollover(activeBackcolor);
        menuCheckRadioRenderer.setStartColorRollover(activeBackcolor);
        menuCheckRadioRenderer.setTextColors(menuForecolor, activeBackcolor, activeBackcolor);
        menuCheckRadioRenderer.setEndColorPressed(mainColor);
        menuCheckRadioRenderer.setStartColorPressed(startColor);
        RenderedMenuCheckItemUI.setDefaultRenderer(menuCheckRadioRenderer);
        RenderedMenuRadioItemUI.setDefaultRenderer(menuCheckRadioRenderer);
        UIManager.put("Button.background", activeBackcolor);
        UIManager.put("Button.foreground", menuForecolor);
        RenderedButtonUI.setDefaultRenderer(buttonRenderer);
        UIManager.put("ButtonUI", RenderedButtonUI.class.getName());
        UIManager.put("CheckBox.background", uiActiveBackcolor);
        UIManager.put("CheckBox.foreground", Color.black);
        UIManager.put("CheckBox.opaque", false);
        BasicRenderer labelRenderer = new BasicRenderer();
        labelRenderer.setColors(activeBackcolor);
        labelRenderer.getColors().setColors(0, Color.black);
        labelRenderer.setPaintBorder(false);
        RenderedCheckBoxUI.setDefaultRenderer(labelRenderer);
        UIManager.put("CheckBoxUI", RenderedCheckBoxUI.class.getName());
        UIManager.put("CheckBoxMenuItem.selectionBackground", menuForecolor);
        UIManager.put("CheckBoxMenuItem.selectionForeground", activeBackcolor);
        UIManager.put("CheckBoxMenuItem.foreground", menuForecolor);
        UIManager.put("CheckBoxMenuItem.background", activeBackcolor);
        UIManager.put("CheckBoxMenuItem.acceleratorForeground", Color.white);
        UIManager.put("CheckBoxMenuItem.disabledBackground", activeBackcolor.darker());
        UIManager.put("CheckBoxMenuItem.disabledForeground", disabledForecolor);
        UIManager.put("CheckBoxMenuItemUI", RenderedMenuCheckItemUI.class.getName());
        UIManager.put("ComboBox.border", new LineBorder(Color.BLACK));
        UIManager.put("ComboBox.selectionForeground", activeBackcolor);
        UIManager.put("ComboBox.selectionBackground", menuForecolor);
        UIManager.put("ComboBox.background", activeBackcolor);
        UIManager.put("ComboBox.foreground", menuForecolor);
        UIManager.put("ComboBox.disabledBackground", disabledColor);
        UIManager.put("ComboBox.disabledForeground", disabledForecolor);
        UIManager.put("ComboBoxUI", "UIRenderers.RenderedComboBoxUI");
        UIManager.put("EditorPane.background", activeBackcolor);
        UIManager.put("EditorPane.foreground", menuForecolor);
        UIManager.put("EditorPane.border", new LineBorder(Color.BLACK));
        UIManager.put("FileChooser.openButtonText", "Open Project");
        UIManager.put("FileChooser.saveButtonText", "Save Project");
        RenderedLabelUI.setDefaultRenderer(new BasicRenderer());
        RenderedLabelUI.getDefaultRenderer().setColors(activeBackcolor);
        RenderedLabelUI.getDefaultRenderer().setTextColors(menuForecolor, menuForecolor, menuForecolor, menuForecolor.darker());
        RenderedLabelUI.getDefaultRenderer().setPaintBorder(false);
        UIManager.put("Label.background", activeBackcolor);
        UIManager.put("Label.foreground", menuForecolor);
        UIManager.put("Label.disabledForeground", disabledForecolor);
        UIManager.put("Label.opaque", false);
        UIManager.put("List.border", new LineBorder(Color.BLACK));
        UIManager.put("List.selectionForeground", activeBackcolor);
        UIManager.put("List.selectionBackground", menuForecolor);
        UIManager.put("List.background", activeBackcolor);
        UIManager.put("List.foreground", menuForecolor);
        UIManager.put("Menu.background", activeBackcolor);
        UIManager.put("Menu.selectionBackground", menuForecolor);
        UIManager.put("Menu.selectionForeground", activeBackcolor);
        UIManager.put("Menu.acceleratorForeground", menuForecolor);
        UIManager.put("Menu.acceleratorSelectionForeground", activeBackcolor);
        UIManager.put("Menu.borderColor", borderColor);
        UIManager.put("Menu.selectionBorderColor", borderColor);
        UIManager.put("MenuUI", RenderedMenuUI.class.getName());
        UIManager.put("MenuBar.background", activeBackcolor);
        UIManager.put("MenuBar.foreground", uiMenuForecolor);
        BasicRenderer menuBarRenderer = new BasicRenderer();
        menuBarRenderer.setColors(activeBackcolor);
        menuBarRenderer.setTextColors(menuForecolor, menuForecolor.brighter(), menuForecolor.darker());
        RenderedMenuBarUI.setDefaultRenderer(menuBarRenderer);
        UIManager.put("MenuBarUI", RenderedMenuBarUI.class.getName());
        UIManager.put("MenuItem.borderColor", borderColor);
        UIManager.put("MenuItem.acceleratorForeground", uiMenuForecolor);
        UIManager.put("MenuItem.acceleratorSelectionForeground", uiActiveBackcolor);
        UIManager.put("MenuItem.background", activeBackcolor);
        UIManager.put("MenuItem.foreground", menuForecolor);
        UIManager.put("MenuItem.selectionForeground", activeBackcolor);
        UIManager.put("MenuItem.selectionBackground", menuForecolor);
        UIManager.put("MenuItemUI", RenderedMenuItemUI.class.getName());
        RenderedMenuItemScrollUI.getDefaultColor().setColors(1, Color.white);
        RenderedMenuItemScrollUI.getDefaultColor().setColors(2, Color.BLUE);
        RenderedMenuItemScrollUI.getDefaultColor().setColors(0, null);
        RenderedMenuItemScrollUI.getDefaultColor().setColors(3, menuBlue);
        UIManager.put("RenderedUI.MenuSeparator.background", uiActiveBackcolor);
        UIManager.put("RenderedUI.MenuSeparator.bordercolor", uiMenuForecolor);
        UIManager.put("RenderedUI.MenuSeparator.fillcolor", uiMenuForecolor);
        UIManager.put("RenderedUI.MenuSeparator.foreground", uiActiveBackcolor);
        UIManager.put("RenderedUI.MenuSeparator.header.background", uiActiveBackcolor);
        UIManager.put("RenderedUI.MenuSeparator.header.bordercolor", uiMenuForecolor);
        UIManager.put("RenderedUI.MenuSeparator.header.fillcolor", uiMenuForecolor);
        UIManager.put("RenderedUI.MenuSeparator.header.foreground", uiActiveBackcolor);
        UIManager.put("RenderedUI.MenuSeparator.footer.background", uiActiveBackcolor);
        UIManager.put("RenderedUI.MenuSeparator.footer.bordercolor", uiMenuForecolor);
        UIManager.put("RenderedUI.MenuSeparator.footer.fillcolor", uiMenuForecolor);
        UIManager.put("OptionPane.messageForeground", menuForecolor);
        LineBorder borderOut = new LineBorder(menuForecolor, 1, false);
        EmptyBorder borderIn = new EmptyBorder(15, 15, 15, 15);
        CompoundBorder border = new CompoundBorder(borderOut, borderIn);
        UIManager.put("OptionPane.border", border);
        UIManager.put("OptionPane.background", activeBackcolor);
        UIManager.put("OptionPane.foreground", menuForecolor);
        UIManager.put("Panel.background", activeBackcolor);
        UIManager.put("Panel.foreground", menuForecolor);
        UIManager.put("PopupMenu.background", activeBackcolor);
        UIManager.put("PopupMenu.border", Defaults.getPopupMenuBorder());
        UIManager.put("RenderedPopupMenuBorder.bordercolor", activeBackcolor);
        RenderedPopupMenuBorderUI.setDefaultRenderer(new GelRenderer());
        RenderedPopupMenuBorderUI.getDefaultRenderer().setRounded(false);
        RenderedPopupMenuBorderUI.getDefaultRenderer().setColors(activeBackcolor, activeBackcolor, activeBackcolor, activeBackcolor);
        RenderedPopupMenuBorderUI.getDefaultRenderer().setTextColors(menuForecolor, menuForecolor, menuForecolor);
        UIManager.put("PopupMenuSeparatorUI", RenderedMenuSeparatorUI.class.getName());
        RenderedProgressBarUI.setDefaultThumbRenderer(RenderedScrollBarUI.getDefaultThumbRenderer());
        RenderedProgressBarUI.setDefaultTrackRenderer(RenderedScrollBarUI.getDefaultTrackRenderer());
        RenderedProgressBarUI.getDefaultValueRenderer().setTextColor(menuForecolor);
        UIManager.put("ProgressBarUI", RenderedProgressBarUI.class.getName());
        UIManager.put("RadioButtonUI", RenderedRadioButtonUI.class.getName());
        UIManager.put("RadioButtonMenuItem.selectionBackground", menuForecolor);
        UIManager.put("RadioButtonMenuItem.selectionForeground", activeBackcolor);
        UIManager.put("RadioButtonMenuItem.foreground", menuForecolor);
        UIManager.put("RadioButtonMenuItem.background", activeBackcolor);
        UIManager.put("RadioButtonMenuItem.acceleratorForeground", Color.white);
        UIManager.put("RadioButtonMenuItem.disabledBackground", activeBackcolor.darker());
        UIManager.put("RadioButtonMenuItem.disabledForeground", disabledForecolor);
        UIManager.put("RadioButtonMenuItemUI", RenderedMenuRadioItemUI.class.getName());
        UIManager.put("RootPaneUI", "UIRenderers.RenderedRootPaneUI");
        UIManager.put("RootPane.frameBorder", new LineBorder(activeBackcolor, 3, false));
        RenderedScrollBarUI.getDefaultThumbRenderer().setColors(menuForecolor);
        RenderedScrollBarUI.getDefaultButtonRenderer().setColors(menuForecolor);
        RenderedScrollBarUI.getDefaultArrowRenderer().getColors().setColors(1, activeBackcolor);
        RenderedScrollBarUI.setDefaultTrackRenderer(new JavTRenderer());
        RenderedScrollBarUI.getDefaultTrackRenderer().setColors(activeBackcolor);
        RenderedScrollBarUI.getDefaultTrackRenderer().setBorderColor(Color.black);
        RenderedScrollBarUI.getDefaultThumbRenderer().setBorderColor(activeBackcolor);
        UIManager.put("ScrollBarUI", RenderedScrollBarUI.class.getName());
        UIManager.put("Separator.foreground", menuForecolor);
        UIManager.put("Separator.background", Color.BLACK);
        UIManager.put("SeparatorUI", RenderedSeparatorUI.class.getName());
        UIManager.put("Spinner.border", new LineBorder(Color.BLACK));
        UIManager.put("Spinner.background", activeBackcolor);
        UIManager.put("Spinner.foreground", menuForecolor);
        UIManager.put("SpinnerUI", RenderedSpinnerUI.class.getName());
        UIManager.put("SplitPane.background", activeBackcolor);
        UIManager.put("ScrollPane.background", activeBackcolor);
        UIManager.put("SplitPane.foreground", activeBackcolor);
        UIManager.put("SplitPaneUI", RenderedSplitPaneUI.class.getName());
        UIManager.put("TabbedPane.background", uiActiveBackcolor);
        UIManager.put("TabbedPane.foreground", uiMenuForecolor);
        UIManager.put("TabbedPane.selected", uiActiveBackcolor);
        UIManager.put("TabbedPaneUI", RenderedTabbedPaneUI.class.getName());
        RenderedTabbedPaneUI.getDefaultRenderer().getColors().setColor(1, 0, activeBackcolor.brighter());
        RenderedTabbedPaneUI.getDefaultRenderer().getColors().setColor(1, 3, activeBackcolor);
        RenderedTabbedPaneUI.getDefaultRenderer().getColors().setColor(0, 0, activeBackcolor);
        RenderedTabbedPaneUI.getDefaultRenderer().getColors().setColor(0, 3, menuForecolor);
        UIManager.put("Table.background", activeBackcolor);
        UIManager.put("Table.foreground", menuForecolor);
        UIManager.put("Table.gridColor", menuForecolor);
        UIManager.put("Table.selectionBackground", menuForecolor);
        UIManager.put("Table.selectionForeground", activeBackcolor);
        UIManager.put("Table.border", new LineBorder(Color.BLACK));
        UIManager.put("TableHeader.foreground", new LineBorder(activeBackcolor));
        UIManager.put("TableHeader.background", new LineBorder(menuForecolor));
        UIManager.put("Table.dropCellForeground", new LineBorder(menuForecolor));
        UIManager.put("Table.dropCellBackground", new LineBorder(activeBackcolor));
        UIManager.put("TaskPaneContainer.backcolor", activeBackcolor);
        UIManager.put("TaskPaneContainer.forecolor", menuForecolor);
        UIManager.put("TaskPane.borderColor", menuForecolor);
        UIManager.put("TaskPane.specialTitleBackground", menuForecolor);
        UIManager.put("TaskPane.titleOver", activeBackcolor);
        UIManager.put("TaskPane.specialTitleOver", Color.black);
        UIManager.put("TaskPane.specialTitleForeground", activeBackcolor);
        UIManager.put("TextArea.background", activeBackcolor);
        UIManager.put("TextArea.foreground", menuForecolor);
        UIManager.put("TextArea.border", new LineBorder(Color.BLACK));
        UIManager.put("TextField.border", new LineBorder(Color.BLACK));
        UIManager.put("TextField.background", activeBackcolor);
        UIManager.put("TextField.foreground", menuForecolor);
        UIManager.put("TextPane.background", activeBackcolor);
        UIManager.put("TextPane.foreground", menuForecolor);
        UIManager.put("TextPane.border", new LineBorder(Color.BLACK));
        UIManager.put("TitledBorder.titleColor", menuForecolor);
        UIManager.put("TitledBorder.border", new LineBorder(menuForecolor));
        Color CLOSE_OVER_RED = new Color(232, 17, 35);
        Color CLOSE_PRESSED_RED = new Color(241, 112, 122);
        UIManager.put("RenderedUI.TitlePaneButton.close.rolloverbackground", CLOSE_OVER_RED);
        UIManager.put("RenderedUI.TitlePaneButton.close.pressedbackground", CLOSE_PRESSED_RED);
        UIManager.put("RenderedUI.TitlePaneButton.close.defaultforeground", Color.lightGray);
        UIManager.put("RenderedUI.TitlePaneButton.close.rolloverforeground", Color.white);
        UIManager.put("RenderedUI.TitlePaneButton.close.pressedforeground", Color.white);
        ControlButtonColors basicCtrlButtonColors = new ControlButtonColors();
        basicCtrlButtonColors.setColors(2, Color.lightGray, Color.white, null, null, null, Color.white, null);
        basicCtrlButtonColors.setColors(5, Color.darkGray, Color.gray, null, null, null, Color.gray, null);
        UIManager.put("RenderedUI.TitlePaneButton.min.colors", basicCtrlButtonColors);
        UIManager.put("RenderedUI.TitlePaneButton.max.colors", basicCtrlButtonColors);
        UIManager.put("RenderedUI.TitlePaneButton.dock.colors", basicCtrlButtonColors);
        UIManager.put("RenderedUI.TitlePaneButton.alwaysontop.colors", basicCtrlButtonColors);
        UIManager.put("RenderedUI.TitlePaneButton.close.inactive.rolloverbackground", CLOSE_PRESSED_RED);
        UIManager.put("RenderedUI.TitlePaneButton.close.inactive.pressedbackground", CLOSE_PRESSED_RED);
        UIManager.put("RenderedUI.TitlePaneButton.close.inactive.defaultforeground", Color.gray);
        UIManager.put("RenderedUI.TitlePaneButton.close.inactive.rolloverforeground", Color.white);
        UIManager.put("RenderedUI.TitlePaneButton.close.inactive.pressedforeground", Color.white);
        UIManager.put("RenderedUI.TitlePaneRenderer", defaultRenderer);
        UIManager.put("ToggleButton.background", activeBackcolor);
        UIManager.put("ToggleButton.foreground", menuForecolor);
        RenderedToggleButtonUI.setDefaultRenderer(buttonRenderer);
        UIManager.put("ToggleButtonUI", RenderedToggleButtonUI.class.getName());
        UIManager.put("ToolBar.background", activeBackcolor);
        UIManager.put("ToolTip.background", menuForecolor);
        UIManager.put("ToolTip.foreground", activeBackcolor);
        UIManager.put("ToolTip.border", new LineBorder(Color.BLACK));
        UIManager.put("Tree.dropLineColor", Color.black);
        TreeOpenClosedIcon closedIcon = new TreeOpenClosedIcon(true);
        TreeOpenClosedIcon openedIcon = new TreeOpenClosedIcon(false);
        closedIcon.getColors().setColor(1, 0, Color.white);
        closedIcon.getColors().setColor(0, 0, Color.black);
        closedIcon.getColors().setColor(2, 0, Color.black);
        openedIcon.setColors(closedIcon.getColors());
        UIManager.put("Tree.collapsedIcon", closedIcon);
        UIManager.put("Tree.expandedIcon", openedIcon);
        UIManager.put("RenderedUI.Slider.thumbBorderColor", menuForecolor.brighter());
        UIManager.put("RenderedUI.Slider.thumbFillcolor", activeBackcolor);
        UIManager.put("RenderedUI.Slider.forecolor", menuForecolor);
        UIManager.put("Plot.map.useoverlay", true);
        UIManager.put("Plot.link.inactive", menuForecolor);
        UIManager.put("Plot.link.active", menuForecolor.brighter());
        UIManager.put("Plot.tooltip.green", new Color(0, 204, 0));
        UIManager.put("Plot.tooltip.blue", new Color(0, 0, 204));
        UIManager.put("Plot.tooltip.yellow", new Color(204, 235, 204));
        UIManager.put("Plot.tooltip.red", new Color(204, 0, 0));
        UIManager.put("MolBioTools.ChromatWindow.background", Color.white);
        UIManager.put("MolBioTools.ChromatWindow.colorA", new Color(0, 255, 0, 30));
        UIManager.put("MolBioTools.ChromatWindow.colorT", new Color(255, 0, 0, 30));
        UIManager.put("MolBioTools.ChromatWindow.colorG", new Color(0, 0, 0, 30));
        UIManager.put("MolBioTools.ChromatWindow.colorC", new Color(0, 0, 255, 30));
        UIManager.put("MolBioTools.ChromatWindow.bordercolorA", new Color(0, 150, 0));
        UIManager.put("MolBioTools.ChromatWindow.bordercolorT", new Color(200, 0, 0));
        UIManager.put("MolBioTools.ChromatWindow.bordercolorG", Color.black);
        UIManager.put("MolBioTools.ChromatWindow.bordercolorC", new Color(0, 0, 200));
        UIManager.put("SequenceEditor.background", new Color(100, 100, 100));
        UIManager.put("SequenceEditor.foreground", Color.black);
        UIManager.put("SequenceEditor.selectioncolor", Color.cyan);
        UIManager.put("SequenceEditor.selectionbordercolor", Color.black);
        UIManager.put("StatusLabel.background", activeBackcolor);
        UIManager.put("StatusLabel.foreground", menuForecolor);
        UIManager.put("DockingFrame.activeTitleBackgroundStart", menuForecolor);
        UIManager.put("DockingFrame.activeTitleBackgroundEnd", activeBackcolor);
        UIManager.put("DockingFrame.activeTitleForeground", menuForecolor);
        UIManager.put("DockingFrame.background", menuForecolor);
        UIManager.put("DockingFrame.titlebar.showdocked", true);
        UIManager.put("DockingFrame.titlebar.showundocked", false);
        UIManager.put("wikipane.titlecolor", Color.white);
        UIManager.put("wikipane.titlebackcolor", Color.lightGray);
        UIManager.put("wikipane.forecolor", Color.black);
        UIManager.put("wikipane.backcolor", Color.white);
        UIManager.put("wikipane.visitedlinkcolor", Color.red);
        UIManager.put("wikipane.linkcolor", Color.BLUE);
        UIManager.put("wikipane.hoverlinkcolor", Color.red);
        UIManager.put("wikipane.activelinkcolor", Color.orange);
    }

    static {
        smallFontProps.setProperty("controlTextFont", "Dialog 10");
        smallFontProps.setProperty("systemTextFont", "Dialog 10");
        smallFontProps.setProperty("userTextFont", "Dialog 10");
        smallFontProps.setProperty("menuTextFont", "Dialog 10");
        smallFontProps.setProperty("windowTitleFont", "Dialog bold 10");
        smallFontProps.setProperty("subTextFont", "Dialog 8");
        largeFontProps.setProperty("controlTextFont", "Dialog 14");
        largeFontProps.setProperty("systemTextFont", "Dialog 14");
        largeFontProps.setProperty("userTextFont", "Dialog 14");
        largeFontProps.setProperty("menuTextFont", "Dialog 14");
        largeFontProps.setProperty("windowTitleFont", "Dialog bold 14");
        largeFontProps.setProperty("subTextFont", "Dialog 12");
        giantFontProps.setProperty("controlTextFont", "Dialog 18");
        giantFontProps.setProperty("systemTextFont", "Dialog 18");
        giantFontProps.setProperty("userTextFont", "Dialog 18");
        giantFontProps.setProperty("menuTextFont", "Dialog 18");
        giantFontProps.setProperty("windowTitleFont", "Dialog 18");
        giantFontProps.setProperty("subTextFont", "Dialog 16");
        themesList.add("Default");
        themesList.add("Small-Font");
        themesList.add("Large-Font");
        themesList.add("Giant-Font");
        themesMap.put("Default", defaultProps);
        themesMap.put("Small-Font", smallFontProps);
        themesMap.put("Large-Font", largeFontProps);
        themesMap.put("Giant-Font", giantFontProps);
    }
}

