/*
 * Decompiled with CFR 0.152.
 */
package plaf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.UIDefaults;
import plaf.AbstractBorderFactory;
import plaf.AbstractIconFactory;
import plaf.AbstractLookAndFeel;
import plaf.AbstractTheme;
import plaf.RenderedBorderFactory;
import plaf.RenderedDefaultTheme;
import plaf.RenderedIconFactory;

public abstract class AbstractRenderedLookAndFeel
extends AbstractLookAndFeel {
    private static RenderedDefaultTheme myTheme = null;
    private static final ArrayList themesList = new ArrayList();
    private static final HashMap themesMap = new HashMap();
    private static final Properties defaultProps = new Properties();
    private static final Properties smallFontProps = new Properties();
    private static final Properties largeFontProps = new Properties();
    private static final Properties giantFontProps = new Properties();

    public static List getThemes() {
        return themesList;
    }

    public static Properties getThemeProperties(String name) {
        return (Properties)themesMap.get(name);
    }

    public static void setTheme(String name) {
        AbstractRenderedLookAndFeel.setTheme((Properties)themesMap.get(name));
        if (myTheme != null) {
            AbstractTheme.setInternalName(name);
        }
    }

    public static void setTheme(Properties themesProps) {
        currentThemeName = "renderedThemeDark";
        if (myTheme == null) {
            myTheme = new RenderedDefaultTheme();
        }
        if (myTheme != null && themesProps != null) {
            myTheme.setUpColor();
            myTheme.setProperties(themesProps);
            myTheme.setUpColorArrs();
            AbstractLookAndFeel.setTheme(myTheme);
        }
    }

    public static void setCurrentTheme(Properties themesProps) {
        AbstractRenderedLookAndFeel.setTheme(themesProps);
    }

    @Override
    public String getName() {
        return "Rendered";
    }

    @Override
    public String getID() {
        return "Rendered";
    }

    @Override
    public String getDescription() {
        return "The Rendered Look and Feel";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public AbstractBorderFactory getBorderFactory() {
        return RenderedBorderFactory.getInstance();
    }

    @Override
    public AbstractIconFactory getIconFactory() {
        return RenderedIconFactory.getInstance();
    }

    @Override
    protected void createDefaultTheme() {
        if (myTheme == null) {
            myTheme = new RenderedDefaultTheme();
        }
        AbstractRenderedLookAndFeel.setTheme(myTheme);
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        if (!"renderedThemeDark".equals(currentThemeName)) {
            AbstractRenderedLookAndFeel.setTheme("Default");
        }
        super.initClassDefaults(table);
        this.initTheme();
    }

    public abstract void initTheme();

    static {
        smallFontProps.setProperty("controlTextFont", "Dialog 10");
        smallFontProps.setProperty("systemTextFont", "Dialog 10");
        smallFontProps.setProperty("userTextFont", "Dialog 10");
        smallFontProps.setProperty("menuTextFont", "Dialog 10");
        smallFontProps.setProperty("windowTitleFont", "Dialog bold 10");
        smallFontProps.setProperty("subTextFont", "Dialog 8");
        largeFontProps.setProperty("controlTextFont", "Dialog 14");
        largeFontProps.setProperty("systemTextFont", "Dialog 14");
        largeFontProps.setProperty("userTextFont", "Dialog 14");
        largeFontProps.setProperty("menuTextFont", "Dialog 14");
        largeFontProps.setProperty("windowTitleFont", "Dialog bold 14");
        largeFontProps.setProperty("subTextFont", "Dialog 12");
        giantFontProps.setProperty("controlTextFont", "Dialog 18");
        giantFontProps.setProperty("systemTextFont", "Dialog 18");
        giantFontProps.setProperty("userTextFont", "Dialog 18");
        giantFontProps.setProperty("menuTextFont", "Dialog 18");
        giantFontProps.setProperty("windowTitleFont", "Dialog 18");
        giantFontProps.setProperty("subTextFont", "Dialog 16");
        themesList.add("Default");
        themesList.add("Small-Font");
        themesList.add("Large-Font");
        themesList.add("Giant-Font");
        themesMap.put("Default", defaultProps);
        themesMap.put("Small-Font", smallFontProps);
        themesMap.put("Large-Font", largeFontProps);
        themesMap.put("Giant-Font", giantFontProps);
    }
}

