/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import Renderers.Renderer;
import UIRenderers.RenderedToolBarUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.Transient;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarSeparatorUI;

public class RenderedToolBarSeparatorUI
extends BasicToolBarSeparatorUI {
    public static int HORIZONTAL_ORIENTATION = 0;
    public static int VERTICAL_ORIENTATION = 1;
    public static int DEFAULT_ORIENTATION = -2;
    public static int STATIC_DEFAULT_ORIENTATION = -1;
    private static int defaultSize = 4;
    private int size = 0;
    private static Renderer defaultRenderer;
    private Renderer renderer;
    private static int defaultForceOrientation;
    private int forceOrientation = -1;

    public static void setDefaultSize(int size) {
        if (size > 0) {
            defaultSize = size;
        }
    }

    public static int getDefaultSize() {
        return defaultSize;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public static void setDefaultRenderer(Renderer renderer) {
        defaultRenderer = renderer;
    }

    public static Renderer getDefaultRenderer() {
        return defaultRenderer != null ? defaultRenderer : RenderedToolBarUI.getDefaultRenderer();
    }

    public static ComponentUI createUI(JComponent c) {
        return new RenderedToolBarSeparatorUI();
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private Renderer getActiveRenderer() {
        return this.renderer == null ? RenderedToolBarSeparatorUI.getDefaultRenderer() : this.renderer;
    }

    public static void setDefaultForcedOrientation(int orientation) {
        if (orientation >= DEFAULT_ORIENTATION && orientation <= VERTICAL_ORIENTATION) {
            defaultForceOrientation = orientation;
        }
    }

    public static int getDefaultForcedOrientation() {
        return defaultForceOrientation;
    }

    public void setForcedOrientation(int orientation) {
        if (orientation >= STATIC_DEFAULT_ORIENTATION && orientation <= VERTICAL_ORIENTATION) {
            this.forceOrientation = orientation;
        }
    }

    public int getForcedOrientation() {
        return this.forceOrientation;
    }

    protected int getRenderedOrientation(JSeparator c) {
        int orient = this.forceOrientation != STATIC_DEFAULT_ORIENTATION ? this.forceOrientation : RenderedToolBarSeparatorUI.getDefaultForcedOrientation();
        return orient == DEFAULT_ORIENTATION ? c.getOrientation() : orient;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Dimension s = c.getSize();
        Renderer renderer = this.getActiveRenderer();
        renderer.setOrientation(this.getRenderedOrientation((JSeparator)c));
        renderer.paintBackground(g, c, new Rectangle(0, 0, s.width, s.height), 0);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int size;
        Container cParent = c.getParent();
        int ht = 1;
        int wd = 1;
        if (c instanceof JToolBar) {
            ht = cParent.getHeight();
            wd = cParent.getWidth();
        }
        int n = size = this.size > 0 ? this.size : defaultSize;
        if (((JSeparator)c).getOrientation() == 1) {
            return new Dimension(size, ht);
        }
        return new Dimension(wd, size);
    }

    @Override
    protected void installDefaults(JSeparator s) {
        Dimension size = ((JToolBar.Separator)s).getSeparatorSize();
        if (size == null || size instanceof UIResource) {
            JToolBar.Separator sep = (JToolBar.Separator)s;
            size = (Dimension)UIManager.get("ToolBar.separatorSize");
            if (size != null) {
                size = sep.getOrientation() == 0 ? new DynamicHeightDimension(size.height, size.width, sep) : new DynamicWidthDimension(size.height, size.width, sep);
                sep.setSeparatorSize(size);
            }
        }
    }

    static {
        defaultForceOrientation = -1;
    }

    class DynamicHeightDimension
    extends Dimension {
        Component c;

        public DynamicHeightDimension(Component c) {
            this.c = c;
        }

        public DynamicHeightDimension(int width, int height, Component c) {
            this.c = c;
            this.height = height;
            this.width = width;
        }

        @Override
        @Transient
        public Dimension getSize() {
            Container cParent;
            int ht = this.height;
            if (this.c != null && (cParent = this.c.getParent()) != null) {
                ht = cParent.getHeight();
            }
            return new Dimension(this.width, ht);
        }
    }

    class DynamicWidthDimension
    extends Dimension {
        Component c;

        public DynamicWidthDimension(Component c) {
            this.c = c;
        }

        public DynamicWidthDimension(int width, int height, Component c) {
            this.c = c;
            this.height = height;
            this.width = width;
        }

        @Override
        @Transient
        public Dimension getSize() {
            Container cParent;
            int wd = this.width;
            if (this.c != null && (cParent = this.c.getParent()) != null) {
                wd = cParent.getWidth();
            }
            return new Dimension(wd, this.height);
        }
    }
}

