/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import Renderers.Renderer;
import UIRenderers.RenderedButtonUI;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class RenderedToggleButtonUI
extends BasicToggleButtonUI {
    private static Renderer defaultRenderer = null;
    private Renderer renderer;
    JToggleButton component;
    protected boolean foundOpaque = false;
    protected boolean opaque = false;
    protected boolean useDefault = false;

    public static void setDefaultRenderer(Renderer renderer) {
        defaultRenderer = renderer;
    }

    public static Renderer getDefaultRenderer() {
        return defaultRenderer != null ? defaultRenderer : RenderedButtonUI.getDefaultRenderer();
    }

    public static ComponentUI createUI(JComponent c) {
        return new RenderedToggleButtonUI();
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private Renderer getActiveRenderer() {
        return this.renderer == null ? RenderedToggleButtonUI.getDefaultRenderer() : this.renderer;
    }

    public void setDefaultIconTextPaint(boolean useDefault) {
        this.useDefault = useDefault;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.component = (JToggleButton)c;
        Object opaque = UIManager.get(this.getPropertyPrefix() + "opaque");
        if (opaque instanceof Boolean) {
            this.foundOpaque = true;
            this.opaque = (Boolean)opaque;
            this.component.setOpaque(this.opaque);
        }
        this.component.setRolloverEnabled(true);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.component == c && this.foundOpaque && this.component.isOpaque() != this.opaque) {
            this.component.setOpaque(this.opaque);
        }
        Renderer renderer = this.getActiveRenderer();
        if (this.useDefault) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            if (!(model.isArmed() && model.isPressed() || model.isSelected())) {
                renderer.setOrientation(0);
                renderer.paintBackground(g, b);
                renderer.paintBorder(g, b);
            }
            super.paint(g, c);
        } else {
            renderer.setOrientation(0);
            renderer.paint(g, c);
            renderer.paintBorder(g, c);
        }
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        Renderer renderer = this.getActiveRenderer();
        renderer.setOrientation(0);
        renderer.paintBackground(g, b);
    }
}

