/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import JMConstants.Constants;
import Renderers.BasicRenderer;
import Renderers.Renderer;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class RenderedTabbedPaneUI
extends BasicTabbedPaneUI
implements Constants {
    static Renderer defaultRenderer = new BasicRenderer();
    private Renderer renderer;

    public static void setDefaultRenderer(Renderer renderer) {
        if (renderer != null) {
            defaultRenderer = renderer;
        }
    }

    public static Renderer getDefaultRenderer() {
        return defaultRenderer;
    }

    public static ComponentUI createUI(JComponent c) {
        return new RenderedTabbedPaneUI();
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private Renderer getActiveRenderer() {
        return this.renderer == null ? defaultRenderer : this.renderer;
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Rectangle tabRect;
        switch (tabPlacement) {
            case 2: {
                tabRect = new Rectangle(x + 1, y + 1, w - 1, h - 3);
                break;
            }
            case 4: {
                tabRect = new Rectangle(x, y + 1, w - 2, h - 3);
                break;
            }
            case 3: {
                tabRect = new Rectangle(x + 1, y, w - 3, h - 1);
                break;
            }
            default: {
                tabRect = new Rectangle(x + 1, y + 1, w - 3, h - 1);
            }
        }
        this.getActiveRenderer().setOrientation(0);
        this.getActiveRenderer().paintBackground(g, this.tabPane, tabRect, isSelected ? 3 : 0);
    }
}

