/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import Renderers.JavTRenderer;
import Renderers.Renderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import plaf.UIUtilities;

public class RenderedPopupMenuBorderUI
extends AbstractBorder
implements UIResource {
    private static Renderer defaultRenderer = new JavTRenderer();
    private Renderer renderer = null;
    private String genericLogo = null;
    private final HashMap<Integer, StoredComponent> registeredComponents = new HashMap();
    protected static Font logoFont;
    protected static Insets topLogoInsets;
    protected static Insets leftLogoInsets;
    protected static Insets rightLogoInsets;
    protected static Insets bottomLogoInsets;
    protected static Insets insets;
    private static final int pad = 4;
    private static final int pad2 = 8;

    public void setGenericLogo(String text) {
        this.genericLogo = text;
    }

    public String getGenericLogo() {
        return this.genericLogo;
    }

    public static void setDefaultRenderer(Renderer renderer) {
        if (renderer != null) {
            defaultRenderer = renderer;
        }
    }

    public static Renderer getDefaultRenderer() {
        Object renderer = UIManager.get("RenderedUI.PopupMenu.BorderRenderer");
        if (renderer != null && renderer instanceof Renderer) {
            return (Renderer)renderer;
        }
        return defaultRenderer;
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private Renderer getActiveRenderer() {
        return this.renderer != null ? this.renderer : RenderedPopupMenuBorderUI.getDefaultRenderer();
    }

    public RenderedPopupMenuBorderUI() {
        logoFont = new Font("Dialog", 1, 12);
        topLogoInsets = new Insets(18, 2, 1, 1);
        leftLogoInsets = new Insets(2, 18, 1, 1);
        rightLogoInsets = new Insets(2, 2, 1, 18);
        bottomLogoInsets = new Insets(2, 2, 18, 2);
        insets = new Insets(2, 1, 1, 1);
    }

    public void setFont(Font font) {
        if (font != null) {
            logoFont = font;
        }
    }

    public Font getFont() {
        return logoFont;
    }

    public boolean isMenuBarPopup(Component c) {
        JPopupMenu pm;
        boolean menuBarPopup = false;
        if (c instanceof JPopupMenu && (pm = (JPopupMenu)c).getInvoker() != null) {
            menuBarPopup = pm.getInvoker().getParent() instanceof JMenuBar;
        }
        return menuBarPopup;
    }

    public void registerMenu(Component c, String logoString) {
        this.registeredComponents.put(c.hashCode(), new StoredComponent(c, logoString));
    }

    private StoredComponent getStoredComponent(Component c) {
        if (c instanceof JPopupMenu) {
            int pKey;
            int cKey = c.hashCode();
            if (this.registeredComponents.containsKey(cKey)) {
                return this.registeredComponents.get(cKey);
            }
            Component parent = ((JPopupMenu)c).getInvoker();
            if (parent != null && this.registeredComponents.containsKey(pKey = parent.hashCode())) {
                return this.registeredComponents.get(pKey);
            }
        }
        return null;
    }

    public void unregisterMenu(Component c) {
        this.registeredComponents.remove(c.hashCode());
    }

    public void paintLogo(Component c, String logoText, Graphics g, int x, int y, int w, int h) {
        Graphics2D g2D = (Graphics2D)g;
        Font savedFont = g2D.getFont();
        g.setFont(logoFont);
        FontMetrics fm = UIUtilities.getFontMetrics((JComponent)c, g, c.getFont());
        String logo = UIUtilities.getClippedText(logoText, fm, h - 16);
        AffineTransform savedTransform = g2D.getTransform();
        Color fc = this.getActiveRenderer().getNormalTextColor(c);
        Color bc = this.getActiveRenderer().getOverTextColor(c);
        if (UIUtilities.isLeftToRight(c)) {
            g2D.translate(fm.getAscent() + 1, h - 4);
            g2D.rotate(Math.toRadians(-90.0));
            g2D.setColor(fc);
            UIUtilities.drawString((JComponent)c, g, logo, 1, 0);
        } else {
            g2D.translate(w - 4, h - 4);
            g2D.rotate(Math.toRadians(-90.0));
            g2D.setColor(fc);
            UIUtilities.drawString((JComponent)c, g, logo, 1, 0);
        }
        g2D.setTransform(savedTransform);
        g2D.setFont(savedFont);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        Renderer logoRenderer = this.getActiveRenderer();
        Color logoColor = this.getActiveRenderer().getOverColor(c);
        Color borderColorLo = UIManager.getColor("RenderedPopupMenuBorder.bordercolor");
        if (borderColorLo == null) {
            borderColorLo = Color.black;
        }
        Color borderColorHi = borderColorLo;
        g.setColor(logoColor);
        logoRenderer.setOrientation(1);
        StoredComponent sc = this.getStoredComponent(c);
        boolean hasLogo = sc != null && sc.hasLogo();
        boolean leftToRight = UIUtilities.isLeftToRight(c);
        Insets borderInsets = this.getBorderInsets(c);
        Renderer renderer = this.getActiveRenderer();
        if (leftToRight) {
            int dx = borderInsets.left;
            renderer.paintBackground(g, c, new Rectangle(x, y, dx - 1, h - 1));
            if (hasLogo) {
                this.paintLogo(c, sc.logoString, g, x, y, w, h);
            }
            g.setColor(borderColorHi);
            g.drawLine(x + 1, y, x + 1, y + h - 2);
            g.setColor(borderColorLo);
            if (this.isMenuBarPopup(c)) {
                g.drawLine(x + dx - 1, y, x + w, y);
                g.drawLine(x, y, x, y + h - 1);
                g.drawLine(x, y + h - 1, x + w, y + h - 1);
                g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
            } else {
                g.drawRect(x, y, w - 1, h - 1);
            }
            if (hasLogo) {
                g.drawLine(x + dx - 1, y + 1, x + dx - 1, y + h - 1);
            }
        } else {
            int dx = borderInsets.right;
            Rectangle clip = new Rectangle(x + w - dx, y, dx, h - 1);
            renderer.paintBackground(g, c, clip);
            if (hasLogo) {
                this.paintLogo(c, sc.logoString, g, x, y, w, h);
            }
            g.setColor(borderColorLo);
            if (this.isMenuBarPopup(c)) {
                g.drawLine(x, y, x + w - dx, y);
                g.drawLine(x, y, x, y + h - 1);
                g.drawLine(x, y + h - 1, x + w, y + h - 1);
                g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            } else {
                g.drawRect(x, y, w - 1, h - 1);
            }
            if (hasLogo) {
                g.drawLine(x + w - dx, y + 1, x + w - dx, y + h - 1);
            }
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        StoredComponent sc = this.getStoredComponent(c);
        if (sc == null) {
            return new Insets(RenderedPopupMenuBorderUI.insets.top, RenderedPopupMenuBorderUI.insets.left, RenderedPopupMenuBorderUI.insets.bottom, RenderedPopupMenuBorderUI.insets.right);
        }
        boolean ltr = UIUtilities.isLeftToRight(c);
        int left = RenderedPopupMenuBorderUI.insets.left;
        int right = RenderedPopupMenuBorderUI.insets.right;
        int top = RenderedPopupMenuBorderUI.insets.top;
        int bot = RenderedPopupMenuBorderUI.insets.bottom;
        if (sc.hasLogo()) {
            if (ltr) {
                left = RenderedPopupMenuBorderUI.leftLogoInsets.left;
            } else {
                right = RenderedPopupMenuBorderUI.rightLogoInsets.right;
            }
        }
        return new Insets(top, left, bot, right);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets borderInsets) {
        Insets ins = this.getBorderInsets(c);
        borderInsets.left = ins.left;
        borderInsets.top = ins.top;
        borderInsets.right = ins.right;
        borderInsets.bottom = ins.bottom;
        return borderInsets;
    }

    private static class StoredComponent {
        public Component c;
        public String logoString;

        public boolean hasLogo() {
            return this.logoString != null && this.logoString.length() > 0;
        }

        public StoredComponent(Component c, String logoString) {
            this.c = c;
            this.logoString = logoString;
        }
    }
}

