/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import Renderers.GlossyRenderer;
import Renderers.Renderer;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class RenderedPanelUI
extends BasicPanelUI {
    private static RenderedPanelUI panelUI;
    static Renderer defaultRenderer;
    private Renderer renderer;

    public static ComponentUI createUI(JComponent c) {
        if (panelUI == null) {
            panelUI = new RenderedPanelUI();
        }
        return panelUI;
    }

    public static void setDefaultRenderer(Renderer renderer) {
        if (renderer != null) {
            defaultRenderer = renderer;
        }
    }

    public static Renderer getDefaultRenderer() {
        return defaultRenderer;
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private Renderer getActiveRenderer() {
        return this.renderer == null ? defaultRenderer : this.renderer;
    }

    @Override
    public synchronized void paint(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            this.getActiveRenderer().paintBackground(g, c);
        }
    }

    static {
        defaultRenderer = new GlossyRenderer();
    }
}

