/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import BaseClasses.RendererColors;
import Tools.UITools;
import UIRenderers.RenderedMenuSeparatorUI;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class RenderedMenuItemScrollUI
extends BasicMenuItemUI {
    public static final int TYPE_FILLCOLOR = 3;
    private static int typesCount = 4;
    private static int statesCount = 7;
    protected RendererColors colors = new RendererColors(typesCount, statesCount);
    private static RendererColors defaultColors = new RendererColors(typesCount, statesCount);
    private int direction = 1;
    protected final int pad = 4;
    protected final int smallBarHt = 2;
    protected boolean showText = true;

    public static RendererColors getDefaultColor() {
        return defaultColors;
    }

    public static void setDefaultColor(RendererColors colors) {
        defaultColors = colors;
    }

    public static void setDefaultColor(int type, int state, Color color) {
        defaultColors.setColor(type, state, color);
    }

    public static void setDefaultColors(int type, Color color) {
        defaultColors.setColors(type, color);
    }

    public RendererColors getColor() {
        return this.colors;
    }

    public void setColor(RendererColors colors) {
        this.colors = colors;
    }

    public void setColor(int type, int state, Color color) {
        this.colors.setColor(type, state, color);
    }

    public void setColors(int type, Color color) {
        this.colors.setColors(type, color);
    }

    public static void setDefaultTextColor(Color color) {
        defaultColors.setColors(0, color);
    }

    public static void setDefaultBackColor(Color color) {
        defaultColors.setColors(1, color);
    }

    public static void setDefaultFillColor(Color color) {
        defaultColors.setColors(3, color);
    }

    public static void setDefaultBorderColor(Color color) {
        defaultColors.setColors(2, color);
    }

    public static ComponentUI createUI(JComponent c) {
        return new RenderedMenuItemScrollUI();
    }

    private static boolean getBoolean(String key, boolean defValue) {
        if (!defValue) {
            return UIManager.getBoolean(key);
        }
        Object obj = UIManager.get(key);
        return obj instanceof Boolean ? (Boolean)obj : defValue;
    }

    public void setShowText(boolean show) {
        this.showText = show;
    }

    public boolean isShowText() {
        return this.showText;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setBorder(null);
    }

    public RenderedMenuItemScrollUI() {
        this(1);
    }

    public RenderedMenuItemScrollUI(int direction) {
        this(direction, true);
    }

    public RenderedMenuItemScrollUI(int direction, boolean showText) {
        switch (direction) {
            case 0: 
            case 1: 
            case 3: {
                this.direction = direction;
            }
        }
        Color color = UIManager.getColor("RenderedUI.MenuScroller.background");
        if (color != null) {
            this.colors.setColors(1, color);
        }
        if ((color = UIManager.getColor("RenderedUI.MenuScroller.bordercolor")) != null) {
            this.colors.setColors(2, color);
        }
        if ((color = UIManager.getColor("RenderedUI.MenuScroller.fillcolor")) != null) {
            this.colors.setColors(3, color);
        }
        if ((color = UIManager.getColor("RenderedUI.MenuScroller.foreground")) != null) {
            this.colors.setColors(0, color);
        }
        this.setShowText(RenderedMenuItemScrollUI.getBoolean("RenderedUI.MenuScroller.showtext", showText));
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        Color textColor;
        Color backColor;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int cWd = menuItem.getWidth();
        int cHt = menuItem.getHeight();
        String caption = menuItem.getText();
        boolean haveCaption = caption != null && caption.length() > 0;
        int state = UITools.getState(menuItem);
        Color color = backColor = this.colors.getColor(1, state) != null ? this.colors.getColor(1, state) : defaultColors.getColor(1, state);
        if (backColor == null && menuItem.isOpaque()) {
            backColor = menuItem.getBackground();
        }
        Color fillColor = this.colors.getColor(3, state) != null ? this.colors.getColor(3, state) : defaultColors.getColor(3, state);
        Color borderColor = this.colors.getColor(2, state) != null ? this.colors.getColor(2, state) : defaultColors.getColor(2, state);
        Color color2 = textColor = this.colors.getColor(0, state) != null ? this.colors.getColor(0, state) : defaultColors.getColor(0, state);
        if (haveCaption) {
            Shape backgroundShape;
            g2d.setFont(menuItem.getFont());
            FontMetrics fm = g2d.getFontMetrics();
            int wd = fm.stringWidth(caption);
            int ht = fm.getMaxAscent() - fm.getMaxDescent();
            int captionX = (menuItem.getWidth() - wd) / 2;
            int captionY = (menuItem.getHeight() + ht) / 2;
            switch (this.direction) {
                case 3: {
                    backgroundShape = RenderedMenuSeparatorUI.getShapeBottom(g2d, menuItem, caption);
                    break;
                }
                case 1: {
                    backgroundShape = RenderedMenuSeparatorUI.getShapeTop(g2d, menuItem, caption);
                    break;
                }
                default: {
                    backgroundShape = RenderedMenuSeparatorUI.getShapeCenter(g2d, menuItem, caption);
                }
            }
            if (backColor != null) {
                g2d.setColor(backColor);
                g2d.fillRect(0, 0, cWd, cHt);
            }
            if (fillColor != null) {
                g2d.setColor(fillColor);
                g2d.fill(backgroundShape);
            }
            if (borderColor != null) {
                g2d.setColor(borderColor);
                g2d.draw(backgroundShape);
            }
            if (this.showText && textColor != null) {
                g2d.setColor(textColor);
                g2d.drawString(caption, captionX, captionY);
            }
            g2d.setClip(null);
        } else {
            if (backColor != null) {
                g2d.setColor(backColor);
                g2d.fillRect(0, 0, cWd, cHt);
            }
            if (borderColor != null) {
                g2d.setColor(borderColor);
                g2d.drawRect(-1, 0, cWd + 1, cHt - 1);
            }
        }
    }

    @Override
    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
    }

    @Override
    protected void doClick(MenuSelectionManager msm) {
        this.menuItem.doClick(0);
    }
}

