/*
 * Decompiled with CFR 0.152.
 */
package UIRenderers;

import Renderers.GlossyRenderer;
import Renderers.Renderer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class RenderedButtonUI
extends BasicButtonUI {
    static Renderer defaultRenderer = new GlossyRenderer();
    private Renderer renderer;
    MouseListener mouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            RenderedButtonUI.this.component.getModel().setRollover(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            RenderedButtonUI.this.component.getModel().setRollover(false);
        }
    };
    JButton component;
    private boolean foundOpaque = false;
    private boolean opaque = false;
    protected boolean useDefault = false;

    public static void setDefaultRenderer(Renderer renderer) {
        if (renderer != null) {
            defaultRenderer = renderer;
        }
    }

    public static Renderer getDefaultRenderer() {
        return defaultRenderer;
    }

    public static ComponentUI createUI(JComponent c) {
        return new RenderedButtonUI();
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private Renderer getActiveRenderer() {
        return this.renderer != null ? this.renderer : defaultRenderer;
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removeMouseListener(this.mouseListener);
        super.uninstallUI(c);
        if (c == this.component) {
            this.component = null;
        }
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.component = (JButton)c;
        this.component.addMouseListener(this.mouseListener);
        Object opaque = UIManager.get(this.getPropertyPrefix() + "opaque");
        if (opaque instanceof Boolean) {
            this.foundOpaque = true;
            this.opaque = (Boolean)opaque;
            this.component.setOpaque(this.opaque);
        }
        this.component.setRolloverEnabled(true);
    }

    private boolean isTlbrButton(Component c) {
        return c.getParent() != null && c.getParent() instanceof JToolBar;
    }

    public void setDefaultIconTextPaint(boolean useDefault) {
        this.useDefault = useDefault;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.component == c && this.foundOpaque && this.component.isOpaque() != this.opaque) {
            this.component.setOpaque(this.opaque);
        }
        if (this.useDefault) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            if (!(model.isArmed() && model.isPressed() || model.isSelected())) {
                this.getActiveRenderer().setOrientation(0);
                this.getActiveRenderer().paintBackground(g, b);
            }
            super.paint(g, c);
        } else {
            this.getActiveRenderer().setOrientation(0);
            this.getActiveRenderer().paint(g, c);
        }
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        this.getActiveRenderer().setOrientation(0);
        this.getActiveRenderer().paintBackground(g, b);
    }
}

