/*
 * Decompiled with CFR 0.152.
 */
package Tools;

import java.awt.Component;
import java.awt.Font;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;

public class UITools {
    public static String osname;
    public static String osarch;
    static boolean isMac;
    static boolean isWin;
    static boolean isLinux;
    static boolean is64Bit;
    static int javaVersion;

    public static boolean isMacintosh() {
        return isMac;
    }

    public static boolean isMacOSX() {
        return UITools.isMacintosh();
    }

    public static boolean isWindows() {
        return isWin;
    }

    public static int javaVersion() {
        return javaVersion;
    }

    public static boolean isJava2() {
        return true;
    }

    public static boolean isJava14() {
        return true;
    }

    public static boolean isJava15() {
        return true;
    }

    public static boolean isJava16() {
        return javaVersion >= 6;
    }

    public static boolean isJava17() {
        return javaVersion >= 7;
    }

    public static boolean isJava18() {
        return javaVersion >= 8;
    }

    public static boolean isJava19() {
        return javaVersion >= 9;
    }

    public static int getState(Component c) {
        if (c instanceof JMenuItem) {
            return UITools.getMenuState((JMenuItem)c);
        }
        if (c instanceof AbstractButton) {
            return UITools.getButtonState((AbstractButton)c);
        }
        return c != null && c.isEnabled() ? 0 : 2;
    }

    public static int getMenuState(JMenuItem item) {
        if (!item.isEnabled()) {
            return 2;
        }
        ButtonModel model = item.getModel();
        if (item instanceof JCheckBoxMenuItem || item instanceof JRadioButtonMenuItem) {
            if (model.isSelected()) {
                if (model.isArmed()) {
                    return 6;
                }
                return 3;
            }
            if (model.isArmed()) {
                return 5;
            }
        } else if (model.isArmed() || item instanceof JMenu && model.isSelected()) {
            return 3;
        }
        return 0;
    }

    public static int getButtonState(AbstractButton button) {
        ButtonModel model = button.getModel();
        if (!model.isEnabled()) {
            if (model.isSelected()) {
                return 4;
            }
            return 2;
        }
        if (model.isPressed() && model.isArmed()) {
            return 1;
        }
        if (model.isSelected()) {
            if (button.isRolloverEnabled() && model.isRollover()) {
                return 6;
            }
            return 3;
        }
        if (model.isRollover()) {
            return 5;
        }
        return 0;
    }

    public static Icon getIcon(String key) {
        return UITools.getIcon(key, null);
    }

    public static Icon getIcon(String key, Icon defObject) {
        Object obj = UIManager.get(key);
        return obj != null && obj instanceof Icon ? (Icon)obj : defObject;
    }

    public static Font getFont(String key) {
        Object obj = UIManager.get(key);
        return obj != null && obj instanceof Font ? (Font)obj : null;
    }

    public static boolean getBoolean(String key, boolean defValue) {
        if (!defValue) {
            return UIManager.getBoolean(key);
        }
        Object obj = UIManager.get(key);
        return obj instanceof Boolean ? (Boolean)obj : defValue;
    }

    public static int getInt(String key, int defValue) {
        Object obj = UIManager.get(key);
        return obj instanceof Integer ? (Integer)obj : defValue;
    }

    static {
        String osName = System.getProperty("os.name");
        boolean iswin = osName.startsWith("Windows");
        isMac = !iswin && osName.startsWith("Mac");
        isLinux = osName.startsWith("Linux");
        osname = osName;
        isWin = iswin;
        String version = System.getProperty("java.version");
        if (version == null || version.length() < 2) {
            version = "1.8";
        }
        javaVersion = version.startsWith("1.8") ? 8 : (version.charAt(0) == '1' && Character.isDigit(version.charAt(1)) ? 10 + (version.charAt(1) - 48) : (version.charAt(0) == '2' && Character.isDigit(version.charAt(1)) ? 20 + (version.charAt(1) - 48) : (version.startsWith("1.6") ? 6 : (version.startsWith("1.9") || version.startsWith("9") ? 9 : (version.startsWith("1.7") ? 7 : 8)))));
    }
}

