/*
 * Decompiled with CFR 0.152.
 */
package ToolTip;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JWindow;
import javax.swing.Timer;

public abstract class AbstractToolTip
implements MouseListener,
MouseMotionListener,
FocusListener,
WindowFocusListener,
WindowListener {
    public static final Color TOOLTIP_YELLOW = new Color(255, 255, 204);
    public static final Color TOOLTIP_BLUE = new Color(153, 255, 255);
    public static final Color TOOLTIP_GREEN = new Color(204, 255, 204);
    public static final int POSITION_CALCULATED = 0;
    public static final int POSITION_ABOVE_LEFT = 1;
    public static final int POSITION_ABOVE_RIGHT = 2;
    public static final int POSITION_BELOW_LEFT = 3;
    public static final int POSITION_BELOW_RIGHT = 4;
    public static final int POSITION_MANUAL = 5;
    public static final int POSITION_CALCULATED_INVERTED_X = 6;
    public static final int POSITION_CALCULATED_INVERTED_Y = 7;
    public static final int POSITION_CALCULATED_INVERTED = 8;
    private static final int BELOW = 10;
    private static final int RIGHT = 10;
    AlphaTimer fadeTimer;
    ToolTipWindow w;
    Component owner;
    float step = 0.01f;
    float opacity = 0.0f;
    boolean fadeIn = false;
    int x = 0;
    int y = 0;
    int pad = 5;
    boolean visible = false;
    float alpha = 0.8f;
    private Color backColor;
    private Color borderColor = Color.black;
    private Color foreColor = Color.black;
    private int offsetting = 0;
    private int rounding = 10;
    boolean rounded = true;
    BufferedImage bufferImage;
    Graphics2D bufferGraphics;
    int tipWidth = 0;
    int tipHeight = 0;
    protected boolean haveText = false;
    final FadeActionListener fadeAction = new FadeActionListener();

    public void setRounded(boolean rounded) {
        this.rounded = rounded;
    }

    public boolean isRounded() {
        return this.rounded;
    }

    public void setFadeIn(boolean fade) {
        this.fadeIn = fade;
    }

    public boolean isFadeIn() {
        return this.fadeIn;
    }

    public void setBackground(Color color) {
        if (color == null) {
            return;
        }
        this.backColor = color;
        if (this.w != null) {
            this.w.backColor = this.backColor;
            if (this.w.isVisible()) {
                this.w.repaint();
            }
        }
    }

    public Color getBackground() {
        return this.backColor;
    }

    public void setForeground(Color color) {
        if (color == null) {
            return;
        }
        this.foreColor = color;
        if (this.w != null && this.w.isVisible()) {
            this.w.repaint();
        }
    }

    public Color getForeground() {
        return this.foreColor;
    }

    public void setBordercolor(Color color) {
        this.borderColor = color;
        if (this.w != null) {
            this.w.borderColor = this.borderColor;
            if (this.w.isVisible()) {
                this.w.repaint();
            }
        }
    }

    public Color getBordercolor() {
        return this.borderColor;
    }

    public void setOpacity(float value) {
        float val;
        this.alpha = val = Math.max(Math.min(value, 1.0f), 0.0f);
        if (this.w != null) {
            this.w.setOpacity(this.alpha);
        }
    }

    public float getFadeStep() {
        return this.step;
    }

    public void setFadeStep(float step) {
        this.step = Math.max(Math.min(step, 1.0f), 0.0f);
    }

    public AbstractToolTip(Component owner) {
        this.fadeTimer = new AlphaTimer(10, this.fadeAction);
        this.createToolTip(owner, 0, 0);
    }

    public AbstractToolTip(Component owner, Component displayComponent) {
        this.fadeTimer = new AlphaTimer(10, this.fadeAction);
        this.createToolTip(owner, 0, 0);
        this.w.setComponent(displayComponent);
    }

    public AbstractToolTip(Component owner, Component displayComponent, int x, int y) {
        this.fadeTimer = new AlphaTimer(10, this.fadeAction);
        this.createToolTip(owner, x, y);
        this.w.setComponent(displayComponent);
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.hide();
    }

    public void show() {
        if (this.w != null && !this.visible) {
            this.owner.addFocusListener(this);
            if (!this.fadeIn) {
                this.w.setVisible(true);
            } else {
                this.fadeTimer.start();
            }
            this.setLocation();
        }
    }

    public void show(int x, int y) {
        this.setLocation(x, y);
        this.show();
    }

    public void hide() {
        this.owner.removeFocusListener(this);
        if (this.fadeIn) {
            this.fadeTimer.stop();
        }
        if (this.visible) {
            this.w.setVisible(false);
        }
    }

    public void dispose() {
        this.hide();
        if (this.w != null) {
            this.w.getContentPane().removeAll();
        }
        this.owner.removeMouseListener(this);
        this.owner.removeMouseMotionListener(this);
        this.owner = null;
        this.w.dispose();
        this.w = null;
    }

    @Override
    public void windowGainedFocus(WindowEvent arg0) {
    }

    @Override
    public void windowLostFocus(WindowEvent arg0) {
        this.hide();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        this.hide();
    }

    void createToolTip(Component owner, int x, int y) {
        this.x = x;
        this.y = y;
        this.owner = owner;
        Frame parentWindow = this.getParentWindow(owner);
        if (parentWindow != null) {
            parentWindow.addWindowFocusListener(this);
            parentWindow.addWindowListener(this);
        }
        this.w = new ToolTipWindow();
        this.w.borderColor = this.borderColor;
        this.w.backColor = this.backColor;
        this.w.setOpacity(this.alpha);
        this.w.setAlwaysOnTop(true);
        if (this.w.isVisible()) {
            this.w.pack();
        }
        this.w.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent arg0) {
                if (AbstractToolTip.this.rounded) {
                    AbstractToolTip.this.w.setShape(new RoundRectangle2D.Double(0.0, 0.0, AbstractToolTip.this.w.getWidth(), AbstractToolTip.this.w.getHeight(), AbstractToolTip.this.rounding, AbstractToolTip.this.rounding));
                }
                if (AbstractToolTip.this.visible) {
                    AbstractToolTip.this.setLocation();
                }
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentShown(ComponentEvent arg0) {
                AbstractToolTip.this.visible = true;
            }

            @Override
            public void componentHidden(ComponentEvent arg0) {
                AbstractToolTip.this.visible = false;
            }
        });
        this.w.setLocation(x, y);
    }

    public void setOffseting(int offsetting) {
        this.offsetting = offsetting;
    }

    public int getOffsetting() {
        return this.offsetting;
    }

    void setLocation() {
        this.setLocation(this.x, this.y);
    }

    public void setLocation(int x, int y) {
        int offsetX = 0;
        int offsetY = 0;
        Rectangle r = this.owner.getGraphicsConfiguration().getDevice().getDefaultConfiguration().getBounds();
        this.x = x;
        this.y = y;
        if (this.w != null && this.owner != null) {
            int midX = r.x + r.width / 2;
            int midY = r.y + r.height / 2;
            int wd = this.w.getWidth();
            int ht = this.w.getHeight();
            switch (this.offsetting) {
                case 4: {
                    offsetX = 10;
                    offsetY = 10;
                    break;
                }
                case 3: {
                    offsetY = 10;
                    offsetX = -wd - 10;
                    break;
                }
                case 1: {
                    offsetY = -ht - 10;
                    offsetX = -wd - 10;
                    break;
                }
                case 2: {
                    offsetY = -ht - 10;
                    offsetX = 10;
                    break;
                }
                case 6: {
                    offsetX = x < midX ? -wd - 10 : 10;
                    offsetY = y > midY ? -ht - 10 : 10;
                    break;
                }
                case 7: {
                    offsetX = x > midX ? -wd - 10 : 10;
                    offsetY = y < midY ? -ht - 10 : 10;
                    break;
                }
                case 8: {
                    offsetX = x < midX ? -wd - 10 : 10;
                    offsetY = y < midY ? -ht - 10 : 10;
                    break;
                }
                case 5: {
                    Point op = this.owner.getLocationOnScreen();
                    this.w.setLocation(op.x + x + offsetX, op.y + y + offsetY);
                    return;
                }
                default: {
                    offsetX = x < midX ? -wd - 10 : 10;
                    offsetY = y > midY ? -ht - 10 : 10;
                }
            }
            Point op = this.owner.getLocationOnScreen();
            this.w.setLocation(Math.min(Math.max(0, op.x + x + offsetX), r.x + r.width - wd), Math.min(Math.max(op.y + y + offsetY, 0), r.y + r.height - ht));
        }
    }

    protected void tick() {
        if (!this.haveText) {
            this.fadeTimer.stop();
            this.hide();
        }
        float oldOpacity = this.opacity;
        this.opacity = Math.min(this.opacity + this.step, this.alpha);
        if (oldOpacity != this.opacity) {
            this.w.setOpacity(this.opacity);
            this.w.setBackground(this.backColor);
            if (this.opacity >= this.alpha) {
                this.fadeTimer.stop();
            }
        }
    }

    Frame getParentWindow(Component c) {
        if (c.getParent() == null) {
            return null;
        }
        if (c.getParent() instanceof Frame) {
            return (Frame)c.getParent();
        }
        return this.getParentWindow(c.getParent());
    }

    class ToolTipWindow
    extends JWindow {
        public Color borderColor = null;
        public Color backColor = null;
        private Component comp;

        ToolTipWindow() {
            this.setFocusableWindowState(false);
            this.setType(Window.Type.POPUP);
            try {
                this.setAlwaysOnTop(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        public void setComponent(Component c) {
            if (c == this.comp) {
                return;
            }
            if (this.comp != null) {
                this.remove(this.comp);
            }
            this.comp = c;
            this.getContentPane().add(c, "Center");
            this.invalidate();
            this.validate();
        }

        @Override
        public void paint(Graphics g) {
            if (AbstractToolTip.this.tipHeight != this.getHeight() || AbstractToolTip.this.tipWidth != this.getWidth()) {
                AbstractToolTip.this.tipHeight = this.getHeight();
                AbstractToolTip.this.tipWidth = this.getWidth();
                AbstractToolTip.this.bufferImage = new BufferedImage(AbstractToolTip.this.tipWidth, AbstractToolTip.this.tipHeight, 6);
                AbstractToolTip.this.bufferGraphics = (Graphics2D)AbstractToolTip.this.bufferImage.getGraphics();
                AbstractToolTip.this.bufferGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            AbstractToolTip.this.bufferGraphics.setColor(this.backColor);
            if (AbstractToolTip.this.rounded) {
                AbstractToolTip.this.bufferGraphics.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, AbstractToolTip.this.rounding, AbstractToolTip.this.rounding);
            } else {
                AbstractToolTip.this.bufferGraphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            this.comp.setForeground(AbstractToolTip.this.foreColor);
            this.comp.paint(AbstractToolTip.this.bufferGraphics);
            if (this.borderColor != null) {
                AbstractToolTip.this.bufferGraphics.setColor(this.borderColor);
                if (AbstractToolTip.this.rounded) {
                    AbstractToolTip.this.bufferGraphics.drawRoundRect(0, 0, AbstractToolTip.this.w.getWidth() - 1, AbstractToolTip.this.w.getHeight() - 1, AbstractToolTip.this.rounding, AbstractToolTip.this.rounding);
                } else {
                    AbstractToolTip.this.bufferGraphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                }
            }
            g.drawImage(AbstractToolTip.this.bufferImage, 0, 0, null);
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public void show() {
            this.pack();
            super.show();
        }
    }

    class FadeActionListener
    implements ActionListener {
        FadeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            AbstractToolTip.this.tick();
        }
    }

    class AlphaTimer
    extends Timer {
        public AlphaTimer(int delay, ActionListener a) {
            super(delay, a);
        }

        @Override
        public void start() {
            if (AbstractToolTip.this.w != null) {
                AbstractToolTip.this.opacity = 0.0f;
                AbstractToolTip.this.w.setOpacity(AbstractToolTip.this.opacity);
                AbstractToolTip.this.w.show();
                super.start();
            }
        }
    }

    static class DefaultFrame
    extends Frame {
        DefaultFrame() {
        }
    }
}

