/*
 * Decompiled with CFR 0.152.
 */
package StatusWindow;

import GhostTextControls.GhostTextPane;
import StatusWindow.SmartScroller;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class FrmStatus
extends JFrame {
    private boolean m_Bold = false;
    private boolean m_Underlined = false;
    private boolean m_Italics = false;
    private StyledDocument sdoc;
    private SimpleAttributeSet attrs;
    private SimpleAttributeSet caretAttrs;
    SmartScroller scroller;
    private boolean updateThreaded = true;
    private JScrollPane ScrollPaneText;
    public GhostTextPane statusPane;

    public void setBold(boolean Bold) {
        StyleConstants.setBold(this.attrs, Bold);
        this.m_Bold = Bold;
    }

    public void setItalics(boolean Italics) {
        StyleConstants.setItalic(this.attrs, Italics);
        this.m_Italics = Italics;
    }

    public void setUnderlined(boolean Underlined) {
        StyleConstants.setUnderline(this.attrs, Underlined);
        this.m_Underlined = Underlined;
    }

    public void setDefaultForecolor(Color newColor) {
        StyleConstants.setForeground(this.caretAttrs, newColor);
    }

    public void setDefaultBackcolor(Color newColor) {
        StyleConstants.setBackground(this.caretAttrs, newColor);
    }

    public void setDefaultBold(boolean Bold) {
        StyleConstants.setBold(this.caretAttrs, Bold);
    }

    public void setDefaultItalics(boolean Italics) {
        StyleConstants.setItalic(this.caretAttrs, Italics);
    }

    public void setDefaultUnderlined(boolean Underlined) {
        StyleConstants.setUnderline(this.caretAttrs, Underlined);
    }

    public void refresh() {
        Image bufferimage = this.createImage(this.getWidth(), this.getHeight());
        this.paint(bufferimage.getGraphics());
        Graphics g = this.getGraphics();
        g.drawImage(bufferimage, 0, 0, this);
    }

    private void initVariables() {
        this.initComponents();
        this.scroller = new SmartScroller(this.ScrollPaneText, 1, 1);
        this.sdoc = this.statusPane.getStyledDocument();
        this.attrs = new SimpleAttributeSet();
        this.caretAttrs = new SimpleAttributeSet();
        StyleConstants.setBackground(this.attrs, Color.BLACK);
        StyleConstants.setBackground(this.caretAttrs, Color.BLACK);
        StyleConstants.setForeground(this.caretAttrs, Color.GREEN);
    }

    public FrmStatus(String title) {
        this.initVariables();
        this.setTitle(title);
    }

    public FrmStatus(String title, Image IconImage) {
        this.initVariables();
        this.setTitle(title);
        this.setIcon(IconImage);
    }

    public FrmStatus() {
        this.initVariables();
        this.setTitle("Status");
    }

    public void setIcon(Image IconImage) {
        this.setIconImage(IconImage);
    }

    @Override
    public void setTitle(String newTitle) {
        super.setTitle(newTitle);
    }

    private void initComponents() {
        this.ScrollPaneText = new JScrollPane();
        this.statusPane = new GhostTextPane();
        this.setDefaultCloseOperation(0);
        this.statusPane.setEditable(false);
        this.statusPane.setBackground(new Color(0, 0, 0));
        this.statusPane.setFont(new Font("Monospaced", 1, 14));
        this.statusPane.setBackcolor(new Color(0, 0, 0));
        this.statusPane.setDoubleBuffered(true);
        this.statusPane.setWordWrap(false);
        this.ScrollPaneText.setViewportView(this.statusPane);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ScrollPaneText, -1, 375, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ScrollPaneText, -1, 300, Short.MAX_VALUE));
        this.pack();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FrmStatus().setVisible(true);
            }
        });
    }

    public void setTextFormat(boolean Bold, boolean Italics, boolean Underlined) {
        StyleConstants.setBold(this.attrs, Bold);
        StyleConstants.setItalic(this.attrs, Italics);
        StyleConstants.setUnderline(this.attrs, Underlined);
    }

    public void addLog(String sText, boolean newLineAfter, boolean AddCaret, int indent, Color textColor, Color textBackColor) {
        this.pAddLog(sText, newLineAfter, AddCaret, indent, textColor, textBackColor);
    }

    private synchronized void psAddLog(String sText, boolean newLineAfter, boolean AddCaret, int indent, Color textColor, Color textBackColor) {
        for (int i = 1; i <= indent; ++i) {
            try {
                this.sdoc.insertString(this.sdoc.getLength(), "  ", this.caretAttrs);
                continue;
            }
            catch (BadLocationException ex) {
                Logger.getLogger(FrmStatus.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (AddCaret) {
            StyleConstants.setForeground(this.attrs, Color.GREEN);
            try {
                this.sdoc.insertString(this.sdoc.getLength(), " > ", this.caretAttrs);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(FrmStatus.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        StyleConstants.setForeground(this.attrs, textColor);
        StyleConstants.setBackground(this.attrs, textBackColor);
        try {
            this.sdoc.insertString(this.sdoc.getLength(), sText, this.attrs);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(FrmStatus.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (newLineAfter) {
            try {
                this.sdoc.insertString(this.sdoc.getLength(), "\n", this.attrs);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(FrmStatus.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void setThreaded(boolean updateThreaded) {
        this.updateThreaded = updateThreaded;
    }

    private void pAddLog(final String sText, final boolean newLineAfter, final boolean AddCaret, final int indent, final Color textColor, final Color textBackColor) {
        if (this.updateThreaded) {
            SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    FrmStatus.this.psAddLog(sText, newLineAfter, AddCaret, indent, textColor, textBackColor);
                    return null;
                }

                @Override
                protected void done() {
                }
            };
            sw.execute();
        } else {
            this.psAddLog(sText, newLineAfter, AddCaret, indent, textColor, textBackColor);
        }
    }

    public void addLog(String newText) {
        this.pAddLog(newText, true, true, 0, Color.GREEN, Color.BLACK);
    }

    public void addLog(String newText, Color textColor) {
        this.pAddLog(newText, true, true, 0, textColor, Color.BLACK);
    }

    public void addLog(String newText, Color textColor, Color backColor) {
        this.pAddLog(newText, true, true, 0, textColor, backColor);
    }

    public void addLog(String newText, boolean newLineAfter, boolean caret, Color textColor, Color backColor) {
        this.pAddLog(newText, newLineAfter, caret, 0, textColor, backColor);
    }

    public void addLog(String newText, boolean newLineAfter, boolean caret) {
        this.pAddLog(newText, newLineAfter, caret, 0, Color.GREEN, Color.BLACK);
    }

    public void addLog(String newText, boolean newLineAfter, boolean caret, int indent) {
        this.pAddLog(newText, newLineAfter, caret, indent, Color.GREEN, Color.BLACK);
    }

    public void addLog(String newText, boolean newLineAfter, boolean caret, int indent, Color textColor) {
        this.pAddLog(newText, newLineAfter, caret, 0, textColor, Color.BLACK);
    }

    public void addLog(String newText, boolean newLineAfter, boolean caret, Color textColor) {
        this.pAddLog(newText, newLineAfter, caret, 0, textColor, Color.BLACK);
    }

    public synchronized void gotoEnd() {
        this.statusPane.setSelectionStart(this.sdoc.getEndPosition().getOffset());
    }
}

