/*
 * Decompiled with CFR 0.152.
 */
package StatusBarDialogs;

import JMScrollBars.JMProgressBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class SplashScreen
extends JDialog {
    private ImageIcon image;

    public SplashScreen(Frame parent) {
        super(parent, true);
        this.init(parent);
    }

    public SplashScreen(Frame parent, ImageIcon image) {
        super(parent, true);
        this.image = image;
        this.init(parent);
    }

    public void run(final Runnable runner) {
        this.setLocationRelativeTo(this.getParent());
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                runner.run();
                return null;
            }

            @Override
            protected void done() {
                SplashScreen.this.setVisible(false);
            }
        }.execute();
        this.setVisible(true);
    }

    public void Refresh() {
        this.setBackground(new Color(0, true));
    }

    private void init(Frame parent) {
        this.setLayout(null);
        this.getFont();
        this.setResizable(false);
        this.getRootPane().setWindowDecorationStyle(0);
        this.setUndecorated(true);
        this.getRootPane().setBorder(null);
        this.setDefaultCloseOperation(0);
        if (this.image != null) {
            this.setSize(this.image.getIconWidth(), this.image.getIconHeight());
        } else {
            this.setSize(100, 100);
        }
        this.setLocationRelativeTo(parent);
        this.Refresh();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.getFont();
    }

    public JProgressBar addProgressBar(int x, int y, int width, int height) {
        JProgressBar newItem = new JProgressBar();
        newItem.setMinimum(0);
        newItem.setMaximum(100);
        this.add(newItem);
        newItem.setBounds(x, y, width, height);
        return newItem;
    }

    public JMProgressBar addJMProgressBar(int x, int y, int width, int height) {
        JMProgressBar newItem = new JMProgressBar();
        newItem.setMinimum(0L);
        newItem.setMaximum(100L);
        this.add(newItem);
        newItem.setBounds(x, y, width, height);
        return newItem;
    }

    public void addComponent(Component component, int x, int y) {
        this.add(component);
        component.setBounds(x, y, component.getWidth(), component.getHeight());
    }

    public JLabel addLabel(String caption, int x, int y, int width, int height) {
        return this.addLabel(caption, x, y, width, height, 2);
    }

    public JLabel addLabel(String caption, int x, int y, int width, int height, int horizontalAlignment) {
        return this.addLabel(caption, x, y, width, height, horizontalAlignment, null);
    }

    public JLabel addLabel(String caption, int x, int y, int width, int height, int horizontalAlignment, Font font) {
        JLabel newItem = new JLabel();
        if (font != null) {
            newItem.setFont(font);
        }
        newItem.setText(caption);
        this.add(newItem);
        newItem.setBounds(x, y, width, height);
        newItem.setHorizontalAlignment(horizontalAlignment);
        return newItem;
    }

    public void setProgressBarValue(int index, int percentDone) {
        this.repaint();
        System.out.println("Setting percentDone = " + percentDone);
    }

    @Override
    public void paint(Graphics g) {
        if (this.image != null) {
            this.image.paintIcon(this, g, 0, 0);
        }
        this.paintComponents(g);
    }
}

