/*
 * Decompiled with CFR 0.152.
 */
package SnapGeneFileReader;

import SnapGeneFileReader.XMLAttribute;
import SnapGeneFileReader.XMLConstants;
import SnapGeneFileReader.XMLElement;
import SnapGeneFileReader.XMLTag;
import java.util.ArrayList;

class XMLParser
implements XMLConstants {
    private static char cNull = '\u0000';
    int cIndex = 0;
    char[] data;

    public XMLParser() {
    }

    public XMLParser(String xmlString) {
        this.setDataString(xmlString);
    }

    public XMLElement parse() {
        if (this.data == null || this.data.length == 0) {
            return null;
        }
        XMLElement root = new XMLElement();
        root.name = "root";
        this.parseElement(root);
        return root;
    }

    public void setDataString(String xmlString) {
        int headerEnd;
        if (xmlString.length() == 0) {
            return;
        }
        if (xmlString.startsWith("<?xml version") && (headerEnd = xmlString.indexOf("?>")) > 0) {
            xmlString = xmlString.substring(headerEnd + 1);
        }
        this.data = (xmlString + cNull).toCharArray();
        this.cIndex = 0;
    }

    private XMLTag parseTag() {
        XMLTag tag = new XMLTag();
        ++this.cIndex;
        block5: while (this.cIndex < this.data.length) {
            switch (this.data[this.cIndex]) {
                case '/': {
                    if (this.data[this.cIndex - 1] == '<') {
                        tag.m_eStyle = 1;
                        while (this.cIndex < this.data.length && this.data[this.cIndex] != '>') {
                            ++this.cIndex;
                        }
                    } else if (this.data[this.cIndex + 1] == '>') {
                        tag.m_eStyle = 2;
                        ++this.cIndex;
                    }
                    ++this.cIndex;
                    return tag;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '>': {
                    ++this.cIndex;
                    break block5;
                }
                default: {
                    if (!(this.data[this.cIndex] >= 'A' && this.data[this.cIndex] <= 'Z' || this.data[this.cIndex] >= 'a' && this.data[this.cIndex] <= 'z' || this.data[this.cIndex] == '_') && this.data[this.cIndex] != ':') break;
                    if (tag.name != null) {
                        tag.appendAttribute(this.parseAttribute());
                        --this.cIndex;
                        break;
                    }
                    tag.name = this.parseName();
                    --this.cIndex;
                }
            }
            ++this.cIndex;
        }
        return tag;
    }

    private XMLAttribute parseAttribute() {
        XMLAttribute attribute = new XMLAttribute();
        while (this.cIndex < this.data.length) {
            switch (this.data[this.cIndex]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '>': {
                    break;
                }
                case '\"': 
                case '\'': {
                    attribute.value = attribute.value + this.parseValue();
                    return attribute;
                }
                default: {
                    if (!(this.data[this.cIndex] >= 'A' && this.data[this.cIndex] <= 'Z' || this.data[this.cIndex] >= 'a' && this.data[this.cIndex] <= 'z' || this.data[this.cIndex] == '_') && this.data[this.cIndex] != ':') break;
                    attribute.keyWord = this.parseName();
                    --this.cIndex;
                }
            }
            ++this.cIndex;
        }
        return attribute;
    }

    private boolean isOnTagOpener() {
        return this.data[this.cIndex] == '<' && this.cIndex < this.data.length - 1 && this.data[this.cIndex + 1] != '!';
    }

    private void parseElement(XMLElement parent) {
        if (this.cIndex < 0) {
            return;
        }
        while (this.cIndex < this.data.length) {
            if (this.isOnTagOpener()) {
                XMLTag oTag = this.parseTag();
                switch (oTag.m_eStyle) {
                    case 2: {
                        parent.addElement(this.tagToElement(oTag, true));
                        break;
                    }
                    case 1: {
                        return;
                    }
                    case 0: {
                        XMLElement element = new XMLElement();
                        element.attributes = oTag.attributes;
                        element.name = oTag.name;
                        element.m_eStyle = oTag.m_eStyle;
                        element.elements = new ArrayList();
                        this.parseElement(element);
                        if (element.body != null && element.body.length() > 0) {
                            this.processBody(element);
                        }
                        parent.addElement(element);
                        break;
                    }
                }
                continue;
            }
            parent.body = parent.body + this.data[this.cIndex];
            ++this.cIndex;
        }
        if (parent.body != null && parent.body.length() > 0) {
            this.processBody(parent);
            parent.body = parent.body.replaceFirst("[\\s\\t\\n\\r]+$", "");
            if (parent.body.startsWith("<![CDATA[") && parent.body.endsWith("]]>")) {
                parent.body = parent.body.substring(8, parent.body.length() - 11);
            }
        }
    }

    private XMLElement tagToElement(XMLTag tag, boolean isEmpty) {
        XMLElement element = new XMLElement();
        element.attributes = tag.attributes;
        element.name = tag.name;
        element.m_eStyle = tag.m_eStyle;
        if (!isEmpty && element.body != null && element.body.length() > 0) {
            this.processBody(element);
        }
        return element;
    }

    private String decodeEscape() {
        String outString = "";
        while (true) {
            ++this.cIndex;
            if (this.cIndex >= this.data.length) {
                return "";
            }
            if (this.data[this.cIndex] == ';') break;
            outString = outString + this.data[this.cIndex];
        }
        switch (outString) {
            case "amp": {
                return "&";
            }
            case "apos": {
                return "'";
            }
            case "lt": {
                return "<";
            }
            case "gt": {
                return ">";
            }
            case "quot": {
                return "\"";
            }
        }
        if (this.data[this.cIndex - outString.length()] == '#') {
            outString = this.data[this.cIndex - outString.length() + 1] == 'x' ? outString.substring(2) : outString.substring(1);
            return outString;
        }
        return "";
    }

    private void processBody(XMLElement element) {
        char chr;
        int index;
        if (element.body.length() == 0) {
            return;
        }
        int start = -1;
        int stop = -1;
        block6: for (index = 0; index < element.body.length(); ++index) {
            chr = element.body.charAt(index);
            switch (chr) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block6;
                }
                default: {
                    start = index;
                    break block6;
                }
            }
        }
        if (start == -1) {
            element.body = "";
            return;
        }
        block7: for (index = element.body.length() - 1; index >= start; --index) {
            chr = element.body.charAt(index);
            switch (chr) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block7;
                }
                default: {
                    stop = index;
                    break block7;
                }
            }
        }
        if (stop == -1) {
            element.body = "";
            return;
        }
        element.body = element.body.substring(start, stop + 1);
        element.body = element.body.startsWith("<![CDATA[") && element.body.endsWith("]]>") ? element.body.substring(9, element.body.length() - 3) : XMLParser.unEscapeString(element.body);
    }

    static String escapeString(String inputString) {
        return inputString.trim().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;");
    }

    static String unEscapeString(String inputString) {
        return inputString.trim().replace("&amp;", "&").replace("&lt;", "<").replace("&gt;", ">").replace("&quot;", "\"").replace("&apos;", "'");
    }

    private String parseValue() {
        boolean bEnd = false;
        String outString = "";
        char quoteChar = this.data[this.cIndex];
        while (this.cIndex < this.data.length) {
            if (this.data[this.cIndex] == quoteChar) {
                boolean bl = bEnd = !bEnd;
                if (!bEnd) {
                    return outString;
                }
            } else if (this.data[this.cIndex] == '&') {
                outString = outString + this.decodeEscape();
            } else if (this.data[this.cIndex] != '<' || this.data[this.cIndex] != '&') {
                outString = outString + this.data[this.cIndex];
            }
            ++this.cIndex;
        }
        return "";
    }

    private String parseName() {
        boolean bEnd = false;
        String outString = "";
        while (this.cIndex < this.data.length) {
            switch (this.data[this.cIndex]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ';': 
                case '=': {
                    bEnd = true;
                    break;
                }
                case '\"': 
                case '\'': 
                case '>': {
                    return outString;
                }
                case '/': {
                    if (this.data[this.cIndex + 1] == '>') {
                        return outString;
                    }
                }
                default: {
                    char chr = this.data[this.cIndex];
                    if (!(chr >= 'A' && chr <= 'Z' || chr >= 'a' && chr <= 'z' || chr >= '0' && chr <= '9' || chr == '_' || chr == ':') && chr != '-') break;
                    if (bEnd) {
                        return outString;
                    }
                    outString = outString + chr;
                }
            }
            ++this.cIndex;
        }
        return "";
    }
}

