/*
 * Decompiled with CFR 0.152.
 */
package SnapGeneFileReader;

import Defaults.DefaultValues;
import Defaults.GenbankType;
import GenbankFileReader.Annotation;
import GenbankFileReader.GenBankFile;
import GenbankFileReader.Locus;
import GenbankFileReader.Qualifier;
import GenbankFileReader.Reference;
import SequenceEditorPanels.ExtensibleArray;
import SnapGeneFileReader.XMLDocument;
import SnapGeneFileReader.XMLElement;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.ArrayList;

public class SnapGeneReader {
    private static final int SEGMENT_DNA = 0;
    private static final int SEGMENT_PRIMERS = 5;
    private static final int SEGMENT_NOTES = 6;
    private static final int SEGMENT_PROPERTIES = 9;
    private static final int SEGMENT_FEATURES = 10;
    private static final int SEGMENT_CompressedDNA = 1;
    private static final int SEGMENT_History_Tree = 7;
    private static final int SEGMENT_History_Node = 11;
    private static final int SEGMENT_Alignable_Sequence = 16;
    private static final int SEGMENT_Alignable_Sequences_Summary = 17;
    private static final int SEGMENT_Sequence_Trace = 18;
    private static final int SEGMENT_Uracil_Positions = 19;
    private static final int SEGMENT_Custom_DNA_Colors = 20;
    private static String lastError = "";
    private static int currentOffset = 0;
    private static String primerColorString;
    private static String primerFeatureString;

    public static GenBankFile loadSnapGeneFile(File file) {
        try {
            byte[] fileBytes = Files.readAllBytes(Paths.get(file.getCanonicalPath(), new String[0]));
            GenBankFile outFile = new GenBankFile();
            currentOffset = 0;
            while (currentOffset < fileBytes.length) {
                Segment segment = SnapGeneReader.parseSegment(fileBytes);
                switch (segment.type) {
                    case 0: {
                        outFile.header.circular = (segment.blockData[0] | 1) == segment.blockData[0];
                        outFile.sequence = new String(segment.blockData, 1, segment.blockData.length - 1);
                        break;
                    }
                    case 5: {
                        String primersString;
                        GenbankType defType = DefaultValues.GBTYPES.get("primer_bind");
                        if (defType != null) {
                            primerColorString = SnapGeneReader.colorToIntString(defType.color);
                            primerFeatureString = String.valueOf(defType.loadedGraphicIndex);
                        }
                        if ((primersString = new String(segment.blockData)).length() <= 0) break;
                        SnapGeneReader.parsePrimers(primersString, outFile);
                        break;
                    }
                    case 6: {
                        String notesString = new String(segment.blockData);
                        if (notesString.length() <= 0) break;
                        SnapGeneReader.parseNotes(notesString, outFile);
                        break;
                    }
                    case 10: {
                        String featuresString = new String(segment.blockData);
                        if (featuresString.length() <= 0) break;
                        SnapGeneReader.parseFeatures(featuresString, outFile);
                        break;
                    }
                    case 9: {
                        int major = SnapGeneReader.byteToInt(segment.blockData[8], segment.blockData[9]);
                        int minor = SnapGeneReader.byteToInt(segment.blockData[10], segment.blockData[11]);
                        int rev = SnapGeneReader.byteToInt(segment.blockData[12], segment.blockData[13]);
                        outFile.header.version = major + "." + minor + "." + rev;
                    }
                }
            }
            outFile.setFile(file);
            return outFile;
        }
        catch (IOException ex) {
            lastError = ex instanceof NoSuchFileException ? "File could not be found." : ex.getLocalizedMessage();
            return null;
        }
    }

    static Segment parseSegment(byte[] fileData) {
        Segment seg = new Segment();
        seg.type = fileData[currentOffset];
        seg.blockSize = SnapGeneReader.byteToInt(fileData[currentOffset + 1], fileData[currentOffset + 2], fileData[currentOffset + 3], fileData[currentOffset + 4]);
        seg.blockData = new byte[seg.blockSize];
        System.arraycopy(fileData, currentOffset += 5, seg.blockData, 0, seg.blockData.length);
        currentOffset += seg.blockSize;
        return seg;
    }

    private static void parseFeatures(String featuresString, GenBankFile outFile) {
        XMLElement rootFeatures = null;
        XMLElement xmlFeatures = null;
        rootFeatures = XMLDocument.makeRoot(featuresString);
        if (rootFeatures != null) {
            xmlFeatures = rootFeatures.getElement("Features");
        }
        if (xmlFeatures != null) {
            for (int eIndex = 0; eIndex < xmlFeatures.getElementCount(); ++eIndex) {
                XMLElement child = xmlFeatures.getElement(eIndex);
                switch (child.name) {
                    case "Feature": {
                        outFile.features.add(SnapGeneReader.xmlToAnnotation(child));
                    }
                }
            }
        }
    }

    private static void parsePrimers(String featuresString, GenBankFile outFile) {
        XMLElement rootPrimers = null;
        XMLElement xmlPrimers = null;
        rootPrimers = XMLDocument.makeRoot(featuresString);
        if (rootPrimers != null) {
            xmlPrimers = rootPrimers.getElement("Primers");
        }
        if (xmlPrimers != null) {
            for (int eIndex = 0; eIndex < xmlPrimers.getElementCount(); ++eIndex) {
                XMLElement child = xmlPrimers.getElement(eIndex);
                switch (child.name) {
                    case "Primer": {
                        SnapGeneReader.xmlToPrimers(child, outFile);
                    }
                }
            }
        }
    }

    private static void parseNotes(String notesString, GenBankFile outFile) {
        XMLElement rootNotes = null;
        XMLElement xmlNotes = null;
        if (notesString.length() > 0 && (rootNotes = XMLDocument.makeRoot(notesString)) != null) {
            xmlNotes = rootNotes.getElement("Notes");
        }
        if (xmlNotes != null) {
            ArrayList<Reference> refs = new ArrayList<Reference>();
            XMLElement child = xmlNotes.getElement("CustomMapLabel");
            if (child != null) {
                outFile.header.name = child.body;
            }
            if ((child = xmlNotes.getElement("Type")) != null) {
                outFile.header.source = child.body;
            }
            if ((child = xmlNotes.getElement("Created")) != null) {
                outFile.header.date = child.getAttribute("UTC", "");
            }
            if ((child = xmlNotes.getElement("LastModified")) != null) {
                outFile.header.date = child.getAttribute("UTC", "");
            }
            if ((child = xmlNotes.getElement("Description")) != null) {
                outFile.header.notes = outFile.header.notes == null || outFile.header.notes.length() == 0 ? child.body : outFile.header.notes + "\r\n" + child.body;
            }
            if ((child = xmlNotes.getElement("References")) != null) {
                for (XMLElement ref : child.elements) {
                    if (!ref.name.equalsIgnoreCase("Reference")) continue;
                    Reference newRef = new Reference();
                    newRef.journal = ref.getAttribute("journal", "");
                    newRef.title = ref.getAttribute("title", "");
                    newRef.pmid = ref.getAttribute("pubMedID", "");
                    newRef.authors = ref.getAttribute("authors", "");
                    refs.add(newRef);
                }
                if (!refs.isEmpty()) {
                    outFile.header.references = new Reference[refs.size()];
                    for (int refIndex = 0; refIndex < refs.size(); ++refIndex) {
                        outFile.header.references[refIndex] = (Reference)refs.get(refIndex);
                    }
                }
            }
        }
    }

    private static void xmlToPrimers(XMLElement child, GenBankFile outFile) {
        String primerName = child.getAttribute("name", child.getName());
        String primerSequence = child.getAttribute("sequence", "");
        String primerDescription = child.getAttribute("description", "");
        for (XMLElement element : child.elements) {
            Locus locus;
            if (!element.name.equals("BindingSite") || element.getAttribute("simplified", null) != null || (locus = SnapGeneReader.getRange(element.getAttribute("location", null))) == null) continue;
            Annotation roi = new Annotation();
            roi.setStart(locus.getStart());
            roi.setStop(locus.getStop());
            roi.setAntisense(element.getAttribute("boundStrand", "0").equals("1"));
            roi.setName(primerName);
            roi.setGBType("primer_bind");
            roi.qualifiers = new Qualifier[8];
            roi.qualifiers[0] = new Qualifier("label", roi.getName());
            roi.qualifiers[1] = new Qualifier("note", primerDescription);
            roi.qualifiers[2] = new Qualifier("note", "sequence: " + primerSequence);
            roi.qualifiers[3] = new Qualifier("plot_color", primerColorString);
            roi.qualifiers[4] = new Qualifier("textcolor", primerColorString);
            roi.qualifiers[5] = new Qualifier("plot_ftype", primerFeatureString);
            roi.qualifiers[6] = new Qualifier("plot_offset", "110");
            roi.qualifiers[7] = new Qualifier("plot_fwidth", "0.3");
            outFile.features.add(roi);
        }
    }

    private static Annotation xmlToAnnotation(XMLElement child) {
        Annotation roi = new Annotation();
        ExtensibleArray<Qualifier> quals = new ExtensibleArray<Qualifier>(Qualifier.class);
        roi.setName(child.getAttribute("name", child.getName()));
        quals.add(new Qualifier("label", roi.getName()));
        roi.setGBType(child.getAttribute("type", "misc_feature"));
        String orientString = child.getAttribute("directionality", "1");
        roi.setAntisense(orientString.equals("2"));
        int minStart = -1;
        int maxStop = -1;
        String fColor = null;
        for (XMLElement element : child.elements) {
            Locus locus;
            if (element.name.equals("Q")) {
                Qualifier qualifier = SnapGeneReader.XMLElementToQualifier(element);
                if (qualifier == null) continue;
                quals.add(qualifier);
                continue;
            }
            if (!element.name.equals("Segment") || (locus = SnapGeneReader.getRange(element)) == null) continue;
            if (!(locus.getStart() > minStart && minStart != -1 || locus.getStop() < maxStop && maxStop != -1)) {
                minStart = locus.getStart();
                maxStop = locus.getStop();
                String sColor = element.getAttribute("color", null);
                if (sColor == null || !sColor.startsWith("#") || sColor.equals("#ffffff")) continue;
                fColor = sColor;
                continue;
            }
            if (locus.getStart() <= minStart || minStart == -1) {
                minStart = locus.getStart();
                continue;
            }
            if (locus.getStop() < maxStop && maxStop != -1) continue;
            maxStop = locus.getStop();
        }
        GenbankType defType = DefaultValues.GBTYPES.get(roi.getGBType());
        if (defType != null) {
            if (fColor == null) {
                quals.add(new Qualifier("color", SnapGeneReader.colorToIntString(defType.color)));
            }
            quals.add(new Qualifier("plot_ftype", String.valueOf(defType.loadedGraphicIndex)));
        }
        if (fColor != null) {
            quals.add(new Qualifier("color", SnapGeneReader.colorToIntString(Color.decode(fColor))));
        }
        quals.add(new Qualifier("plot_fwidth", "0.3"));
        roi.qualifiers = quals.toArray();
        roi.set(minStart, maxStop);
        return roi;
    }

    private static Qualifier XMLElementToQualifier(XMLElement element) {
        XMLElement val = element.getElement("V");
        if (val != null) {
            String qualKey = element.getAttribute("name", null);
            String qualValue = val.getAttribute("text", null);
            if (qualKey != null && qualValue != null) {
                return new Qualifier(qualKey, qualValue);
            }
        }
        return null;
    }

    private static int byteToInt(byte ... value) {
        if (value != null) {
            switch (value.length) {
                case 1: {
                    return ByteBuffer.wrap(new byte[]{0, 0, 0, value[0]}).getInt();
                }
                case 2: {
                    return ByteBuffer.wrap(new byte[]{0, 0, value[0], value[1]}).getInt();
                }
                case 3: {
                    return ByteBuffer.wrap(new byte[]{0, value[0], value[1], value[2]}).getInt();
                }
                case 4: {
                    return ByteBuffer.wrap(value).getInt();
                }
            }
        }
        throw new IllegalArgumentException("You cannot create an int with more than 4 bytes.");
    }

    private static byte[] intToByte(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    private static String colorToIntString(Color color) {
        return String.valueOf(color.getRed() + color.getGreen() * 256 + color.getBlue() * 65536);
    }

    private static Locus getRange(String rangeString) {
        String[] startStopString;
        if (rangeString != null && rangeString.length() > 3 && (startStopString = rangeString.split("-")).length == 2) {
            String sStart = startStopString[0];
            String sStop = startStopString[1];
            return new Locus(Integer.parseInt(sStart), Integer.parseInt(sStop));
        }
        return null;
    }

    private static Locus getRange(XMLElement segChild) {
        return segChild.getAttribute("name", null) == null ? SnapGeneReader.getRange(segChild.getAttribute("range", "")) : null;
    }

    static {
        primerFeatureString = "6";
    }

    private static class Segment {
        public int type;
        public int blockSize;
        public byte[] blockData;

        private Segment() {
        }
    }
}

