/*
 * Decompiled with CFR 0.152.
 */
package Sequences;

import GenbankFileReader.Annotation;
import GenbankFileReader.GenBankFile;
import GenbankFileReader.Qualifier;
import SequenceEditorPanels.ExtensibleArray;
import SequenceEditorPanels.ROI;
import Sequences.DNA;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;

public class SequenceExportFormat
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final DataFlavor copiedSequenceFlavor = new DataFlavor(SequenceExportFormat.class, "Copied Sequence");
    public static final DataFlavor copiedSequencesFlavor = new DataFlavor(SequenceExportFormat[].class, "Copied Sequences");
    public String sequence;
    public boolean circular = false;
    public String name;
    public ROI[] annotations;
    public Qualifier[] qualifiers;

    public SequenceExportFormat() {
    }

    public SequenceExportFormat(String seq) {
        this.sequence = seq;
        this.name = "New Sequence";
    }

    public SequenceExportFormat(String seq, String name) {
        this.sequence = seq;
        this.name = name;
    }

    public static SequenceTransferable createTransferable(SequenceExportFormat data) {
        return new SequenceTransferable(data);
    }

    public static SequenceTransferable createTransferable(SequenceExportFormat[] data) {
        return new SequenceTransferable(data);
    }

    public static SequenceExportFormat fromGenbankFile(GenBankFile src) {
        if (src != null) {
            int x;
            String seq = DNA.filterSequence(src.getSequence()).toUpperCase();
            int seqLen = seq.length();
            if (seqLen == 0) {
                return null;
            }
            SequenceExportFormat dest = new SequenceExportFormat();
            dest.name = src.getName();
            dest.circular = src.isCircular();
            dest.sequence = seq;
            if (src.header.qualifiers != null && src.header.qualifiers.length > 0) {
                for (x = 0; x < src.header.qualifiers.length && !src.header.qualifiers[x].key.equalsIgnoreCase("codon_table"); ++x) {
                }
            }
            if (!src.features.isEmpty()) {
                dest.annotations = new ROI[src.features.size()];
                for (x = 0; x < src.features.size(); ++x) {
                    Annotation annotation = src.features.get(x);
                    if (annotation.start <= 0 || annotation.stop > seqLen) continue;
                    ROI roi = ROI.fromAnnotation(annotation);
                    if (roi.getName().length() == 0) {
                        roi.setName("misc_feature");
                    }
                    dest.annotations[x] = roi;
                }
            }
            return dest;
        }
        return null;
    }

    public void antisense() {
        if (this.sequence == null || this.sequence.length() == 0) {
            return;
        }
        this.sequence = DNA.getAntisense(this.sequence);
        if (this.annotations != null && this.annotations.length > 0) {
            int seqLen = this.sequence.length();
            for (ROI roi : this.annotations) {
                roi.antisense(seqLen);
            }
        }
    }

    public boolean hasQualifiers() {
        return this.qualifiers != null && this.qualifiers.length > 0;
    }

    public String toString() {
        return "Name: " + this.name + ", Sequence: " + this.sequence.length() + ", annotations: " + (this.annotations == null || this.annotations.length == 0 ? "0" : Integer.valueOf(this.annotations.length));
    }

    public static SequenceExportFormat merge(SequenceExportFormat ... sequences) {
        if (sequences == null || sequences.length == 0) {
            return null;
        }
        if (sequences.length == 1) {
            return sequences[0];
        }
        ExtensibleArray<ROI> rois = new ExtensibleArray<ROI>(ROI.class);
        SequenceExportFormat outSeq = new SequenceExportFormat();
        int offset = 0;
        outSeq.sequence = "";
        for (SequenceExportFormat seq : sequences) {
            outSeq.sequence = outSeq.sequence + seq.sequence;
            if (seq.annotations != null) {
                for (ROI roi : seq.annotations) {
                    roi.stop += offset;
                    roi.start += offset;
                    rois.add(roi);
                }
            }
            offset += seq.sequence.length();
        }
        outSeq.annotations = rois.toArray();
        return outSeq;
    }

    public static class SequenceTransferable
    implements Transferable {
        SequenceExportFormat[] data = null;

        public SequenceTransferable(SequenceExportFormat seq) {
            this.data = new SequenceExportFormat[1];
            this.data[0] = seq;
        }

        public SequenceTransferable(SequenceExportFormat[] seq) {
            this.data = seq;
        }

        public SequenceTransferable(String seq) {
            this.data = new SequenceExportFormat[1];
            this.data[0] = new SequenceExportFormat();
            this.data[0].sequence = seq;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{copiedSequenceFlavor, copiedSequencesFlavor, DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            if (this.data == null || this.data[0].sequence == null) {
                return false;
            }
            return copiedSequenceFlavor.equals(flavor) || copiedSequencesFlavor.equals(flavor) || DataFlavor.stringFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.data == null || this.data.length == 0) {
                return null;
            }
            if (copiedSequenceFlavor.equals(flavor)) {
                return this.data[0];
            }
            if (copiedSequencesFlavor.equals(flavor)) {
                return this.data;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                if (this.data.length == 1) {
                    return this.data[0].sequence;
                }
                if (this.data.length > 1) {
                    String outStrings = "";
                    for (SequenceExportFormat sef : this.data) {
                        if (outStrings.length() > 0) {
                            outStrings = outStrings + "\n\n";
                        }
                        outStrings = outStrings + ">" + sef.name + "\n" + sef.sequence;
                    }
                    return outStrings;
                }
                return "";
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

