/*
 * Decompiled with CFR 0.152.
 */
package Sequences;

import Sequences.Sequence;

public class Protein
extends Sequence {
    public static final String AU1 = "DTYRYI";
    public static final String AU5 = "TDFYLK";
    public static final String BTAG = "QYPALT";
    public static final String CMYC = "EQKLISEEDL";
    public static final String FLAG = "DYKDDDDK";
    public static final String GFP = "MSKGEELFTGVVPILVELDGDVNGHKFSVSGEGEGDATYGKLTLKFICTTGKLPVPWPTLVTTFSYGVQCFSRYPDHMKRHDFFKSAMPEGYVQERTIFFKDDGNYKTRAEVKFEGDTLVNRIELKGIDFKEDGNILGHKLEYNYNSHNVYIMADKQKNGIKVNFKIRHNIEDGSVQLADHYQQNTPIGDGPVLLPDNHYLSTQSALSKDPNEKRDHMVLLEFVTAAGITHGMDELYK";
    public static final String GLU_GLU = "EYMPME";
    public static final String GLU_GLU2 = "EFMPME";
    public static final String GST = "MSPILGYWKIKGLVQPTRLLLEYLEEKYEEHLYERDEGDKWRNKKFELGLEFPNLPYYIDGDVKLTQSMAIIRYIADKHNMLGGCPKERAEISMLEGAVLDIRYGVSRIAYSKDFETLKVDFLSKLPEMLKMFEDRLCHKTYLNGDHVTHPDFMLYDALDVVLYMDPMCLDAFPKLVCFKKRIEAIPQIDKYLKSSKYIAWPLQGWQATFGGGDHPPKSDLVPRGSPGIHRD";
    public static final String HA = "YPYDVPDYA";
    public static final String HIS6 = "HHHHHH";
    public static final String HSV = "QPELAPEDPED";
    public static final String HTTPHH = "HTTPHH";
    public static final String IRS = "RYIRS";
    public static final String KT3 = "PPEPET";
    public static final String PROTEINC = "EDQVDPRLIDGK";
    public static final String S_TAG = "KETAAAKFERQHMDS";
    public static final String SBP = "MDEKTTGWRGGHVVEGLAGELEQLRARLEHHPQGQREP";
    public static final String T7 = "MASMTGGQQMG";
    public static final String V5 = "GKPIPNPLLGLDST";
    public static final String VSVG = "MNRLGK";
    private static final float[] MOLWTS = new float[]{71.08f, 0.0f, 103.14f, 115.09f, 129.12f, 147.18f, 57.06f, 137.15f, 113.17f, 0.0f, 128.18f, 113.17f, 131.21f, 114.11f, 0.0f, 97.12f, 128.41f, 156.2f, 87.08f, 101.11f, 0.0f, 99.14f, 186.21f, 0.0f, 163.18f, 0.0f};
    private static final String SEQUENCE_FILTER = "[^*ACDEFGHIKLMNPQRSTVWYacdefghiklmnpqrstvwy]";
    private static final float[] GRAVYTABLE = new float[]{1.8f, 0.0f, 2.5f, -3.5f, -3.5f, 2.8f, -0.4f, -3.2f, 4.5f, 0.0f, -3.9f, 3.8f, 1.9f, -3.5f, 0.0f, -1.6f, -3.5f, -4.5f, -0.8f, -0.7f, 0.0f, 4.2f, -0.9f, 0.0f, -1.3f, 0.0f};
    public static final int EMBOSS = 0;
    public static final int DTASELECT = 1;

    public static String FilterSequence(String Seq) {
        return Seq.replaceAll(SEQUENCE_FILTER, "");
    }

    public static String ReplaceSequence(String SrcSeq, int RepStart, int RepStop, String NewSeq) {
        return Protein.getSequence(SrcSeq, 1, RepStart - 1) + Protein.FilterSequence(NewSeq) + Protein.getSequence(SrcSeq, RepStop + 1, SrcSeq.length());
    }

    public static boolean isValidSequence(String Seq) {
        return Seq.length() == Protein.FilterSequence(Seq).length();
    }

    public Protein() {
    }

    public Protein(String Sequence2) {
        this.sequence = Protein.FilterSequence(Sequence2);
    }

    public static float getGRAVY(String protein) {
        float retVal = 0.0f;
        String fProtein = Protein.FilterSequence(protein.toUpperCase());
        for (int x = 0; x < fProtein.length(); ++x) {
            char chr = fProtein.charAt(x);
            if (chr <= '@' || chr >= '[') continue;
            retVal += GRAVYTABLE[chr - 65];
        }
        return retVal / (float)fProtein.length();
    }

    public static float getMwt(String protein) {
        String fProtein = Protein.FilterSequence(protein.toUpperCase());
        float mwt = 0.0f;
        for (int x = 0; x < fProtein.length(); ++x) {
            char chr = fProtein.charAt(x);
            if (chr <= '@' || chr >= '[') continue;
            mwt += MOLWTS[chr - 65];
        }
        return (mwt + 18.015f) / 100.0f;
    }

    public static float getIP(String protein) {
        return Protein.getIP(protein, 0);
    }

    public static float getIP(String protein, int valueSet) {
        float C_term_pK;
        float Y_pK;
        float C_pK;
        float E_pK;
        float D_pK;
        float H_pK;
        float R_pK;
        float K_pK;
        float N_term_pK;
        float pH = 7.0f;
        float step = 3.5f;
        double charge = 0.0;
        double last_charge = 0.0;
        if (valueSet == 1) {
            N_term_pK = 8.0f;
            K_pK = 10.0f;
            R_pK = 12.0f;
            H_pK = 6.5f;
            D_pK = 4.4f;
            E_pK = 4.4f;
            C_pK = 8.5f;
            Y_pK = 10.0f;
            C_term_pK = 3.1f;
        } else {
            N_term_pK = 8.6f;
            K_pK = 10.8f;
            R_pK = 12.5f;
            H_pK = 6.5f;
            D_pK = 3.9f;
            E_pK = 4.1f;
            C_pK = 8.5f;
            Y_pK = 10.1f;
            C_term_pK = 3.6f;
        }
        int K_count = 0;
        int R_count = 0;
        int H_count = 0;
        int D_count = 0;
        int E_count = 0;
        int C_count = 0;
        int Y_count = 0;
        String fSeq = Protein.FilterSequence(protein).toUpperCase();
        block9: for (int x = 0; x < fSeq.length(); ++x) {
            char chr = fSeq.charAt(x);
            switch (chr) {
                case 'K': {
                    ++K_count;
                    continue block9;
                }
                case 'R': {
                    ++R_count;
                    continue block9;
                }
                case 'H': {
                    ++H_count;
                    continue block9;
                }
                case 'D': {
                    ++D_count;
                    continue block9;
                }
                case 'E': {
                    ++E_count;
                    continue block9;
                }
                case 'C': {
                    ++C_count;
                    continue block9;
                }
                case 'Y': {
                    ++Y_count;
                }
            }
        }
        while (Protein.round(charge = (double)(Protein.partial_charge(N_term_pK, pH) + (float)K_count * Protein.partial_charge(K_pK, pH) + (float)R_count * Protein.partial_charge(R_pK, pH) + (float)H_count * Protein.partial_charge(H_pK, pH) - (float)D_count * Protein.partial_charge(pH, D_pK) - (float)E_count * Protein.partial_charge(pH, E_pK) - (float)C_count * Protein.partial_charge(pH, C_pK) - (float)Y_count * Protein.partial_charge(pH, Y_pK) - Protein.partial_charge(pH, C_term_pK))) != Protein.round(last_charge * 100.0)) {
            pH = charge > 0.0 ? (pH += step) : (pH -= step);
            step /= 2.0f;
            last_charge = charge;
        }
        return pH;
    }

    private static float partial_charge(float first, float second) {
        double charge = Math.pow(10.0, first - second);
        return (float)(charge / (charge + 1.0));
    }

    private static double round(double number) {
        return (double)Math.round(number * 100.0) / 100.0;
    }

    @Override
    public String filterSeq(String seq) {
        return Protein.FilterSequence(seq);
    }

    @Override
    public void resetStoredVariables() {
    }
}

