/*
 * Decompiled with CFR 0.152.
 */
package Sequences;

import ProteinTools.CodonTable;
import SequenceEditorPanels.ROI;
import Sequences.Sequence;
import Sequences.SequenceExportFormat;
import java.util.Arrays;

public class DNA
extends Sequence {
    static CodonTable codonTable = new CodonTable();
    private static final String SEQUENCE_FILTER = "[^atgcnATGCN]";
    private int countAT = -1;
    private int countGC = -1;
    private static final int DISPLAYLINELENGTH = 60;
    private static final String SPLITSTRING = "(?<=\\G.{60})";
    public static final int DISPLAY_ssDNA = 0;
    public static final int DISPLAY_ssDNA1 = 1;
    public static final int DISPLAY_ssDNA2 = 2;
    public static final int DISPLAY_ssDNA3 = 3;
    public static final int DISPLAY_ssDNA123 = 4;
    public static final int DISPLAY_dsDNA = 5;
    public static final int DISPLAY_dsDNA1 = 6;
    public static final int DISPLAY_dsDNA2 = 7;
    public static final int DISPLAY_dsDNA3 = 8;
    public static final int DISPLAY_dsDNA123 = 9;
    public static final int DISPLAY_FORMATTED_SS = 10;
    public static final int DISPLAY_FORMATTED_DS = 11;

    public static String getFormattedSequence(String DNASequence, int displayFormat) {
        return DNA.getFormattedSequence(DNASequence, 1, DNASequence.length(), displayFormat, false);
    }

    public static String getFormattedSequence(String DNASequence, int startingBp, int maxBP, int displayFormat) {
        return DNA.getFormattedSequence(DNASequence, startingBp, maxBP, displayFormat, false);
    }

    public static String getFormattedSequence(String DNASequence, int startingBp, int maxBP, int displayFormat, boolean antisense) {
        startingBp = Math.min(Math.max(1, startingBp), DNASequence.length());
        maxBP = Math.min(Math.max(1, maxBP), DNASequence.length());
        switch (displayFormat) {
            case 0: {
                return DNA.getss_ds_DNAF123(DNASequence, startingBp, maxBP, displayFormat, false, antisense, false, false, false);
            }
            case 1: {
                return DNA.getss_ds_DNAF123(DNASequence, startingBp, maxBP, displayFormat, false, antisense, true, false, false);
            }
            case 2: {
                return DNA.getss_ds_DNAF123(DNASequence, startingBp, maxBP, displayFormat, false, antisense, false, true, false);
            }
            case 3: {
                return DNA.getss_ds_DNAF123(DNASequence, startingBp, maxBP, displayFormat, false, antisense, false, false, true);
            }
            case 4: {
                return DNA.getss_ds_DNAF123(DNASequence, startingBp, maxBP, displayFormat, false, antisense, true, true, true);
            }
            case 5: {
                return DNA.getss_ds_DNAF123(DNASequence, startingBp, maxBP, displayFormat, true, antisense, false, false, false);
            }
            case 6: {
                return DNA.getss_ds_DNAF123(DNASequence, startingBp, maxBP, displayFormat, true, antisense, true, false, false);
            }
            case 7: {
                return DNA.getss_ds_DNAF123(DNASequence, startingBp, maxBP, displayFormat, true, antisense, false, true, false);
            }
            case 8: {
                return DNA.getss_ds_DNAF123(DNASequence, startingBp, maxBP, displayFormat, true, antisense, false, false, true);
            }
            case 9: {
                return DNA.getss_ds_DNAF123(DNASequence, startingBp, maxBP, displayFormat, true, antisense, true, true, true);
            }
            case 10: {
                return DNA.getDNAFormatted(DNASequence, startingBp, maxBP, antisense, false);
            }
            case 11: {
                return DNA.getDNAFormatted(DNASequence, startingBp, maxBP, antisense, true);
            }
        }
        return "";
    }

    private static String getss_ds_DNAF123(String DNASequence, int startingBp, int maxBP, int displayFormat, boolean doubleStranded, boolean antisense, boolean showAA1, boolean showAA2, boolean showAA3) {
        int lineEndNum;
        int x;
        int orientMod;
        String seq;
        if (displayFormat > 4) {
            doubleStranded = true;
        }
        CodonTable.setCodonFormat(CodonTable.LetterCode.eSpaced_1_Letter_Code);
        int maxBpLen = String.valueOf(maxBP).length();
        String BlankHeader = DNA.formatBlankHeader(maxBpLen);
        if (antisense) {
            seq = DNA.getAntisense(DNASequence);
            orientMod = -1;
            x = startingBp + seq.length() - 1;
            if (x > maxBP) {
                x -= maxBP;
            }
            if ((lineEndNum = startingBp - seq.length() - 1) < 0) {
                lineEndNum = maxBP - lineEndNum;
            }
        } else {
            seq = DNASequence;
            orientMod = 1;
            x = startingBp;
            lineEndNum = 0;
        }
        StringBuilder outString = new StringBuilder();
        String[] lines = seq.split(SPLITSTRING);
        String[] lines2 = null;
        if (doubleStranded) {
            lines2 = DNA.pRevAntisense(seq).split(SPLITSTRING);
        }
        String[] AA1lines = new String[]{};
        String[] AA2lines = new String[]{};
        String[] AA3lines = new String[]{};
        if (showAA1) {
            AA1lines = codonTable.translate(seq, 1).split(SPLITSTRING);
        }
        if (showAA2) {
            AA2lines = (" " + codonTable.translate(seq, 2)).split(SPLITSTRING);
        }
        if (showAA3) {
            AA3lines = ("  " + codonTable.translate(seq, 3)).split(SPLITSTRING);
        }
        for (int lineNum = 0; lineNum < lines.length; ++lineNum) {
            lineEndNum = x + orientMod * (lines[lineNum].length() - 1);
            if (lineEndNum > maxBP) {
                lineEndNum -= maxBP;
            } else if (lineEndNum < 0) {
                lineEndNum = maxBP - lineEndNum;
            }
            outString.append(DNA.formatNumberHeader(x, maxBpLen)).append(lines[lineNum]).append(" ").append(lineEndNum).append("\n");
            if (showAA1) {
                outString.append(BlankHeader).append(AA1lines[lineNum]).append("\n");
            }
            if (showAA2) {
                outString.append(BlankHeader).append(AA2lines[lineNum]).append("\n");
            }
            if (showAA3) {
                outString.append(BlankHeader).append(AA3lines[lineNum]).append("\n");
            }
            if (doubleStranded) {
                outString.append(DNA.formatNumberHeader(x, maxBpLen)).append(lines2[lineNum]).append(" ").append(lineEndNum).append("\n\n");
            }
            x = lineEndNum + orientMod;
        }
        return outString.toString();
    }

    private static String getDNAFormatted(String DNASequence, int startingBp, int maxBP, boolean antisense, boolean doubleStranded) {
        int maxBpLen = String.valueOf(maxBP).length();
        StringBuilder outString = new StringBuilder();
        String[] lines = DNASequence.split(SPLITSTRING);
        String[] lines2 = new String[]{};
        if (doubleStranded) {
            lines2 = DNA.pRevAntisense(DNASequence).split(SPLITSTRING);
        }
        int x = startingBp;
        int lineEndNum = 0;
        for (int lineNum = 0; lineNum < lines.length; ++lineNum) {
            lineEndNum = x + lines[lineNum].length() - 1;
            if (lineEndNum > maxBP) {
                lineEndNum -= maxBP;
            }
            outString.append(DNA.formatNumberHeader(x, maxBpLen)).append(String.join((CharSequence)" ", lines[lineNum].split("(?<=\\G.{10})"))).append(" ").append(lineEndNum).append("\n");
            if (doubleStranded) {
                outString.append(DNA.formatNumberHeader(x, maxBpLen)).append(String.join((CharSequence)" ", lines2[lineNum].split("(?<=\\G.{10})"))).append(" ").append(lineEndNum).append("\n\n");
            }
            x = lineEndNum + 1;
        }
        return outString.toString();
    }

    private static String formatNumberHeader(int currentBP, int maxBpLen) {
        String sNum = String.valueOf(currentBP);
        return DNA.repeat(' ', maxBpLen - sNum.length() + 1) + sNum + " ";
    }

    private static String formatBlankHeader(int maxBpLen) {
        return DNA.repeat(' ', maxBpLen + 2);
    }

    private static String repeat(char chr, int num) {
        char[] chars = new char[num];
        Arrays.fill(chars, chr);
        return new String(chars);
    }

    public static String filterSequence(String Seq) {
        return Seq.replaceAll(SEQUENCE_FILTER, "");
    }

    public static String replaceSequence(String SrcSeq, int RepStart, int RepStop, String NewSeq) {
        return Sequence.getSequence(SrcSeq, 1, RepStart - 1) + DNA.filterSequence(NewSeq) + DNA.getSequence(SrcSeq, RepStop + 1, SrcSeq.length());
    }

    public static boolean isValidSequence(String Seq) {
        return Seq.length() == DNA.filterSequence(Seq).length();
    }

    public static int bpNumToCodonNumber(int bpNum) {
        return (bpNum - (bpNum - 1) % 3 - 1) / 3 + 1;
    }

    public static int bpNumToCodonNumber(int bpNum, int ORFStartBp) {
        int bpNum2 = bpNum - (ORFStartBp - 1);
        return (bpNum2 - (bpNum2 - 1) % 3 - 1) / 3 + 1;
    }

    public static int codonNumberToBpStart(int CodonNum, int ORFStartBp) {
        return ORFStartBp + (CodonNum * 3 - 3);
    }

    public static int codonNumberToBpStart(int CodonNum) {
        return CodonNum * 3 - 2;
    }

    public static String complementSequence(String Sequence2) {
        char[] seqBytes = Sequence2.toCharArray();
        return DNA.complementSequence(seqBytes);
    }

    public static String complementSequence(char[] sequence) {
        char[] outSeq = new char[sequence.length];
        block12: for (int i = 0; i < sequence.length; ++i) {
            switch (sequence[i]) {
                case 'a': {
                    outSeq[i] = 116;
                    continue block12;
                }
                case 'A': {
                    outSeq[i] = 84;
                    continue block12;
                }
                case 't': {
                    outSeq[i] = 97;
                    continue block12;
                }
                case 'T': {
                    outSeq[i] = 65;
                    continue block12;
                }
                case 'g': {
                    outSeq[i] = 99;
                    continue block12;
                }
                case 'G': {
                    outSeq[i] = 67;
                    continue block12;
                }
                case 'c': {
                    outSeq[i] = 103;
                    continue block12;
                }
                case 'C': {
                    outSeq[i] = 71;
                    continue block12;
                }
                case 'n': {
                    outSeq[i] = 110;
                    continue block12;
                }
                case 'N': {
                    outSeq[i] = 78;
                }
            }
        }
        return new String(outSeq);
    }

    public static void complementSequenceArray(char[] sequence) {
        block12: for (int i = 0; i < sequence.length; ++i) {
            switch (sequence[i]) {
                case 'a': {
                    sequence[i] = 116;
                    continue block12;
                }
                case 'A': {
                    sequence[i] = 84;
                    continue block12;
                }
                case 't': {
                    sequence[i] = 97;
                    continue block12;
                }
                case 'T': {
                    sequence[i] = 65;
                    continue block12;
                }
                case 'g': {
                    sequence[i] = 99;
                    continue block12;
                }
                case 'G': {
                    sequence[i] = 67;
                    continue block12;
                }
                case 'c': {
                    sequence[i] = 103;
                    continue block12;
                }
                case 'C': {
                    sequence[i] = 71;
                    continue block12;
                }
                case 'n': {
                    sequence[i] = 110;
                    continue block12;
                }
                case 'N': {
                    sequence[i] = 78;
                }
            }
        }
    }

    private static char complement(char chr) {
        switch (chr) {
            case 'A': {
                return 'T';
            }
            case 'T': 
            case 'U': {
                return 'A';
            }
            case 'C': {
                return 'G';
            }
            case 'G': {
                return 'C';
            }
            case 'a': {
                return 't';
            }
            case 't': 
            case 'u': {
                return 'a';
            }
            case 'c': {
                return 'g';
            }
            case 'g': {
                return 'c';
            }
        }
        return chr < '`' ? (char)'N' : 'n';
    }

    private static boolean isCharValid(char chr) {
        switch (chr) {
            case 'A': 
            case 'C': 
            case 'G': 
            case 'T': 
            case 'a': 
            case 'c': 
            case 'g': 
            case 't': {
                return true;
            }
        }
        return false;
    }

    public static void antisense(char[] sequence) {
        if (sequence == null || sequence.length == 0) {
            return;
        }
        int mid = sequence.length / 2;
        int lastIndex = sequence.length - 1;
        for (int i = 0; i <= mid; ++i) {
            char c2;
            int i2 = lastIndex - i;
            char c1 = DNA.complement(sequence[i]);
            sequence[i] = c2 = DNA.complement(sequence[i2]);
            if (1 == i2) break;
            sequence[i2] = c1;
        }
    }

    public static String getAntisense(char[] sequence) {
        return new String(DNA.pAntisenseCharSeq(sequence));
    }

    public static String getAntisense(String sequence) {
        return DNA.pAntisenseSeq(DNA.filterSequence(sequence));
    }

    public static String getReverse(String sequence) {
        return new String(DNA.pReverseChar(DNA.filterSequence(sequence)));
    }

    public static int getTM(String sequence) {
        return DNA.pGetTM(sequence.length(), DNA.getGCCount(sequence), DNA.getATCount(sequence));
    }

    public static int getATCount(String sequence) {
        int count = 0;
        for (int x = 0; x < sequence.length(); ++x) {
            switch (sequence.charAt(x)) {
                case 'A': 
                case 'T': 
                case 'a': 
                case 't': {
                    ++count;
                }
            }
        }
        return count;
    }

    public static int getGCCount(String sequence) {
        int count = 0;
        for (int x = 0; x < sequence.length(); ++x) {
            switch (sequence.charAt(x)) {
                case 'C': 
                case 'G': 
                case 'c': 
                case 'g': {
                    ++count;
                }
            }
        }
        return count;
    }

    public static float getMwt(String sequence) {
        return DNA.getMwt(sequence, false);
    }

    public static float getMwt(String sequence, boolean phosphorylated) {
        float mwt = 0.0f;
        float phos = 79.0f;
        String fSeq = DNA.filterSequence(sequence).toUpperCase();
        block6: for (int x = 0; x < fSeq.length(); ++x) {
            switch (fSeq.charAt(x)) {
                case 'A': {
                    mwt += 313.21f;
                    continue block6;
                }
                case 'C': {
                    mwt += 289.18f;
                    continue block6;
                }
                case 'G': {
                    mwt += 329.21f;
                    continue block6;
                }
                case 'T': {
                    mwt += 304.2f;
                }
            }
        }
        mwt -= 61.96f;
        if (phosphorylated) {
            mwt += phos;
        }
        return mwt;
    }

    public DNA() {
    }

    public DNA(String sequence) {
        this.sequence = DNA.filterSequence(sequence);
    }

    public int getATCount() {
        if (this.countAT == -1) {
            DNA.pGetATGCCounts(this);
        }
        return this.countAT;
    }

    public int getGCCount() {
        if (this.countGC == -1) {
            DNA.pGetATGCCounts(this);
        }
        return this.countGC;
    }

    @Override
    public String filterSeq(String seq) {
        return DNA.filterSequence(seq);
    }

    @Override
    public void resetStoredVariables() {
        this.countAT = -1;
        this.countGC = -1;
    }

    public void setSequence(DNA Sequence2) {
        super.setSequence(Sequence2.sequence);
    }

    public void setSequence(DNA Sequence2, int Start2, int Stop) {
        super.setSequence(Sequence2.getSequence(Start2, Stop));
        this.resetStoredVariables();
    }

    public String getSequence(int bpStart, int bpStop, boolean Antisense) {
        if (!Antisense) {
            return DNA.getSequence(this.sequence, bpStart, bpStop);
        }
        return DNA.pAntisenseSeq(DNA.getSequence(this.sequence, bpStart, bpStop));
    }

    public String getFormattedSequence(int displayFormat) {
        return DNA.getFormattedSequence(this.sequence, 1, this.sequence.length(), displayFormat);
    }

    public String getFormattedSequence(int startBP, int stopBP, boolean antisense, int displayFormat) {
        return DNA.getFormattedSequence(this.getSequence(startBP, stopBP), startBP, this.sequence.length(), displayFormat, antisense);
    }

    public String getAntisense() {
        return DNA.pAntisenseSeq(this.sequence);
    }

    public String getReverse() {
        return new String(DNA.pReverseChar(this.sequence));
    }

    public char[] getReverseAsCharArray() {
        return DNA.pReverseChar(this.sequence);
    }

    public void antisenseSequence() {
        this.sequence = DNA.pAntisenseSeq(this.sequence);
    }

    public static void antisense(SequenceExportFormat sef) {
        if (sef.sequence == null || sef.sequence.length() == 0) {
            return;
        }
        sef.sequence = DNA.getAntisense(sef.sequence);
        if (sef.annotations != null && sef.annotations.length > 0) {
            int seqLen = sef.sequence.length();
            for (ROI roi : sef.annotations) {
                roi.antisense(seqLen);
            }
        }
    }

    public void antisenseSequence(int StartBp, int StopBp) {
        String SequenceText = DNA.pAntisenseSeq(this.getSequence(StartBp, StopBp));
        if (StartBp > StopBp) {
            String leftSeq = DNA.getSequence(SequenceText, 1, StopBp);
            String midSeq = this.getSequence(StopBp + 1, StartBp - 1);
            String rightSeq = DNA.getSequence(SequenceText, StartBp, SequenceText.length());
            this.sequence = leftSeq + midSeq + rightSeq;
        } else {
            this.replace(StartBp, StopBp, DNA.pAntisenseSeq(this.getSequence(StartBp, StopBp)));
        }
    }

    public void reverseSequence() {
        this.sequence = new String(DNA.pReverseChar(this.sequence));
    }

    public void setOrigin(int newOrigin) {
        if (newOrigin < 2 || newOrigin > this.sequence.length()) {
            return;
        }
        this.sequence = this.getSequence(newOrigin, this.sequence.length()) + this.getSequence(1, newOrigin - 1);
    }

    private static void pGetATGCCounts(DNA src) {
        src.countAT = 0;
        src.countGC = 0;
        block4: for (int x = 0; x < src.sequence.length(); ++x) {
            switch (src.sequence.charAt(x)) {
                case 'C': 
                case 'G': 
                case 'c': 
                case 'g': {
                    ++src.countGC;
                    continue block4;
                }
                case 'A': 
                case 'T': 
                case 'a': 
                case 't': {
                    ++src.countAT;
                }
            }
        }
    }

    private static char[] pReverseChar(String sequence) {
        char[] tmp = sequence.toCharArray();
        int right = tmp.length - 1;
        for (int left = 0; left < right; ++left, --right) {
            char tempChar = tmp[left];
            tmp[left] = tmp[right];
            tmp[right] = tempChar;
        }
        return tmp;
    }

    private static int pGetTM(int seqLen, int gcCount, int atCount) {
        if (seqLen < 14) {
            return atCount * 2 + gcCount * 4;
        }
        return (int)Math.round(64.9 + 41.0 * ((double)gcCount - 16.4) / (double)(atCount + gcCount));
    }

    private static String pAntisenseSeq(String sequence) {
        return new String(DNA.pAntisenseCharSeq(sequence.toCharArray()));
    }

    private static char complementChar(char chr) {
        switch (chr) {
            case 'a': {
                return 't';
            }
            case 'A': {
                return 'T';
            }
            case 't': {
                return 'a';
            }
            case 'T': {
                return 'A';
            }
            case 'g': {
                return 'c';
            }
            case 'G': {
                return 'C';
            }
            case 'c': {
                return 'g';
            }
            case 'C': {
                return 'G';
            }
            case 'n': {
                return 'n';
            }
        }
        return 'N';
    }

    private static char ucaseChar(char chr) {
        return (char)(chr > 96 && chr < 123 ? chr - 32 : chr);
    }

    private static char lcaseChar(char chr) {
        return (char)(chr > 64 && chr < 91 ? chr + 32 : chr);
    }

    private static char icaseChar(char chr) {
        if (chr > '@' && chr < '[') {
            return (char)(chr + 32);
        }
        if (chr > '`' && chr < '{') {
            return (char)(chr - 32);
        }
        return chr;
    }

    private static void pAntisenseChars(char[] seqChars) {
        int right = seqChars.length - 1;
        for (int left = 0; left <= right; ++left, --right) {
            char tmp = DNA.complementChar(seqChars[left]);
            seqChars[left] = DNA.complementChar(seqChars[right]);
            if (left == right) continue;
            seqChars[right] = tmp;
        }
    }

    private static char[] pAntisenseCharSeq(char[] seqChars) {
        char[] result = new char[seqChars.length];
        int right = seqChars.length - 1;
        for (int left = 0; left <= right; ++left, --right) {
            result[left] = DNA.complementChar(seqChars[right]);
            if (left == right) continue;
            result[right] = DNA.complementChar(seqChars[left]);
        }
        return result;
    }

    private static String pRevAntisense(String seq) {
        char[] seqChars = seq.toCharArray();
        DNA.pAntisenseChars(seqChars);
        return new String(seqChars);
    }

    public static String DNAtoRegex(String sequence) {
        if (sequence == null || sequence.length() == 0) {
            return "";
        }
        char[] seq = sequence.toUpperCase().toCharArray();
        StringBuilder outString = new StringBuilder();
        block15: for (int x = 0; x < seq.length; ++x) {
            switch (seq[x]) {
                case 'A': 
                case 'C': 
                case 'G': 
                case 'T': {
                    outString.append(seq[x]);
                    continue block15;
                }
                case '-': {
                    outString.append(".*");
                    continue block15;
                }
                case 'N': {
                    outString.append("[ACGT]");
                    continue block15;
                }
                case 'K': {
                    outString.append("[GT]");
                    continue block15;
                }
                case 'M': {
                    outString.append("[AC]");
                    continue block15;
                }
                case 'R': {
                    outString.append("[AG]");
                    continue block15;
                }
                case 'S': {
                    outString.append("[CG]");
                    continue block15;
                }
                case 'B': {
                    outString.append("[CGT]");
                    continue block15;
                }
                case 'D': {
                    outString.append("[AGT]");
                    continue block15;
                }
                case 'H': {
                    outString.append("[ACT]");
                    continue block15;
                }
                case 'V': {
                    outString.append("[ACG]");
                    continue block15;
                }
                case 'W': {
                    outString.append("[AT]");
                    continue block15;
                }
                case 'Y': {
                    outString.append("[CT]");
                }
            }
        }
        return outString.toString();
    }

    public static boolean compare(char c1, char c2) {
        if (c1 == c2 || c1 == 'N' || c2 == 'N') {
            return true;
        }
        switch (c1) {
            case 'A': {
                return c2 == 'R' || c2 == 'W' || c2 == 'M' || c2 == 'D' || c2 == 'H' || c2 == 'V';
            }
            case 'C': {
                return c2 == 'Y' || c2 == 'B' || c2 == 'H' || c2 == 'V' || c2 == 'S';
            }
            case 'G': {
                return c2 == 'R' || c2 == 'S' || c2 == 'K' || c2 == 'B' || c2 == 'D' || c2 == 'V';
            }
            case 'T': 
            case 'U': {
                return c2 == 'Y' || c2 == 'W' || c2 == 'K' || c2 == 'B' || c2 == 'D' || c2 == 'H' || c2 == 'T' || c2 == 'U';
            }
            case 'R': {
                return c2 == 'A' || c2 == 'G';
            }
            case 'Y': {
                return c2 == 'C' || c2 == 'T';
            }
            case 'S': {
                return c2 == 'C' || c2 == 'G';
            }
            case 'W': {
                return c2 == 'A' || c2 == 'T';
            }
            case 'K': {
                return c2 == 'G' || c2 == 'T';
            }
            case 'M': {
                return c2 == 'C' || c2 == 'A';
            }
            case 'B': {
                return c2 == 'C' || c2 == 'G' || c2 == 'T';
            }
            case 'D': {
                return c2 == 'A' || c2 == 'G' || c2 == 'T';
            }
            case 'H': {
                return c2 == 'C' || c2 == 'A' || c2 == 'T';
            }
            case 'V': {
                return c2 == 'C' || c2 == 'G' || c2 == 'A';
            }
        }
        return false;
    }
}

