/*
 * Decompiled with CFR 0.152.
 */
package SequenceEditorPanels;

import GenbankFileReader.Qualifier;
import GenbankFileReader.Reference;
import SequenceEditorPanels.ExtensibleArray;
import SequenceEditorPanels.SequenceDocumentChangeListener;
import UndoRedo.ChangeEvent;
import UndoRedo.UndoRedoManager;
import UndoRedo.Undoable;
import java.util.Vector;

public abstract class SequenceDocument<T> {
    public static final int PROPERTY_NAME = 0;
    public static final int PROPERTY_ORGANISM = 1;
    public static final int PROPERTY_SOURCE = 2;
    public static final int PROPERTY_ACCESSION = 3;
    public static final int PROPERTY_SEQUENCE_CHANGED = 4;
    public static final int PROPERTY_CODON_TABLE_CHANGED = 5;
    public static final int PROPERTY_TOPOLOGY = 6;
    public static final int PROPERTY_DOCUMENT_LOADED = 7;
    public static final int PROPERTY_DOCUMENT_CLOSED = 8;
    public static final int PROPERTY_DOCUMENT_SAVED = 9;
    public static final int PROPERTY_DOCUMENT_CHANGED = 10;
    public static final int PROPERTY_UNDOREDO = 100;
    public static final int PROPERTY_LAST_PROPERTY = 100;
    protected UndoRedoManager undoManager = new UndoRedoManager(){

        @Override
        public void undoRedoOccurred() {
            SequenceDocument.this.fireEvents(new ChangeEvent(100));
        }
    };
    private final Vector<SequenceDocumentChangeListener> listeners = new Vector();
    protected boolean listenersEnabled = true;
    protected final ExtensibleArray<Reference> references = new ExtensibleArray<Reference>(Reference.class);
    protected final ExtensibleArray<Qualifier> qualifiers = new ExtensibleArray<Qualifier>(Qualifier.class);
    protected boolean changed = false;
    protected boolean seqChanged = false;
    protected String name = "New Sequence";
    protected boolean circular = false;

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    public void undo() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
    }

    public void redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    public void addEdit(Undoable edit) {
        this.undoManager.addEdit(edit);
    }

    public void runEdit(Undoable edit) {
        if (edit.runRedo()) {
            this.undoManager.addEdit(edit);
        }
    }

    public String getRedoText() {
        return this.undoManager.getRedoName();
    }

    public String getUndoText() {
        return this.undoManager.getUndoName();
    }

    public void fireEvents(ChangeEvent ... events) {
        if (this.isListenerActive()) {
            for (SequenceDocumentChangeListener l : this.listeners) {
                l.propertyChanged(events);
            }
        }
    }

    public void fireEvents(int ... events) {
        if (this.isListenerActive()) {
            for (SequenceDocumentChangeListener l : this.listeners) {
                for (int x = 0; x < events.length; ++x) {
                    l.propertyChanged(new ChangeEvent(events[x]));
                }
            }
        }
    }

    public void setListenersEnabled(boolean enabled) {
        this.listenersEnabled = enabled;
    }

    public boolean disableListeners() {
        boolean wasEnabled = this.listenersEnabled;
        this.listenersEnabled = false;
        return wasEnabled;
    }

    public boolean isListenersEnabled() {
        return this.listenersEnabled;
    }

    public int getReferenceCount() {
        return this.references.size();
    }

    public Reference getReference(int index) {
        return this.references.get(index);
    }

    public void addReference(Reference reference) {
        this.references.add(reference);
        this.fireEvents(new ChangeEvent(10, this.changed, this.seqChanged));
    }

    public void removeReference(Reference reference) {
        this.references.remove(reference);
        this.fireEvents(new ChangeEvent(10, this.changed, this.seqChanged));
    }

    public int getQualifiersCount() {
        return this.qualifiers.size();
    }

    public Qualifier getQualifier(int index) {
        return this.qualifiers.get(index);
    }

    public void addQualifier(Qualifier qualifier) {
        this.qualifiers.add(qualifier);
        this.fireEvents(new ChangeEvent(10, this.changed, this.seqChanged));
    }

    public void removeQualifier(Qualifier qualifier) {
        this.qualifiers.remove(qualifier);
        this.fireEvents(new ChangeEvent(10, this.changed, this.seqChanged));
    }

    public boolean isListenerActive() {
        return !this.listeners.isEmpty() && this.listenersEnabled;
    }

    public void addListener(SequenceDocumentChangeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(SequenceDocumentChangeListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public boolean isChanged() {
        return this.changed | this.seqChanged;
    }

    public void setChanged(boolean changed) {
        if (this.changed != changed) {
            this.changed = changed;
            if (!changed) {
                this.seqChanged = false;
            }
            if (!this.seqChanged) {
                this.fireEvents(new ChangeEvent(10, changed, this.seqChanged));
            } else {
                this.fireEvents(new ChangeEvent(10, changed, this.seqChanged), new ChangeEvent(4));
            }
        }
    }

    public boolean isSeqChanged() {
        return this.seqChanged;
    }

    public void setSeqChanged(boolean seqChanged) {
        this.seqChanged = seqChanged;
    }

    public String getName() {
        return this.name != null ? this.name : "Unnamed Sequence";
    }

    public void setName(String newName) {
        if (newName != null) {
            this.name = newName;
        }
    }

    public boolean isCircular() {
        return this.circular;
    }

    public void setCircular(boolean isCircular) {
        if (this.circular != isCircular) {
            this.circular = isCircular;
            this.fireEvents(new ChangeEvent(6, !isCircular, isCircular));
        }
    }
}

