/*
 * Decompiled with CFR 0.152.
 */
package SequenceEditorPanels;

import ProteinTools.AminoAcid;
import java.util.Arrays;

public class Base {
    protected char base = '\u0000';
    protected char aBase = '\u0000';
    protected AminoAcid AA = null;
    protected AminoAcid aAA = null;

    public Base() {
    }

    public Base(char base) {
        this.setBase(base);
    }

    public void setBase(char base) {
        this.base = base;
        this.aBase = Base.complement(base);
    }

    public void complement() {
        char tmp = this.aBase;
        this.aBase = this.base;
        this.base = tmp;
    }

    public char getBase() {
        return this.base;
    }

    public char getAntisenseBase() {
        return this.aBase;
    }

    public boolean lowercase() {
        if (this.base > '@' && this.base < '[') {
            this.base = (char)(this.base + 32);
            this.aBase = (char)(this.aBase + 32);
            return true;
        }
        return false;
    }

    public boolean uppercase() {
        if (this.base > '`' && this.base < '{') {
            this.base = (char)(this.base - 32);
            this.aBase = (char)(this.aBase - 32);
            return true;
        }
        return false;
    }

    private static char complement(char chr) {
        switch (chr) {
            case 'A': {
                return 'T';
            }
            case 'T': 
            case 'U': {
                return 'A';
            }
            case 'C': {
                return 'G';
            }
            case 'G': {
                return 'C';
            }
            case 'a': {
                return 't';
            }
            case 't': 
            case 'u': {
                return 'a';
            }
            case 'c': {
                return 'g';
            }
            case 'g': {
                return 'c';
            }
        }
        return '\u0000';
    }

    public static boolean isCharValid(char chr) {
        switch (chr) {
            case 'A': 
            case 'C': 
            case 'G': 
            case 'T': 
            case 'a': 
            case 'c': 
            case 'g': 
            case 't': {
                return true;
            }
        }
        return false;
    }

    public static Base[] toBaseArray(char[] seq) {
        if (seq.length == 0) {
            return null;
        }
        Base[] outBases = new Base[seq.length];
        int validCount = 0;
        for (int x = 0; x < seq.length; ++x) {
            if (!Base.isCharValid(seq[x])) continue;
            outBases[validCount] = new Base(seq[x]);
            ++validCount;
        }
        if (validCount == 0) {
            return null;
        }
        if (validCount < seq.length) {
            outBases = Arrays.copyOf(outBases, validCount);
        }
        return outBases;
    }
}

