/*
 * Decompiled with CFR 0.152.
 */
package SequenceBuilders;

import ProteinTools.AminoAcid;
import ProteinTools.AminoAcids;
import SequenceBuilders.ObjectChain;

public class ProteinBuilder
extends ObjectChain<AminoAcid> {
    public ProteinBuilder() {
    }

    public ProteinBuilder(String sequence) {
        this(sequence.toCharArray(), false);
    }

    public ProteinBuilder(String sequence, boolean circular) {
        this(sequence.toCharArray(), circular);
    }

    public ProteinBuilder(char[] sequence) {
        this(sequence, false);
    }

    public ProteinBuilder(char[] sequence, boolean circular) {
        this.circular = circular;
        if (sequence == null || sequence.length == 0) {
            return;
        }
        AminoAcids aminoAcids = AminoAcids.getDefaultAminoAcids();
        for (int x = 0; x < sequence.length; ++x) {
            AminoAcid aa = aminoAcids.getAA(sequence[x]);
            if (aa == null) continue;
            this.add(aa);
        }
    }

    public String toString() {
        char[] chars = new char[this.count];
        ObjectChain.Node node = this.root.next;
        for (int x = 0; x < this.count; ++x) {
            chars[x] = ((AminoAcid)node.next.object).getAbbr1();
            node = node.next;
        }
        return new String(chars);
    }
}

