/*
 * Decompiled with CFR 0.152.
 */
package ScrollableSearchablePopupMenu;

import ScrollableSearchablePopupMenu.SearchPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ScrollSearchPopupMenu
extends JPopupMenu {
    private static final int TEXT_FIELD_WIDTH = 200;
    private static final int TEXT_FIELD_HEIGHT = 25;
    private static final int MENU_ITEM_HEIGHT = 25;
    private static final int SCROLLER_ITEM_HEIGHT = 20;
    private JTextField textField;
    private SearchPanel topPanel;
    private ArrayList<Component> topFixedItems = new ArrayList();
    private ArrayList<Component> bottomFixedItems = new ArrayList();
    private ArrayList<JMenuItem> scrollItems = new ArrayList();
    private final ArrayList<JMenuItem> matchingItems = new ArrayList();
    private ArrayList<Component> displayedMenuItems = new ArrayList();
    private Component lastInvoker;
    private int lastX;
    private int lastY;
    private Comparator cSortAZ = new Comparator<JMenuItem>(){

        @Override
        public int compare(JMenuItem o1, JMenuItem o2) {
            return o1.getText().compareToIgnoreCase(o2.getText());
        }
    };
    private Comparator cSortZA = new Comparator<JMenuItem>(){

        @Override
        public int compare(JMenuItem o1, JMenuItem o2) {
            return o2.getText().compareToIgnoreCase(o1.getText());
        }
    };
    private MenuScrollItem upItem;
    private MenuScrollItem downItem;
    private final MenuScrollListener menuListener = new MenuScrollListener();
    private int scrollCount;
    private int interval;
    private int topFixedCount;
    private int bottomFixedCount;
    private int firstIndex = 0;
    public static final int TRIGGER_ON_MOUSE_CLICK = 0;
    public static final int TRIGGER_ON_MOUSE_OVER = 1;
    private int scrollTrigger = 1;
    private int lastHt = 0;
    private int lastWd = 0;
    boolean isUpdating = false;
    private MouseWheelListener scrollListener = new MouseWheelListener(){

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getWheelRotation() < 0) {
                if (ScrollSearchPopupMenu.this.firstIndex > 0) {
                    ScrollSearchPopupMenu.this.scroll(-1);
                }
            } else if (ScrollSearchPopupMenu.this.firstIndex >= 0 && ScrollSearchPopupMenu.this.firstIndex < ScrollSearchPopupMenu.this.matchingItems.size() - ScrollSearchPopupMenu.this.scrollCount + 1) {
                ScrollSearchPopupMenu.this.scroll(1);
            }
        }
    };

    public ScrollSearchPopupMenu() {
        this.initUI(null);
    }

    public ScrollSearchPopupMenu(Icon icon) {
        this.initUI(icon);
    }

    private void initUI(Icon icon) {
        this.addMouseWheelListener(this.scrollListener);
        this.topPanel = new SearchPanel();
        this.textField = this.topPanel.textField;
        if (icon != null) {
            this.topPanel.iconLabel.setIcon(icon);
        }
        this.add((Component)this.topPanel, 0);
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ScrollSearchPopupMenu.this.filterMenuItems();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ScrollSearchPopupMenu.this.filterMenuItems();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ScrollSearchPopupMenu.this.filterMenuItems();
            }
        });
        this.topPanel.cmdSortAZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScrollSearchPopupMenu.this.sortAZ();
            }
        });
        this.topPanel.cmdSortZA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScrollSearchPopupMenu.this.sortZA();
            }
        });
        this.setupScroller(10);
        this.setScrollTrigger(1);
        this.textField.addActionListener(e -> this.doClick());
    }

    private void doClick() {
        MenuElement highlightedElement;
        MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
        if (path != null && path.length > 0 && (highlightedElement = path[path.length - 1]) instanceof JMenuItem) {
            JMenuItem highlightedItem = (JMenuItem)highlightedElement;
            highlightedItem.doClick();
        }
    }

    public String getSearchText() {
        return this.textField.getText();
    }

    public void setSearchText(String text) {
        this.textField.setText(text);
    }

    private void filterMenuItems() {
        this.firstIndex = 0;
        String filter = this.textField.getText().toLowerCase();
        while (this.getComponentCount() > 1) {
            this.remove(1);
        }
        int fLen = filter.length();
        this.matchingItems.clear();
        for (JMenuItem item : this.scrollItems) {
            if (fLen != 0 && !item.getText().toLowerCase().contains(filter)) continue;
            this.matchingItems.add(item);
        }
        this.refreshMenuItems();
    }

    @Override
    public JMenuItem add(JMenuItem item) {
        this.addScrollItem(item);
        return item;
    }

    public void addTopFixedItem(Component c) {
        this.addTopFixedItem(c, true);
    }

    public void addScrollItem(JMenuItem menuItem) {
        this.addScrollItem(menuItem, true);
    }

    public void addBottomFixedItem(Component c) {
        this.addBottomFixedItem(c, true);
    }

    public void removeTopFixedItem(Component menuItem) {
        this.removeTopFixedItem(menuItem, true);
    }

    public void removeScrollItem(Component menuItem) {
        this.removeScrollItem(menuItem, true);
    }

    public void removeBottomFixedItem(Component menuItem) {
        this.removeBottomFixedItem(menuItem, true);
    }

    public void removeAllTopFixedItems() {
        this.removeAllTopFixedItems(true);
    }

    public void removeAllScrollItems() {
        this.removeAllScrollItems(true);
    }

    public void removeAllBottomFixedItems() {
        this.removeAllBottomFixedItems(true);
    }

    public void addScrollItem(JMenuItem menuItem, boolean refresh) {
        if (menuItem != null) {
            this.scrollItems.add(menuItem);
            this.setMenuItemFixedHeight(menuItem);
            if (refresh && this.isVisible()) {
                this.refreshMenu();
            }
        }
    }

    public void addTopFixedItem(Component c, boolean refresh) {
        if (c != null) {
            this.topFixedItems.add(c);
            if ((c instanceof JPopupMenu.Separator || c instanceof JMenuItem) && c instanceof JMenuItem) {
                this.setMenuItemFixedHeight((JMenuItem)c);
            }
            if (refresh && this.isVisible()) {
                this.refreshMenu();
            }
        }
    }

    public void addBottomFixedItem(Component c, boolean refresh) {
        if (c != null) {
            this.bottomFixedItems.add(c);
            if (c instanceof JPopupMenu.Separator || c instanceof JMenuItem) {
                this.setMenuItemFixedHeight(c);
            }
            if (refresh && this.isVisible()) {
                this.refreshMenu();
            }
        }
    }

    public void removeTopFixedItem(Component menuItem, boolean refresh) {
        if (menuItem != null) {
            this.topFixedItems.remove(menuItem);
            if (refresh && this.isVisible()) {
                this.refreshMenu();
            }
        }
    }

    public void removeBottomFixedItem(Component menuItem, boolean refresh) {
        if (menuItem != null) {
            this.bottomFixedItems.remove(menuItem);
            if (refresh && this.isVisible()) {
                this.refreshMenu();
            }
        }
    }

    public void removeAllTopFixedItems(boolean refresh) {
        if (!this.topFixedItems.isEmpty()) {
            this.topFixedItems.clear();
            if (refresh && this.isVisible()) {
                this.refreshMenu();
            }
        }
    }

    public void removeAllBottomFixedItems(boolean refresh) {
        if (!this.bottomFixedItems.isEmpty()) {
            this.bottomFixedItems.clear();
            if (refresh && this.isVisible()) {
                this.refreshMenu();
            }
        }
    }

    public void removeAllScrollItems(boolean refresh) {
        if (!this.scrollItems.isEmpty()) {
            this.scrollItems.clear();
            if (refresh && this.isVisible()) {
                this.refreshMenu();
            }
        }
    }

    public void removeScrollItem(Component menuItem, boolean refresh) {
        if (this.scrollItems.contains(menuItem)) {
            this.scrollItems.remove(menuItem);
            if (this.isVisible() && this.matchingItems.contains(menuItem)) {
                this.matchingItems.remove(menuItem);
                if (refresh) {
                    this.refreshMenu();
                }
            }
        }
    }

    public JMenuItem[] getScrollItems() {
        JMenuItem[] items = new JMenuItem[this.scrollItems.size()];
        this.scrollItems.toArray(items);
        return items;
    }

    private void setMenuItemFixedHeight(Component item) {
        Dimension d = new Dimension(item.getPreferredSize().width, 25);
        item.setPreferredSize(d);
        item.setMinimumSize(new Dimension(Integer.MIN_VALUE, 25));
        item.setMaximumSize(new Dimension(Integer.MAX_VALUE, 25));
    }

    private void addMenuItemDirect(Component item) {
        super.add(item);
    }

    public void showPopup(Component invoker, int x, int y) {
        this.lastInvoker = invoker;
        this.lastX = x;
        this.lastY = y;
        super.show(invoker, x, y);
    }

    @Override
    public void show(Component invoker, int x, int y) {
        super.show(invoker, x, y);
        this.filterMenuItems();
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public JLabel getIconLabel() {
        return this.topPanel.iconLabel;
    }

    public void sortAZ() {
        this.sort(this.cSortAZ);
    }

    public void sortZA() {
        this.sort(this.cSortZA);
    }

    private void sort(Comparator c) {
        this.matchingItems.sort(c);
        this.firstIndex = 0;
        this.refreshMenuItems();
        this.repaint();
    }

    public JButton getButtonX() {
        return this.topPanel.cmdX;
    }

    public JButton getButtonAZ() {
        return this.topPanel.cmdSortAZ;
    }

    public JButton getButtonZA() {
        return this.topPanel.cmdSortZA;
    }

    public int getScrollTrigger() {
        return this.scrollTrigger;
    }

    public void setScrollTrigger(int trigger) {
        if (trigger < 0 || trigger > 1) {
            return;
        }
        this.scrollTrigger = trigger;
    }

    private void setupScroller(int scrollCount) {
        this.setupScroller(scrollCount, 150);
    }

    private void setupScroller(int scrollCount, int interval) {
        if (scrollCount <= 0 || interval <= 0) {
            throw new IllegalArgumentException("scrollCount and interval must be greater than 0");
        }
        if (this.topFixedCount < 0 || this.bottomFixedCount < 0) {
            throw new IllegalArgumentException("topFixedCount and bottomFixedCount cannot be negative");
        }
        this.upItem = new MenuScrollItem(new MenuIcon(MenuIcon.UP), -1);
        this.downItem = new MenuScrollItem(new MenuIcon(MenuIcon.DOWN), 1);
        this.setMenuScrollerFixedHeight(this.upItem);
        this.setMenuScrollerFixedHeight(this.downItem);
        this.setScrollCount(scrollCount);
        this.setInterval(interval);
        this.addPopupMenuListener(this.menuListener);
    }

    public MenuScrollItem getMenuScrollUpItem() {
        return this.upItem;
    }

    public MenuScrollItem getMenuScrollDownItem() {
        return this.downItem;
    }

    private void setMenuScrollerFixedHeight(JMenuItem item) {
        Dimension d = new Dimension(200, 20);
        item.setPreferredSize(d);
        item.setMinimumSize(new Dimension(Integer.MIN_VALUE, 20));
        item.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
    }

    public int getInterval() {
        return this.interval;
    }

    public final void setInterval(int interval) {
        if (interval <= 0) {
            throw new IllegalArgumentException("interval must be greater than 0");
        }
        this.upItem.setInterval(interval);
        this.downItem.setInterval(interval);
        this.interval = interval;
    }

    public int getscrollCount() {
        return this.scrollCount;
    }

    public final void setScrollCount(int scrollCount) {
        if (scrollCount <= 0) {
            throw new IllegalArgumentException("scrollCount must be greater than 0");
        }
        this.scrollCount = scrollCount;
        MenuSelectionManager.defaultManager().clearSelectedPath();
    }

    public void dispose() {
        this.removePopupMenuListener(this.menuListener);
    }

    public void refreshMenu() {
        this.refreshMenuItems();
    }

    private void refreshMenuItems() {
        this.displayedMenuItems.clear();
        this.displayedMenuItems.add(this.topPanel);
        for (Component component : this.topFixedItems) {
            this.displayedMenuItems.add(component);
        }
        if (!this.matchingItems.isEmpty()) {
            if (this.matchingItems.size() <= this.scrollCount) {
                this.firstIndex = 0;
                for (Component component : this.matchingItems) {
                    this.displayedMenuItems.add(component);
                }
            } else {
                int lastIndex;
                this.displayedMenuItems.add(this.upItem);
                if (this.firstIndex + this.scrollCount > this.matchingItems.size()) {
                    this.firstIndex = this.matchingItems.size() - this.scrollCount;
                    lastIndex = this.matchingItems.size();
                } else {
                    lastIndex = this.scrollCount + this.firstIndex;
                }
                int n = this.matchingItems.size() - (this.bottomFixedCount + this.topFixedCount);
                boolean showScrollers = n > this.scrollCount;
                this.displayedMenuItems.add(this.upItem);
                for (int index = this.firstIndex; index < lastIndex; ++index) {
                    Component i = this.matchingItems.get(index);
                    this.displayedMenuItems.add(i);
                }
                this.displayedMenuItems.add(this.downItem);
                this.upItem.setEnabled(showScrollers && this.firstIndex > this.topFixedCount);
                this.downItem.setEnabled(showScrollers && this.scrollCount + this.firstIndex < this.matchingItems.size());
            }
        }
        for (Component component : this.bottomFixedItems) {
            this.displayedMenuItems.add(component);
        }
        this.removeAll();
        for (Component component : this.displayedMenuItems) {
            this.addMenuItemDirect(component);
        }
        boolean focus = this.textField.hasFocus();
        this.resizeToFitComponents();
        if (focus) {
            this.textField.requestFocus();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.lastWd, this.lastHt);
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(new Dimension(this.lastWd, this.lastHt));
    }

    public void resizeToFitComponents() {
        Dimension pref;
        int maxWidth = 0;
        int totalHeight = 0;
        for (Component component : this.topFixedItems) {
            component.doLayout();
            pref = component.getPreferredSize();
            if (pref.width <= maxWidth) continue;
            maxWidth = pref.width;
        }
        for (Component component : this.matchingItems) {
            component.doLayout();
            pref = component.getPreferredSize();
            if (pref.width <= maxWidth) continue;
            maxWidth = pref.width;
        }
        for (Component component : this.bottomFixedItems) {
            component.doLayout();
            pref = component.getPreferredSize();
            if (pref.width <= maxWidth) continue;
            maxWidth = pref.width;
        }
        for (Component comp : this.getComponents()) {
            comp.doLayout();
            Dimension pref2 = comp.getPreferredSize();
            totalHeight += pref2.height;
        }
        Insets insets = this.getInsets();
        if (maxWidth < 200) {
            maxWidth = 200;
        }
        if (totalHeight < 25) {
            totalHeight = this.topPanel.getHeight();
        }
        int n = maxWidth + insets.left + insets.right;
        int finalHeight = totalHeight + insets.top + insets.bottom;
        boolean reset = this.lastHt != finalHeight || this.lastWd != n;
        this.lastHt = finalHeight;
        this.lastWd = n;
        this.isUpdating = true;
        if (this.isVisible() && this.lastInvoker != null) {
            if (reset) {
                this.setVisible(false);
            }
            SwingUtilities.invokeLater(() -> {
                super.show(this.lastInvoker, this.lastX, this.lastY);
                this.revalidate();
                this.isUpdating = false;
                this.textField.requestFocus();
            });
        }
    }

    private void scroll(int increment) {
        this.firstIndex += increment;
        this.refreshMenuItems();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("PopupMenuWithTextFieldv2 Demo");
            frame.setDefaultCloseOperation(3);
            frame.setSize(400, 300);
            frame.setLayout(new FlowLayout());
            JButton button = new JButton("Right-click me!");
            frame.add(button);
            final ScrollSearchPopupMenu popupMenu = new ScrollSearchPopupMenu();
            popupMenu.getMenuScrollUpItem().setText("\u2191 More...");
            popupMenu.getMenuScrollDownItem().setText("\u2193 More...");
            popupMenu.addTopFixedItem(new JMenuItem("Top"));
            popupMenu.addTopFixedItem(new JPopupMenu.Separator());
            final JMenuItem mnuApple = new JMenuItem("Apple");
            popupMenu.add(mnuApple);
            popupMenu.addScrollItem(new JMenuItem("Banana"));
            popupMenu.addScrollItem(new JMenuItem("Cherry"));
            popupMenu.addScrollItem(new JMenuItem("Date"));
            popupMenu.addScrollItem(new JMenuItem("Elderberry"));
            popupMenu.addScrollItem(new JMenuItem("Fig"));
            popupMenu.addScrollItem(new JMenuItem("Grape"));
            popupMenu.addScrollItem(new JMenuItem("Honeydew"));
            popupMenu.addScrollItem(new JMenuItem("Apple2"));
            popupMenu.addScrollItem(new JMenuItem("Banana2"));
            popupMenu.addScrollItem(new JMenuItem("Cherry2"));
            popupMenu.addScrollItem(new JMenuItem("Date2"));
            popupMenu.addScrollItem(new JMenuItem("Honeydew2 - Honeydew2 - Honeydew2 - Honeydew2"));
            popupMenu.addScrollItem(new JMenuItem("Elderberry2"));
            popupMenu.addScrollItem(new JMenuItem("Fig2"));
            popupMenu.addScrollItem(new JMenuItem("Grape2"));
            popupMenu.addScrollItem(new JMenuItem("Honeydew2"));
            popupMenu.addBottomFixedItem(new JPopupMenu.Separator());
            popupMenu.addBottomFixedItem(new JMenuItem("Bot"));
            popupMenu.getButtonX().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    popupMenu.removeScrollItem(mnuApple);
                }
            });
            button.setComponentPopupMenu(popupMenu);
            button.addActionListener(e -> {
                popupMenu.showPopup(button, 0, button.getHeight());
                popupMenu.getTextField().requestFocusInWindow();
            });
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
        });
    }

    private class MenuScrollListener
    implements PopupMenuListener {
        private MenuScrollListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            if (!ScrollSearchPopupMenu.this.isUpdating) {
                ScrollSearchPopupMenu.this.filterMenuItems();
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (!ScrollSearchPopupMenu.this.isUpdating) {
                ScrollSearchPopupMenu.this.firstIndex = 0;
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    public class MenuScrollItem
    extends JMenuItem
    implements ChangeListener {
        private MenuScrollTimer timer;

        public MenuScrollItem(MenuIcon icon, int increment) {
            this.setIcon(icon);
            this.setDisabledIcon(icon);
            this.timer = new MenuScrollTimer(increment, ScrollSearchPopupMenu.this.interval);
            this.addChangeListener(this);
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (MenuScrollItem.this.isEnabled() && ScrollSearchPopupMenu.this.scrollTrigger == 0 && !MenuScrollItem.this.timer.isRunning()) {
                        MenuScrollItem.this.getModel().setArmed(true);
                        MenuScrollItem.this.timer.start();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (MenuScrollItem.this.isEnabled() && ScrollSearchPopupMenu.this.scrollTrigger == 0 && MenuScrollItem.this.timer.isRunning()) {
                        MenuScrollItem.this.getModel().setArmed(false);
                        MenuScrollItem.this.timer.stop();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (MenuScrollItem.this.isEnabled() && ScrollSearchPopupMenu.this.scrollTrigger == 1 && !MenuScrollItem.this.timer.isRunning()) {
                        MenuScrollItem.this.getModel().setArmed(true);
                        MenuScrollItem.this.timer.start();
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (MenuScrollItem.this.isEnabled() && ScrollSearchPopupMenu.this.scrollTrigger == 1 && MenuScrollItem.this.timer.isRunning()) {
                        MenuScrollItem.this.getModel().setArmed(false);
                        MenuScrollItem.this.timer.stop();
                    }
                }
            });
        }

        public void setInterval(int interval) {
            this.timer.setDelay(interval);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (ScrollSearchPopupMenu.this.scrollTrigger == 1) {
                if (this.isArmed() && !this.timer.isRunning()) {
                    this.timer.start();
                }
                if (!this.isArmed() && this.timer.isRunning()) {
                    this.timer.stop();
                }
            }
        }
    }

    private static class MenuIcon
    implements Icon {
        public static int UP = 0;
        public static int DOWN = 1;
        int[] up = new int[]{9, 1, 9};
        int[] down = new int[]{1, 9, 1};
        final int[] xPoints = new int[]{1, 5, 9};
        final int[] yPoints;

        MenuIcon(int direction) {
            this.yPoints = direction == UP ? this.up : this.down;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Dimension size = c.getSize();
            Graphics g2 = g.create(size.width / 2 - 5, size.height / 2 - 5, 10, 10);
            g2.setColor(Color.GRAY);
            g2.drawPolygon(this.xPoints, this.yPoints, 3);
            g2.setColor(!c.isEnabled() ? Color.GRAY : Color.BLACK);
            g2.fillPolygon(this.xPoints, this.yPoints, 3);
            g2.dispose();
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }

    private class MenuScrollTimer
    extends Timer {
        public MenuScrollTimer(final int increment, int interval) {
            super(interval, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScrollSearchPopupMenu.this.scroll(increment);
                }
            });
        }
    }
}

