/*
 * Decompiled with CFR 0.152.
 */
package ScrollPanels;

import JMConstants.Constants;
import JMScrollBars.JMScrollBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.BeanProperty;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.GroupLayout;
import javax.swing.JPanel;

public class ScrollPanel
extends JPanel
implements MouseWheelListener,
MouseListener,
MouseMotionListener,
FocusListener,
Constants {
    String versionID = "1.00.00";
    boolean loading = true;
    Font mFont = this.getFont();
    KeyEventDispatcher keyEventDispatcher = new KeyEventDispatcher(){

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            Component owner = FocusManager.getCurrentManager().getFocusOwner();
            if (owner == ScrollPanel.this.displayPanel || owner == ScrollPanel.this.me()) {
                switch (e.getID()) {
                    case 401: {
                        return ScrollPanel.this.displayPanelKeyPressed(e);
                    }
                    case 402: {
                        return ScrollPanel.this.displayPanelKeyReleased(e);
                    }
                    case 400: {
                        return ScrollPanel.this.displayPanelKeyTyped(e);
                    }
                }
            }
            return false;
        }
    };
    private static final int LISTENER_KEYS = 0;
    private static final int LISTENER_MOUSE = 1;
    private static final int LISTENER_MOUSEMOTION = 2;
    private static final int LISTENER_MOUSEWHEEL = 3;
    private static final int LISTENER_FOCUSGAINED = 4;
    private static final int LISTENER_FOCUSLOST = 5;
    final boolean[] activeListeners = new boolean[]{true, true, false, true, false, false};
    int panelHeight = 0;
    int panelWidth = 0;
    BufferedImage panelBuffer = null;
    Graphics panelGraphics = null;
    public JPanel displayPanel;
    public JMScrollBar hScroll;
    public JMScrollBar vScroll;

    @Override
    public void focusGained(FocusEvent arg0) {
        if (this.activeListeners[0]) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyEventDispatcher);
        }
        if (this.activeListeners[4]) {
            this.displayPanelFocusGained();
        }
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        if (this.activeListeners[0]) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyEventDispatcher);
        }
        if (this.activeListeners[5]) {
            this.displayPanelFocusLost();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.displayPanelMouseWheelMoved(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.displayPanelMouseClicked(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.displayPanel.requestFocus();
        this.displayPanelMousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.displayPanelMouseReleased(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.displayPanelMouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.displayPanelMouseExited(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.displayPanelMouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.displayPanelMouseMoved(e);
    }

    ScrollPanel me() {
        return this;
    }

    public int fontHeight() {
        return this.displayPanel.getGraphics().getFontMetrics().getHeight();
    }

    public int fontWidth() {
        return this.displayPanel.getGraphics().getFontMetrics().charWidth(' ');
    }

    @Override
    @BeanProperty(preferred=true)
    public void setFont(Font font) {
        super.setFont(font);
        if (this.displayPanel != null) {
            this.displayPanel.setFont(font);
        }
        this.mFont = font;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.displayPanel.setEnabled(enabled);
        this.hScroll.setEnabled(enabled);
        this.vScroll.setEnabled(enabled);
    }

    @BeanProperty(hidden=true)
    public JMScrollBar getHScrollBar() {
        return this.hScroll;
    }

    @BeanProperty(hidden=true)
    public JMScrollBar getVScrollBar() {
        return this.vScroll;
    }

    @BeanProperty(hidden=true, visualUpdate=true, description="The background color of the scrollbars.")
    public void setScrollbarTrackColors(Color color) {
        this.hScroll.setTrackColors(color);
        this.vScroll.setTrackColors(color);
        this.repaint();
    }

    public Color getScrollbarTrackColor() {
        return this.hScroll.getTrackColor();
    }

    @BeanProperty(preferred=true, visualUpdate=true, description="The background color of the scrollbars.")
    public void setScrollbarTrackColor(Color color) {
        this.hScroll.setTrackColor(color);
        this.vScroll.setTrackColor(color);
        this.repaint();
    }

    public Color getScrollbarTrackColorRollover() {
        return this.hScroll.getTrackColorRollOver();
    }

    @BeanProperty(preferred=true, visualUpdate=true, description="The background color of the scrollbars when the mouse is over.")
    public void setScrollbarTrackColorRollover(Color color) {
        this.hScroll.setTrackColorRollOver(color);
        this.vScroll.setTrackColorRollOver(color);
        this.repaint();
    }

    public Color getScrollbarTrackColorPressed() {
        return this.hScroll.getTrackColorPressed();
    }

    @BeanProperty(preferred=true, visualUpdate=true, description="The background color of the scrollbars when mouse is pressed.")
    public void setScrollbarTrackColorPressed(Color color) {
        this.hScroll.setTrackColorPressed(color);
        this.vScroll.setTrackColorPressed(color);
        this.repaint();
    }

    public Color getScrollbarTrackBorderColor() {
        return this.hScroll.getBorderColor();
    }

    @BeanProperty(preferred=true, description="Sets the border color of scrollbar.")
    public void setScrollbarTrackBorderColor(Color color) {
        this.hScroll.setBorderColor(color);
        this.vScroll.setBorderColor(color);
        this.repaint();
    }

    public Color getScrollbarThumbBorderColor() {
        return this.hScroll.getThumbBorderColor();
    }

    @BeanProperty(preferred=true, description="Sets the border color of scrollbar.")
    public void setScrollBarThumbBorderColor(Color color) {
        this.hScroll.setThumbBorderColor(color);
        this.vScroll.setThumbBorderColor(color);
        this.repaint();
    }

    public Color getScrollbarThumbColorRollOver() {
        return this.hScroll.getThumbColorOver();
    }

    @BeanProperty(preferred=true, description="Sets the color of the scrollbar thumbs.")
    public void setScrollbarThumbColorRollOver(Color color) {
        this.hScroll.setThumbColorOver(color);
        this.vScroll.setThumbColorOver(color);
        this.repaint();
    }

    @BeanProperty(hidden=true, description="Sets the color of the scrollbar thumbs.")
    public void setScrollbarThumbColors(Color color) {
        this.hScroll.setThumbColors(color);
        this.vScroll.setThumbColors(color);
        this.repaint();
    }

    public Color getScrollbarThumbColorPressed() {
        return this.hScroll.getThumbColorPressed();
    }

    @BeanProperty(preferred=true, description="Sets the color of the scrollbar thumbs when the mouse is down.")
    public void setScrollbarThumbColorPressed(Color color) {
        this.hScroll.setThumbColorPressed(color);
        this.vScroll.setThumbColorPressed(color);
        this.repaint();
    }

    public Color getScrollbarThumbColorOut() {
        return this.hScroll.getThumbColor();
    }

    @BeanProperty(preferred=true, description="Sets the color of the scrollbar thumbs when mouse is not over the scrollbar.")
    public void setScrollbarThumbColorOut(Color color) {
        this.hScroll.setThumbColor(color);
        this.vScroll.setThumbColor(color);
        this.repaint();
    }

    @BeanProperty(preferred=true, description="Sets the style of the track.")
    public void setScrollbarTrackStyle(Constants.DEFAULTRENDERERS style) {
        this.hScroll.setTrackStyle(style);
        this.vScroll.setTrackStyle(style);
        this.repaint();
    }

    public Constants.DEFAULTRENDERERS getScrollbarTrackStyle() {
        return this.hScroll.getTrackStyle();
    }

    @BeanProperty(preferred=true, description="Sets the style of the thumb.")
    public void setScrollbarThumbStyle(Constants.DEFAULTRENDERERS style) {
        this.hScroll.setThumbStyle(style);
        this.vScroll.setThumbStyle(style);
        this.repaint();
    }

    public Constants.DEFAULTRENDERERS getScrollbarThumbStyle() {
        return this.hScroll.getThumbStyle();
    }

    @BeanProperty(preferred=true, description="Sets which scrollbars if any are visible by default.", enumerationValues={"NONE", "HORIZONTAL", "VERTICAL", "BOTH"})
    public void setScrollBars(int bar) {
        this.hScroll.setVisible(bar == 0 || bar == 2);
        this.vScroll.setVisible(bar == 1 || bar == 2);
    }

    public int getScrollBars() {
        if (this.hScroll.isVisible() && this.vScroll.isVisible()) {
            return 2;
        }
        if (this.hScroll.isVisible()) {
            return 0;
        }
        if (this.vScroll.isVisible()) {
            return 1;
        }
        return -1;
    }

    public ScrollPanel() {
        this.initComponents();
        this.displayPanel.setFocusable(true);
        if (this.activeListeners[1]) {
            this.setHandleMouse(this.activeListeners[1]);
        }
        if (this.activeListeners[2]) {
            this.setHandleMouseMotion(this.activeListeners[2]);
        }
        if (this.activeListeners[3]) {
            this.setHandleMouseWheel(this.activeListeners[3]);
        }
        this.addFocusListener(this);
        this.displayPanel.addFocusListener(this);
        this.loading = false;
    }

    public void hScrollValueChanged(long newValue) {
    }

    public void vScrollValueChanged(long newValue) {
    }

    public void displayPanelClicked(MouseEvent e) {
    }

    public void displayPanelMouseMoved(MouseEvent e) {
    }

    public void displayPanelMouseDragged(MouseEvent e) {
    }

    public void displayPanelMouseClicked(MouseEvent e) {
    }

    public void displayPanelMousePressed(MouseEvent e) {
    }

    public void displayPanelMouseReleased(MouseEvent e) {
    }

    public void displayPanelMouseEntered(MouseEvent e) {
    }

    public void displayPanelMouseExited(MouseEvent e) {
    }

    public void displayPanelMouseWheelMoved(MouseWheelEvent e) {
    }

    public void displayPanelResized(int Width, int Height) {
    }

    public void displayPanelFocusGained() {
    }

    public void displayPanelFocusLost() {
    }

    public boolean displayPanelKeyTyped(KeyEvent e) {
        return false;
    }

    public boolean displayPanelKeyPressed(KeyEvent e) {
        return false;
    }

    public boolean displayPanelKeyReleased(KeyEvent e) {
        return false;
    }

    public void customDisplayPaint(Graphics g, int width, int height) {
    }

    @BeanProperty(hidden=true)
    public int getPanelHeight() {
        return this.panelHeight;
    }

    @BeanProperty(hidden=true)
    public int getPanelWidth() {
        return this.panelWidth;
    }

    @BeanProperty(hidden=true)
    public Graphics getGraphicsBuffer() {
        if (this.panelGraphics == null) {
            this.regenBuffer();
        }
        return this.panelGraphics;
    }

    public BufferedImage getImageBuffer() {
        if (this.panelBuffer == null) {
            this.regenBuffer();
        }
        return this.panelBuffer;
    }

    private void regenBuffer() {
        if (this.panelGraphics != null) {
            this.panelGraphics.dispose();
        }
        this.panelHeight = Math.max(1, this.getHeight());
        this.panelWidth = Math.max(1, this.getWidth());
        this.panelBuffer = new BufferedImage(this.panelWidth, this.panelHeight, 2);
        this.panelGraphics = this.panelBuffer.getGraphics();
        this.panelGraphics.setFont(this.getFont());
    }

    @BeanProperty(preferred=true, description="Sets whether the scrollpanel handles mouse motion events. If true, events will call the overridable DisplayPanelMouseXXX functions.")
    public void setHandleMouseMotion(boolean handle) {
        if (handle != this.isHandleMouseMotion() || this.loading) {
            if (handle) {
                this.displayPanel.addMouseMotionListener(this);
            } else {
                this.displayPanel.removeMouseMotionListener(this);
            }
            this.activeListeners[2] = handle;
        }
    }

    public boolean isHandleMouseMotion() {
        return this.activeListeners[2];
    }

    @BeanProperty(preferred=true, description="Sets whether the scrollpanel handles mouse wheel events. If true, events will call the overridable DisplayPanelMouseWheelMoved function.")
    public void setHandleMouseWheel(boolean handle) {
        if (handle != this.isHandleMouseWheel() || this.loading) {
            if (handle) {
                this.displayPanel.addMouseWheelListener(this);
            } else {
                this.displayPanel.removeMouseWheelListener(this);
            }
            this.activeListeners[3] = handle;
        }
    }

    public boolean isHandleMouseWheel() {
        return this.activeListeners[3];
    }

    @BeanProperty(preferred=true, description="Sets whether the scrollpanel handles mouse click events. If true, events will call the overridable DisplayPanelMousePressed ect... function.")
    public void setHandleMouse(boolean handle) {
        if (handle != this.isHandleMouse() || this.loading) {
            if (handle) {
                this.displayPanel.addMouseListener(this);
            } else {
                this.displayPanel.removeMouseListener(this);
            }
            this.activeListeners[1] = handle;
        }
    }

    public boolean isHandleMouse() {
        return this.activeListeners[1];
    }

    @BeanProperty(preferred=true, description="Sets whether the scrollpanel handles keyboard events. If true, events will call the overridable DisplayPanelKeyPressed ect... functions.")
    public void setHandleKeys(boolean handle) {
        if (handle != this.isHandleKeys() || this.loading) {
            if (handle) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyEventDispatcher);
            } else {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyEventDispatcher);
            }
            this.activeListeners[0] = handle;
        }
    }

    public boolean isHandleKeys() {
        return this.activeListeners[0];
    }

    @BeanProperty(preferred=true, description="Sets whether the scrollpanel automatically handles focus gained events.")
    public void setHandleFocusGained(boolean handle) {
        this.activeListeners[4] = handle;
    }

    public boolean isHandleFocusGained() {
        return this.activeListeners[4];
    }

    @BeanProperty(preferred=true, description="Sets whether the scrollpanel automatically handles focus lost events.")
    public void setHandleFocusLost(boolean handle) {
        this.activeListeners[5] = handle;
    }

    public boolean isHandleFocusLost() {
        return this.activeListeners[5];
    }

    private void initComponents() {
        this.displayPanel = new JPanel(){

            @Override
            public void paint(Graphics g) {
                int currentHt = ScrollPanel.this.displayPanel.getHeight();
                int currentWd = ScrollPanel.this.displayPanel.getWidth();
                if (currentHt > ScrollPanel.this.panelHeight || currentWd > ScrollPanel.this.panelWidth || ScrollPanel.this.panelBuffer == null || ScrollPanel.this.panelGraphics == null) {
                    ScrollPanel.this.regenBuffer();
                }
                super.paint(ScrollPanel.this.panelGraphics);
                ScrollPanel.this.customDisplayPaint(ScrollPanel.this.panelGraphics, currentWd, currentHt);
                g.drawImage(ScrollPanel.this.panelBuffer, 0, 0, this);
            }
        };
        this.hScroll = new JMScrollBar(){

            @Override
            public void valueChanged(long value) {
                ScrollPanel.this.hScrollValueChanged(value);
            }
        };
        this.vScroll = new JMScrollBar(){

            @Override
            public void valueChanged(long value) {
                ScrollPanel.this.vScrollValueChanged(value);
            }
        };
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.setFont(new Font("Segoe UI", 0, 18));
        this.displayPanel.setBackground(new Color(255, 255, 255));
        this.displayPanel.setCursor(new Cursor(0));
        this.displayPanel.setFont(this.getFont());
        this.displayPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ScrollPanel.this.displayPanelComponentResized(evt);
            }
        });
        GroupLayout displayPanelLayout = new GroupLayout(this.displayPanel);
        this.displayPanel.setLayout(displayPanelLayout);
        displayPanelLayout.setHorizontalGroup(displayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 645, Short.MAX_VALUE));
        displayPanelLayout.setVerticalGroup(displayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 306, Short.MAX_VALUE));
        this.vScroll.setInvertDirection(true);
        this.vScroll.setOrientation(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.displayPanel, -1, -1, Short.MAX_VALUE).addComponent(this.hScroll, -1, -1, Short.MAX_VALUE)).addGap(0, 0, 0).addComponent(this.vScroll, -2, 15, -2).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.displayPanel, -1, -1, Short.MAX_VALUE).addComponent(this.vScroll, -1, -1, Short.MAX_VALUE)).addGap(0, 0, 0).addComponent(this.hScroll, -2, 15, -2).addGap(0, 0, 0)));
    }

    private void displayPanelComponentResized(ComponentEvent evt) {
        this.displayPanelResized(this.displayPanel.getWidth(), this.displayPanel.getHeight());
    }

    public static enum ScrollBarType {
        HORIZONTAL_ONLY,
        VERTICAL_ONLY,
        BOTH,
        NONE;

    }
}

