/*
 * Decompiled with CFR 0.152.
 */
package Renderers;

import HSL.HSLColor;
import Renderers.GradientRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;

public class ShineyRenderer
extends GradientRenderer {
    boolean useDefaultColors = false;
    boolean selectedColorsMade = false;
    boolean rolloverColorsMade = false;
    boolean pressedColorsMade = false;
    boolean normalColorsMade = false;
    private static final Color defShineyTopPressed = new Color(81, 149, 235);
    private static final Color defShineyBotPressed = new Color(36, 80, 193);
    private static final Color defShineyGlarePressed = new Color(148, 177, 228);
    private static final Color defShineyTopDef = new Color(116, 161, 216);
    private static final Color defShineyBotDef = new Color(81, 117, 206);
    private static final Color defShineyGlareDef = new Color(122, 157, 212);
    private static final Color defShineyTopHot = new Color(160, 191, 233);
    private static final Color defShineyBotHot = new Color(102, 132, 216);
    private static final Color defShineyGlareHot = new Color(200, 211, 242);
    private static final Color defShineyBorderDef = new Color(89, 134, 183);
    private Color shineyTopPressed = defShineyTopPressed;
    private Color shineyBotPressed = defShineyBotPressed;
    private Color shineyGlarePressed = defShineyGlarePressed;
    private Color shineyBorderPressed = defShineyBorderDef;
    private Color shineyTopSelected = defShineyTopPressed;
    private Color shineyBotSelected = defShineyBotPressed;
    private Color shineyGlareSelected = defShineyGlarePressed;
    private Color shineyBorderSelected = defShineyBorderDef;
    private Color shineyTopDef = defShineyTopDef;
    private Color shineyBotDef = defShineyBotDef;
    private Color shineyGlareDef = defShineyGlareDef;
    private Color shineyBorderDef = defShineyBorderDef;
    private Color shineyTopHot = defShineyTopHot;
    private Color shineyBotHot = defShineyBotHot;
    private Color shineyGlareHot = defShineyGlareHot;
    private Color shineyBorderHot = defShineyBorderDef;
    boolean paintBorder2 = true;
    private Color borderColor;

    public void setUseDefaultColors(boolean useDefault) {
        if (this.useDefaultColors && !useDefault) {
            this.rolloverColorsMade = false;
            this.pressedColorsMade = false;
            this.normalColorsMade = false;
        }
        this.useDefaultColors = useDefault;
    }

    @Override
    public void setColorRollover(Color color) {
        this.rolloverColorsMade = false;
        if (color != null) {
            this.genRolloverColors(color);
            this.rolloverColorsMade = true;
        }
        super.setColorRollover(color);
    }

    @Override
    public void setColorNormal(Color color) {
        this.normalColorsMade = false;
        if (color != null) {
            this.genNormalColors(color);
            this.normalColorsMade = false;
        }
        super.setColorNormal(color);
    }

    @Override
    public void setColorPressed(Color color) {
        this.pressedColorsMade = false;
        if (color != null) {
            this.genPressedColors(color);
            this.pressedColorsMade = false;
        }
        super.setColorPressed(color);
    }

    @Override
    public void setColorSelected(Color color) {
        this.selectedColorsMade = false;
        if (color != null) {
            this.genSelectedColors(color);
            this.selectedColorsMade = false;
        }
        super.setColorSelected(color);
    }

    private void genNormalColors(Color baseColor) {
        HSLColor color = new HSLColor(baseColor);
        this.shineyTopDef = color.adjustHSL(0.8875f, 0.5617977f, 1.3019607f);
        this.shineyBotDef = color.adjustHSL(0.92800003f, 0.5605382f, 1.1254902f);
        this.shineyGlareDef = color.adjustHSL(0.90277773f, 0.51136357f, 1.309804f);
        this.shineyBorderDef = color.adjustHSL(0.8803192f, 0.39495805f, 1.0666667f);
    }

    private void genRolloverColors(Color baseColor) {
        HSLColor color = new HSLColor(baseColor);
        this.shineyTopHot = color.adjustHSL(0.89383566f, 0.62393165f, 1.5411766f);
        this.shineyBotHot = color.adjustHSL(0.93421054f, 0.59374994f, 1.2470589f);
        this.shineyGlareHot = color.adjustHSL(0.9345238f, 0.6176472f, 1.7333332f);
        this.shineyBorderHot = color.adjustHSL(0.8803192f, 0.39495805f, 1.0666667f);
    }

    private void genPressedColors(Color baseColor) {
        HSLColor color = new HSLColor(baseColor);
        this.shineyTopPressed = color.adjustHSL(0.8896104f, 0.7938144f, 1.2392157f);
        this.shineyBotPressed = color.adjustHSL(0.9299363f, 0.68558955f, 0.8980392f);
        this.shineyGlarePressed = color.adjustHSL(0.909375f, 0.59701484f, 1.4745098f);
        this.shineyBorderPressed = color.adjustHSL(0.8803192f, 0.39495805f, 1.0666667f);
    }

    private void genSelectedColors(Color baseColor) {
        HSLColor color = new HSLColor(baseColor);
        this.shineyTopSelected = color.adjustHSL(0.8896104f, 0.7938144f, 1.2392157f);
        this.shineyBotSelected = color.adjustHSL(0.9299363f, 0.68558955f, 0.8980392f);
        this.shineyGlareSelected = color.adjustHSL(0.909375f, 0.59701484f, 1.4745098f);
        this.shineyBorderSelected = color.adjustHSL(0.8803192f, 0.39495805f, 1.0666667f);
    }

    public ShineyRenderer(Component parent) {
        super(parent);
        this.paintBorder = false;
    }

    public ShineyRenderer(Component parent, boolean rounded) {
        super(parent, rounded);
        this.paintBorder = false;
    }

    public ShineyRenderer(Component parent, boolean rounded, boolean paintIcon) {
        super(parent, rounded, paintIcon);
        this.paintBorder = false;
    }

    public ShineyRenderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption) {
        super(parent, rounded, paintIcon, paintCaption);
        this.paintBorder = false;
    }

    public ShineyRenderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder, boolean useDefaultColors) {
        super(parent, rounded, paintIcon, paintCaption, false);
        this.paintBorder2 = paintBorder;
        this.useDefaultColors = useDefaultColors;
    }

    public ShineyRenderer() {
    }

    public ShineyRenderer(boolean rounded) {
        super(rounded);
    }

    public ShineyRenderer(boolean rounded, boolean paintIcon) {
        super(rounded, paintIcon);
    }

    public ShineyRenderer(boolean rounded, boolean paintIcon, boolean paintCaption) {
        super(rounded, paintIcon, paintCaption);
    }

    public ShineyRenderer(boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder) {
        super(rounded, paintIcon, paintCaption, paintBorder);
    }

    public ShineyRenderer(boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder, boolean useDefaultColors) {
        super(rounded, paintIcon, paintCaption, false);
        this.paintBorder2 = paintBorder;
        this.useDefaultColors = useDefaultColors;
    }

    @Override
    public void paintBackground(Graphics g, Component c, Shape clip, int state) {
        Color colorGlare;
        Color colorBot;
        Color colorTop;
        int bottom;
        int right;
        int left;
        int top;
        Shape clipShape;
        if (clip != null) {
            Rectangle bounds = clip.getBounds();
            clipShape = bounds;
            top = bounds.y;
            left = bounds.x;
            right = bounds.width;
            bottom = bounds.height;
        } else {
            clipShape = this.getShape(c);
            top = 0;
            left = 0;
            right = c.getWidth();
            bottom = c.getHeight();
        }
        int wd = right - left + 1;
        int ht = bottom - top + 1;
        int midX = wd / 2;
        int midY = ht / 2;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape oldClip = g2d.getClip();
        g2d.clip(clipShape);
        switch (state) {
            case 2: {
                colorTop = Color.LIGHT_GRAY;
                Color colorTop2 = Color.LIGHT_GRAY;
                colorBot = Color.GRAY;
                Color colorBot2 = Color.GRAY;
                g2d.setColor(colorTop);
                g2d.fillRect(left, top, wd, ht);
                this.borderColor = Color.GRAY;
                colorGlare = Color.LIGHT_GRAY;
                break;
            }
            case 5: {
                if (this.useDefaultColors) {
                    colorTop = defShineyTopHot;
                    colorBot = defShineyBotHot;
                    colorGlare = defShineyGlareHot;
                    this.borderColor = defShineyBorderDef;
                    break;
                }
                if (this.shineyTopHot == null || this.shineyBotHot == null || this.shineyGlareHot == null || this.shineyBorderHot == null) {
                    this.genRolloverColors(c.getBackground().brighter());
                }
                colorTop = this.shineyTopHot;
                colorBot = this.shineyBotHot;
                colorGlare = this.shineyGlareHot;
                this.borderColor = this.shineyBorderHot;
                break;
            }
            case 1: {
                if (this.useDefaultColors) {
                    colorTop = defShineyTopPressed;
                    colorBot = defShineyBotPressed;
                    colorGlare = defShineyGlarePressed;
                    this.borderColor = defShineyBorderDef;
                    break;
                }
                if (this.shineyTopPressed == null || this.shineyBotPressed == null || this.shineyBorderPressed == null || this.shineyGlarePressed == null) {
                    this.genPressedColors(c.getBackground().darker());
                }
                colorTop = this.shineyTopPressed;
                colorBot = this.shineyBotPressed;
                this.borderColor = this.shineyBorderPressed;
                colorGlare = this.shineyGlarePressed;
                break;
            }
            case 3: {
                if (this.useDefaultColors) {
                    colorTop = defShineyTopPressed;
                    colorBot = defShineyBotPressed;
                    colorGlare = defShineyGlarePressed;
                    this.borderColor = defShineyBorderDef;
                    break;
                }
                if (this.shineyTopSelected == null || this.shineyBotSelected == null || this.shineyBorderSelected == null || this.shineyGlareSelected == null) {
                    this.genPressedColors(c.getBackground().darker());
                }
                colorTop = this.shineyTopSelected;
                colorBot = this.shineyBotSelected;
                this.borderColor = this.shineyBorderSelected;
                colorGlare = this.shineyGlareSelected;
                break;
            }
            default: {
                if (this.useDefaultColors) {
                    colorTop = defShineyTopDef;
                    colorBot = defShineyBotDef;
                    colorGlare = defShineyGlareDef;
                    this.borderColor = defShineyBorderDef;
                    break;
                }
                if (this.shineyTopDef == null || this.shineyBotDef == null || this.shineyBorderDef == null || this.shineyGlareDef == null) {
                    this.genNormalColors(c.getBackground());
                }
                colorTop = this.shineyTopDef;
                colorBot = this.shineyBotDef;
                this.borderColor = this.shineyBorderDef;
                colorGlare = this.shineyGlareDef;
            }
        }
        g2d.setColor(colorTop);
        g2d.fillRect(left, top, wd, ht);
        g2d.setClip(oldClip);
        g2d.clip(new RoundRectangle2D.Double(left + 1, midY, wd - 2, ht / 2, this.ellipse, this.ellipse));
        g2d.setColor(colorBot);
        g2d.fillRect(left, ht / 2 + 1, wd, ht / 2);
        if (state != 8) {
            float radius = midY * 3 / 2;
            Point2D.Float center = new Point2D.Float(midX, (float)ht + radius / 2.0f);
            Color[] colors = new Color[]{colorGlare, colorGlare, colorBot};
            float[] dist = new float[]{0.0f, 0.1f, 1.0f};
            RadialGradientPaint p = new RadialGradientPaint(center, radius, dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
            g2d.setPaint(p);
            g2d.fillRect(left, top, right, bottom);
        }
        g2d.setClip(oldClip);
        g2d.clip(new RoundRectangle2D.Double(left, top, wd, ht, this.ellipse, this.ellipse));
        ShineyRenderer.paintGradient(g2d, colorTop, Color.WHITE, left + wd / 4, top + 1, left + midX, top + 1, true);
        ShineyRenderer.paintGradient(g2d, Color.WHITE, colorTop, left + midX, top + 1, left + wd * 3 / 4, top + 1, true);
        ShineyRenderer.paintGradient(g2d, colorBot, Color.WHITE, left + wd / 4, bottom - 2, left + midX, bottom - 2, true);
        ShineyRenderer.paintGradient(g2d, Color.WHITE, colorBot, left + midX, bottom - 2, left + wd * 3 / 4, bottom - 2, true);
        ShineyRenderer.paintGradient(g2d, colorTop, Color.WHITE, left + 1, ht / 4, left + 1, top + midY, false);
        ShineyRenderer.paintGradient(g2d, Color.WHITE, colorBot, left + 1, top + midY, left + 1, top + bottom * 3 / 4, false);
        ShineyRenderer.paintGradient(g2d, colorTop, Color.WHITE, right - 2, top + ht / 4, right - 2, top + midY, false);
        ShineyRenderer.paintGradient(g2d, Color.WHITE, colorBot, right - 2, top + midY, right - 2, top + bottom * 3 / 4, false);
        g2d.setClip(oldClip);
        g2d.dispose();
        if (this.paintBorder2) {
            this.paintBorder(g, c, this.shape);
        }
    }

    @Override
    public void setPaintBorder(boolean paint) {
        this.paintBorder2 = paint;
    }

    @Override
    public boolean isPaintCaption() {
        return this.paintCaption;
    }

    @Override
    public boolean isPaintBorder() {
        return this.paintBorder2;
    }

    @Override
    public void paintBorder(Graphics g, Component c, Shape border) {
        Graphics2D g2d = (Graphics2D)g.create();
        Color color = this.borderColor;
        if (color != null) {
            Rectangle bounds;
            if (border != null) {
                bounds = new Rectangle(border.getBounds().x, border.getBounds().y, border.getBounds().width, border.getBounds().height);
            } else {
                bounds = this.getShape(c).getBounds();
                bounds = new Rectangle(bounds.getBounds().x, bounds.getBounds().y, bounds.getBounds().width, bounds.getBounds().height);
            }
            boolean focused = c.hasFocus();
            Shape oldClip = g2d.getClip();
            g2d.clip(bounds);
            if (this.showFocus && focused) {
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.setColor(color.darker());
                if (this.rounded) {
                    g2d.drawRoundRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, this.ellipse, this.ellipse);
                } else {
                    g2d.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
                }
                g2d.setStroke(new BasicStroke(1.0f));
            } else {
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.setColor(color);
                if (this.rounded) {
                    g2d.drawRoundRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, this.ellipse, this.ellipse);
                } else {
                    g2d.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
                }
            }
            g2d.setClip(oldClip);
            g2d.dispose();
        }
    }
}

