/*
 * Decompiled with CFR 0.152.
 */
package Renderers;

import BaseClasses.RendererColors;
import Renderers.Renderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;

public abstract class GradientRenderer
extends Renderer {
    public static final int TYPE_FORECOLOR_START = 0;
    public static final int TYPE_BACKCOLOR_START = 1;
    public static final int TYPE_LINECOLOR_START = 2;
    public static final int TYPE_FORECOLOR_END = 3;
    public static final int TYPE_BACKCOLOR_END = 4;
    public static final int TYPE_LINECOLOR_END = 5;

    public GradientRenderer(Component parent) {
        super(parent);
        this.initColors();
    }

    public GradientRenderer(Component parent, boolean rounded) {
        super(parent, rounded);
        this.initColors();
    }

    public GradientRenderer(Component parent, boolean rounded, boolean paintIcon) {
        super(parent, rounded, paintIcon);
        this.initColors();
    }

    public GradientRenderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption) {
        super(parent, rounded, paintIcon, paintCaption);
        this.initColors();
    }

    public GradientRenderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder) {
        super(parent, rounded, paintIcon, paintCaption, paintBorder);
        this.initColors();
    }

    public GradientRenderer() {
        this.initColors();
    }

    public GradientRenderer(boolean rounded) {
        super(rounded);
        this.initColors();
    }

    public GradientRenderer(boolean rounded, boolean paintIcon) {
        super(rounded, paintIcon);
        this.initColors();
    }

    public GradientRenderer(boolean rounded, boolean paintIcon, boolean paintCaption) {
        super(rounded, paintIcon, paintCaption);
        this.initColors();
    }

    public GradientRenderer(boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder) {
        super(rounded, paintIcon, paintCaption, paintBorder);
        this.initColors();
    }

    protected void initColors() {
        this.colors = new RendererColors(5);
    }

    public static Color ShiftColorXP(Color color, int Base2) {
        if (color == null) {
            return null;
        }
        float fBase = Base2;
        float delta = 255.0f - fBase;
        int b = (int)(fBase + (float)color.getBlue() * delta / 255.0f);
        int g = (int)(fBase + (float)color.getGreen() * delta / 255.0f);
        int r = (int)(fBase + (float)color.getRed() * delta / 255.0f);
        if (r > 255) {
            r = 255;
        }
        if (g > 255) {
            g = 255;
        }
        if (b > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }

    public static Color shiftColor(Color color, float shift) {
        if (color == null) {
            return null;
        }
        int R = (int)((float)color.getRed() + shift * 255.0f);
        int G = (int)((float)color.getGreen() + shift * 255.0f);
        int B = (int)((float)color.getBlue() + shift * 255.0f);
        if (shift > 0.0f) {
            if (R > 255) {
                R = 255;
            }
            if (G > 255) {
                G = 255;
            }
            if (B > 255) {
                B = 255;
            }
        } else {
            if (R < 0) {
                R = 0;
            }
            if (G < 0) {
                G = 0;
            }
            if (B < 0) {
                B = 0;
            }
        }
        return new Color(R, G, B);
    }

    static void paintGradient(Graphics2D g2d, Color startColor, Color endColor, Shape shape, int width, int height, boolean horizontal) {
        if (startColor == null) {
            return;
        }
        if (endColor == null) {
            endColor = startColor;
        }
        GradientPaint drawGradient = horizontal ? new GradientPaint(0.0f, 0.0f, startColor, width, 0.0f, endColor, false) : new GradientPaint(0.0f, 0.0f, startColor, 0.0f, height, endColor, false);
        g2d.setPaint(drawGradient);
        g2d.fill(shape);
    }

    static void paintGradient(Graphics2D g2d, Color startColor, Color endColor, Polygon drawArea, boolean horizontal) {
        if (startColor == null) {
            return;
        }
        if (endColor == null) {
            endColor = startColor;
        }
        Rectangle GradientArea = drawArea.getBounds();
        GradientPaint drawGradient = horizontal ? new GradientPaint(GradientArea.x, GradientArea.y, startColor, (float)GradientArea.getMaxX(), GradientArea.y, endColor, false) : new GradientPaint(GradientArea.x, GradientArea.y, startColor, GradientArea.x, (float)GradientArea.getMaxY(), endColor, false);
        g2d.setPaint(drawGradient);
        g2d.fillPolygon(drawArea);
    }

    static void paintGradient(Graphics2D g2d, Color startColor, Color endColor, int x1, int y1, int x2, int y2, boolean horizontal) {
        if (startColor == null) {
            return;
        }
        if (endColor == null) {
            endColor = startColor;
        }
        GradientPaint drawGradient = horizontal ? new GradientPaint(x1, y1, startColor, x2, y1, endColor, false) : new GradientPaint(x1, y1, startColor, x1, y2, endColor, false);
        g2d.setPaint(drawGradient);
        g2d.fillRect(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
    }
}

