/*
 * Decompiled with CFR 0.152.
 */
package Renderers;

import Renderers.GradientRenderer;
import Renderers.Renderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;

public class GlossyRenderer
extends GradientRenderer {
    static final int ellipseWd = 15;
    static final int borderWidth = 2;
    public static final Color DEFAULT_BASE_COLOR = new Color(153, 153, 255);
    static Color grayColor = new Color(0xC0C0C0);
    static Color grayColor2 = GlossyRenderer.shiftColor(grayColor, 0.2f);
    static final Color MOUSEDOWNGLARECOLOR1 = new Color(250, 250, 250);
    private Color backColorNormal1 = null;
    private Color backColorNormal2 = null;
    private Color gradColorNormal = null;
    private Color backColorOver1 = null;
    private Color backColorOver2 = null;
    private Color gradColorOver = null;
    private Color backColorPressed1 = null;
    private Color backColorPressed2 = null;
    private Color gradColorPressed = null;
    private Color backColorSelected1 = null;
    private Color backColorSelected2 = null;
    private Color gradColorSelected = null;

    public GlossyRenderer(Component parent) {
        super(parent);
    }

    public GlossyRenderer(Component parent, boolean rounded) {
        super(parent, rounded);
    }

    public GlossyRenderer(Component parent, boolean rounded, boolean paintIcon) {
        super(parent, rounded, paintIcon);
    }

    public GlossyRenderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption) {
        super(parent, rounded, paintIcon, paintCaption);
    }

    public GlossyRenderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder) {
        super(parent, rounded, paintIcon, paintCaption, paintBorder);
    }

    public GlossyRenderer() {
    }

    public GlossyRenderer(boolean rounded) {
        super(rounded);
    }

    public GlossyRenderer(boolean rounded, boolean paintIcon) {
        super(rounded, paintIcon);
    }

    public GlossyRenderer(boolean rounded, boolean paintIcon, boolean paintCaption) {
        super(rounded, paintIcon, paintCaption);
    }

    public GlossyRenderer(boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder) {
        super(rounded, paintIcon, paintCaption, paintBorder);
    }

    @Override
    public void setColorRollover(Color color) {
        if (color != null) {
            this.genColorOver(color);
        }
        super.setColorRollover(color);
    }

    @Override
    public void setColorNormal(Color color) {
        if (color != null) {
            this.genColorNormal(color);
        }
        super.setColorNormal(color);
    }

    @Override
    public void setColorPressed(Color color) {
        if (color != null) {
            this.genColorPressed(color);
        }
        super.setColorPressed(color);
    }

    @Override
    public void setColorSelected(Color color) {
        if (color != null) {
            this.genColorSelected(color);
        }
        super.setColorSelected(color);
    }

    private void genColorNormal(Color color) {
        this.backColorNormal1 = color;
        this.backColorNormal2 = GlossyRenderer.shiftColor(color, 0.1f);
        this.gradColorNormal = GlossyRenderer.shiftColor(color, 0.05f);
    }

    private void genColorOver(Color color) {
        this.backColorOver1 = color;
        this.backColorOver2 = GlossyRenderer.shiftColor(color, -0.01f);
        this.gradColorOver = color;
    }

    private void genColorPressed(Color color) {
        this.backColorPressed1 = GlossyRenderer.shiftColor(color, -0.15f);
        this.gradColorPressed = this.backColorPressed2 = GlossyRenderer.shiftColor(color, -0.1f);
    }

    private void genColorSelected(Color color) {
        this.backColorSelected1 = GlossyRenderer.shiftColor(color, -0.15f);
        this.gradColorSelected = this.backColorSelected2 = GlossyRenderer.shiftColor(color, -0.1f);
    }

    @Override
    public void paintBackground(Graphics g, Component c, Shape clip, int state) {
        Shape main;
        int wd;
        int ht;
        int left;
        int top;
        Color gColor2;
        Color bColor2;
        Color bColor1;
        Color baseColor = this.colors.getActiveColor(1);
        if (baseColor == null) {
            return;
        }
        switch (state) {
            case 2: 
            case 4: {
                bColor1 = grayColor;
                bColor2 = grayColor2;
                gColor2 = bColor1;
                break;
            }
            case 5: {
                this.genColorOver(baseColor);
                bColor1 = this.backColorOver1;
                bColor2 = this.backColorOver2;
                gColor2 = this.gradColorOver;
                break;
            }
            case 1: {
                this.genColorPressed(baseColor);
                bColor1 = this.backColorPressed1;
                bColor2 = this.backColorPressed2;
                gColor2 = this.gradColorPressed;
                break;
            }
            case 3: 
            case 6: {
                this.genColorSelected(baseColor);
                bColor1 = this.backColorSelected1;
                bColor2 = this.backColorSelected2;
                gColor2 = this.gradColorSelected;
                break;
            }
            default: {
                this.genColorNormal(baseColor);
                bColor1 = this.backColorNormal1;
                bColor2 = this.backColorNormal2;
                gColor2 = this.gradColorNormal;
            }
        }
        int gradWd = 15;
        int gradHt = 7;
        if (clip != null) {
            Rectangle bounds = clip.getBounds();
            top = bounds.y;
            left = bounds.x;
            ht = bounds.height;
            wd = bounds.width;
            main = this.getShape(bounds);
        } else {
            top = 0;
            left = 0;
            ht = c.getHeight();
            wd = c.getWidth();
            main = this.getShape(c);
        }
        int right = left + wd - 1;
        int bottom = top + ht - 1;
        int glareInset = 5;
        int gTop = top;
        int gLeft = glareInset;
        int gRight = wd - glareInset * 2;
        int gBottom = (int)((double)(bottom - top) / 1.75);
        if (gBottom - gTop > 20) {
            gBottom = gTop + 20;
        }
        Renderer.Point pt1 = new Renderer.Point(left, gBottom - 3);
        Renderer.Point pt2 = new Renderer.Point(right, pt1.y);
        Renderer.Point pt3 = new Renderer.Point(left + gradWd / 2, pt1.y + 7);
        Renderer.Point pt4 = new Renderer.Point(right - gradWd / 2, pt3.y);
        Renderer.Point pt5 = new Renderer.Point(pt3.x, bottom - gradHt);
        Renderer.Point pt6 = new Renderer.Point(pt4.x, pt5.y);
        Polygon polyTop = new Polygon();
        polyTop.addPoint(pt1.x, pt1.y);
        polyTop.addPoint(pt2.x, pt2.y);
        polyTop.addPoint(pt4.x, pt4.y);
        polyTop.addPoint(pt3.x, pt3.y);
        Polygon polyLt = new Polygon();
        polyLt.addPoint(pt1.x, pt1.y);
        polyLt.addPoint(pt3.x, pt3.y);
        polyLt.addPoint(pt5.x, pt5.y);
        polyLt.addPoint(left, bottom);
        Polygon polyRt = new Polygon();
        polyRt.addPoint(pt2.x, pt2.y);
        polyRt.addPoint(pt4.x, pt4.y);
        polyRt.addPoint(pt6.x, pt6.y);
        polyRt.addPoint(right, bottom);
        Polygon polyBt = new Polygon();
        polyBt.addPoint(left, bottom);
        polyBt.addPoint(pt5.x, pt5.y);
        polyBt.addPoint(pt6.x, pt6.y);
        polyBt.addPoint(right, bottom);
        Polygon polyMd = new Polygon();
        polyMd.addPoint(pt3.x, pt3.y);
        polyMd.addPoint(pt4.x, pt4.y);
        polyMd.addPoint(pt6.x, pt6.y);
        polyMd.addPoint(pt5.x, pt5.y);
        GradientPaint gradGlare = state == 1 || state == 3 || state == 6 ? new GradientPaint(left, gTop, MOUSEDOWNGLARECOLOR1, left, gBottom, bColor1, false) : new GradientPaint(left, gTop, Color.WHITE, left, gBottom, gColor2, false);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape oldClip = g2d.getClip();
        g2d.clip(main);
        g2d.setPaint(bColor1);
        g2d.fill(main);
        g2d.setPaint(gradGlare);
        g2d.fillRoundRect(gLeft, gTop, gRight, gBottom, 15, 15);
        g2d.setColor(bColor2);
        g2d.fill(polyMd);
        GlossyRenderer.paintGradient(g2d, bColor1, bColor2, polyTop, false);
        GlossyRenderer.paintGradient(g2d, bColor1, bColor2, polyLt, true);
        GlossyRenderer.paintGradient(g2d, bColor2, bColor1, polyRt, true);
        GlossyRenderer.paintGradient(g2d, bColor2, Color.white, polyBt, false);
        g2d.setClip(oldClip);
        g2d.dispose();
    }

    public void paintBorder(Graphics2D g2d, Component c, Shape border) {
        Color color = this.getBorderColor(c);
        if (color != null) {
            Rectangle bounds = border != null ? this.getShape(border).getBounds() : this.getShape(c).getBounds();
            g2d.setColor(c.hasFocus() ? color.darker().darker() : color.darker());
            g2d.setStroke(new BasicStroke(2.0f));
            if (this.rounded) {
                g2d.drawRoundRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, this.ellipse, this.ellipse);
            } else {
                g2d.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            }
            g2d.setStroke(new BasicStroke(1.0f));
        }
    }
}

