/*
 * Decompiled with CFR 0.152.
 */
package Renderers;

import Renderers.GradientRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;

public class BasicGradientRenderer
extends GradientRenderer {
    public static final int HORIZONTAL_GRADIENT_1 = 0;
    public static final int VERTICAL_GRADIENT_1 = 1;
    public static final int HORIZONTAL_GRADIENT_2 = 2;
    public static final int VERTICAL_GRADIENT_2 = 3;
    public static final int SOLID_COLOR = 4;
    final int gradientDistance = 1;
    Color defStartColorNormal = Color.white;
    Color defEndColorNormal = new Color(253, 81, 81);
    int drawStyle = 1;

    public void setStartColors(Color color) {
        this.colors.setColors(1, color);
    }

    public void setEndColors(Color color) {
        this.colors.setColors(4, color);
    }

    public Color getStartColorNormal() {
        return this.colors.getColor(1, 0);
    }

    public Color getStartColorRollover() {
        return this.colors.getColor(1, 5);
    }

    public Color getStartColorPressed() {
        return this.colors.getColor(1, 1);
    }

    public Color getStartColorSelected() {
        return this.colors.getColor(1, 0);
    }

    public Color getStartColorDisabled() {
        return this.colors.getColor(1, 2);
    }

    public Color getEndColorNormal() {
        return this.colors.getColor(4, 0);
    }

    public Color getEndColorRollover() {
        return this.colors.getColor(4, 5);
    }

    public Color getEndColorPressed() {
        return this.colors.getColor(4, 1);
    }

    public Color getEndColorSelected() {
        return this.colors.getColor(4, 3);
    }

    public Color getEndColorDisabled() {
        return this.colors.getColor(4, 2);
    }

    public void setStartColorNormal(Color color) {
        this.colors.setColor(1, 0, color);
    }

    public void setStartColorRollover(Color color) {
        this.colors.setColor(1, 5, color);
    }

    public void setStartColorPressed(Color color) {
        this.colors.setColor(1, 1, color);
    }

    public void setStartColorSelected(Color color) {
        this.colors.setColor(1, 3, color);
    }

    public void setStartColorDisabled(Color color) {
        this.colors.setColor(1, 2, color);
    }

    public void setEndColorNormal(Color color) {
        this.colors.setColor(4, 0, color);
    }

    public void setEndColorRollover(Color color) {
        this.colors.setColor(4, 5, color);
    }

    public void setEndColorPressed(Color color) {
        this.colors.setColor(4, 1, color);
    }

    public void setEndColorSelected(Color color) {
        this.colors.setColor(4, 3, color);
    }

    public void setEndColorDisabled(Color color) {
        this.colors.setColor(4, 2, color);
    }

    public BasicGradientRenderer(Component parent) {
        super(parent);
    }

    public BasicGradientRenderer(Component parent, boolean rounded) {
        super(parent, rounded);
    }

    public BasicGradientRenderer(Component parent, boolean rounded, boolean paintIcon) {
        super(parent, rounded, paintIcon);
    }

    public BasicGradientRenderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption) {
        super(parent, rounded, paintIcon, paintCaption);
    }

    public BasicGradientRenderer(Component parent, boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder) {
        super(parent, rounded, paintIcon, paintCaption, paintBorder);
    }

    public BasicGradientRenderer() {
    }

    public BasicGradientRenderer(boolean rounded) {
        super(rounded);
    }

    public BasicGradientRenderer(boolean rounded, boolean paintIcon) {
        super(rounded, paintIcon);
    }

    public BasicGradientRenderer(boolean rounded, boolean paintIcon, boolean paintCaption) {
        super(rounded, paintIcon, paintCaption);
    }

    public BasicGradientRenderer(boolean rounded, boolean paintIcon, boolean paintCaption, boolean paintBorder) {
        super(rounded, paintIcon, paintCaption, paintBorder);
    }

    public void setStyle(int style) {
        if (style >= 0 && style <= 4) {
            this.drawStyle = style;
        }
    }

    public int getStyle() {
        return this.drawStyle;
    }

    @Override
    protected void initColors() {
        super.initColors();
        this.colors.setColors(1, this.defStartColorNormal);
        this.colors.setColors(4, this.defEndColorNormal);
    }

    @Override
    public void paintBackground(Graphics g, Component c, Shape clip, int state) {
        Graphics2D g2d = (Graphics2D)g.create();
        Rectangle bounds = clip != null ? clip.getBounds() : new Rectangle(0, 0, c.getWidth(), c.getHeight());
        int top = bounds.y;
        int left = bounds.x;
        int ht = bounds.height;
        int wd = bounds.width;
        Color startColor = this.colors.getColor(1, state);
        Color endColor = this.colors.getColor(4, state);
        if (startColor == null) {
            startColor = endColor;
        } else if (endColor == null) {
            endColor = startColor;
        }
        if (startColor != null && endColor != null) {
            int startX = left;
            int startY = top;
            int endX = wd - startX;
            int endY = ht - startY;
            switch (this.drawStyle) {
                case 0: {
                    g2d.setPaint(new GradientPaint(startX, startY, startColor, endX * 1, startY, endColor, false));
                    break;
                }
                case 1: {
                    g2d.setPaint(new GradientPaint(startX, startY, startColor, startX, endY * 1, endColor, false));
                    break;
                }
                case 2: {
                    g2d.setPaint(new GradientPaint(startX, startY, startColor, endX / 2, startY, endColor, true));
                    break;
                }
                case 3: {
                    g2d.setPaint(new GradientPaint(startX, startY, startColor, startX, endY / 2, endColor, true));
                    break;
                }
                default: {
                    g2d.setColor(startColor);
                }
            }
            Shape oldClip = g2d.getClip();
            g2d.clip(bounds);
            g2d.fill(bounds);
            g2d.setClip(oldClip);
        }
        g2d.dispose();
    }
}

