/*
 * Decompiled with CFR 0.152.
 */
package ProteinTools;

import AbstractClasses.AbstractGappedFinder;
import GenbankFileReader.Locus;
import ProteinTools.AminoAcid;
import ProteinTools.CodonTable;
import Sequences.DNA;

public class AAGappedFinder
extends AbstractGappedFinder {
    String aSequence = null;
    String AAFrame1S = null;
    String AAFrame2S = null;
    String AAFrame3S = null;
    String AAFrame1AS = null;
    String AAFrame2AS = null;
    String AAFrame3AS = null;
    protected int refLen = 0;
    private CodonTable table = null;

    public void setCodonTable(CodonTable table) {
        this.table = table;
    }

    public AAGappedFinder() {
    }

    public AAGappedFinder(String sequence) {
        this(sequence, false);
    }

    public AAGappedFinder(String sequence, boolean circular) {
        this(sequence, circular, false);
    }

    public AAGappedFinder(String sequence, boolean circular, boolean caseSensitive) {
        this.isCircular = circular;
        this.isCaseSensitive = caseSensitive;
        this.refLen = sequence.length();
        this.searchLimit = this.refLen / 3;
        if (!this.isCaseSensitive) {
            sequence = sequence.toUpperCase();
        }
        this.sequence = circular ? sequence + sequence : sequence;
    }

    @Override
    public String stringToDegenerate(String qry) {
        return AminoAcid.AAtoRegex(qry);
    }

    @Override
    public boolean find(String qry, boolean searchSense, boolean searchAntisense) {
        this.matches.clear();
        if (!searchSense && !searchAntisense) {
            return false;
        }
        if (this.table == null) {
            this.table = new CodonTable();
        }
        if (searchSense) {
            Locus[] senseResults3;
            Locus[] senseResults2;
            Locus[] senseResults1;
            if (this.AAFrame1S == null) {
                this.AAFrame1S = this.table.translate(this.sequence, 1, CodonTable.LetterCode.e1_Letter_Code);
                this.AAFrame2S = this.table.translate(this.sequence, 2, CodonTable.LetterCode.e1_Letter_Code);
                this.AAFrame3S = this.table.translate(this.sequence, 3, CodonTable.LetterCode.e1_Letter_Code);
            }
            if ((senseResults1 = this.findOnStrand(this.AAFrame1S, qry)) != null) {
                for (Locus locus : senseResults1) {
                    locus.setStart(DNA.codonNumberToBpStart(locus.getStart()));
                    locus.setStop(locus.getStop() * 3);
                }
                this.matches.add((T[])senseResults1);
            }
            if ((senseResults2 = this.findOnStrand(this.AAFrame2S, qry)) != null) {
                for (Locus locus : senseResults2) {
                    locus.setStart(DNA.codonNumberToBpStart(locus.getStart()) + 1);
                    locus.setStop(locus.getStop() * 3 + 1);
                }
                this.matches.add((T[])senseResults2);
            }
            if ((senseResults3 = this.findOnStrand(this.AAFrame3S, qry)) != null) {
                for (Locus locus : senseResults3) {
                    locus.setStart(DNA.codonNumberToBpStart(locus.getStart()) + 2);
                    locus.setStop(locus.getStop() * 3 + 2);
                }
                this.matches.add((T[])senseResults3);
            }
        }
        if (searchAntisense) {
            Locus[] aSenseResults3;
            Locus[] aSenseResults2;
            Locus[] aSenseResults1;
            if (this.AAFrame1AS == null) {
                if (this.aSequence == null) {
                    this.aSequence = DNA.getAntisense(this.sequence);
                }
                this.AAFrame1AS = this.table.translate(this.aSequence, 1, CodonTable.LetterCode.e1_Letter_Code);
                this.AAFrame2AS = this.table.translate(this.aSequence, 2, CodonTable.LetterCode.e1_Letter_Code);
                this.AAFrame3AS = this.table.translate(this.aSequence, 3, CodonTable.LetterCode.e1_Letter_Code);
            }
            if ((aSenseResults1 = this.findOnStrand(this.AAFrame1AS, qry)) != null) {
                for (Locus locus : aSenseResults1) {
                    locus.setStart(DNA.codonNumberToBpStart(locus.getStart()));
                    locus.setStop(locus.getStop() * 3);
                    locus.antisense(this.refLen);
                }
                this.matches.add((T[])aSenseResults1);
            }
            if ((aSenseResults2 = this.findOnStrand(this.AAFrame2AS, qry)) != null) {
                for (Locus locus : aSenseResults2) {
                    locus.setStart(DNA.codonNumberToBpStart(locus.getStart()) + 1);
                    locus.setStop(locus.getStop() * 3 + 1);
                    locus.antisense(this.refLen);
                }
                this.matches.add((T[])aSenseResults2);
            }
            if ((aSenseResults3 = this.findOnStrand(this.AAFrame3AS, qry)) != null) {
                for (Locus locus : aSenseResults3) {
                    locus.setStart(DNA.codonNumberToBpStart(locus.getStart()) + 2);
                    locus.setStop(locus.getStop() * 3 + 2);
                    locus.antisense(this.refLen);
                }
                this.matches.add((T[])aSenseResults3);
            }
        }
        return !this.matches.isEmpty();
    }
}

