/*
 * Decompiled with CFR 0.152.
 */
package MiscTools;

public class StringTrimmer {
    private boolean[] blockedChars = new boolean[128];

    public StringTrimmer() {
    }

    public StringTrimmer(char ... filteredChars) {
        this.disallow(filteredChars);
    }

    public StringTrimmer(int ... filteredChars) {
        this.disallow(filteredChars);
    }

    public void allow(char ... chars) {
        this.setFiltered(false, chars);
    }

    public void disallow(char ... chars) {
        this.setFiltered(true, chars);
    }

    public void allow(int ... chars) {
        this.setFiltered(false, chars);
    }

    public void disallow(int ... chars) {
        this.setFiltered(true, chars);
    }

    private void setFiltered(boolean allowed, char ... chars) {
        for (char c : chars) {
            if (c < '\u0000' || c >= this.blockedChars.length) continue;
            this.blockedChars[c] = allowed;
        }
    }

    private void setFiltered(boolean allowed, int ... chars) {
        for (int c : chars) {
            if (c < 0 || c >= this.blockedChars.length) continue;
            this.blockedChars[c] = allowed;
        }
    }

    public boolean isAllowed(char c) {
        return c >= '\u0000' && c < this.blockedChars.length ? !this.blockedChars[c] : false;
    }

    public String trim(String src) {
        return this.trim(src, "");
    }

    public String trim(String src, String defaultValue) {
        int start;
        if (src == null || src.length() == 0) {
            return defaultValue;
        }
        int end = src.length() - 1;
        for (start = 0; start <= end && !this.isAllowed(src.charAt(start)); ++start) {
        }
        if (start > end) {
            return defaultValue;
        }
        while (end > 0 && !this.isAllowed(src.charAt(end))) {
            --end;
        }
        if (start == 0 && end == src.length() - 1) {
            return src;
        }
        return src.substring(start, end + 1);
    }
}

