/*
 * Decompiled with CFR 0.152.
 */
package MiscTools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public class FileTools {
    private static String lastError = "";

    public static String getError() {
        return lastError;
    }

    public static boolean writeFile(File file, byte[] data) {
        lastError = "";
        if (file == null) {
            lastError = "File was null.";
            return false;
        }
        if (file.exists()) {
            if (!file.isFile()) {
                lastError = "Save path was not a file.";
                return false;
            }
            if (!file.canWrite()) {
                lastError = "File does not have write permission.";
                return false;
            }
        }
        try {
            Files.write(file.toPath(), data, new OpenOption[0]);
            return true;
        }
        catch (IOException ex) {
            lastError = ex.getMessage();
            return false;
        }
    }

    public static char[] getFileChars(File file) {
        lastError = "";
        if (!file.isFile()) {
            lastError = "Specified path is not a file.";
            return null;
        }
        if (!file.exists()) {
            lastError = "Specified file does not exist.";
            return null;
        }
        if (!file.canRead()) {
            lastError = "Specified file does not have read access.";
            return null;
        }
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]));
            char[] chars = new char[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                chars[i] = (char)(bytes[i] & 0xFF);
            }
            return chars;
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex.getLocalizedMessage());
            return null;
        }
        catch (IOException ex) {
            System.err.println(ex.getLocalizedMessage());
            return null;
        }
    }
}

