/*
 * Decompiled with CFR 0.152.
 */
package MiscTools;

import java.awt.Color;

public class ColorTools {
    public static Color intToColor(int col) {
        return ColorTools.intToColor(col, 255);
    }

    public static Color intToColor(int col, int Alpha) {
        int R = col & 0xFF;
        int G = (col & 0xFF00) / 256;
        int B = (col & 0xFF0000) / 65536;
        return new Color(R, G, B, Alpha);
    }

    public static int colorToInt(Color color) {
        return color.getRed() + color.getGreen() * 256 + color.getBlue() * 65536;
    }

    public static Color getForecolor(Color backcolor) {
        if (backcolor == null) {
            return Color.black;
        }
        double r = (double)backcolor.getRed() / 255.0;
        double g = (double)backcolor.getGreen() / 255.0;
        double b = (double)backcolor.getBlue() / 255.0;
        r = r <= 0.03928 ? (r /= 12.92) : Math.pow((r + 0.055) / 1.055, 2.4);
        g = g <= 0.03928 ? (g /= 12.92) : Math.pow((g + 0.055) / 1.055, 2.4);
        b = b <= 0.03928 ? (b /= 12.92) : Math.pow((b + 0.055) / 1.055, 2.4);
        return 0.2126 * r + 0.7152 * g + 0.0722 * b > 0.179 ? Color.black : Color.white;
    }
}

