/*
 * Decompiled with CFR 0.152.
 */
package ListModels;

import BinaryTrees.BinaryChain;
import java.util.Comparator;
import javax.swing.AbstractListModel;

public class UniqueListModel<T>
extends AbstractListModel {
    public final BinaryChain<T> items = new BinaryChain();

    @Override
    public int getSize() {
        return this.items.size();
    }

    public int size() {
        return this.items.size();
    }

    @Override
    public T getElementAt(int index) {
        return this.items.get(index);
    }

    public void add(T item, String key) {
        this.add(item, key, true);
    }

    public void add(T item, String key, boolean update) {
        if (!this.items.containsKey(key)) {
            this.items.add(item, key);
            int index = this.items.indexOf(item);
            this.fireIntervalAdded(this, index, index);
        }
    }

    public void add(T item) {
        this.add(item, item.toString(), true);
    }

    public void add(T item, boolean update) {
        this.add(item, item.toString(), update);
    }

    public boolean contains(String key) {
        return this.items.containsKey(key);
    }

    public void clear() {
        int size = this.items.size();
        this.items.clear();
        this.fireIntervalRemoved(this, 0, size - 1);
    }

    public void remove(String key) {
        T obj = this.items.get(key);
        if (obj != null) {
            int index = this.items.indexOf(obj);
            this.items.remove(key);
            this.fireIntervalRemoved(this, index, index);
        }
    }

    public boolean isEmpty() {
        return this.items.size() == 0;
    }

    public void sort(Comparator c) {
        this.sort(c, true);
    }

    public void sort(Comparator c, boolean update) {
        if (this.items.size() > 1) {
            this.items.sort(c);
            if (update) {
                this.fireContentsChanged(this, 0, this.items.size());
            }
        }
    }
}

